/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.ImplicitRequireProvider;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.cache.FQNCache;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.settings.RSupportPerModuleSettings;

public class LoadPathUtil {
    private static final long a = c.a(4339323939306624479L, -5092976223627727153L, MethodHandles.lookup().lookupClass()).a(27169521321913L);

    private LoadPathUtil() {
    }

    public static Collection<VirtualFile> getLoadPath(PsiFile psiFile) {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        LoadPathUtil.appendExplicitLoadPath(arrayList, module2);
        for (ImplicitRequireProvider implicitRequireProvider : ImplicitRequireProvider.EP_NAME.getExtensionList()) {
            Collection<VirtualFile> collection = implicitRequireProvider.getLoadPath(module2, psiFile);
            arrayList.addAll(collection);
        }
        arrayList.add(psiFile.getProject().getBaseDir());
        Sdk sdk = LoadPathUtil.findSdkForBuiltInSymbol(psiFile);
        if (sdk != null) {
            Collections.addAll(arrayList, RubySdkUtil.getSdkRootsWithAllGems(sdk, psiFile.getProject()));
        }
        return arrayList;
    }

    public static void appendExplicitLoadPath(Collection<? super VirtualFile> loadpath, Module module2) {
        RSupportPerModuleSettings rSupportPerModuleSettings;
        if (module2 != null && (rSupportPerModuleSettings = RModuleUtil.getInstance().getRubyModuleSettings(module2)) != null) {
            for (String string : rSupportPerModuleSettings.getLoadPaths()) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
                if (virtualFile == null && ApplicationManager.getApplication().isUnitTestMode()) {
                    virtualFile = TempFileSystem.getInstance().findFileByPath(string);
                }
                if (virtualFile == null) continue;
                loadpath.add((VirtualFile)virtualFile);
            }
        }
    }

    @Nullable
    public static Sdk findSdkForBuiltInSymbol(PsiFile psiFile) {
        VirtualFile virtualFile = RubyPsiUtil.getVirtualFileFromElement((PsiElement)psiFile);
        if (virtualFile == null) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        Sdk sdk = null;
        if (module2 != null) {
            sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
        } else {
            Project project = psiFile.getProject();
            List list2 = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(virtualFile);
            Module module3 = list2.iterator();
            while (module3.hasNext()) {
                RubySupportProvider rubySupportProvider;
                OrderEntry orderEntry = (OrderEntry)module3.next();
                if (orderEntry instanceof JdkOrderEntry) {
                    sdk = ((JdkOrderEntry)orderEntry).getJdk();
                    if (!RubySdkUtil.isRubySDK(sdk)) continue;
                    break;
                }
                Iterator iterator = RubySupportProvider.EP_NAME.getExtensionList().iterator();
                while (iterator.hasNext() && !RubySdkUtil.isRubySDK(sdk = (rubySupportProvider = (RubySupportProvider)iterator.next()).findRubySdkFromOrderEntry(orderEntry))) {
                }
            }
            if ((module3 = RModuleUtil.getInstance().getModuleWithRubySupport(project)) != null) {
                sdk = RModuleUtil.getInstance().findRubySdkForModule(module3);
            }
        }
        return sdk;
    }

    @Nullable
    public static VirtualFile getBuiltinFile(@NotNull Sdk sdk) {
        if (sdk == null) {
            LoadPathUtil.a(0);
        }
        String string = RubySdkUtil.getStubsFolder(sdk);
        String string2 = ((RubySdkType)sdk.getSdkType()).getBuiltinsName();
        for (VirtualFile virtualFile : RubySdkUtil.getSdkRoots(sdk)) {
            VirtualFile virtualFile2;
            if (!virtualFile.getName().equals(string) || (virtualFile2 = virtualFile.findChild(string2)) == null || !virtualFile2.isValid()) continue;
            return virtualFile2;
        }
        return null;
    }

    public static <T extends PsiElement> List<T> sortByProcessingOrder(@NotNull Collection<? extends T> elements, @NotNull Comparator<? super VirtualFile> comparator) {
        if (elements == null) {
            LoadPathUtil.a(1);
        }
        if (comparator == null) {
            LoadPathUtil.a(2);
        }
        if (elements.isEmpty()) {
            return Collections.emptyList();
        }
        if (elements.size() == 1) {
            return Collections.singletonList(elements.iterator().next());
        }
        Map map2 = StreamEx.of(elements).groupingBy(psiElement -> psiElement.getContainingFile().getVirtualFile());
        return ((StreamEx)StreamEx.of(map2.keySet()).sorted(comparator)).flatMap(virtualFile -> ((List)map2.get(virtualFile)).stream().sorted(RubyPsiUtil.getRelativePositionComparator())).toList();
    }

    public static boolean isLoadPathRoot(PsiElement element) {
        RSupportPerModuleSettings rSupportPerModuleSettings;
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module2 != null && RModuleUtil.getInstance().hasRubySupport(module2) && (rSupportPerModuleSettings = RModuleUtil.getInstance().getRubyModuleSettings(module2)) != null) {
            for (String string : rSupportPerModuleSettings.getLoadPaths()) {
                if (!string.equals(((PsiDirectory)element).getVirtualFile().getPath())) continue;
                return true;
            }
        }
        return false;
    }

    public static void invalidateRubyCaches(@Nullable Project project) {
        if (project != null && !project.isDisposed()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
            PsiManager.getInstance((Project)project).dropResolveCaches();
            FQNCache.getInstance(project).clearEverything();
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
            ProjectView.getInstance((Project)project).refresh();
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x621B819B2D42L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/codeInsight/symbols/v2/LoadPathUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuiltinFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sortByProcessingOrder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

