/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.WrappingRunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.motion.RubyMotionUtil;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyProcessDispatcher;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.settings.RubyDebuggerSettings;
import org.jetbrains.plugins.ruby.ruby.run.configuration.AbstractRubyRunConfiguration;
import org.jetbrains.plugins.ruby.ruby.run.configuration.DebugGemHelper;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyAbstractCommandLineState;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyCommandLineData;
import org.jetbrains.plugins.ruby.ruby.run.configuration.RubyProgramRunner;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyDebugTarget;

public class RubyDebugRunner
extends RubyProgramRunner {
    private static final Logger a;
    public static final int RUBY_DEBUG_DEFAULT_TIMEOUT = 10;
    public static final int RUBY_DEBUG_DEFAULT_TIMELIMIT = 100;
    public static final int RUBY_DEBUG_DEFAULT_MEMORYLIMIT = 0;
    public static final String ID = "RubyDebugRunner";
    private static final long g;

    @Override
    @NotNull
    public String getRunnerId() {
        long l2 = g ^ 0x2D9965C834BFL;
        if (ID == null) {
            RubyDebugRunner.b(0);
        }
        return ID;
    }

    @Override
    public boolean preloaderAllowed() {
        return false;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            RubyDebugRunner.b(1);
        }
        if (profile == null) {
            RubyDebugRunner.b(2);
        }
        if (profile instanceof WrappingRunConfiguration) {
            profile = ((WrappingRunConfiguration)profile).getPeer();
        }
        return DefaultDebugExecutor.EXECUTOR_ID.equals(executorId) && profile instanceof AbstractRubyRunConfiguration;
    }

    protected RunContentDescriptor doExecute(@NotNull RunProfileState state2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        long l2 = g ^ 0xF100C4918B6L;
        if (state2 == null) {
            RubyDebugRunner.b(3);
        }
        if (environment == null) {
            RubyDebugRunner.b(4);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        a.debug("Initializing debugger service");
        XDebugSession xDebugSession = new RubyDebugSessionBuilder((RubyAbstractCommandLineState)state2, environment).setRubyDebuggerProxy().setAcceptor().setRubyDebugTarget().connectProxy().build();
        a.debug("Debugger service initialized. Starting RubyDebugProcess");
        return xDebugSession.getRunContentDescriptor();
    }

    protected static boolean supportsCatchpointRemoval(@NotNull DebugGemHelper helper, @Nullable Sdk sdk) {
        if (helper == null) {
            RubyDebugRunner.b(5);
        }
        if (sdk == null) {
            return false;
        }
        return helper.supportsCatchpointRemoval();
    }

    protected static boolean shouldUseDebugConsole(@NotNull DebugGemHelper helper, @Nullable Sdk sdk, @NotNull RubyCommandLineData data) {
        if (helper == null) {
            RubyDebugRunner.b(6);
        }
        if (data == null) {
            RubyDebugRunner.b(7);
        }
        if (sdk == null) {
            return false;
        }
        Boolean bl2 = (Boolean)data.getUserData(RubyCommandLineData.DEBUG_CONSOLE_ALLOWED_KEY);
        if (bl2 == null || !bl2.booleanValue()) {
            return false;
        }
        return helper.debugConsoleSupported(sdk);
    }

    @NotNull
    public static RubyDebugTarget getDebugTarget(@Nullable String debuggedScript, ProcessHandler serverProcessHandler, Integer debuggerPort, RubyDebuggerProxy rubyDebuggerProxy, String localHostString) {
        Process process2;
        Process process3 = process2 = serverProcessHandler instanceof OSProcessHandler ? ((OSProcessHandler)serverProcessHandler).getProcess() : null;
        if (process2 != null) {
            RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, localHostString, debuggerPort.intValue(), process2, debuggedScript, null);
            if (rubyDebugTarget == null) {
                RubyDebugRunner.b(8);
            }
            return rubyDebugTarget;
        }
        RubyDebugTarget rubyDebugTarget = new RubyDebugTarget(rubyDebuggerProxy, localHostString, debuggerPort.intValue());
        if (rubyDebugTarget == null) {
            RubyDebugRunner.b(9);
        }
        return rubyDebugTarget;
    }

    @Nullable
    public static RubyProcessDispatcher getAcceptor(boolean supportsNonSuspendedFramesReading, String localHostString, boolean supportsCatchpointRemoval, @Nullable Integer dispatcherPort, boolean masterConnectionExpected) throws ExecutionException {
        RubyProcessDispatcher rubyProcessDispatcher;
        if (RubyDebuggerSettings.getInstance().getState().isMultiprocess() && dispatcherPort != null) {
            rubyProcessDispatcher = new RubyProcessDispatcher(localHostString, dispatcherPort, supportsNonSuspendedFramesReading, supportsCatchpointRemoval, masterConnectionExpected);
            rubyProcessDispatcher.start();
        } else {
            rubyProcessDispatcher = null;
        }
        return rubyProcessDispatcher;
    }

    public static boolean supportsNonSuspendedFramesReading(@NotNull DebugGemHelper debugGemHelper, @Nullable Sdk sdk) {
        if (debugGemHelper == null) {
            RubyDebugRunner.b(10);
        }
        if (sdk == null) {
            return false;
        }
        if (!RubyDebuggerSettings.getInstance().getState().isReadNonSuspendedFrames()) {
            return false;
        }
        return debugGemHelper.supportsNonSuspendedFramesReading(sdk);
    }

    static {
        g = c.a(-4974302089072454561L, 6494447368079379534L, MethodHandles.lookup().lookupClass()).a(43624949207927L);
        a = Logger.getInstance(RubyDebugRunner.class);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x1DC9182DE3DAL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugGemHelper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugTarget";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doExecute";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "supportsCatchpointRemoval";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseDebugConsole";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "supportsNonSuspendedFramesReading";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class RubyDebugSessionBuilder {
        protected RubyDebugTarget myRubyDebugTarget;
        protected List<VirtualFile> mySourceRoots;
        protected List<VirtualFile> myExcludedDirs;
        protected String myLocalHostString;
        protected RubyDebuggerProxy myRubyDebuggerProxy;
        protected final Integer myDebuggerPort;
        protected boolean mySupportsNonSuspendedFramesReading;
        protected boolean myEnableFileFiltering;
        @NotNull
        private final RubyAbstractCommandLineState b;
        @NotNull
        private final ExecutionEnvironment c;
        @NotNull
        private final RubyCommandLineData i;
        @NotNull
        private final ProcessHandler g;
        @NotNull
        private final Project e;
        private DebugGemHelper a;
        private SourcePositionConverter d;
        private int j;
        private Sdk k;
        private RubyProcessDispatcher h;
        private boolean l;
        private boolean f;
        private String m;
        private static final long n = com.jetbrains.python.psi.c.a(8764968299501380260L, 7070074048671721085L, MethodHandles.lookup().lookupClass()).a(131796475417219L);

        public RubyDebugSessionBuilder(@NotNull RubyAbstractCommandLineState state2, @NotNull ExecutionEnvironment environment) throws ExecutionException {
            long l2 = n ^ 0x1B6C86F17306L;
            if (state2 == null) {
                RubyDebugSessionBuilder.a(0);
            }
            if (environment == null) {
                RubyDebugSessionBuilder.a(1);
            }
            this.mySupportsNonSuspendedFramesReading = false;
            this.myEnableFileFiltering = false;
            this.l = false;
            this.f = false;
            this.b = state2;
            this.c = environment;
            this.e = this.b.getConfig().getProject();
            Pair<RubyCommandLineData, ProcessHandler> pair = this.b.createCommandLineAndProcessHandler();
            this.i = (RubyCommandLineData)((Object)pair.getFirst());
            this.g = (ProcessHandler)pair.getSecond();
            this.myDebuggerPort = (Integer)this.i.getUserData(RubyCommandLineData.DEBUG_PORT_KEY);
            if (this.myDebuggerPort != null) {
                this.a = (DebugGemHelper)this.i.getUserData(RubyCommandLineData.DEBUG_GEM_HELPER_KEY);
                a.assertTrue(this.a != null, (Object)"cannot create debug runner without gem helper");
                this.d = (SourcePositionConverter)this.i.getUserData(RubyCommandLineData.SOURCE_POSITION_CONVERTER_KEY);
                assert (this.d != null) : "source position converter must not be null";
                this.j = RubyDebuggerSettings.getInstance().getState().getTimeout();
                this.k = this.b.getConfig().getSdk();
                this.mySupportsNonSuspendedFramesReading = RubyDebugRunner.supportsNonSuspendedFramesReading(this.a, this.k);
                this.l = RubyDebugRunner.shouldUseDebugConsole(this.a, this.k, this.i);
                this.f = RubyDebugRunner.supportsCatchpointRemoval(this.a, this.k);
                this.mySourceRoots = this.a.getSourceRoots(this.e);
                this.myExcludedDirs = this.a.getExcludedDirs(this.e);
                this.myEnableFileFiltering = this.a.supportFileFiltering() && RubyDebuggerSettings.getInstance().getState().isStepIntoProjectOnly();
                this.myLocalHostString = NetUtils.getLocalHostString();
            }
        }

        @NotNull
        public RubyDebugSessionBuilder setRubyDebuggerProxy() {
            if (this.myDebuggerPort != null) {
                this.myRubyDebuggerProxy = new RubyDebuggerProxy(this.j, this.mySupportsNonSuspendedFramesReading, true, this.f);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(2);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder setAcceptor() throws ExecutionException {
            if (this.myDebuggerPort != null) {
                this.h = RubyDebugRunner.getAcceptor(this.mySupportsNonSuspendedFramesReading, this.myLocalHostString, this.f, (Integer)this.i.getCopyableUserData(RubyCommandLineData.DISPATCHER_KEY), false);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(3);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder setRubyDebugTarget() {
            long l2 = n ^ 0x67A03152653CL;
            if (this.myDebuggerPort != null) {
                String string = (String)this.i.getUserData(RubyCommandLineData.DEBUGED_SCRIPT_KEY);
                assert (string != null) : "script cannot be null";
                this.myRubyDebugTarget = RubyDebugRunner.getDebugTarget(string, this.g, this.myDebuggerPort, this.myRubyDebuggerProxy, this.myLocalHostString);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(4);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder connectProxy() {
            if (this.myDebuggerPort != null) {
                this.myRubyDebuggerProxy.setDebugTarget(this.myRubyDebugTarget);
            }
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(5);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public RubyDebugSessionBuilder showTab(String sessionName) {
            this.m = sessionName;
            RubyDebugSessionBuilder rubyDebugSessionBuilder = this;
            if (rubyDebugSessionBuilder == null) {
                RubyDebugSessionBuilder.a(6);
            }
            return rubyDebugSessionBuilder;
        }

        @NotNull
        public XDebugSession build() throws ExecutionException {
            if (this.myDebuggerPort == null) {
                XDebugSession xDebugSession = RubyMotionUtil.getInstance().createMotionDebugSession((RunProfileState)this.b, this.c, this.g);
                if (xDebugSession == null) {
                    RubyDebugSessionBuilder.a(7);
                }
                return xDebugSession;
            }
            XDebugProcessStarter xDebugProcessStarter = new XDebugProcessStarter(){
                private static final long a = com.jetbrains.python.psi.c.a(-8650865868782815189L, -2144622269956783721L, MethodHandles.lookup().lookupClass()).a(272437262690856L);

                @NotNull
                public XDebugProcess start(@NotNull XDebugSession session) {
                    if (session == null) {
                        1.a(0);
                    }
                    RubyDebugProcess rubyDebugProcess = new RubyDebugProcess(session, (RunProfileState)b, g, myRubyDebuggerProxy, j, d, c, h, a.pauseActionSupported(), l, myEnableFileFiltering, mySourceRoots, myExcludedDirs);
                    if (rubyDebugProcess == null) {
                        1.a(1);
                    }
                    return rubyDebugProcess;
                }

                private static /* synthetic */ void a(int n2) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n3;
                    String string;
                    long l2 = a ^ 0x7D11203373C9L;
                    switch (n2) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            n3 = 3;
                            break;
                        }
                        case 1: {
                            n3 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n3];
                    switch (n2) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "session";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder$1";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder$1";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "start";
                            break;
                        }
                    }
                    switch (n2) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "start";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n2) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
            if (this.m == null) {
                XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.c.getProject()).startSession(this.c, xDebugProcessStarter);
                if (xDebugSession == null) {
                    RubyDebugSessionBuilder.a(8);
                }
                return xDebugSession;
            }
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)this.c.getProject()).startSessionAndShowTab(this.m, null, xDebugProcessStarter);
            if (xDebugSession == null) {
                RubyDebugSessionBuilder.a(9);
            }
            return xDebugSession;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = n ^ 0x4E144825FEAL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/RubyDebugRunner$RubyDebugSessionBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebuggerProxy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setAcceptor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setRubyDebugTarget";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "connectProxy";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showTab";
                    break;
                }
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

