/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.ProcessedGlobalsCollector;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebugProcess;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEvaluator;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyStepVariant;
import org.rubyforge.debugcommons.model.RubySuspensionLocation;
import org.rubyforge.debugcommons.model.RubyThread;
import org.rubyforge.debugcommons.model.RubyVariable;

public class RubyStackFrame
extends XStackFrame {
    private static final Logger e;
    private static final Object c;
    protected Project myProject;
    private List<RubyStepVariant> f;
    @Nullable
    protected XSourcePosition myXSourcePosition;
    private final boolean b;
    private final RubyThread d;
    private final RubyFrame a;
    protected RubyDebuggerProxy myDebuggerProxy;
    private static final long g;

    public Object getEqualityObject() {
        return c;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            RubyStackFrame.a(0);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myDebuggerProxy.waitForDebuggerProxyReady();
                LinkedList<RubyVariable> linkedList = new LinkedList<RubyVariable>();
                if (this.a.getLocation() != null) {
                    if (this.a.getLocation().getType() == RubySuspensionLocation.Type.METHOD) {
                        linkedList.add(this.a.getReceiver());
                    }
                    if (this.b && this.a.getLocation().getType() == RubySuspensionLocation.Type.LEAVE) {
                        linkedList.add(this.a.getReturnValue());
                    }
                }
                linkedList.addAll(Arrays.asList(this.a.getVariables()));
                RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.myXSourcePosition, node, linkedList.toArray(new RubyVariable[0]), this, true, false, false);
                XValueGroup xValueGroup = RubyDebugValueFactory.createGlobalVariables(this.myProject, this.myXSourcePosition, this.myDebuggerProxy, this.a(node), this);
                node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)xValueGroup), true);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                e.info((Throwable)rubyDebuggerException);
            }
        });
    }

    private Set<String> a(@NotNull XCompositeNode xCompositeNode) {
        if (xCompositeNode == null) {
            RubyStackFrame.a(1);
        }
        ProcessedGlobalsCollector processedGlobalsCollector = new ProcessedGlobalsCollector(this.myProject, this.myXSourcePosition);
        processedGlobalsCollector.addVariableNodes(xCompositeNode, this);
        return processedGlobalsCollector.getProcessedGlobals();
    }

    public RubyStackFrame(Project project, @NotNull RubyDebugProcess process2, RubyDebuggerProxy debuggerProxy, RubyThread rubyThread, @NotNull RubyFrame frame) {
        if (process2 == null) {
            RubyStackFrame.a(2);
        }
        if (frame == null) {
            RubyStackFrame.a(3);
        }
        this.myProject = project;
        this.d = rubyThread;
        this.a = frame;
        this.myDebuggerProxy = debuggerProxy;
        this.myXSourcePosition = process2.getPositionConverter().createLocalPosition(new RubyPosition(this.a.getFile(), this.a.getLine(), this.a.getLocation()));
        this.b = process2.myObtainingReturnValuesSupported;
        if (this.myXSourcePosition != null && this.myXSourcePosition.getLine() < 0) {
            this.myXSourcePosition = null;
        }
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    public boolean isInProjectFrame() {
        XSourcePosition xSourcePosition = this.getSourcePosition();
        if (xSourcePosition == null) {
            return false;
        }
        VirtualFile virtualFile = xSourcePosition.getFile();
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(virtualFile);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XSourcePosition xSourcePosition;
        long l2 = g ^ 0x699D9B37BF4DL;
        if (component == null) {
            RubyStackFrame.a(4);
        }
        if ((xSourcePosition = this.getSourcePosition()) != null) {
            VirtualFile virtualFile = xSourcePosition.getFile();
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document == null) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            boolean bl2 = this.isInProjectFrame();
            int n2 = xSourcePosition.getLine();
            if (n2 >= document.getLineCount()) {
                return;
            }
            PsiElement psiElement = psiFile.findElementAt(document.getLineStartOffset(n2));
            RContainer rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RContainer.class);
            if (rContainer instanceof RMethod) {
                component.append(RMethodPresentationUtil.formatName((RMethod)rContainer, 1), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                component.append(" [", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append(virtualFile.getName(), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append(":", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append(String.valueOf(n2 + 1), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append("]", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                RContainer rContainer2 = rContainer.getParentContainer();
                if (rContainer2 != null && !(rContainer2 instanceof PsiFile)) {
                    component.append(" (", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    component.append(RContainerPresentationUtil.getContainerNameWithLocation(rContainer2, false), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    component.append(")", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                }
            } else {
                component.append(virtualFile.getName(), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                component.append(":", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                component.append(String.valueOf(n2 + 1), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
            }
            component.setIcon(AllIcons.Debugger.Frame);
        } else {
            component.append(RBundle.message("ruby.debugger.stackframe.not.available"), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    public RubyThread getRubyThread() {
        return this.d;
    }

    public static SimpleTextAttributes processAttributes(boolean isInProject, @NotNull SimpleTextAttributes originalAttributes) {
        if (originalAttributes == null) {
            RubyStackFrame.a(5);
        }
        if (isInProject) {
            return originalAttributes;
        }
        return (originalAttributes.getStyle() & 2) != 0 ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    public XDebuggerEvaluator getEvaluator() {
        return this.myXSourcePosition != null ? new RubyDebuggerEvaluator(this.myProject, this, this.myDebuggerProxy) : null;
    }

    public RubyFrame getFrame() {
        return this.a;
    }

    public List<RubyStepVariant> getSmartStepIntoVariants() {
        if (this.f == null) {
            this.f = this.myDebuggerProxy.getSmartStepIntoVariants();
        }
        return this.f;
    }

    public String getName() {
        return this.a.getName();
    }

    static {
        g = com.jetbrains.python.psi.c.a(-3140995432397525939L, -3167058197857129200L, MethodHandles.lookup().lookupClass()).a(263836794689917L);
        e = Logger.getInstance(RubyStackFrame.class);
        c = new Object();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = g ^ 0x2118391DB4A5L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalAttributes";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyStackFrame";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProcessedGlobals";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "customizePresentation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

