/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.hash;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.mongoid.MongoidUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.hash.RubyHashUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.assoc.RAssoc;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RBaseString;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArrayIndexing;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RAssocList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RContainerUtil;
import org.jetbrains.plugins.ruby.testing.testunit.RTestUnitUtil;

public class RubyStringKeysInHashInspection
extends RubyInspection {
    private static final RubyFix a;
    private static final long b;

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = b ^ 0x4CF6C3A3A533L;
        String string = RBundle.message("inspection.hash.double.quoted.keys");
        if (string == null) {
            RubyStringKeysInHashInspection.b(0);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        long l2 = b ^ 0xF8538352CDBL;
        if ("RubyStringKeysInHashInspection" == null) {
            RubyStringKeysInHashInspection.b(1);
        }
        return "RubyStringKeysInHashInspection";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RubyStringKeysInHashInspection.b(2);
        }
        RubyHashKeysVisitor rubyHashKeysVisitor = new RubyHashKeysVisitor(holder);
        if (rubyHashKeysVisitor == null) {
            RubyStringKeysInHashInspection.b(3);
        }
        return rubyHashKeysVisitor;
    }

    static {
        b = c.a(504295202558497412L, -5085231206019482813L, MethodHandles.lookup().lookupClass()).a(239887910980139L);
        a = new RubyFix(){
            private static final long a = c.a(5207229693250569417L, -2940264019845589763L, MethodHandles.lookup().lookupClass()).a(206703184052774L);

            @Override
            protected void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
                if (project == null) {
                    1.b(0);
                }
                if (descriptor2 == null) {
                    1.b(1);
                }
                PsiElement psiElement = descriptor2.getPsiElement();
                assert (psiElement instanceof RBaseString);
                RBaseString rBaseString = (RBaseString)psiElement;
                PsiElement psiElement2 = rBaseString.getStringBeginning();
                PsiElement psiElement3 = rBaseString.getStringEnding();
                if (psiElement2 != null && psiElement3 != null) {
                    String string = ":" + rBaseString.getContent();
                    rBaseString.replace((PsiElement)RubyElementFactory.createElementFromText((PsiElement)rBaseString, string));
                }
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                long l2 = a ^ 0x17B7F38D7205L;
                String string = RBundle.message("inspection.hash.double.quoted.keys.fix");
                if (string == null) {
                    1.b(2);
                }
                return string;
            }

            private static /* synthetic */ void b(int n2) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n3;
                String string;
                long l2 = a ^ 0x77EA73C01FB8L;
                switch (n2) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        n3 = 3;
                        break;
                    }
                    case 2: {
                        n3 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection$1";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n2) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "doFix";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n2) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x2965B2CBF826L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/hash/RubyStringKeysInHashInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RubyHashKeysVisitor
    extends RubyInspectionVisitor {
        private static final long b = c.a(-530627652613807038L, 8975222955714992141L, MethodHandles.lookup().lookupClass()).a(280724471437809L);

        RubyHashKeysVisitor(ProblemsHolder holder) {
            super(holder);
        }

        @Override
        public void visitRArrayIndexing(RArrayIndexing arrayIndexing) {
            switch (RubyHashUtil.checkSyntax(arrayIndexing)) {
                case ARRAY_TYPE: {
                    this.c(arrayIndexing.getIndexes());
                    break;
                }
                case ASSOC_TYPE: {
                    this.a(arrayIndexing.getIndexes());
                    break;
                }
                case LIST_TYPE: {
                    this.b(arrayIndexing.getIndexes());
                    break;
                }
            }
        }

        private void b(List<RPsiElement> list2) {
            for (int i10 = 0; i10 < list2.size(); i10 += 2) {
                RPsiElement rPsiElement = list2.get(i10);
                if (!(rPsiElement instanceof RBaseString) || !TextUtil.isCID(((RBaseString)rPsiElement).getContent())) continue;
                this.a(rPsiElement);
            }
        }

        private void a(List<RPsiElement> list2) {
            for (RPsiElement rPsiElement : list2) {
                RPsiElement rPsiElement2;
                if (!(rPsiElement instanceof RAssoc) || !((rPsiElement2 = ((RAssoc)rPsiElement).getKey()) instanceof RBaseString) || !TextUtil.isCID(((RBaseString)rPsiElement2).getContent())) continue;
                this.a(rPsiElement2);
            }
        }

        private void c(List<RPsiElement> list2) {
            List<RPsiElement> list3 = RubyHashUtil.collectKeysFromArray(list2, false);
            for (RPsiElement rPsiElement : list3) {
                if (!(rPsiElement instanceof RBaseString) || !TextUtil.isCID(((RBaseString)rPsiElement).getContent())) continue;
                this.a(rPsiElement);
            }
        }

        @Override
        public void visitRAssocList(RAssocList rAssocList) {
            RContainer rContainer = rAssocList.getParentContainer();
            if (rContainer instanceof RClass && MongoidUtil.isMongoidIncluded((RClass)rContainer)) {
                return;
            }
            for (RPsiElement rPsiElement : rAssocList.getElements()) {
                if (!(rPsiElement instanceof RAssoc)) continue;
                RClass rClass = RContainerUtil.getFirstClassInFile(rPsiElement.getContainingFile());
                if (rClass != null && RTestUnitUtil.isUnitTestCaseLikeClass(rClass)) {
                    return;
                }
                RPsiElement rPsiElement2 = ((RAssoc)rPsiElement).getKey();
                if (!(rPsiElement2 instanceof RBaseString) || !TextUtil.isCID(((RBaseString)rPsiElement2).getContent())) continue;
                this.a(rPsiElement2);
            }
        }

        private void a(RPsiElement rPsiElement) {
            long l2 = b ^ 0x7CE2AC8C2C7L;
            this.registerProblem((PsiElement)rPsiElement, RBundle.message("inspection.hash.double.quoted.keys"), a);
        }
    }
}

