/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.g;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;

public class RubyClassVariableNamingConventionInspection
extends ConventionInspection {
    private static final int c = 2;
    private static final int b = 30;
    private static final long d = com.jetbrains.python.psi.c.a(8155200115567476791L, -7023094890875726927L, MethodHandles.lookup().lookupClass()).a(34620625850706L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        long l2 = d ^ 0x471BF33C49E8L;
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 2;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = d ^ 0x3873FECE07FL;
        if ("Class variable naming convention" == null) {
            RubyClassVariableNamingConventionInspection.d(0);
        }
        return "Class variable naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = d ^ 0x1073483B338CL;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Class variable name '#ref' is too short" == null) {
                RubyClassVariableNamingConventionInspection.d(1);
            }
            return "Class variable name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Class variable name '#ref' is too long" == null) {
                RubyClassVariableNamingConventionInspection.d(2);
            }
            return "Class variable name '#ref' is too long";
        }
        String string2 = "Class variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyClassVariableNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x281619268BEEL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyClassVariableNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRClassVariable(RClassVariable rClassVariable) {
            if (!UsageAnalyzer.isDeclaration((PsiElement)rClassVariable)) {
                return;
            }
            String string = rClassVariable.getName();
            if (RubyClassVariableNamingConventionInspection.this.isValid(string, (PsiElement)rClassVariable)) {
                return;
            }
            this.registerFieldError(rClassVariable, string);
        }

        /* synthetic */ NamingConventionsVisitor(g x1) {
            this();
        }
    }
}

