/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.naming;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.ruby.codeInsight.usages.UsageAnalyzer;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyFix;
import org.jetbrains.plugins.ruby.ruby.inspections.fixes.RubyRenameFix;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.ConventionInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.naming.h;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;

public class RubyLocalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int b = 1;
    private static final int c = 30;
    private static final long d = com.jetbrains.python.psi.c.a(727852261117008069L, 1607165977683264281L, MethodHandles.lookup().lookupClass()).a(267070974458L);

    @Override
    protected String getDefaultRegex() {
        return TextUtil.IDENTIFIER_LOWERCASE_PATTERN.pattern();
    }

    @Override
    protected String getMotionDefaultRegex() {
        long l2 = d ^ 0x739FCDDB03DFL;
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 30;
    }

    @Override
    protected RubyFix buildFix(PsiElement location) {
        return new RubyRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = d ^ 0x73F9DA2FEE99L;
        if ("Local variable naming convention" == null) {
            RubyLocalVariableNamingConventionInspection.d(0);
        }
        return "Local variable naming convention";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        long l2 = d ^ 0x24F776DC79BBL;
        String string = (String)args[0];
        if (string.length() < this.getMinLength()) {
            if ("Local variable name '#ref' is too short" == null) {
                RubyLocalVariableNamingConventionInspection.d(1);
            }
            return "Local variable name '#ref' is too short";
        }
        if (string.length() > this.getMaxLength()) {
            if ("Local variable name '#ref' is too long" == null) {
                RubyLocalVariableNamingConventionInspection.d(2);
            }
            return "Local variable name '#ref' is too long";
        }
        String string2 = "Local variable name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string2 == null) {
            RubyLocalVariableNamingConventionInspection.d(3);
        }
        return string2;
    }

    @Override
    public RubyInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor(null);
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        long l2 = d ^ 0x75DB7F8AEDDEL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/inspections/naming/RubyLocalVariableNamingConventionInspection";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildErrorString";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class NamingConventionsVisitor
    extends RubyInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitRIdentifier(RIdentifier identifier) {
            if (!identifier.isLocalVariable() || !UsageAnalyzer.isFirstDeclaration(identifier)) {
                return;
            }
            String string = identifier.getName();
            if (RubyLocalVariableNamingConventionInspection.this.isValid(string, (PsiElement)identifier)) {
                return;
            }
            this.registerVariableError(identifier, string);
        }

        /* synthetic */ NamingConventionsVisitor(h x1) {
            this();
        }
    }
}

