/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.resolve;

import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.util.BundlerUtil;
import org.jetbrains.plugins.ruby.rails.RailsUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.MethodReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RFileReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RQualifiedReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.ResolveUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.TextResolveResult;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RSymbolType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RType;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyClassFix;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.CreateRubyMethodFix;
import org.jetbrains.plugins.ruby.ruby.inspections.resolve.RubyAutoImportProvider;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPossibleCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.RSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.RAliasStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.names.RSuperClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBinaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RRangeExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RUnaryExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RAssocKeyReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.basicTypes.RSymbolNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.methods.arguments.RMacRubyArgumentNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.holders.utils.RFileUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.methodCall.RCallNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceBase;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.references.RReferenceNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RequireRelativeFileReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.methodCall.RubyCallTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RReference;
import org.jetbrains.plugins.ruby.ruby.lang.psi.ruby19.RAssocKey;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RConstant;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RFid;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RGlobalVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RClassVariable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RField;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.fields.RInstanceVariable;
import org.jetbrains.plugins.ruby.testing.rspec.RSpecUtil;

public class RubyResolveVisitor
extends RubyInspectionVisitor {
    private final boolean b;
    private static final long c = com.jetbrains.python.psi.c.a(8572314186182209497L, -7564482285771633607L, MethodHandles.lookup().lookupClass()).a(125425495747160L);

    public RubyResolveVisitor(@NotNull ProblemsHolder holder, boolean warnImplicitResults) {
        if (holder == null) {
            RubyResolveVisitor.d(0);
        }
        super(holder);
        this.b = warnImplicitResults;
    }

    @Override
    protected void registerProblem(PsiElement element, String message) {
        super.registerProblem(element, message, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, RubyResolveVisitor.a(element, null));
    }

    private static LocalQuickFix[] a(PsiElement psiElement, @Nullable Context context) {
        ArrayList<CreateRubyMethodFix> arrayList = new ArrayList<CreateRubyMethodFix>();
        PsiElement psiElement2 = psiElement.getParent();
        if (!(psiElement2 instanceof RReference) && (psiElement instanceof RIdentifier || psiElement instanceof RFid || psiElement instanceof RSymbol)) {
            String string;
            RContainer rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)psiElement, (Class[])new Class[]{RClass.class, RModule.class});
            String string2 = string = psiElement instanceof RSymbol ? RubyPsiUtil.getElementText(psiElement) : psiElement.getText();
            if (rContainer != null) {
                RCompoundStatement rCompoundStatement = rContainer.getCompoundStatement();
                arrayList.add(new CreateRubyMethodFix((RPsiElement)psiElement, rCompoundStatement, string, context, null));
            } else {
                RCompoundStatement rCompoundStatement = CreateRubyMethodFix.getClosestApplicableEnclosingCompoundStatementForFix(psiElement);
                if (rCompoundStatement != null) {
                    arrayList.add(new CreateRubyMethodFix((RPsiElement)psiElement, rCompoundStatement, string, context, null));
                }
            }
        }
        return arrayList.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    private static LocalQuickFix[] b(RType rType, RQualifiedReference rQualifiedReference) {
        if (TextUtil.isConstId(rQualifiedReference.getCanonicalText())) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        ArrayList<CreateRubyMethodFix> arrayList = new ArrayList<CreateRubyMethodFix>();
        RSymbolType rSymbolType = RTypeUtil.extractSymbolType(rType);
        if (rSymbolType != null) {
            PsiElement psiElement;
            Symbol symbol = rSymbolType.getSymbol();
            RPsiElement rPsiElement = rQualifiedReference.getRefObject();
            if (rPsiElement != null && ((psiElement = symbol.getPsiElement()) instanceof RClass || psiElement instanceof RModule)) {
                RCompoundStatement rCompoundStatement = ((RContainer)psiElement).getCompoundStatement();
                arrayList.add(new CreateRubyMethodFix((RPsiElement)rQualifiedReference.getElement(), rCompoundStatement, rQualifiedReference.getCanonicalText(), rSymbolType.getContext(), null));
            }
        }
        return arrayList.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @Override
    public void visitRConstant(@NotNull RConstant rConstant) {
        Symbol symbol;
        long l2 = c ^ 0x267A2365FEECL;
        if (rConstant == null) {
            RubyResolveVisitor.d(1);
        }
        if (!RubyPsiUtil.isDeclaration((PsiElement)rConstant) && RubyResolveVisitor.a((RPsiElement)rConstant) && RCallNavigator.getByCommand((PsiElement)rConstant) == null && (symbol = ResolveUtil.resolveToSymbolWithCaching(rConstant.getReference(), !this.b)) == null) {
            RubyAutoImportProvider rubyAutoImportProvider;
            if (RubyResolveVisitor.a(rConstant)) {
                this.registerProblem((PsiElement)rConstant, RBundle.message("inspection.resolve.cannot.find", rConstant.getText()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new CreateRubyClassFix(true), new CreateRubyClassFix(false));
                return;
            }
            HintAction hintAction = null;
            ProgressManager.checkCanceled();
            Iterator iterator = RubyAutoImportProvider.EP_NAME.getExtensionList().iterator();
            while (iterator.hasNext() && (hintAction = (rubyAutoImportProvider = (RubyAutoImportProvider)iterator.next()).getAutoImportAction(rConstant)) == null) {
            }
            this.registerProblem((PsiElement)rConstant, RBundle.message("inspection.resolve.cannot.find", rConstant.getText()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, hintAction);
        }
    }

    private static boolean a(RConstant rConstant) {
        PsiElement psiElement = rConstant.getParent();
        if (psiElement instanceof RSuperClass) {
            return true;
        }
        return psiElement instanceof RDotReference;
    }

    @Override
    public void visitRFid(@NotNull RFid rFid) {
        long l2 = c ^ 0x66E3D76BDB87L;
        if (rFid == null) {
            RubyResolveVisitor.d(2);
        }
        if (RubyResolveVisitor.a(rFid) && ResolveUtil.resolveToSymbolWithCaching(rFid.getReference(), !this.b) == null) {
            this.registerProblem((PsiElement)rFid, RBundle.message("inspection.resolve.cannot.find", rFid.getText()));
        }
    }

    @Override
    public void visitRAssocKey(RAssocKey rAssocKey) {
        PsiReference psiReference = rAssocKey.getReference();
        if (!(psiReference instanceof RAssocKeyReference)) {
            return;
        }
        ResolveUtil.resolvePsiMultiReference((RAssocKeyReference)psiReference);
    }

    @Override
    public void visitRIdentifier(@NotNull RIdentifier rIdentifier) {
        long l2 = c ^ 0x80A174A81AEL;
        if (rIdentifier == null) {
            RubyResolveVisitor.d(3);
        }
        if (rIdentifier.isConstructorLike() || !RubyResolveVisitor.a(rIdentifier) || rIdentifier.isParameterDeclaration() || rIdentifier.isLocalVariable()) {
            return;
        }
        String string = rIdentifier.getText();
        if (ResolveUtil.resolveToSymbolWithCaching(rIdentifier.getReference(), !this.b) == null) {
            this.registerProblem((PsiElement)rIdentifier, RBundle.message("inspection.resolve.cannot.find", string));
        }
    }

    @Override
    public void visitRGlobalVariable(@NotNull RGlobalVariable globalVariable) {
        long l2 = c ^ 0x2B922180416FL;
        if (globalVariable == null) {
            RubyResolveVisitor.d(4);
        }
        if (RubyResolveVisitor.a(globalVariable) && ResolveUtil.resolveToSymbolWithCaching(globalVariable.getReference(), !this.b) == null) {
            this.registerProblem((PsiElement)globalVariable, RBundle.message("inspection.resolve.cannot.find", globalVariable.getText()));
        }
    }

    @Override
    public void visitRReference(@NotNull RReference rReference) {
        long l2 = c ^ 0x3AA3D1812013L;
        if (rReference == null) {
            RubyResolveVisitor.d(5);
        }
        if (((RReferenceBase)rReference).isConstructorLike() || !RubyResolveVisitor.a(rReference)) {
            return;
        }
        PsiReference psiReference = rReference.getReference();
        if (psiReference instanceof RQualifiedReference) {
            RQualifiedReference rQualifiedReference = (RQualifiedReference)psiReference;
            RType rType = rQualifiedReference.getRefObjectType();
            ResolveResult[] resolveResultArray = rQualifiedReference.multiResolve(false);
            if (resolveResultArray.length == 0) {
                if (rType.isTyped()) {
                    this.a(rType, rQualifiedReference);
                } else {
                    this.registerProblem(rQualifiedReference.getRefValue(), RBundle.message("inspection.resolve.cannot.find", rQualifiedReference.getCanonicalText()));
                }
                return;
            }
            if (!resolveResultArray[0].isValidResult() && resolveResultArray[0].getElement() == rReference.getValue() && rType.isTyped()) {
                this.a(rType, rQualifiedReference);
            } else if (this.b && (resolveResultArray[0] instanceof TextResolveResult || !resolveResultArray[0].isValidResult())) {
                this.registerProblem(rQualifiedReference.getRefValue(), RBundle.message("inspection.resolve.cannot.find", rQualifiedReference.getCanonicalText()));
            }
        }
    }

    @Override
    public void visitRBinaryExpression(@NotNull RBinaryExpression rBinaryExpression) {
        long l2 = c ^ 0x46B5BE852AE7L;
        if (rBinaryExpression == null) {
            RubyResolveVisitor.d(6);
        }
        if (rBinaryExpression instanceof RRangeExpression || rBinaryExpression instanceof RBoolBinExpression) {
            return;
        }
        if (!RubyResolveVisitor.a(rBinaryExpression)) {
            return;
        }
        RPsiElement rPsiElement = rBinaryExpression.getLeftOperand();
        RType rType = null;
        if (rPsiElement instanceof RExpression && !(rType = ((RExpression)rPsiElement).getType()).isTyped()) {
            return;
        }
        PsiReference psiReference = rBinaryExpression.getReference();
        assert (psiReference instanceof RQualifiedReference) : "Unexpected reference " + psiReference + " found in binary expression";
        RQualifiedReference rQualifiedReference = (RQualifiedReference)psiReference;
        if (rQualifiedReference.multiResolve(false).length == 0) {
            this.a(rType, rQualifiedReference);
        }
    }

    private void a(RType rType, RQualifiedReference rQualifiedReference) {
        String string;
        long l2 = c ^ 0xCBEEC931A3DL;
        String string2 = string = rType != null ? rType.getPresentableName() : null;
        if (string != null) {
            this.registerProblem(rQualifiedReference.getRefValue(), RBundle.message("inspection.resolve.cannot.find.in.type", rQualifiedReference.getCanonicalText(), string), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, RubyResolveVisitor.b(rType, rQualifiedReference));
        } else {
            this.registerProblem(rQualifiedReference.getRefValue(), RBundle.message("inspection.resolve.cannot.find", rQualifiedReference.getCanonicalText()));
        }
    }

    @Override
    public void visitRUnaryExpression(@NotNull RUnaryExpression rUnaryExpression) {
        RQualifiedReference rQualifiedReference;
        if (rUnaryExpression == null) {
            RubyResolveVisitor.d(7);
        }
        if (rUnaryExpression instanceof RBoolNegExpression) {
            return;
        }
        RPsiElement rPsiElement = rUnaryExpression.getElement();
        RType rType = null;
        if (rPsiElement instanceof RExpression && !(rType = ((RExpression)rPsiElement).getType()).isTyped()) {
            return;
        }
        PsiReference psiReference = rUnaryExpression.getReference();
        if (psiReference instanceof RQualifiedReference && (rQualifiedReference = (RQualifiedReference)psiReference).multiResolve(false).length == 0) {
            this.a(rType, rQualifiedReference);
        }
    }

    @Override
    public void visitRAliasStatement(RAliasStatement rAliasStatement) {
        long l2 = c ^ 0xCA4FC73F489L;
        for (PsiReference psiReference : rAliasStatement.getReferences()) {
            if (psiReference.resolve() != null) continue;
            this.registerProblem((PsiElement)rAliasStatement.getPsiOldName(), RBundle.message("inspection.resolve.cannot.find", rAliasStatement.getOldName()));
        }
    }

    private static boolean a(@NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RubyResolveVisitor.d(8);
        }
        if (!rPsiElement.isValid()) {
            return false;
        }
        if (RReferenceNavigator.getRRefenceOrTopReference((PsiElement)rPsiElement) != null) {
            return false;
        }
        if (RubyPsiUtil.isClassModuleOrMethodName((PsiElement)rPsiElement)) {
            return false;
        }
        if (RSymbolNavigator.getSymbolByObject((PsiElement)rPsiElement) != null) {
            return false;
        }
        return RMacRubyArgumentNavigator.getByRPsiElement(rPsiElement) == null;
    }

    @Override
    public void visitRequireCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(9);
        }
        this.b(rCall);
    }

    @Override
    public void visitLoadCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(10);
        }
        this.b(rCall);
    }

    @Override
    public void visitPublicCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(11);
        }
        this.c(rCall);
    }

    @Override
    public void visitProtectedCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(12);
        }
        this.c(rCall);
    }

    @Override
    public void visitPrivateCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(13);
        }
        this.c(rCall);
    }

    private void c(RCall rCall) {
        long l2 = c ^ 0x70B83436B6C4L;
        for (PsiReference psiReference : rCall.getReferences()) {
            if (!(psiReference instanceof MethodReference) || psiReference.resolve() != null) continue;
            PsiElement psiElement = ((MethodReference)psiReference).getReferenceContent();
            this.registerProblem(psiElement, RBundle.message("inspection.resolve.cannot.find", psiReference.getCanonicalText()), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, RubyResolveVisitor.a(psiElement, Context.INSTANCE_PRIVATE));
        }
    }

    private void b(RCall rCall) {
        long l2 = c ^ 0x59BB0B9BF703L;
        if (BundlerUtil.isBundlerCall(rCall) || RailsUtil.isStrongParameter(rCall)) {
            return;
        }
        for (PsiReference psiReference : rCall.getReferences()) {
            RFileReference rFileReference;
            RFileReference rFileReference2 = psiReference instanceof RFileReference ? (RFileReference)psiReference : (rFileReference = psiReference instanceof RequireRelativeFileReference ? ((RequireRelativeFileReference)psiReference).getRFileReference() : null);
            if (rFileReference == null) continue;
            PsiFile psiFile = rCall.getContainingFile();
            PsiElement psiElement = rFileReference.getRefValue();
            String string = RFileUtil.evaluateRequirement(psiFile.getVirtualFile(), psiElement);
            if (string != null) {
                Collection<? extends VirtualFile> collection = rFileReference.multiResolveToVirtualFiles();
                if (!collection.isEmpty()) continue;
                this.registerProblem(psiElement, RBundle.message("inspection.resolve.cannot.find.required.file"));
                return;
            }
            this.registerProblem(psiElement, RBundle.message("inspection.resolve.implicit.required.item"));
            return;
        }
    }

    @Override
    public void visitIncludeCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(14);
        }
        if (RubyResolveVisitor.a((PsiElement)rCall)) {
            return;
        }
        this.a(rCall);
    }

    @Override
    public void visitExtendCall(@NotNull RCall rCall) {
        if (rCall == null) {
            RubyResolveVisitor.d(15);
        }
        this.a(rCall);
    }

    private void a(RCall rCall) {
        long l2 = c ^ 0x5FBD40AB1B39L;
        for (RPsiElement rPsiElement : rCall.getArguments()) {
            Symbol symbol;
            FQN fQN = RNameUtilCore.getPath((PsiElement)rPsiElement);
            if (RubyCallTypes.isIgnoredIncludeExtendArgument(rCall, fQN) || (symbol = ResolveUtil.resolveToSymbolWithCaching(rPsiElement.getReference())) != null || SymbolUtil.isAnonymousModule(fQN) || RSpecUtil.underShouldCall(rCall)) continue;
            this.registerProblem((PsiElement)rPsiElement, RBundle.message("inspection.resolve.cannot.resolve.include"));
        }
    }

    @Override
    public void visitRInstanceVariable(RInstanceVariable rInstanceVariable) {
        this.a(rInstanceVariable);
    }

    @Override
    public void visitRClassVariable(RClassVariable rClassVariable) {
        this.a(rClassVariable);
    }

    private void a(RField rField) {
        long l2 = c ^ 0x15E5A6450D5DL;
        if (!RubyResolveVisitor.a(rField)) {
            return;
        }
        RContainer rContainer = rField.getParentContainer();
        if (rContainer instanceof RModule || PsiTreeUtil.getParentOfType((PsiElement)rContainer, (Class[])new Class[]{RClass.class, RModule.class, RTopLevelContainer.class}) instanceof RModule) {
            return;
        }
        PsiReference psiReference = rField.getReference();
        if (psiReference == null) {
            return;
        }
        Symbol symbol = ResolveUtil.resolveToSymbolWithCaching(psiReference, !this.b);
        if (symbol == null || !symbol.getAllDeclarations((PsiElement)rField).stream().allMatch(RubyPsiUtil::isDeclaration)) {
            this.registerProblem((PsiElement)rField, RBundle.message("inspection.resolve.field.cannot.find", rField.getText()));
        }
    }

    private static boolean a(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            RubyResolveVisitor.d(16);
        }
        psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPossibleCall.class);
        while (psiElement != null) {
            if (RSpecUtil.isExampleCall((RPossibleCall)psiElement)) {
                return true;
            }
            psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiElement, RPossibleCall.class);
        }
        return false;
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = c ^ 0x50475FD4E04BL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rConstant";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rFid";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rIdentifier";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalVariable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rReference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBinaryExpression";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rUnaryExpression";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rCall";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/resolve/RubyResolveVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRConstant";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRFid";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRIdentifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRGlobalVariable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBinaryExpression";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRUnaryExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "shouldInspectElement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRequireCall";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitLoadCall";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPublicCall";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitProtectedCall";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPrivateCall";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIncludeCall";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "visitExtendCall";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideRspecExampleContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

