/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.rubocop;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.RubyGemExecutionContext;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopFileResultDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInitialInformation;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopInspection;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopLinterModel;
import org.jetbrains.plugins.ruby.ruby.inspections.rubocop.RubocopResponse;
import org.jetbrains.plugins.ruby.ruby.lang.RubyLanguage;

public class RubocopExternalAnnotator
extends ExternalAnnotator<RubocopInitialInformation, RubocopFileResultDescriptor> {
    public static final RubocopExternalAnnotator INSTANCE;
    public static final String FEATURE_RUBOCOP_AUTO_CHECK = "ruby.rubocop.check.background";
    public static final String FEATURE_RUBOCOP_MANUAL_CHECK = "ruby.rubocop.check.manual";
    private static final Logger a;
    private static final long b;

    @Nullable
    public RubocopInitialInformation collectInformation(@NotNull PsiFile psiFile) {
        long l2 = b ^ 0x3ECED3F26980L;
        if (psiFile == null) {
            RubocopExternalAnnotator.a(0);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = psiFile.getProject();
        if (project.isDisposed()) {
            a.debug("Project is disposed");
            return null;
        }
        if (!RubocopInspection.isEnabled(project)) {
            a.debug("Rubocop inspection disabled in " + project.getName());
            return null;
        }
        RubocopInitialInformation rubocopInitialInformation = RubocopExternalAnnotator.calcInitialInformation(psiFile);
        if (rubocopInitialInformation == null) {
            return null;
        }
        if (rubocopInitialInformation.getGemExecutionContext() != null) {
            return rubocopInitialInformation;
        }
        RubocopLinterModel.getModel(project).handleMissingGem(rubocopInitialInformation);
        return null;
    }

    @Nullable
    public RubocopFileResultDescriptor doAnnotate(final RubocopInitialInformation initialInformation) {
        if (!initialInformation.isValid()) {
            return null;
        }
        RubyGemExecutionContext rubyGemExecutionContext = initialInformation.getGemExecutionContext();
        if (rubyGemExecutionContext == null) {
            return null;
        }
        RubocopResponse rubocopResponse = RubocopResponse.computeWithArguments(rubyGemExecutionContext, (ProcessListener)new ProcessAdapter(){
            private static final long a = c.a(-4546683243546743999L, -8244941642793099889L, MethodHandles.lookup().lookupClass()).a(32894044262933L);

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.a(0);
                }
                try (OutputStream outputStream2 = event.getProcessHandler().getProcessInput();){
                    if (outputStream2 == null) {
                        return;
                    }
                    outputStream2.write(initialInformation.getSourceFileBytes());
                }
                catch (IOException iOException) {
                    a.warn((Throwable)iOException);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x4EE73286DD9FL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator$1", "startNotified"));
            }
        });
        if (!rubocopResponse.isSuccess()) {
            String string = rubocopResponse.getErrorMessage();
            assert (string != null);
            RubocopLinterModel.showRubocopError(string, RubocopLinterModel.createDisableRubocopAction(initialInformation.getProject()));
            return null;
        }
        List<RubocopResponse.File> list2 = rubocopResponse.getFiles();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        return initialInformation.isValid() ? new RubocopFileResultDescriptor(list2.get(0), rubyGemExecutionContext) : null;
    }

    public void apply(@NotNull PsiFile psiFile, @NotNull RubocopFileResultDescriptor resultDescriptor, @NotNull AnnotationHolder holder) {
        long l2 = b ^ 0x40C3F1AB3902L;
        if (psiFile == null) {
            RubocopExternalAnnotator.a(1);
        }
        if (resultDescriptor == null) {
            RubocopExternalAnnotator.a(2);
        }
        if (holder == null) {
            RubocopExternalAnnotator.a(3);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        resultDescriptor.annotateOffenses(psiFile, holder);
        FeatureUsageTracker.getInstance().triggerFeatureUsed(FEATURE_RUBOCOP_AUTO_CHECK);
    }

    @Nullable
    static RubocopInitialInformation calcInitialInformation(@NotNull PsiFile psiFile) {
        long l2 = b ^ 0x447D34F5D59FL;
        if (psiFile == null) {
            RubocopExternalAnnotator.a(4);
        }
        Project project = psiFile.getProject();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (a.isDebugEnabled()) {
            a.debug("Computing info for: " + PsiUtilCore.getVirtualFile((PsiElement)psiFile));
        }
        if (!psiFile.getLanguage().is((Language)RubyLanguage.INSTANCE) || !virtualFile.isValid() || psiFile.getViewProvider() instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
            if (a.isDebugEnabled()) {
                a.debug("Not good file: language: " + psiFile.getLanguage() + "; valid: " + virtualFile.isValid() + "; view provider: " + psiFile.getViewProvider());
            }
            return null;
        }
        Sdk sdk = RubocopExternalAnnotator.getFileSdk(project, virtualFile);
        if (a.isDebugEnabled()) {
            a.debug("File sdk is " + sdk);
        }
        return sdk == null ? null : new RubocopInitialInformation(sdk, psiFile);
    }

    @Nullable
    static Sdk getFileSdk(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            RubocopExternalAnnotator.a(5);
        }
        if (virtualFile == null) {
            RubocopExternalAnnotator.a(6);
        }
        return virtualFile.isInLocalFileSystem() ? RModuleUtil.getInstance().findRubySdkForVirtualFile(project, virtualFile) : null;
    }

    static {
        b = c.a(-4230420877108054173L, -3052547565788032814L, MethodHandles.lookup().lookupClass()).a(13379632621742L);
        INSTANCE = new RubocopExternalAnnotator();
        a = Logger.getInstance(RubocopExternalAnnotator.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x2E284833EC75L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/rubocop/RubocopExternalAnnotator";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calcInitialInformation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFileSdk";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

