/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.inspections.simplify;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ControlFlowHolder;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbolicExecution.NilAnalysisUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.RTypeUtil;
import org.jetbrains.plugins.ruby.ruby.inspections.RubyInspectionVisitor;
import org.jetbrains.plugins.ruby.ruby.inspections.simplify.RubySimplifyBooleanQuickFix;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolBinExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolMatchingExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RBoolNegExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RExpression;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.references.RDotReference;

class RubySimplifyBooleanVisitor
extends RubyInspectionVisitor {
    static final String RUBY_TRUE;
    static final String RUBY_FALSE;
    static final String RUBY_NIL;
    private static final long b;

    RubySimplifyBooleanVisitor(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            RubySimplifyBooleanVisitor.d(0);
        }
        super(holder);
    }

    @Override
    public void visitRBoolNegExpression(RBoolNegExpression rBoolNegExpression) {
        PsiElement psiElement;
        PsiElement psiElement2 = rBoolNegExpression.getParent();
        if (psiElement2 instanceof RBoolNegExpression) {
            return;
        }
        PsiElement psiElement3 = rBoolNegExpression.getLastChild();
        if (psiElement3 instanceof RBoolNegExpression && (psiElement = psiElement3.getLastChild()) instanceof RExpression && RTypeUtil.isBoolType(((RExpression)psiElement).getType())) {
            RExpression rExpression = (RExpression)psiElement;
            ControlFlowHolder controlFlowHolder = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)rBoolNegExpression, ControlFlowHolder.class);
            if (controlFlowHolder == null) {
                return;
            }
            ThreeState threeState = NilAnalysisUtil.getCanBeNil(rExpression, controlFlowHolder);
            if (threeState == ThreeState.NO) {
                this.a(rBoolNegExpression);
            }
        }
    }

    @Override
    public void visitRBoolBinExpression(RBoolBinExpression rBoolBinExpression) {
        RPsiElement rPsiElement = rBoolBinExpression.getLeftOperand();
        String string = rPsiElement.getText();
        if (RUBY_TRUE.equals(string) || RUBY_FALSE.equals(string) || RUBY_NIL.equals(string) || rPsiElement instanceof RLiteral) {
            this.a(rBoolBinExpression);
        }
    }

    @Override
    public void visitRBoolMatchingExpression(@NotNull RBoolMatchingExpression rBoolMatchingExpression) {
        RPsiElement rPsiElement;
        long l2 = b ^ 0x321C51486871L;
        if (rBoolMatchingExpression == null) {
            RubySimplifyBooleanVisitor.d(1);
        }
        RPsiElement rPsiElement2 = rBoolMatchingExpression.getLeftOperand();
        RPsiElement rPsiElement3 = rBoolMatchingExpression.getRightOperand();
        if (!(rPsiElement2 instanceof RExpression) || !(rPsiElement3 instanceof RExpression)) {
            return;
        }
        IElementType iElementType = rBoolMatchingExpression.getOperationType();
        if (RubyTokenTypes.tEQQ.equals(iElementType)) {
            return;
        }
        if (rPsiElement2 instanceof RDotReference && (rPsiElement = ((RDotReference)rPsiElement2).getValue()) != null && "should".equals(rPsiElement.getName())) {
            return;
        }
        rPsiElement = (ControlFlowHolder)PsiTreeUtil.getParentOfType((PsiElement)rBoolMatchingExpression, ControlFlowHolder.class);
        if (rPsiElement == null) {
            return;
        }
        if (RubySimplifyBooleanQuickFix.getReplacementElement(rBoolMatchingExpression) == null) {
            return;
        }
        if (RubySimplifyBooleanVisitor.b(rPsiElement2) && RTypeUtil.isBoolType(((RExpression)rPsiElement3).getType()) && NilAnalysisUtil.getCanBeNil(rPsiElement3, (ControlFlowHolder)rPsiElement) == ThreeState.NO) {
            this.a(rBoolMatchingExpression);
            return;
        }
        if (RubySimplifyBooleanVisitor.b(rPsiElement3) && RTypeUtil.isBoolType(((RExpression)rPsiElement2).getType()) && NilAnalysisUtil.getCanBeNil(rPsiElement2, (ControlFlowHolder)rPsiElement) == ThreeState.NO) {
            this.a(rBoolMatchingExpression);
        }
    }

    private void a(@NotNull RPsiElement rPsiElement) {
        long l2 = b ^ 0x39AAD30FE80L;
        if (rPsiElement == null) {
            RubySimplifyBooleanVisitor.d(2);
        }
        this.registerProblem((PsiElement)rPsiElement, RBundle.message("inspection.simplify.name"), new RubySimplifyBooleanQuickFix(rPsiElement));
    }

    private static boolean b(@NotNull RPsiElement rPsiElement) {
        if (rPsiElement == null) {
            RubySimplifyBooleanVisitor.d(3);
        }
        return RUBY_TRUE.equals(rPsiElement.getText()) || RUBY_FALSE.equals(rPsiElement.getText());
    }

    static {
        b = c.a(4280840725077437126L, 317680830658350868L, MethodHandles.lookup().lookupClass()).a(35462078560031L);
        RUBY_TRUE = RubyTokenTypes.kTRUE.toString();
        RUBY_FALSE = RubyTokenTypes.kFALSE.toString();
        RUBY_NIL = RubyTokenTypes.kNIL.toString();
    }

    private static /* synthetic */ void d(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x11F9DC962EDFL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rBoolMatchingExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/inspections/simplify/RubySimplifyBooleanVisitor";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRBoolMatchingExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "registerProblem";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPrimitiveBoolean";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

