/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.RubyTextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RStringLiteral;
import org.jetbrains.plugins.ruby.ruby.lang.psi.basicTypes.stringLiterals.RWords;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RArray;
import org.jetbrains.plugins.ruby.ruby.lang.psi.expressions.RListOfExpressions;

public class TextUtil
extends RubyTextUtil {
    private static final Logger i;
    private static final String k = "\\x7f-\\xff\\x{001C0}-\\x{10FFFF}";
    private static final String c = "[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]]";
    private static final String e = "[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]";
    private static final String g = "[_A-Za-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]";
    private static final String d = "[A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*";
    private static final String f = "[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]+[!?]?";
    public static final Pattern CID_PATTERN;
    private static final Pattern a;
    private static final Pattern m;
    private static final Pattern b;
    private static final Pattern j;
    private static final Pattern n;
    private static final Pattern l;
    private static final Pattern h;
    public static final Pattern INTEGER_PATTERN;
    public static final Pattern METHOD_NAME_PATTERN;
    public static final Pattern IDENTIFIER_PATTERN;
    public static final Pattern IDENTIFIER_LOWERCASE_PATTERN;
    public static final Pattern CONST_UPPERCASE_PATTERN;
    public static final Pattern NUMBERED_PARAMETER_PATTERN;
    public static final String EMPTY_STRING = "";
    public static final String SPACE_STRING = " ";
    private static final long p;

    private TextUtil() {
    }

    public static boolean isEol(char c10) {
        return c10 == '\n' || c10 == '\r';
    }

    public static boolean isWhiteSpace(char c10) {
        return c10 == ' ' || c10 == '\t' || c10 == '\f' || c10 == '\r' || c10 == '\u000b';
    }

    public static boolean isWhiteSpaceOrEol(char c10) {
        return TextUtil.isWhiteSpace(c10) || c10 == '\n';
    }

    public static char getOpenDelim(char c10) {
        if (c10 == ')') {
            return '(';
        }
        if (c10 == '>') {
            return '<';
        }
        if (c10 == '}') {
            return '{';
        }
        if (c10 == ']') {
            return '[';
        }
        return c10;
    }

    public static char getCloseDelim(char c10) {
        if (c10 == '(') {
            return ')';
        }
        if (c10 == '<') {
            return '>';
        }
        if (c10 == '{') {
            return '}';
        }
        if (c10 == '[') {
            return ']';
        }
        return c10;
    }

    public static boolean isRegexpModifier(char c10) {
        return c10 == 'i' || c10 == 'x' || c10 == 'm' || c10 == 'o' || c10 == 'n' || c10 == 'e' || c10 == 's' || c10 == 'u';
    }

    public static String escapeComparisonForHTML(String string) {
        long l2 = p ^ 0x268B896A460DL;
        String string2 = string.replaceAll("<", "&lt;");
        string2 = string2.replaceAll(">", "&gt;");
        return string2;
    }

    public static String concat(String ... strings) {
        StringBuilder stringBuilder = new StringBuilder(strings[0]);
        for (int i10 = 1; i10 < strings.length; ++i10) {
            if (strings[i10].length() <= 0) continue;
            stringBuilder.append(SPACE_STRING);
            stringBuilder.append(strings[i10]);
        }
        return stringBuilder.toString();
    }

    public static boolean isBraceLikeDelim(char c10) {
        return TextUtil.isOpenBrace(c10) || TextUtil.isCloseBrace(c10) || c10 == '<' || c10 == '>';
    }

    public static boolean isOpenBrace(char c10) {
        return c10 == '(' || c10 == '{' || c10 == '[';
    }

    public static boolean isCloseBrace(char c10) {
        return c10 == ')' || c10 == '}' || c10 == ']';
    }

    public static boolean isCID(@Nullable String content2) {
        return content2 != null && CID_PATTERN.matcher(content2).matches();
    }

    public static boolean isField(String content2) {
        return j.matcher(content2).matches();
    }

    public static boolean isFID(String content2) {
        return l.matcher(content2).matches();
    }

    public static boolean isAID(String content2) {
        return h.matcher(content2).matches();
    }

    public static boolean isConstId(String content2) {
        return n.matcher(content2).matches();
    }

    public static boolean isIdentifier(String content2) {
        return IDENTIFIER_PATTERN.matcher(content2).matches();
    }

    public static boolean isMethodName(String content2) {
        return METHOD_NAME_PATTERN.matcher(content2).matches();
    }

    public static boolean isDotFullyQualifiedRef(String content2) {
        return a.matcher(content2).matches();
    }

    public static boolean isCIDOrColonQualifiedReference(String content2) {
        return b.matcher(content2).matches();
    }

    public static boolean isClassOrModuleFqn(String content2) {
        return m.matcher(content2).matches();
    }

    public static boolean isQuote(char c10) {
        return c10 == '\"' || c10 == '\'';
    }

    public static char getCorrespondingChar(char c10) {
        if (TextUtil.isOpenBrace(c10)) {
            return TextUtil.getCloseDelim(c10);
        }
        if (TextUtil.isCloseBrace(c10)) {
            return TextUtil.getOpenDelim(c10);
        }
        if (TextUtil.isQuote(c10)) {
            return c10;
        }
        if (c10 == '/' || c10 == '`') {
            return c10;
        }
        return '\uffff';
    }

    @NotNull
    public static String wrapInParens(@NotNull String s2) {
        if (s2 == null) {
            TextUtil.b(0);
        }
        String string = "(" + s2 + ")";
        if (string == null) {
            TextUtil.b(1);
        }
        return string;
    }

    public static String removeQuoting(@NonNls @Nullable String s2) {
        long l2 = p ^ 0x41E2530B253AL;
        if (s2 == null || s2.length() <= 1) {
            return s2;
        }
        if (s2.startsWith("\"") && s2.endsWith("\"")) {
            return s2.substring(1, s2.length() - 1);
        }
        if (s2.startsWith("'") && s2.endsWith("'")) {
            return s2.substring(1, s2.length() - 1);
        }
        if (s2.startsWith("%q")) {
            if (s2.length() > 2) {
                return s2.substring(3, s2.length() - 1);
            }
            return EMPTY_STRING;
        }
        return s2;
    }

    public static void flattern(RPsiElement element, ArrayList<? super String> items) {
        long l2 = p ^ 0x6C8F78EB8400L;
        if (element instanceof RArray) {
            for (RPsiElement rPsiElement : ((RArray)element).getElements()) {
                TextUtil.flattern(rPsiElement, items);
            }
            return;
        }
        if (element instanceof RWords) {
            String string = element.getText();
            if (string.startsWith("%w")) {
                String[] stringArray = string.substring(3, string.length() - 1).split(SPACE_STRING);
                Collections.addAll(items, stringArray);
            } else {
                i.error("Unexpected literal:\n" + string);
            }
            return;
        }
        if (element instanceof RStringLiteral) {
            items.add(TextUtil.removeQuoting(element.getText()));
        }
    }

    public static String arrayToString(@Nullable RArray array) {
        PsiElement psiElement;
        long l2 = p ^ 0x439CED8737ACL;
        PsiElement psiElement2 = psiElement = array != null && array.getChildren().length > 0 ? array.getChildren()[0] : null;
        if (!(psiElement instanceof RListOfExpressions)) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        RListOfExpressions rListOfExpressions = (RListOfExpressions)psiElement;
        List<RPsiElement> list2 = rListOfExpressions.getElements();
        Iterator<RPsiElement> iterator = list2.iterator();
        while (iterator.hasNext()) {
            RPsiElement rPsiElement = iterator.next();
            stringBuilder.append(TextUtil.removeQuoting(rPsiElement.getText()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static String chomp(String s2) {
        s2 = StringUtil.trimEnd((String)s2, (String)"\n");
        s2 = StringUtil.trimEnd((String)s2, (String)"\r");
        return s2;
    }

    public static boolean isAnyID(String name) {
        return TextUtil.isCID(name) || TextUtil.isFID(name) || TextUtil.isAID(name);
    }

    public static boolean isInteger(@NotNull String versionText) {
        if (versionText == null) {
            TextUtil.b(2);
        }
        return INTEGER_PATTERN.matcher(versionText).matches();
    }

    @NotNull
    public static String trimTrailingSlashes(@Nullable String url) {
        if (url == null) {
            if (EMPTY_STRING == null) {
                TextUtil.b(3);
            }
            return EMPTY_STRING;
        }
        for (int i10 = url.length() - 1; i10 >= 0; --i10) {
            if (url.charAt(i10) == '/' || url.charAt(i10) == '\\') continue;
            String string = url.substring(0, i10 + 1);
            if (string == null) {
                TextUtil.b(4);
            }
            return string;
        }
        if (EMPTY_STRING == null) {
            TextUtil.b(5);
        }
        return EMPTY_STRING;
    }

    public static int getIndentSizeForLineAtOffset(@NotNull CharSequence charSequence, int offset) {
        int n2;
        if (charSequence == null) {
            TextUtil.b(6);
        }
        int n3 = 0;
        for (n2 = offset; n2 < charSequence.length() && Character.isWhitespace(charSequence.charAt(n2)); ++n2) {
        }
        --n2;
        while (n2 >= 0) {
            char c10 = charSequence.charAt(n2);
            if (c10 == '\n') {
                return n3;
            }
            n3 = Character.isWhitespace(c10) ? ++n3 : 0;
            --n2;
        }
        return n3;
    }

    public static int getFirstIndentSize(@NotNull CharSequence text2) {
        int n2;
        if (text2 == null) {
            TextUtil.b(7);
        }
        for (n2 = 0; n2 < text2.length() && text2.charAt(n2) == '\n'; ++n2) {
        }
        int n3 = 0;
        while (n2 + n3 < text2.length() && TextUtil.isWhiteSpace(text2.charAt(n2 + n3))) {
            ++n3;
        }
        return n3;
    }

    public static boolean isNumberedParameter(String content2) {
        return NUMBERED_PARAMETER_PATTERN.matcher(content2).matches();
    }

    static {
        p = com.jetbrains.python.psi.c.a(2002619097553223665L, 7648558587311885909L, MethodHandles.lookup().lookupClass()).a(77023419867349L);
        long l2 = p ^ 0x37121E5273D9L;
        i = Logger.getInstance(TextUtil.class);
        CID_PATTERN = Pattern.compile("[_A-Za-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");
        a = Pattern.compile("[A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*(::[A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)*\\.[_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]+[!?]?");
        m = Pattern.compile("[A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*(::[A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)*");
        b = Pattern.compile("([A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)?(::[A-Z[\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*)*");
        j = Pattern.compile("@@?[_A-Za-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");
        n = Pattern.compile(d);
        l = Pattern.compile("[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*[!?]");
        h = Pattern.compile("[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*=");
        INTEGER_PATTERN = Pattern.compile("^[-+]?\\d+$");
        METHOD_NAME_PATTERN = Pattern.compile(f);
        IDENTIFIER_PATTERN = Pattern.compile("[_a-z\\x7f-\\xff\\x{001C0}-\\x{10FFFF}&&[^\\p{Lu}]][_A-Za-z0-9\\x7f-\\xff\\x{001C0}-\\x{10FFFF}]*");
        IDENTIFIER_LOWERCASE_PATTERN = Pattern.compile("[_a-z][_a-z0-9]*");
        CONST_UPPERCASE_PATTERN = Pattern.compile("[A-Z[\\p{Lu}]][_A-Z0-9[\\p{Lu}]]*");
        NUMBERED_PARAMETER_PATTERN = Pattern.compile("@[1-9][0-9]?");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x61DC1054620FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/lang/TextUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSequence";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/lang/TextUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInParens";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailingSlashes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapInParens";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInteger";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSizeForLineAtOffset";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFirstIndentSize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

