/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.lang.documentation;

import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.ruby.codeInsight.completion.RubyPsiLookupElement;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyHelpUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RNameUtilCore;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;

public class RubyDocumentationProvider
implements DocumentationProvider {
    private static final Logger a;
    private static final String b = "http://rubydoc.info/";
    private static final long c;

    public String getQuickNavigateInfo(@NotNull PsiElement targetElement, PsiElement elementAtCursorOrReferenceOwner) {
        RPsiElement rPsiElement;
        if (targetElement == null) {
            RubyDocumentationProvider.a(0);
        }
        if ((rPsiElement = RubyDocumentationProvider.a(targetElement)) == null) {
            return null;
        }
        return QuickDocUtil.inferLinkFromFullDocumentation((DocumentationProvider)this, (PsiElement)targetElement, (PsiElement)elementAtCursorOrReferenceOwner, (String)RubyHelpUtil.getSimpleInfo(rPsiElement, true));
    }

    public List<String> getUrlFor(PsiElement targetElement, PsiElement elementAtCursor) {
        Collection<Object> collection;
        Symbol symbol;
        long l2 = c ^ 0xDC6DB4E4766L;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)targetElement);
        if (virtualFile == null) {
            return null;
        }
        FQN fQN = FQN.INVALID;
        if (targetElement instanceof RContainer && (symbol = SymbolUtil.getSymbolByContainer((RContainer)targetElement)) != null) {
            fQN = symbol.getFQNWithNesting();
            if (virtualFile.getParent().getName().startsWith("rubystubs")) {
                collection = symbol.getAllDeclarations(null);
                for (Object object : collection) {
                    VirtualFile virtualFile2 = object.getContainingFile().getVirtualFile();
                    if (virtualFile2 == null || virtualFile2.getParent().getName().startsWith("rubystubs")) continue;
                    virtualFile = virtualFile2;
                }
            }
        }
        collection = new ArrayList();
        Optional.ofNullable(elementAtCursor).map(ModuleUtilCore::findModuleForPsiElement).map(module2 -> ModuleRootManager.getInstance((Module)module2).getSdk()).ifPresent(arg_0 -> collection.add(arg_0));
        collection.addAll(ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)RubySdkType.getInstance()));
        StringBuilder stringBuilder = new StringBuilder(b);
        for (Sdk sdk : collection) {
            VirtualFile[] virtualFileArray = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
            for (VirtualFile virtualFile2 : virtualFileArray) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                stringBuilder.append("stdlib/");
                VirtualFile virtualFile3 = virtualFile;
                while (!Comparing.equal((Object)virtualFile3.getParent(), (Object)virtualFile2)) {
                    virtualFile3 = virtualFile3.getParent();
                }
                String string = virtualFile3.getNameWithoutExtension();
                stringBuilder.append(virtualFile2.getName().startsWith("rubystubs") ? "core" : string).append("/");
                String string2 = sdk.getVersionString();
                if (string2 != null) {
                    if (string2.contains("1.8.7")) {
                        stringBuilder.append("1.8.7/");
                    } else if (string2.contains("1.8.6")) {
                        stringBuilder.append("1.8.6/");
                    } else if (string2.contains("1.9.2")) {
                        stringBuilder.append("1.9.2/");
                    } else if (string2.contains("1.9.3")) {
                        stringBuilder.append("1.9.3/");
                    }
                }
                RubyDocumentationProvider.a(fQN, stringBuilder);
                return Collections.singletonList(stringBuilder.toString());
            }
            Collection<GemInfo> collection2 = GemManager.getInstance().getAllGems(sdk, ModuleUtilCore.findModuleForPsiElement((PsiElement)targetElement));
            Iterator iterator = collection2.iterator();
            while (iterator.hasNext()) {
                VirtualFile virtualFile2;
                GemInfo gemInfo = (GemInfo)iterator.next();
                virtualFile2 = gemInfo.getFile();
                if (virtualFile2 == null || !virtualFile2.isValid() || !VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false)) continue;
                stringBuilder.append("gems/").append(gemInfo.getName()).append("/").append(gemInfo.getVersion()).append("/");
                RubyDocumentationProvider.a(fQN, stringBuilder);
                return Collections.singletonList(stringBuilder.toString());
            }
        }
        return null;
    }

    private static void a(FQN fQN, StringBuilder stringBuilder) {
        long l2 = c ^ 0x52494A39DCFBL;
        if (fQN != null) {
            boolean bl2 = fQN.getFullPath().contains(".");
            boolean bl3 = false;
            FQN fQN2 = fQN.getCallerFQN();
            if ("$$SINGLETON$$".equals(fQN2.getShortName())) {
                fQN2 = fQN2.getCallerFQN();
                bl3 = true;
            }
            stringBuilder.append(fQN2.getFullPath().replace(RNameUtilCore.SYMBOL_DELIMITER, "/"));
            if (!bl2) {
                stringBuilder.append('/').append(fQN.getShortName());
            } else {
                stringBuilder.append("#").append(fQN.getShortName());
                if (!bl3) {
                    stringBuilder.append("-instance_method");
                } else {
                    stringBuilder.append("-class_method");
                }
            }
        }
    }

    public String generateDoc(PsiElement targetElement, @Nullable PsiElement elementAtCursor) {
        long l2 = c ^ 0x69E8EAC3741FL;
        if (targetElement instanceof RPsiElement) {
            if (elementAtCursor == null) {
                a.info("original element is null");
            }
            RPsiElement rPsiElement = RubyDocumentationProvider.a(elementAtCursor);
            if (elementAtCursor != null && rPsiElement == null) {
                a.info("corresponding element is null");
            }
            if (rPsiElement != null && !rPsiElement.isValid()) {
                a.info("Invalid origin element " + rPsiElement);
                return null;
            }
            return RubyHelpUtil.getHelpByElement(elementAtCursor, rPsiElement, (RPsiElement)targetElement);
        }
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof RubyPsiLookupElement) {
            return ((RubyPsiLookupElement)object).getPsiElement();
        }
        return null;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return RubyHelpUtil.getElementByLink(link, psiManager);
    }

    @Nullable
    private static RPsiElement a(@Nullable PsiElement psiElement) {
        if (psiElement == null) {
            return null;
        }
        if (psiElement instanceof RPsiElement) {
            return (RPsiElement)psiElement;
        }
        RPsiElement rPsiElement = RubyPsiUtil.getCoveringRPsiElement(psiElement);
        if (rPsiElement != null && psiElement.getTextRange() != null && rPsiElement.getTextRange().getStartOffset() == psiElement.getTextRange().getStartOffset()) {
            return rPsiElement;
        }
        int n2 = psiElement.getTextOffset() - 1;
        if (n2 >= 0) {
            RPsiElement rPsiElement2;
            PsiElement psiElement2 = psiElement.getContainingFile().findElementAt(n2);
            RPsiElement rPsiElement3 = rPsiElement2 = psiElement2 != null ? RubyPsiUtil.getCoveringRPsiElement(psiElement2) : null;
            if (rPsiElement2 != null && rPsiElement2.getTextOffset() == psiElement2.getTextOffset()) {
                return rPsiElement2;
            }
        }
        return null;
    }

    static {
        c = com.jetbrains.python.psi.c.a(-8102284471641138535L, -6697410644290764483L, MethodHandles.lookup().lookupClass()).a(104814522905220L);
        a = Logger.getInstance(RubyDocumentationProvider.class);
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = c ^ 0x11BCE727A71BL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "org/jetbrains/plugins/ruby/ruby/lang/documentation/RubyDocumentationProvider", "getQuickNavigateInfo"));
    }
}

