/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.presentation;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.IconManager;
import com.intellij.ui.icons.RowIcon;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.fqn.FQN;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.v2.AnonymousClassModuleSymbol;
import org.jetbrains.plugins.ruby.ruby.lang.lexer.RubyTokenTypes;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RPresentationConstants;

public class RContainerPresentationUtil
implements RPresentationConstants {
    private static final long a = c.a(-9034885594916568697L, -8434051802169529384L, MethodHandles.lookup().lookupClass()).a(193490709263763L);

    @NotNull
    public static String getContainerNameWithLocation(@NotNull RContainer container, boolean includeFile) {
        long l2 = a ^ 0x59F2794D5478L;
        if (container == null) {
            RContainerPresentationUtil.a(0);
        }
        if (container instanceof RFile) {
            String string = StringUtil.notNullize((String)((RFile)container).getPresentableLocation());
            if (string == null) {
                RContainerPresentationUtil.a(1);
            }
            return string;
        }
        FQN fQN = container.getFQNWithNesting();
        String string = fQN.getFullPath().contains("$$ANON") ? RContainerPresentationUtil.a(container, fQN) : RContainerPresentationUtil.getHumanizedFQN(fQN);
        if (!includeFile) {
            String string2 = string;
            if (string2 == null) {
                RContainerPresentationUtil.a(2);
            }
            return string2;
        }
        PsiFile psiFile = container.getContainingFile();
        if (psiFile instanceof RFile) {
            String string3 = ((RFile)psiFile).getPresentableLocation();
            String string4 = string.isEmpty() ? string3 : string + " in " + string3;
            if (string4 == null) {
                RContainerPresentationUtil.a(3);
            }
            return string4;
        }
        String string5 = string;
        if (string5 == null) {
            RContainerPresentationUtil.a(4);
        }
        return string5;
    }

    @NotNull
    public static String getHumanizedFQN(@NotNull FQN fqn, @Nullable Symbol anchorSymbol, @Nullable PsiElement anchorPsiElement) {
        int n2;
        long l2 = a ^ 0x5C64769A7BADL;
        if (fqn == null) {
            RContainerPresentationUtil.a(5);
        }
        if (fqn == FQN.INVALID) {
            if ("" == null) {
                RContainerPresentationUtil.a(6);
            }
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        List<String> list2 = fqn.asList();
        int n3 = -1;
        for (n2 = list2.size() - 1; n2 >= 0; --n2) {
            if (list2.get(n2).startsWith("$$")) continue;
            n3 = n2;
            break;
        }
        n2 = fqn.getFullPath().contains(".") ? 1 : 0;
        for (int i10 = 0; i10 < list2.size(); ++i10) {
            String string = list2.get(i10);
            if (!(i10 <= 0 || string.contains("$$") && i10 >= n3)) {
                stringBuilder.append(n2 != 0 && i10 + 1 == list2.size() ? "." : "::");
            }
            if (string.contains("$$")) {
                String string2;
                String string3;
                if ("$$SINGLETON$$".equals(string)) {
                    string3 = "singleton class";
                    string2 = " of ";
                } else {
                    if (!string.startsWith("$$ANON")) continue;
                    String string4 = StringUtil.join(list2.subList(0, i10 + 1), (String)"::");
                    while (anchorSymbol != null && !FQN.same(anchorSymbol.getFQNWithNesting(), string4)) {
                        anchorSymbol = anchorSymbol.getParentSymbol();
                    }
                    string3 = anchorSymbol instanceof AnonymousClassModuleSymbol ? ((AnonymousClassModuleSymbol)anchorSymbol).getPresentableName(anchorPsiElement) : "anonymous";
                    string2 = " in ";
                }
                if (i10 < n3) {
                    stringBuilder.append('<').append(string3).append('>');
                    continue;
                }
                stringBuilder.insert(0, string3 + (i10 == 0 ? "" : string2));
                continue;
            }
            stringBuilder.append(string);
        }
        String string = stringBuilder.toString();
        if (string == null) {
            RContainerPresentationUtil.a(7);
        }
        return string;
    }

    @NotNull
    public static String getHumanizedFQN(@NotNull FQN fqn) {
        if (fqn == null) {
            RContainerPresentationUtil.a(8);
        }
        String string = RContainerPresentationUtil.getHumanizedFQN(fqn, null, null);
        if (string == null) {
            RContainerPresentationUtil.a(9);
        }
        return string;
    }

    @NotNull
    public static String getLocation(@NotNull RPsiElement element) {
        RContainer rContainer;
        long l2 = a ^ 0x18BD1C9AFEDAL;
        if (element == null) {
            RContainerPresentationUtil.a(10);
        }
        if (!element.isValid()) {
            if ("<invalid>" == null) {
                RContainerPresentationUtil.a(11);
            }
            return "<invalid>";
        }
        boolean bl2 = element instanceof RContainer;
        RContainer rContainer2 = rContainer = bl2 ? (RContainer)element : element.getParentContainer();
        assert (rContainer != null);
        String string = RContainerPresentationUtil.getContainerNameWithLocation(rContainer, true);
        if (element instanceof RContainer) {
            int n2 = string.indexOf(" in ");
            if (n2 == -1) {
                String string2 = string;
                if (string2 == null) {
                    RContainerPresentationUtil.a(12);
                }
                return string2;
            }
            String string3 = string.substring(0, n2);
            int n3 = string3.lastIndexOf(".");
            if (n3 != -1) {
                string3 = string3.substring(0, n3);
                String string4 = string3 + string.substring(n2);
                if (string4 == null) {
                    RContainerPresentationUtil.a(13);
                }
                return string4;
            }
            String string5 = string.substring(n2 + 4);
            if (string5 == null) {
                RContainerPresentationUtil.a(14);
            }
            return string5;
        }
        String string6 = string;
        if (string6 == null) {
            RContainerPresentationUtil.a(15);
        }
        return string6;
    }

    public static Icon getIconWithModifiers(RContainer container) {
        return RContainerPresentationUtil.getIconWithModifiers(container, container.getIcon(0));
    }

    public static Icon getIconWithModifiers(RContainer container, Icon containerIcon) {
        if (container instanceof RMethod) {
            Visibility visibility = ((RMethod)container).getVisibility();
            return RContainerPresentationUtil.createIconWithAccessSign(containerIcon, visibility);
        }
        return containerIcon;
    }

    public static RowIcon createIconWithAccessSign(@NotNull Icon baseIcon, @NotNull Visibility modifier) {
        if (baseIcon == null) {
            RContainerPresentationUtil.a(16);
        }
        if (modifier == null) {
            RContainerPresentationUtil.a(17);
        }
        RowIcon rowIcon = IconManager.getInstance().createRowIcon(2);
        rowIcon.setIcon(baseIcon, 0);
        rowIcon.setIcon(RContainerPresentationUtil.getIconForAccessModifier(modifier), 1);
        return rowIcon;
    }

    @Nullable
    public static Icon getIconForAccessModifier(Visibility modifier) {
        if (modifier == Visibility.PRIVATE) {
            return AllIcons.Nodes.C_private;
        }
        if (modifier == Visibility.PUBLIC) {
            return AllIcons.Nodes.C_public;
        }
        if (modifier == Visibility.PROTECTED) {
            return AllIcons.Nodes.C_protected;
        }
        return null;
    }

    public static boolean isSelf(@NotNull FQN fqn) {
        if (fqn == null) {
            RContainerPresentationUtil.a(18);
        }
        return FQN.same(fqn, RubyTokenTypes.kSELF.toString());
    }

    @Nullable
    public static String getPresentableSymbolName(@Nullable Symbol symbol, @Nullable PsiElement invocationPoint) {
        if (symbol != null && symbol.getType() != Type.FILE) {
            return RContainerPresentationUtil.getHumanizedFQN(symbol.getFQNWithNesting(), symbol, invocationPoint);
        }
        return null;
    }

    @NotNull
    private static String a(@NotNull RContainer rContainer, @NotNull FQN fQN) {
        String string;
        Symbol symbol;
        long l2 = a ^ 0x73C22FD64F6DL;
        if (rContainer == null) {
            RContainerPresentationUtil.a(19);
        }
        if (fQN == null) {
            RContainerPresentationUtil.a(20);
        }
        String string2 = (symbol = SymbolUtil.getSymbolByContainer(rContainer)) != null ? ((string = (String)ObjectUtils.notNull((Object)ContainerUtil.getLastItem(fQN.asList()))).contains("$$ANON") ? (String)ObjectUtils.notNull((Object)RContainerPresentationUtil.getPresentableSymbolName(symbol, (PsiElement)rContainer)) : String.format("%s in %s", symbol.getName(), RContainerPresentationUtil.getPresentableSymbolName(symbol.getParentSymbol(), (PsiElement)rContainer))) : RContainerPresentationUtil.getHumanizedFQN(fQN);
        String string3 = string2;
        if (string3 == null) {
            RContainerPresentationUtil.a(21);
        }
        return string3;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1DB912E26A1FL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/presentation/RContainerPresentationUtil";
                break;
            }
            case 5: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseIcon";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nesting";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/presentation/RContainerPresentationUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerNameWithLocation";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getHumanizedFQN";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentationForContainerInAnonymousStruct";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainerNameWithLocation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getHumanizedFQN";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createIconWithAccessSign";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isSelf";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPresentationForContainerInAnonymousStruct";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

