/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod;

import com.intellij.codeInsight.codeFragment.CodeFragment;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.extractMethod.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.ExtractMethodSettings;
import com.intellij.refactoring.extractMethod.ExtractMethodSettingsImpl;
import com.intellij.refactoring.extractMethod.ExtractMethodValidator;
import com.intellij.refactoring.extractMethod.SimpleDuplicatesFinder;
import com.intellij.refactoring.extractMethod.SimpleMatch;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringElementListenerComposite;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.AbstractVariableData;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.references.RNumberedParameterReference;
import org.jetbrains.plugins.ruby.ruby.codeInsight.resolve.scope.ScopeUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Types;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.Symbol;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.structure.SymbolUtil;
import org.jetbrains.plugins.ruby.ruby.codeInsight.types.Context;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.MethodDescriptor;
import org.jetbrains.plugins.ruby.ruby.inspections.blocktoreference.RubyBlockToMethodReferenceUtil;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.lang.documentation.RubyCommentsUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RFile;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RPsiElement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyElementFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.blocks.RCompoundStatement;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgument;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RArgumentList;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RSingletonMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.Visibility;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RMethodHolder;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RTopLevelContainer;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.VisibilityUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.controlStructures.blocks.RCompoundStatementNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.iterators.RCodeBlockNavigator;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RBlockCall;
import org.jetbrains.plugins.ruby.ruby.lang.psi.iterators.RCodeBlock;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RIdentifier;
import org.jetbrains.plugins.ruby.ruby.lang.psi.variables.RNumberedParameter;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RefactoringPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyDuplicatesFinder;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodDialog;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHandler;
import org.jetbrains.plugins.ruby.ruby.refactoring.extractMethod.RubyExtractMethodHelperBase;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.settings.RubyCodeStyleSettings;

public class RubyExtractMethodHelper
extends RubyExtractMethodHelperBase {
    public static final RubyExtractMethodHelper HELPER;
    private static final long a;

    RubyExtractMethodHelper() {
    }

    @Override
    protected void handleExtractFromExpression(Project project, Editor editor2, CodeFragment codeFragment, RPsiElement expression) {
        long l2 = a ^ 0x36DB7891C764L;
        if (!codeFragment.getOutputVariables().isEmpty()) {
            String string = codeFragment.isReturnInstructionInside() ? RBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.with.return.statement.inside.and.notempty.output.variables") : RBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.from.expression.with.notempty.output.variables");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)string, (String)RubyExtractMethodHandler.DIALOG_TITLE, (String)"refactoring.extractMethod");
            return;
        }
        ExtractMethodSettings<Visibility> extractMethodSettings = this.getExtractSettings(project, codeFragment, expression);
        if (extractMethodSettings == null) {
            return;
        }
        String string = extractMethodSettings.getMethodName();
        AbstractVariableData[] abstractVariableDataArray = extractMethodSettings.getAbstractVariableData();
        RubyDuplicatesFinder rubyDuplicatesFinder = new RubyDuplicatesFinder(expression.getContainingFile(), (PsiElement)expression, (PsiElement)expression, abstractVariableDataArray);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RubyExtractMethodHandler.DIALOG_TITLE, null, () -> {
            RMethod rMethod = RubyExtractMethodHelper.a(project, extractMethodSettings, expression);
            rMethod = RubyExtractMethodHelper.a(expression, rMethod, (Visibility)((Object)((Object)extractMethodSettings.getVisibility())));
            RubyExtractMethodHelper.a(project, rMethod, abstractVariableDataArray);
            PsiElement psiElement = RubyExtractMethodHelper.a(codeFragment, string, abstractVariableDataArray, expression, project);
            psiElement = RefactoringPsiHelper.replaceExpression(project, (PsiElement)expression, psiElement);
            RContainer rContainer = RubyPsiUtil.getParentContainer(psiElement);
            RubyExtractMethodHelper.a(rContainer, psiElement, rMethod, rubyDuplicatesFinder, editor2);
            RubyExtractMethodHelper.setSelectionAndCaret(editor2, psiElement);
        }, (PsiFile[])new PsiFile[]{expression.getContainingFile()});
    }

    private static PsiElement a(@NotNull CodeFragment codeFragment, @NotNull String string, @NotNull AbstractVariableData[] abstractVariableDataArray, @NotNull RPsiElement rPsiElement, @NotNull Project project) {
        long l2 = a ^ 0x5745DE8A74DCL;
        if (codeFragment == null) {
            RubyExtractMethodHelper.b(0);
        }
        if (string == null) {
            RubyExtractMethodHelper.b(1);
        }
        if (abstractVariableDataArray == null) {
            RubyExtractMethodHelper.b(2);
        }
        if (rPsiElement == null) {
            RubyExtractMethodHelper.b(3);
        }
        if (project == null) {
            RubyExtractMethodHelper.b(4);
        }
        String string2 = (codeFragment.isReturnInstructionInside() ? "return " : "") + string;
        String string3 = RubyExtractMethodHelper.a(abstractVariableDataArray, false, true);
        if (StringUtil.isNotEmpty((String)string3)) {
            string2 = string2 + "(" + string3 + ")";
        }
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement((PsiElement)rPsiElement);
        assert (languageLevel != null);
        return RubyElementFactory.createElementFromText(project, string2, languageLevel);
    }

    private static RMethod a(Project project, ExtractMethodSettings<Visibility> extractMethodSettings, RPsiElement rPsiElement) {
        long l2 = a ^ 0x7C73FE47BCC3L;
        String string = RubyExtractMethodHelper.generateSignature(extractMethodSettings, rPsiElement, true) + rPsiElement.getText() + "\nend";
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement((PsiElement)rPsiElement);
        assert (languageLevel != null);
        RMethod rMethod = (RMethod)RubyElementFactory.createElementFromText(project, string, languageLevel);
        RubyPsiUtil.markGenerated((PsiElement)rMethod);
        return rMethod;
    }

    @Override
    protected void handleExtractFromStatements(Project project, Editor editor2, CodeFragment codeFragment, RPsiElement statement1, RPsiElement statement2) {
        long l2 = a ^ 0x7E3BAD151529L;
        List list2 = (List)codeFragment.getOutputVariables();
        if (!list2.isEmpty() && codeFragment.isReturnInstructionInside()) {
            String string = RBundle.message("refactoring.extract.method.error.cannot.perform.refactoring.with.return.statement.inside.and.notempty.output.variables");
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)string, (String)RubyExtractMethodHandler.DIALOG_TITLE, (String)"refactoring.extractMethod");
            return;
        }
        ExtractMethodSettings<Visibility> extractMethodSettings = this.getExtractSettings(project, codeFragment, statement1);
        if (extractMethodSettings == null) {
            return;
        }
        String string = extractMethodSettings.getMethodName();
        AbstractVariableData[] abstractVariableDataArray = extractMethodSettings.getAbstractVariableData();
        List<PsiElement> list3 = RubyExtractMethodHelper.collectElements((PsiElement)statement1, (PsiElement)statement2);
        RubyDuplicatesFinder rubyDuplicatesFinder = new RubyDuplicatesFinder(statement1.getContainingFile(), (PsiElement)statement1, (PsiElement)statement2, abstractVariableDataArray);
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement((PsiElement)statement1);
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RubyExtractMethodHandler.DIALOG_TITLE, null, () -> {
            Object object;
            CharSequence charSequence;
            long l2 = a ^ 0x62F6E7CD180L;
            RMethod rMethod = RubyExtractMethodHelper.a(project, extractMethodSettings, list3);
            rMethod = RubyExtractMethodHelper.a(statement1, rMethod, (Visibility)((Object)((Object)extractMethodSettings.getVisibility())));
            if (!list2.isEmpty()) {
                assert (!codeFragment.isReturnInstructionInside());
                if (list2.size() != 1 || !StringUtil.equals((CharSequence)ScopeUtil.getLastReturnName(rMethod), (CharSequence)((CharSequence)list2.get(0)))) {
                    charSequence = new StringBuilder();
                    for (Object object2 : list2) {
                        if (((StringBuilder)charSequence).length() > 0) {
                            ((StringBuilder)charSequence).append(",");
                        }
                        ((StringBuilder)charSequence).append((String)object2);
                    }
                    if (list2.size() > 1) {
                        ((StringBuilder)charSequence).insert(0, "return ");
                    }
                    object = RubyElementFactory.createElementFromText(project, ((StringBuilder)charSequence).toString(), languageLevel);
                    rMethod.getCompoundStatement().add((PsiElement)object);
                }
            }
            RubyExtractMethodHelper.a(project, rMethod, abstractVariableDataArray);
            if (list2.isEmpty()) {
                charSequence = RubyExtractMethodHelper.a(statement1, codeFragment) ? "return " : "";
            } else {
                object = new StringBuilder();
                for (String string2 : list2) {
                    if (((StringBuilder)object).length() > 0) {
                        ((StringBuilder)object).append(",");
                    }
                    ((StringBuilder)object).append(string2);
                }
                ((StringBuilder)object).append(" = ");
                charSequence = ((StringBuilder)object).toString();
            }
            object = RubyExtractMethodHelper.a(abstractVariableDataArray, false, true);
            boolean bl2 = RubyCodeStyleSettings.getInstance((Editor)editor2).PARENTHESES_AROUND_METHOD_ARGUMENTS && ((String)object).length() > 0;
            char c10 = bl2 ? (char)'(' : (char)' ';
            char c11 = bl2 ? (char)')' : (char)' ';
            String string3 = (String)charSequence + string + c10 + (String)object + c11;
            RPsiElement rPsiElement2 = RubyElementFactory.createElementFromText(project, string3, languageLevel);
            rPsiElement2 = RubyExtractMethodHelper.replaceElements(list3, (PsiElement)rPsiElement2);
            RContainer rContainer = RubyPsiUtil.getParentContainer((PsiElement)rPsiElement2);
            RubyExtractMethodHelper.a((PsiElement)rPsiElement2);
            RubyExtractMethodHelper.a(rContainer, (PsiElement)rPsiElement2, rMethod, rubyDuplicatesFinder, editor2);
            RubyExtractMethodHelper.setSelectionAndCaret(editor2, (PsiElement)rPsiElement2);
        }, (PsiFile[])new PsiFile[]{statement1.getContainingFile()});
    }

    @Override
    @NotNull
    protected String getFeatureId() {
        long l2 = a ^ 0x1D32ED0BCC67L;
        if ("refactoring.extractMethod" == null) {
            RubyExtractMethodHelper.b(5);
        }
        return "refactoring.extractMethod";
    }

    private static boolean a(RPsiElement rPsiElement, CodeFragment codeFragment) {
        RContainer rContainer = rPsiElement.getParentContainer();
        return !(rContainer instanceof RClass) && !(rContainer instanceof RModule) && codeFragment.isReturnInstructionInside();
    }

    private static void a(Project project, RMethod rMethod, AbstractVariableData[] abstractVariableDataArray) {
        Map<String, String> map2 = RubyExtractMethodHelper.a(abstractVariableDataArray);
        RArgumentList rArgumentList = rMethod.getArgumentList();
        assert (rArgumentList != null);
        for (RArgument rArgument : rArgumentList.getArguments()) {
            if (TextUtil.isNumberedParameter(rArgument.getText())) {
                RubyExtractMethodHelper.a(project, map2, rArgument, rMethod);
                continue;
            }
            boolean bl2 = RubyExtractMethodHelper.a(project, map2, rArgument);
            if (bl2) continue;
            break;
        }
    }

    private static void a(@NotNull Project project, @NotNull Map<String, String> map2, @NotNull RArgument rArgument, @NotNull RMethod rMethod) {
        if (project == null) {
            RubyExtractMethodHelper.b(6);
        }
        if (map2 == null) {
            RubyExtractMethodHelper.b(7);
        }
        if (rArgument == null) {
            RubyExtractMethodHelper.b(8);
        }
        if (rMethod == null) {
            RubyExtractMethodHelper.b(9);
        }
        RNumberedParameter rNumberedParameter = (RNumberedParameter)Objects.requireNonNull(PsiTreeUtil.getChildOfType((PsiElement)rArgument, RNumberedParameter.class));
        String string = rNumberedParameter.getText();
        String string2 = map2.get(string);
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement((PsiElement)rNumberedParameter);
        assert (languageLevel != null);
        Computable computable = () -> (RIdentifier)RubyElementFactory.createElementFromText(project, string2, languageLevel);
        CommonProcessors.CollectProcessor collectProcessor = new CommonProcessors.CollectProcessor();
        RNumberedParameterReference.visitUsagesInBlock(rMethod, string, (Processor<? super RNumberedParameter>)collectProcessor);
        for (RNumberedParameter rNumberedParameter2 : collectProcessor.getResults()) {
            rNumberedParameter2.replace((PsiElement)computable.compute());
        }
    }

    private static boolean a(@NotNull Project project, @NotNull Map<String, String> map2, @NotNull RArgument rArgument) {
        String string;
        String string2;
        if (project == null) {
            RubyExtractMethodHelper.b(10);
        }
        if (map2 == null) {
            RubyExtractMethodHelper.b(11);
        }
        if (rArgument == null) {
            RubyExtractMethodHelper.b(12);
        }
        if (!StringUtil.equals((CharSequence)(string2 = rArgument.getName()), (CharSequence)(string = map2.get(string2)))) {
            RIdentifier rIdentifier = rArgument.getIdentifier();
            if (rIdentifier == null) {
                return true;
            }
            UsageInfo[] usageInfoArray = RenameUtil.findUsages((PsiElement)rIdentifier, (String)string, (boolean)false, (boolean)false, Collections.singletonMap(rIdentifier, string));
            try {
                RenameUtil.doRename((PsiElement)rIdentifier, (String)string, (UsageInfo[])usageInfoArray, (Project)project, (RefactoringElementListener)new RefactoringElementListenerComposite());
            }
            catch (IncorrectOperationException incorrectOperationException) {
                RenameUtil.showErrorMessage((IncorrectOperationException)incorrectOperationException, (PsiElement)rIdentifier, (Project)project);
                return false;
            }
        }
        return true;
    }

    private static String a(AbstractVariableData[] abstractVariableDataArray, boolean bl2, boolean bl3) {
        long l2 = a ^ 0x36496E56DBE7L;
        StringBuilder stringBuilder = new StringBuilder();
        for (AbstractVariableData abstractVariableData : abstractVariableDataArray) {
            if (!bl2 && !abstractVariableData.isPassAsParameter()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(bl2 || bl3 ? abstractVariableData.getOriginalName() : abstractVariableData.getName());
        }
        return stringBuilder.toString();
    }

    private static Map<String, String> a(AbstractVariableData[] abstractVariableDataArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (AbstractVariableData abstractVariableData : abstractVariableDataArray) {
            hashMap.put(abstractVariableData.getOriginalName(), abstractVariableData.getName());
        }
        return hashMap;
    }

    private static RMethod a(@NotNull RPsiElement rPsiElement, @NotNull RMethod rMethod, @Nullable Visibility visibility) {
        RContainer rContainer;
        RCompoundStatement rCompoundStatement;
        Pair pair;
        if (rPsiElement == null) {
            RubyExtractMethodHelper.b(13);
        }
        if (rMethod == null) {
            RubyExtractMethodHelper.b(14);
        }
        if ((pair = (Pair)rPsiElement.getUserData(RubyPsiUtil.SELECTION_BREAKS_AST_NODE)) != null) {
            rPsiElement = (RPsiElement)pair.first;
        }
        RCompoundStatement rCompoundStatement2 = rCompoundStatement = (rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)rPsiElement, (Class[])new Class[]{RTopLevelContainer.class, RModule.class, RClass.class})) != null ? rContainer.getCompoundStatement() : (RCompoundStatement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)rPsiElement, (Class[])new Class[]{RCompoundStatement.class});
        assert (rCompoundStatement != null) : rPsiElement.getContainingFile();
        RContainer rContainer2 = RubyPsiUtil.getParentContainer((PsiElement)rPsiElement);
        if (!(rContainer2 instanceof RMethod) || rContainer instanceof RTopLevelContainer || rContainer == null) {
            RPsiElement rPsiElement2 = RubyPsiUtil.getStatement(rCompoundStatement, (PsiElement)rPsiElement);
            assert (rPsiElement2 != null);
            List<PsiComment> list2 = RubyCommentsUtil.getPsiComments((PsiElement)rPsiElement2);
            RPsiElement rPsiElement3 = list2.isEmpty() ? rPsiElement2 : (PsiElement)list2.get(0);
            return (RMethod)rPsiElement3.getParent().addBefore((PsiElement)rMethod, (PsiElement)rPsiElement3);
        }
        RPsiElement rPsiElement4 = RubyExtractMethodHelper.a((RMethod)rContainer2, rContainer, visibility);
        return (RMethod)rCompoundStatement.addAfter((PsiElement)rMethod, (PsiElement)rPsiElement4);
    }

    @Nullable(value="null means add first")
    private static RPsiElement a(@NotNull RMethod rMethod, @NotNull RContainer rContainer, @Nullable Visibility visibility) {
        Object object;
        RPsiElement rPsiElement32;
        RCompoundStatement rCompoundStatement;
        RPsiElement rPsiElement4;
        if (rMethod == null) {
            RubyExtractMethodHelper.b(15);
        }
        if (rContainer == null) {
            RubyExtractMethodHelper.b(16);
        }
        if ((rPsiElement4 = RubyPsiUtil.getStatement(rCompoundStatement = rContainer.getCompoundStatement(), (PsiElement)rMethod)) == null) {
            return RubyExtractMethodHelper.b(rMethod, rContainer);
        }
        if (visibility == null) {
            return rPsiElement4;
        }
        EnumMap<Visibility, RPsiElement> enumMap = new EnumMap<Visibility, RPsiElement>(Visibility.class);
        EnumMap<Visibility, RPsiElement> enumMap2 = new EnumMap<Visibility, RPsiElement>(Visibility.class);
        Visibility visibility2 = Visibility.PUBLIC;
        for (RPsiElement rPsiElement32 : rCompoundStatement.getStatements()) {
            if (VisibilityUtil.isVisibilityChangeCall(rPsiElement32.getNode())) {
                visibility2 = VisibilityUtil.getVisibility(rPsiElement32.getText());
                enumMap.put(visibility2, rPsiElement32);
                enumMap2.put(visibility2, rPsiElement32);
            } else if (rPsiElement32 instanceof RMethod) {
                enumMap.put(visibility2, rPsiElement32);
            }
            if (rPsiElement32 != rPsiElement4 || !enumMap.containsKey((Object)visibility)) continue;
            return (RPsiElement)enumMap.get((Object)visibility);
        }
        if (enumMap2.containsKey((Object)visibility)) {
            return (RPsiElement)enumMap2.get((Object)visibility);
        }
        if (visibility == Visibility.PUBLIC) {
            object = Stream.of((RPsiElement)enumMap2.get((Object)Visibility.PROTECTED), (RPsiElement)enumMap2.get((Object)Visibility.PRIVATE)).min((rPsiElement, rPsiElement2) -> {
                if (rPsiElement == null) {
                    return 1;
                }
                if (rPsiElement2 == null) {
                    return -1;
                }
                return rPsiElement.getTextRange().getStartOffset() - rPsiElement2.getTextRange().getStartOffset();
            }).orElseGet(() -> RubyExtractMethodHelper.b(rMethod, rContainer));
            return (RPsiElement)PsiTreeUtil.getPrevSiblingOfType((PsiElement)object, RPsiElement.class);
        }
        object = visibility == Visibility.PRIVATE ? null : (RPsiElement)enumMap2.get((Object)Visibility.PRIVATE);
        rPsiElement32 = RubyElementFactory.createElementFromText((PsiElement)rContainer, visibility.getPresentableName());
        PsiElement psiElement = rCompoundStatement.addBefore((PsiElement)rPsiElement32, (PsiElement)object);
        if (!(psiElement instanceof RPsiElement)) {
            RubyExtractMethodHelper.b(rMethod, rContainer);
        }
        return (RPsiElement)psiElement;
    }

    private static RPsiElement b(@NotNull RMethod rMethod, @NotNull RContainer rContainer) {
        long l2 = a ^ 0x5AA72778E71CL;
        if (rMethod == null) {
            RubyExtractMethodHelper.b(17);
        }
        if (rContainer == null) {
            RubyExtractMethodHelper.b(18);
        }
        throw new AssertionError((Object)(rContainer.getText() + ";;;" + rMethod.getText()));
    }

    private static RMethod a(Project project, ExtractMethodSettings<Visibility> extractMethodSettings, List<PsiElement> list2) {
        long l2 = a ^ 0x418403E08DD0L;
        PsiElement psiElement = list2.get(0);
        StringBuilder stringBuilder = new StringBuilder(RubyExtractMethodHelper.generateSignature(extractMethodSettings, (RPsiElement)psiElement, true));
        LanguageLevel languageLevel = RubyLanguageLevelPusher.getInstance().getLanguageLevelByElement(psiElement);
        for (PsiElement psiElement2 : list2) {
            stringBuilder.append(psiElement2.getText());
        }
        stringBuilder.append("\nend");
        RMethod rMethod = (RMethod)RubyElementFactory.createElementFromText(project, stringBuilder.toString(), languageLevel);
        RubyPsiUtil.markGenerated((PsiElement)rMethod);
        return rMethod;
    }

    public static String generateSignature(ExtractMethodSettings<Visibility> extractMethodSettings, @NotNull RPsiElement expression, boolean fakeSignature) {
        RContainer rContainer;
        long l2 = a ^ 0x2DC2EBF8109DL;
        if (expression == null) {
            RubyExtractMethodHelper.b(19);
        }
        boolean bl2 = (rContainer = expression.getParentContainer()) instanceof RSingletonMethod || rContainer instanceof RClass || rContainer instanceof RModule;
        String string = RubyExtractMethodHelper.a(extractMethodSettings.getAbstractVariableData(), fakeSignature, false);
        boolean bl3 = RubyCodeStyleSettings.getInstance((PsiElement)expression).PARENTHESES_AROUND_METHOD_ARGUMENTS && string.length() > 0;
        char c10 = bl3 ? (char)'(' : ' ';
        char c11 = bl3 ? (char)')' : ' ';
        return (bl2 ? "def self." : "def ") + extractMethodSettings.getMethodName() + (string.isEmpty() ? "" : c10 + string + c11) + "\n";
    }

    @Nullable
    ExtractMethodSettings<Visibility> getExtractSettings(Project project, CodeFragment codeFragment, RPsiElement expression) {
        long l2 = a ^ 0x7272518371B1L;
        RubyExtractMethodValidator rubyExtractMethodValidator = new RubyExtractMethodValidator(expression, Context.getContext((PsiElement)expression));
        RubyExtractMethodDialog rubyExtractMethodDialog = new RubyExtractMethodDialog(project, "method_name", codeFragment, rubyExtractMethodValidator, expression);
        return rubyExtractMethodDialog.showAndGet() ? new ExtractMethodSettingsImpl(rubyExtractMethodDialog.getMethodName(), rubyExtractMethodDialog.getAbstractVariableData(), rubyExtractMethodDialog.getVisibility()) : null;
    }

    private static void a(@Nullable RContainer rContainer, @NotNull PsiElement psiElement, @NotNull RMethod rMethod, @NotNull RubyDuplicatesFinder rubyDuplicatesFinder, @NotNull Editor editor2) {
        if (psiElement == null) {
            RubyExtractMethodHelper.b(20);
        }
        if (rMethod == null) {
            RubyExtractMethodHelper.b(21);
        }
        if (rubyDuplicatesFinder == null) {
            RubyExtractMethodHelper.b(22);
        }
        if (editor2 == null) {
            RubyExtractMethodHelper.b(23);
        }
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        if (rContainer instanceof RMethod) {
            RContainer rContainer2 = RubyPsiUtil.getParentContainer((PsiElement)rContainer);
            if (rContainer2 instanceof RClass || rContainer2 instanceof RModule) {
                arrayList.add((PsiElement)rContainer);
                for (RMethod rMethod2 : ((RMethodHolder)rContainer2).getMethods()) {
                    if (rMethod2.equals(rContainer) || rMethod2.equals(rMethod) || rMethod2.getClass() != rMethod.getClass()) continue;
                    arrayList.add((PsiElement)rMethod2);
                }
            } else {
                RubyExtractMethodHelper.a(rContainer2, arrayList);
            }
        }
        RubyExtractMethodHelper.a(rContainer, arrayList);
        ExtractMethodHelper.processDuplicates((PsiElement)psiElement, (PsiElement)rMethod, arrayList, (SimpleDuplicatesFinder)rubyDuplicatesFinder, (Editor)editor2, pair -> RubyExtractMethodHelper.a((SimpleMatch)pair.first, ((PsiElement)pair.second).copy()));
    }

    private static void a(RContainer rContainer, List<PsiElement> list2) {
        if (rContainer instanceof RFile) {
            for (RPsiElement rPsiElement : rContainer.getStatements()) {
                if (rPsiElement instanceof RClass || rPsiElement instanceof RModule) continue;
                list2.add((PsiElement)rPsiElement);
            }
        }
    }

    private static void a(@NotNull PsiElement psiElement) {
        RCompoundStatement rCompoundStatement;
        if (psiElement == null) {
            RubyExtractMethodHelper.b(24);
        }
        if ((rCompoundStatement = RCompoundStatementNavigator.getByPsiElement(psiElement)) == null) {
            return;
        }
        RCodeBlock rCodeBlock = RCodeBlockNavigator.getByBlockCmsSt(rCompoundStatement);
        if (rCodeBlock == null) {
            return;
        }
        RBlockCall rBlockCall = rCodeBlock.getBlockCall();
        if (rBlockCall == null) {
            return;
        }
        MethodDescriptor methodDescriptor = RubyBlockToMethodReferenceUtil.getBlockMethodDescriptor(rBlockCall);
        if (methodDescriptor != null) {
            RubyBlockToMethodReferenceUtil.replaceBlock(rBlockCall, methodDescriptor.getReference());
        }
    }

    private static void a(@NotNull SimpleMatch simpleMatch, @NotNull PsiElement psiElement) {
        if (simpleMatch == null) {
            RubyExtractMethodHelper.b(25);
        }
        if (psiElement == null) {
            RubyExtractMethodHelper.b(26);
        }
        PsiElement psiElement2 = RubyExtractMethodHelper.replaceElements(simpleMatch, psiElement);
        RubyExtractMethodHelper.a(psiElement2);
    }

    static {
        a = c.a(-1958360311430784041L, 2797817673402241119L, MethodHandles.lookup().lookupClass()).a(217908543003935L);
        HELPER = new RubyExtractMethodHelper();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x16F46B17645CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableData";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHelper";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableMap";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 9: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generatedMethod";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerMethod";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerClassModule";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 20: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callElement";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "match";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/refactoring/extractMethod/RubyExtractMethodHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeatureId";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateCallElement";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renameNumberedParameter";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "renameIdentifierParameter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "insertGeneratedMethod";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateElementForVisibility";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "reportUnexpectedExtraction";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "generateSignature";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processDuplicates";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyPostReplacementInspections";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "replaceMatch";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RubyExtractMethodValidator
    implements ExtractMethodValidator {
        private final RPsiElement b;
        private final Context a;
        private static final long c = com.jetbrains.python.psi.c.a(118896482599416407L, -2079224201494664547L, MethodHandles.lookup().lookupClass()).a(251816724904607L);

        RubyExtractMethodValidator(RPsiElement expression, Context context) {
            this.b = expression;
            this.a = context;
        }

        public String check(String name) {
            long l2 = c ^ 0x55B3C553D777L;
            Symbol symbol = SymbolUtil.getScopeContextWithCaching((PsiElement)this.b);
            assert (symbol != null);
            return SymbolUtil.findMethod(symbol, name, Types.METHODS_LIKE, this.a, (PsiElement)this.b) != null ? RBundle.message("refactoring.extract.method.error.method.name.clashes.with.existing.method") : null;
        }

        public boolean isValidName(String name) {
            return TextUtil.isMethodName(name);
        }
    }
}

