/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.moveInner;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.codeInsight.symbols.Type;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.classes.RClass;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.modules.RModule;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.moveInner.RubyMoveClassModuleImpl;
import org.jetbrains.plugins.ruby.ruby.refactoring.moveInner.RubyMoveClassModuleProcessor;
import org.jetbrains.plugins.ruby.utils.NamingConventions;

public class RubyMoveClassModuleDialog
extends RefactoringDialog {
    private static final Logger b;
    protected JTextField myExtractedContainerNameField;
    protected JTextField myExtractedFileNameField;
    protected TextFieldWithBrowseButton myTargetDirField;
    protected RContainer myContainer;
    private final Type a;
    private static final long c;

    public RubyMoveClassModuleDialog(Project project, RContainer container) {
        long l2 = c ^ 0x575CCC141CF9L;
        super(project, true);
        b.assertTrue(container instanceof RClass || container instanceof RModule, (Object)("Expected only class of module, but got '" + container.getText() + "'"));
        this.myContainer = container;
        this.a = this.myContainer.getSymbolType();
        this.myTargetDirField = new TextFieldWithBrowseButton();
        String string = this.a.getPresentableName();
        this.setTitle(RBundle.message("refactoring.move.class.module.header", string != null ? StringUtil.capitalize((String)string) : "Container"));
        this.initExtractedContainerField();
        this.initExtractedFilePathField();
        this.c();
        this.validateButtons();
        this.setAutoAdjustable(true);
        this.init();
    }

    protected void initExtractedContainerField() {
        this.myExtractedContainerNameField = new JTextField();
        this.myExtractedContainerNameField.setEditable(true);
        this.myExtractedContainerNameField.setText(this.myContainer.getName());
    }

    protected void initExtractedFilePathField() {
        long l2 = c ^ 0x318E84A5BADL;
        this.myExtractedFileNameField = new JTextField();
        this.myExtractedFileNameField.setEditable(true);
        this.myExtractedFileNameField.setText(NamingConventions.toUnderscoreCase(RubyMoveClassModuleImpl.getClassModuleQualifiedName(this.myContainer) + ".rb"));
        this.myExtractedFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(2986741015443385665L, -8497128757099157811L, MethodHandles.lookup().lookupClass()).a(136131114472439L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    1.a(0);
                }
                RubyMoveClassModuleDialog.this.validateButtons();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5AFA09FA9F56L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleDialog$1", "textChanged"));
            }
        });
    }

    private void c() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        VirtualFile virtualFile = this.getRoot();
        fileChooserDescriptor.setRoots(new VirtualFile[]{virtualFile});
        fileChooserDescriptor.withTreeRootVisible(true);
        this.myTargetDirField.setText(FileUtil.toSystemDependentName((String)(virtualFile != null ? virtualFile.getPath() : "")));
        this.myTargetDirField.addBrowseFolderListener(this.getFileBrowserTitle(), null, this.myContainer.getProject(), fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        ((JTextField)this.myTargetDirField.getChildComponent()).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = com.jetbrains.python.psi.c.a(8668300063565167946L, -1109987146095054779L, MethodHandles.lookup().lookupClass()).a(202413842674936L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                RubyMoveClassModuleDialog.this.validateButtons();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x416E15DF2B1L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleDialog$2", "textChanged"));
            }
        });
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExtractedContainerNameField;
    }

    protected JComponent createCenterPanel() {
        long l2 = c ^ 0x6DE3AC034916L;
        Box box = this.createBox();
        box.add(Box.createVerticalStrut(10));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)box, "Center");
        return jPanel;
    }

    protected Box createBox() {
        long l2 = c ^ 0x50F6BCFDDD80L;
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new BorderLayout());
        String string = this.a();
        JLabel jLabel = new JLabel(RBundle.message("refactoring.move.class.module.type", this.a.getPresentableName()) + " " + string);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jPanel.add((Component)jLabel, "Center");
        box.add(jPanel);
        box.add(Box.createVerticalStrut(10));
        RubyMoveClassModuleDialog.a(box, RBundle.message("refactoring.move.class.module.name.promt", this.a.getPresentableName()), this.myExtractedContainerNameField, 8);
        RubyMoveClassModuleDialog.a(box, RBundle.message("refactoring.move.class.module.to.file.name.promt"), this.myExtractedFileNameField, 5);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(this.getFileBrowserTitle()), "North");
        jPanel.add((Component)this.myTargetDirField, "Center");
        box.add(jPanel);
        return box;
    }

    @NotNull
    private String a() {
        String string = null;
        if (this.a == Type.CLASS) {
            string = ((RClass)this.myContainer).getQualifiedName();
        } else if (this.a == Type.MODULE) {
            string = ((RModule)this.myContainer).getQualifiedName();
        }
        String string2 = string == null ? "" : string;
        if (string2 == null) {
            RubyMoveClassModuleDialog.a(0);
        }
        return string2;
    }

    private static void a(Box box, String string, JTextField jTextField, int n2) {
        long l2 = c ^ 0x7E0466E3E782L;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(string), "North");
        jPanel.add((Component)jTextField, "Center");
        box.add(jPanel);
        box.add(Box.createVerticalStrut(n2));
    }

    @Nullable
    private PsiDirectory a(String string) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        if (virtualFile == null) {
            return null;
        }
        PsiDirectory psiDirectory = this.myContainer.getManager().findDirectory(virtualFile);
        if (psiDirectory == null) {
            return null;
        }
        return psiDirectory;
    }

    @Nullable
    protected VirtualFile getRoot() {
        return this.myContainer.getContainingFile().getVirtualFile().getParent();
    }

    @NotNull
    protected String getFileBrowserTitle() {
        long l2 = c ^ 0x3A4AF16DBFE7L;
        String string = RBundle.message("refactoring.move.class.module.directory", this.a.getPresentableName());
        if (string == null) {
            RubyMoveClassModuleDialog.a(1);
        }
        return string;
    }

    @Nullable
    public PsiDirectory getTargetDirectory() {
        return this.a(this.myTargetDirField.getText());
    }

    @NotNull
    public String getFilePath() {
        String string = this.myExtractedFileNameField.getText().trim();
        if (string == null) {
            RubyMoveClassModuleDialog.a(2);
        }
        return string;
    }

    @NotNull
    public String getNewContainerName() {
        String string = this.myExtractedContainerNameField.getText();
        if (string == null) {
            RubyMoveClassModuleDialog.a(3);
        }
        return string;
    }

    protected String getHelpId() {
        long l2 = c ^ 0x3EFFCDFC9C4FL;
        return "refactoring.move.module.dialog";
    }

    protected void doAction() {
        long l2 = c ^ 0x1F4D82805234L;
        String string = this.getNewContainerName();
        String string2 = this.getFilePath();
        PsiDirectory psiDirectory = this.getTargetDirectory();
        if (psiDirectory == null) {
            b.error("Target directory must be specified.");
            return;
        }
        this.invokeRefactoring(new RubyMoveClassModuleProcessor(this.myProject, this.myContainer, string, string2, psiDirectory));
    }

    protected void validateButtons() {
        super.validateButtons();
        this.setErrorText(this.b());
    }

    protected boolean areButtonsValid() {
        return this.b() == null;
    }

    @Nullable
    private String b() {
        long l2 = c ^ 0x7965E2484AA2L;
        PsiDirectory psiDirectory = this.getTargetDirectory();
        if (psiDirectory == null) {
            return RBundle.message("refactoring.move.class.module.warning.directory");
        }
        return psiDirectory.getVirtualFile().findFileByRelativePath(this.getFilePath()) != null ? RBundle.message("refactoring.move.class.module.warning.file.exists") : null;
    }

    static {
        c = com.jetbrains.python.psi.c.a(-991651835661236677L, -4482705495191238863L, MethodHandles.lookup().lookupClass()).a(192657359335476L);
        b = Logger.getInstance(RubyMoveClassModuleDialog.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = c ^ 0x1E4D3510338AL;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/ruby/ruby/refactoring/moveInner/RubyMoveClassModuleDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainerQualifiedName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileBrowserTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewContainerName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

