/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.refactoring.pullUp;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.ruby.lang.psi.RubyPsiUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersPsiHelper;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassMembersRefactoringSupport;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyClassRefactoringHandlerBase;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfo;
import org.jetbrains.plugins.ruby.ruby.refactoring.common.RubyMemberInfoStorage;
import org.jetbrains.plugins.ruby.ruby.refactoring.pullUp.RubyPullUpDialog;

public class RubyPullUpHandler
extends RubyClassRefactoringHandlerBase {
    private static final long a = c.a(-7670763990196882446L, 5355700230481989839L, MethodHandles.lookup().lookupClass()).a(134506725974252L);

    protected void showDialog(Project project, PsiElement element, Editor editor2, PsiFile file, DataContext dataContext) {
        long l2 = a ^ 0x4483269D2268L;
        CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)file);
        RContainer rContainer = RubyPsiUtil.getContainingRClassOrModule(element);
        assert (rContainer != null);
        RubyMemberInfoStorage rubyMemberInfoStorage = RubyClassMembersRefactoringSupport.getSelectedMemberInfos(rContainer, element);
        if (rubyMemberInfoStorage.getClassMemberInfos((PsiElement)rContainer).isEmpty()) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)RefactoringBundle.getCannotRefactorMessage((String)"No members to pull up found"), (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        Set<RContainer> set = rubyMemberInfoStorage.getInstanceClasses();
        Set<RContainer> set2 = rubyMemberInfoStorage.getStaticClasses();
        if (set.size() == 0 && set2.size() == 0) {
            String string = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"class.does.not.have.base.classes.interfaces.in.current.project", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)rContainer)}).replace("interfaces", "modules"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor2, (String)string, (String)RefactoringBundle.message((String)"pull.members.up.title"), (String)"members.pull.up");
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        RubyPullUpDialog rubyPullUpDialog = new RubyPullUpDialog(project, rContainer, set, set2, rubyMemberInfoStorage);
        if (rubyPullUpDialog.showAndGet()) {
            RubyPullUpHandler.pullUp(rContainer, rubyPullUpDialog.getSelectedMemberInfos(), rubyPullUpDialog.getSuperClass(), rubyPullUpDialog.isStatic());
        }
    }

    protected String getInvalidPositionMessage() {
        long l2 = a ^ 0x57862A0CB168L;
        return RefactoringBundle.message((String)"the.caret.should.be.positioned.inside.a.class.to.pull.members.from");
    }

    static void pullUp(RContainer clazz, Collection<RubyMemberInfo> selectedMemberInfos, RContainer superClass, boolean isStatic) {
        long l2 = a ^ 0x7C27827A4C96L;
        Project project = clazz.getProject();
        CommandProcessor.getInstance().executeCommand(project, () -> PostprocessReformattingAspect.getInstance((Project)project).postponeFormattingInside(() -> WriteAction.run(() -> RubyPullUpHandler.navigate((PsiElement)RubyPullUpHandler.a(selectedMemberInfos, superClass, isStatic)))), RefactoringBundle.message((String)"pullUp.command", (Object[])new Object[]{DescriptiveNameUtil.getDescriptiveName((PsiElement)clazz)}), null);
    }

    @Nullable
    private static PsiElement a(Collection<RubyMemberInfo> collection, RContainer rContainer, boolean bl2) {
        long l2 = a ^ 0x2DE2A2235A70L;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        RubyClassMembersPsiHelper.splitByAccess(collection, arrayList, arrayList2, arrayList3);
        PsiElement psiElement = RubyClassMembersPsiHelper.insertMethods(rContainer, arrayList3, "private", bl2);
        PsiElement psiElement2 = RubyClassMembersPsiHelper.insertMethods(rContainer, arrayList2, "protected", bl2);
        PsiElement psiElement3 = RubyClassMembersPsiHelper.insertMethods(rContainer, arrayList, "public", bl2);
        RubyClassMembersPsiHelper.removeMembers(collection);
        return psiElement3 != null ? psiElement3 : (psiElement2 != null ? psiElement2 : psiElement);
    }

    protected String getHelpId() {
        long l2 = a ^ 0x356A374B69F6L;
        return "members.pull.up";
    }

    protected String getTitle() {
        long l2 = a ^ 0x22BDDB6E259FL;
        return RefactoringBundle.message((String)"pull.members.up.title");
    }
}

