/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemInfo;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.GemModificationUtil;
import org.jetbrains.plugins.ruby.gem.GemUtil;
import org.jetbrains.plugins.ruby.gem.module.GemRequirementsChangeWatcher;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.lang.psi.impl.RubyLanguageLevelPusher;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RbConfig;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkUtil;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySupportProvider;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;

public final class RubySdkPatcher
implements ProjectComponent {
    @NonNls
    private static final String d = "[gem]";
    private static final Logger b;
    private final Project c;
    private static final Map<String, Pair<LanguageLevel, Boolean>> a;
    private static final long e;

    public RubySdkPatcher(Project project) {
        this.c = project;
    }

    private static void a(@NotNull GemManager gemManager, Sdk sdk, Set<String> set, @Nullable Set<String> set2) {
        if (gemManager == null) {
            RubySdkPatcher.a(0);
        }
        if (set == null) {
            return;
        }
        SdkModificator sdkModificator = sdk.getSdkModificator();
        RubySdkPatcher.a(gemManager);
        RubySdkPatcher.a(gemManager, sdk, set, sdkModificator);
        RubySdkPatcher.a(sdk, set2, sdkModificator);
        VirtualFile[] virtualFileArray = sdkModificator.getRoots(OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        for (RubySupportProvider rubySupportProvider : RubySupportProvider.EP_NAME.getExtensionList()) {
            rubySupportProvider.sdkRootsChanged(sdk.getName(), virtualFileArray);
        }
    }

    public void projectOpened() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Runnable runnable = () -> {
            long l2 = e ^ 0x4C4841F323B1L;
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.c, "Refreshing Gem Paths", false){
                private static final long a = com.jetbrains.python.psi.c.a(5874958022379144289L, 8992193671296600731L, MethodHandles.lookup().lookupClass()).a(219476063182022L);

                public void run(@NotNull ProgressIndicator indicator) {
                    Collection collection;
                    long l2 = a ^ 0x275FEF5C862DL;
                    if (indicator == null) {
                        1.a(0);
                    }
                    if (!(collection = RubySdkPatcher.this.a()).isEmpty()) {
                        RubySdkPatcher.a(this.myProject, collection, null);
                    }
                    assert (this.myProject != null) : "Project must not be null here";
                    if (!this.myProject.isDisposed()) {
                        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                            if (!RModuleUtil.getInstance().hasRubySupport(module2) || module2.isDisposed()) continue;
                            GemRequirementsChangeWatcher.getInstance(module2).start();
                        }
                        MessageBusConnection messageBusConnection = this.myProject.getMessageBus().connect((Disposable)this.myProject);
                        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){
                            private static final long a = com.jetbrains.python.psi.c.a(-8817452783990047672L, -5397335753164804457L, MethodHandles.lookup().lookupClass()).a(8850127513965L);

                            public void moduleAdded(@NotNull Project project, @NotNull Module module2) {
                                if (project == null) {
                                    1.a(0);
                                }
                                if (module2 == null) {
                                    1.a(1);
                                }
                                if (RModuleUtil.getInstance().hasRubySupport(module2)) {
                                    GemRequirementsChangeWatcher.getInstance(module2).start();
                                }
                            }

                            private static /* synthetic */ void a(int n2) {
                                Object[] objectArray;
                                long l2 = a ^ 0x4F88435F1FE8L;
                                Object[] objectArray2 = new Object[3];
                                switch (n2) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "project";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[0] = "module";
                                        break;
                                    }
                                }
                                objectArray[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher$1$1";
                                objectArray[2] = "moduleAdded";
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                        messageBusConnection.subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){
                            private static final long a = com.jetbrains.python.psi.c.a(4106398970098567006L, 1957245429089600243L, MethodHandles.lookup().lookupClass()).a(91928856672202L);

                            public void facetRemoved(@NotNull Facet facet) {
                                if (facet == null) {
                                    2.a(0);
                                }
                                this.a(facet);
                            }

                            public void facetAdded(@NotNull Facet facet) {
                                if (facet == null) {
                                    2.a(1);
                                }
                                this.a(facet);
                            }

                            public void facetConfigurationChanged(@NotNull Facet facet) {
                                if (facet == null) {
                                    2.a(2);
                                }
                                this.a(facet);
                            }

                            private void a(@NotNull Facet facet) {
                                if (facet == null) {
                                    2.a(3);
                                }
                                Module module2 = facet.getModule();
                                if (RModuleUtil.getInstance().hasRubySupport(module2)) {
                                    GemRequirementsChangeWatcher.getInstance(module2).start();
                                } else {
                                    GemRequirementsChangeWatcher.getInstance(module2).stop();
                                }
                            }

                            private static /* synthetic */ void a(int n2) {
                                Object[] objectArray;
                                long l2 = a ^ 0x79520E8FBC6BL;
                                Object[] objectArray2 = new Object[3];
                                objectArray2[0] = "facet";
                                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher$1$2";
                                switch (n2) {
                                    default: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "facetRemoved";
                                        break;
                                    }
                                    case 1: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "facetAdded";
                                        break;
                                    }
                                    case 2: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "facetConfigurationChanged";
                                        break;
                                    }
                                    case 3: {
                                        objectArray = objectArray2;
                                        objectArray2[2] = "enableRequirementsWatcherIfNeeded";
                                        break;
                                    }
                                }
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                            }
                        });
                    }
                }

                private static /* synthetic */ void a(int n2) {
                    long l2 = a ^ 0x6C1A38BF80B7L;
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher$1", "run"));
                }
            });
        };
        if (this.c.isInitialized() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            runnable.run();
        } else {
            StartupManager.getInstance((Project)this.c).runWhenProjectIsInitialized(runnable);
        }
    }

    public static void prepareGemRootsAndRefresh(@NotNull Sdk rubySdk, @Nullable Runnable callback) {
        if (rubySdk == null) {
            RubySdkPatcher.a(1);
        }
        RubySdkPatcher.a(null, Collections.singleton(rubySdk), callback);
    }

    public static Future<?> prepareGemRootsAndRefreshOnPooledThread(@NotNull Sdk rubySdk, @Nullable Runnable callback) {
        if (rubySdk == null) {
            RubySdkPatcher.a(2);
        }
        EmptyProgressIndicator emptyProgressIndicator = new EmptyProgressIndicator();
        return ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> RubySdkPatcher.prepareGemRootsAndRefresh(rubySdk, callback), (ProgressIndicator)emptyProgressIndicator));
    }

    private Collection<Sdk> a() {
        HashSet<Sdk> hashSet = new HashSet<Sdk>();
        for (Module module2 : ModuleManager.getInstance((Project)this.c).getModules()) {
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
            if (sdk == null) continue;
            hashSet.add(sdk);
        }
        return hashSet;
    }

    private static void a(@Nullable Project project, @NotNull Collection<Sdk> collection, @Nullable Runnable runnable) {
        if (collection == null) {
            RubySdkPatcher.a(3);
        }
        HashMap<String, Set<String>> hashMap = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> hashMap2 = new HashMap<String, Set<String>>();
        int n2 = 0;
        List list2 = ContainerUtil.filter(collection, sdk -> sdk != null && !RubySdkPatcher.b(sdk));
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.setIndeterminate(false);
        }
        for (Sdk sdk2 : list2) {
            RbConfig.initIfNecessary(sdk2);
            sdk2.getVersionString();
            hashMap.put(sdk2.getName(), GemUtil.determineGemUrlsForSDK(sdk2));
            hashMap2.put(sdk2.getName(), RubySdkPatcher.c(sdk2));
            if (progressIndicator == null) continue;
            progressIndicator.setFraction((double)(++n2 / list2.size()));
        }
        Runnable runnable2 = () -> {
            ApplicationManager.getApplication().runWriteAction(() -> {
                Runnable runnable = () -> {
                    for (Sdk sdk : list2) {
                        RubySdkPatcher.a(GemManager.getInstance(), sdk, (Set<String>)((Set)hashMap.get(sdk.getName())), (Set)hashMap2.get(sdk.getName()));
                    }
                };
                if (project == null || project.isDisposed()) {
                    runnable.run();
                } else {
                    ProjectRootManagerEx.getInstanceEx((Project)project).mergeRootsChangesDuring(runnable);
                }
            });
            for (Sdk sdk : list2) {
                a.put(sdk.getName(), (Pair<LanguageLevel, Boolean>)Pair.create((Object)((Object)RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk)), (Object)RVMSupportUtil.isGlobalGempathIgnored(sdk)));
            }
            if (runnable != null) {
                runnable.run();
            }
        };
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeLater(runnable2);
    }

    private static void a(@NotNull GemManager gemManager, @NotNull Sdk sdk, @NotNull Set<String> set, @NotNull SdkModificator sdkModificator) {
        if (gemManager == null) {
            RubySdkPatcher.a(4);
        }
        if (sdk == null) {
            RubySdkPatcher.a(5);
        }
        if (set == null) {
            RubySdkPatcher.a(6);
        }
        if (sdkModificator == null) {
            RubySdkPatcher.a(7);
        }
        if (gemManager.isRegistered(sdk)) {
            gemManager.softRefreshRoots(sdk, set);
            gemManager.flushLibraries(sdk);
        } else {
            gemManager.addGemsForSdk(sdk, set, true);
            RubySdkPatcher.a(set, sdkModificator);
        }
    }

    private static void a(@NotNull Sdk sdk, @Nullable Set<String> set, @NotNull SdkModificator sdkModificator) {
        long l2 = e ^ 0x13CFC43B7772L;
        if (sdk == null) {
            RubySdkPatcher.a(8);
        }
        if (sdkModificator == null) {
            RubySdkPatcher.a(9);
        }
        boolean bl2 = set != null;
        sdkModificator.setVersionString(sdk.getVersionString());
        String string = RubySdkUtil.getStubsFolder(sdk);
        boolean bl3 = false;
        if (bl2) {
            sdkModificator.removeAllRoots();
        } else {
            for (VirtualFile object : sdkModificator.getRoots(OrderRootType.CLASSES)) {
                String string2 = object.getName();
                if (string2.equals(string)) {
                    bl3 = true;
                    continue;
                }
                if (!string2.startsWith("rubystubs")) continue;
                sdkModificator.removeRoot(object, OrderRootType.CLASSES);
            }
        }
        if (!bl3) {
            HashSet hashSet = new HashSet();
            RubySdkType.addRubyStubsUrls(hashSet, sdk);
            Iterator<Object> iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string3);
                if (virtualFile == null || !virtualFile.isValid() || !virtualFile.isDirectory()) continue;
                sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
            }
            if (set != null) {
                for (String string4 : set) {
                    VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string4);
                    if (virtualFile == null || !virtualFile.isValid() || !virtualFile.isDirectory()) continue;
                    sdkModificator.addRoot(virtualFile, OrderRootType.CLASSES);
                }
            }
        }
    }

    private static void a(@NotNull Set<String> set, @NotNull SdkModificator sdkModificator) {
        if (set == null) {
            RubySdkPatcher.a(10);
        }
        if (sdkModificator == null) {
            RubySdkPatcher.a(11);
        }
        for (String string : set) {
            VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
            if (virtualFile == null) continue;
            sdkModificator.removeRoot(virtualFile, OrderRootType.CLASSES);
            sdkModificator.removeRoot(virtualFile, OrderRootType.SOURCES);
        }
    }

    private static void a(@NotNull GemManager gemManager) {
        long l2 = e ^ 0x80E9C0F6A44L;
        if (gemManager == null) {
            RubySdkPatcher.a(12);
        }
        LibraryTable.ModifiableModel modifiableModel = GemModificationUtil.getLibraryTableModifiableModel();
        for (Library library : modifiableModel.getLibraries()) {
            String string = library.getName();
            if (string != null && string.startsWith(d)) {
                modifiableModel.removeLibrary(library);
            }
            if (gemManager.needsLibraryUpdate() && GemInfo.isGemLibrary(string)) {
                modifiableModel.removeLibrary(library);
            }
            if (!(library instanceof LibraryEx) || ((LibraryEx)library).getInvalidRootUrls(OrderRootType.CLASSES).isEmpty() || !GemInfo.isGemLibrary(string)) continue;
            modifiableModel.removeLibrary(library);
        }
        if (modifiableModel.isChanged()) {
            modifiableModel.commit();
        } else {
            GemModificationUtil.disposeLibraryTableModifiableModel(modifiableModel);
        }
    }

    @Nullable
    private static Set<String> c(Sdk sdk) {
        if (RubySdkUtil.canChangeLanguageLevel(sdk)) {
            Pair<LanguageLevel, Boolean> pair = a.get(sdk.getName());
            LanguageLevel languageLevel = RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk);
            if (pair == null || languageLevel != pair.first) {
                return RubySdkType.buildSdkLoadpath(sdk);
            }
        }
        return null;
    }

    private static boolean b(@NotNull Sdk sdk) {
        Pair<LanguageLevel, Boolean> pair;
        if (sdk == null) {
            RubySdkPatcher.a(13);
        }
        return (pair = a.get(sdk.getName())) != null && RubyLanguageLevelPusher.getEffectiveLanguageLevel(sdk) == pair.first && RVMSupportUtil.isGlobalGempathIgnored(sdk) == (Boolean)pair.second;
    }

    static {
        e = com.jetbrains.python.psi.c.a(-8073303968286692737L, 1768793607659248123L, MethodHandles.lookup().lookupClass()).a(57865979419102L);
        b = Logger.getInstance(RubySdkPatcher.class);
        a = new HashMap<String, Pair<LanguageLevel, Boolean>>();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x6168BC472878L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 2: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubySdks";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemUrls";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificator";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubySdkPatcher";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doRefresh";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareGemRootsAndRefresh";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareGemRootsAndRefreshOnPooledThread";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "revalidateGems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "revalidateRubyStubs";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "removeOldPlainGemUrls";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "removeIncompatibleOldGems";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "alreadyCached";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

