/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.lang.TextUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.ruby.sdk.LanguageLevel;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.sdk.RubySdkType;
import org.jetbrains.plugins.ruby.ruby.sdk.jruby.JRubySdkUtil;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;

public class RubyVersionUtil {
    private static final List<String> a;
    public static final String JRUBY_9000 = "9.0.0.0.snapshot";
    @NonNls
    public static final String GET_PATCHLEVEL_SCRIPT = "print(defined?(RUBY_PATCHLEVEL) ? RUBY_PATCHLEVEL : 0)";
    protected static final Logger LOG;
    @NonNls
    private static final String c = "maglev";
    @NonNls
    private static final String d = "rubinius";
    private static final Pattern e;
    @NonNls
    private static final String g = "macruby";
    @NonNls
    private static final String f = "ir";
    private static final TreeMap<String, String> b;
    private static final long h;

    private RubyVersionUtil() {
    }

    @Nullable
    public static String extractPlatformFromVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        int n2 = version.indexOf(91);
        int n3 = version.indexOf(93);
        if (n2 != -1 && n3 != -1) {
            return version.substring(n2 + 1, n3);
        }
        return null;
    }

    @Nullable
    static String getFullVersion(@Nullable Sdk sdk, @NotNull NullableConsumer<? super String> validationCallback) {
        RubyRunner rubyRunner;
        String string;
        Object object;
        if (validationCallback == null) {
            RubyVersionUtil.a(0);
        }
        if (sdk == null) {
            return null;
        }
        SdkAdditionalData sdkAdditionalData = sdk.getSdkAdditionalData();
        if (sdkAdditionalData instanceof RubySdkAdditionalData) {
            object = (RubySdkAdditionalData)sdkAdditionalData;
            String string2 = ((RubySdkAdditionalData)object).getNormalizedVersionString();
            if (string2 != null) {
                return string2;
            }
            string = ((RubySdkAdditionalData)object).getInterpreterPath(sdk);
            rubyRunner = ((RubySdkAdditionalData)object).getRunner(null);
        } else {
            string = sdk.getHomePath();
            assert (string != null);
            rubyRunner = RubyLocalRunner.getRunner(null);
        }
        object = null;
        try {
            object = RubyVersionUtil.getFullVersion(rubyRunner, string, true, validationCallback);
        }
        catch (ExecutionException executionException) {
            LOG.error((Throwable)executionException);
        }
        if (sdkAdditionalData instanceof RubySdkAdditionalData && SdkRefresher.isAutoRefreshable(sdk)) {
            ((RubySdkAdditionalData)sdkAdditionalData).setNormalizedVersionString((String)object);
        }
        return object;
    }

    @Nullable
    public static String getFullVersion(@NotNull RubyRunner runner, @NotNull String sdkHome, boolean doNormalize) throws ExecutionException {
        if (runner == null) {
            RubyVersionUtil.a(1);
        }
        if (sdkHome == null) {
            RubyVersionUtil.a(2);
        }
        return RubyVersionUtil.getFullVersion(runner, sdkHome, doNormalize, RubySdkType.DEFAULT_SDK_VALIDATION_CALLBACK);
    }

    @Nullable
    static String getFullVersion(@NotNull RubyRunner runner, @NotNull String sdkHome, boolean doNormalize, @NotNull NullableConsumer<? super String> validationCallback) throws ExecutionException {
        ProcessOutput processOutput;
        long l2 = h ^ 0x55BBBDBAEE3L;
        if (runner == null) {
            RubyVersionUtil.a(3);
        }
        if (sdkHome == null) {
            RubyVersionUtil.a(4);
        }
        if (validationCallback == null) {
            RubyVersionUtil.a(5);
        }
        if ((processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdkHome, a).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message("ruby.fetching.version")))) == null) {
            return null;
        }
        String string = RubyVersionUtil.getSDKVersionByOutput(processOutput, doNormalize, validationCallback);
        String string2 = processOutput.getStdout();
        String[] stringArray = string2.split("\n");
        if (doNormalize && stringArray.length > 1) {
            String string3 = RubyVersionUtil.getPatchLevelFromText(stringArray[1]);
            return !StringUtil.isEmpty((String)string3) ? string + " p" + string3 : string;
        }
        return string;
    }

    private static boolean a(@NotNull ProcessOutput processOutput, @NotNull NullableConsumer<? super String> nullableConsumer) {
        String string;
        long l2 = h ^ 0x3C728E07A060L;
        if (processOutput == null) {
            RubyVersionUtil.a(6);
        }
        if (nullableConsumer == null) {
            RubyVersionUtil.a(7);
        }
        if ((string = processOutput.getStdout()).contains("JAVA_HOME")) {
            nullableConsumer.consume((Object)string);
            return false;
        }
        if (!StringUtil.isEmpty((String)processOutput.getStderr())) {
            String string2 = processOutput.getStderr();
            if (string2.contains("jdb was unexpected at this time.")) {
                string2 = string2 + RBundle.message("sdk.error.old.x64");
            }
            if (processOutput.getExitCode() != 0 || processOutput.isTimeout()) {
                nullableConsumer.consume((Object)string2);
                return false;
            }
            LOG.warn("Unexpected output in stderr: " + string2);
        }
        return true;
    }

    @Nullable
    static String getSDKVersionByOutput(@NotNull ProcessOutput output, boolean doNormalize, @NotNull NullableConsumer<? super String> validationCallback) {
        String[] stringArray;
        if (output == null) {
            RubyVersionUtil.a(8);
        }
        if (validationCallback == null) {
            RubyVersionUtil.a(9);
        }
        if ((stringArray = output.getStdout().split("\n")).length == 0) {
            return null;
        }
        if (!RubyVersionUtil.a(output, validationCallback)) {
            return null;
        }
        String string = stringArray[0];
        return doNormalize ? RubyVersionUtil.normalizeSdkVersionText(string) : string;
    }

    @Nullable
    public static String getPatchLevel(@NotNull RubyRunner runner, @NotNull String sdkHome) throws IOException, ExecutionException {
        long l2 = h ^ 0x406226953F79L;
        if (runner == null) {
            RubyVersionUtil.a(10);
        }
        if (sdkHome == null) {
            RubyVersionUtil.a(11);
        }
        ProcessOutput processOutput = runner.executeInSameThread(RubyRunnerExecutionContext.create(RunnerUtil.collectCommands(sdkHome, GET_PATCHLEVEL_SCRIPT)));
        String string = processOutput.getStdout();
        if (!RubyVersionUtil.a(processOutput, RubySdkType.DEFAULT_SDK_VALIDATION_CALLBACK)) {
            return null;
        }
        return RubyVersionUtil.getPatchLevelFromText(string);
    }

    @Nullable
    public static String getPatchLevelFromText(String patchLevelText) {
        return TextUtil.isInteger(patchLevelText) ? patchLevelText : null;
    }

    public static String getPatchLevel(@NotNull String normalizedVersion) {
        int n2;
        if (normalizedVersion == null) {
            RubyVersionUtil.a(12);
        }
        if ((n2 = normalizedVersion.lastIndexOf(112)) > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i10 = n2 + 1; i10 < normalizedVersion.length() && StringUtil.isDecimalDigit((char)normalizedVersion.charAt(i10)); ++i10) {
                stringBuilder.append(normalizedVersion.charAt(i10));
            }
            return stringBuilder.toString();
        }
        return null;
    }

    static LanguageLevel extractLanguageLevelFromVersion(String version) {
        long l2 = h ^ 0x3109DC7E7DC8L;
        if (version == null) {
            return LanguageLevel.DEFAULT;
        }
        if (RubyVersionUtil.isRubinius(version) && VersionComparatorUtil.compare((String)RubyVersionUtil.getRubiniusShortVersion(version), (String)"2.0.0pre") >= 0) {
            return LanguageLevel.RUBY21;
        }
        if (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(version), (String)"9.2.0.0") >= 0) {
            return LanguageLevel.RUBY25;
        }
        if (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(version), (String)"9.1.0.0") >= 0) {
            return LanguageLevel.RUBY23;
        }
        if (VersionComparatorUtil.compare((String)JRubySdkUtil.getJRubyShortVersion(version), (String)JRUBY_9000) >= 0) {
            return LanguageLevel.RUBY22;
        }
        String string = RubyVersionUtil.a(version);
        if (VersionComparatorUtil.compare((String)string, (String)"2.7.0") >= 0) {
            return LanguageLevel.RUBY27;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.6.0") >= 0) {
            return LanguageLevel.RUBY26;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.5.0") >= 0) {
            return LanguageLevel.RUBY25;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.4.0") >= 0) {
            return LanguageLevel.RUBY24;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.3.0") >= 0) {
            return LanguageLevel.RUBY23;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.2.0") >= 0) {
            return LanguageLevel.RUBY22;
        }
        if (VersionComparatorUtil.compare((String)string, (String)"2.1.0") >= 0) {
            return LanguageLevel.RUBY21;
        }
        if (version.contains("2.0.")) {
            return LanguageLevel.RUBY20;
        }
        if (version.contains("1.9.")) {
            return LanguageLevel.RUBY19;
        }
        if (version.contains("1.8.")) {
            return LanguageLevel.RUBY18;
        }
        return LanguageLevel.DEFAULT;
    }

    @NotNull
    static LanguageLevel extractLanguageLevelFromSdkName(@NotNull String sdkName) {
        if (sdkName == null) {
            RubyVersionUtil.a(13);
        }
        LanguageLevel languageLevel = RubyVersionUtil.extractLanguageLevelFromVersion(RubyVersionUtil.createFakeVersionStringFromSdkName(sdkName));
        if (languageLevel == null) {
            RubyVersionUtil.a(14);
        }
        return languageLevel;
    }

    @NotNull
    static String createFakeVersionStringFromSdkName(@NotNull String sdkName) {
        long l2 = h ^ 0x3C753DD4F447L;
        if (sdkName == null) {
            RubyVersionUtil.a(15);
        }
        sdkName = StringUtil.trimStart((String)sdkName, (String)"RVM:").trim();
        sdkName = StringUtil.trimStart((String)sdkName, (String)"rbenv:").trim();
        sdkName = StringUtil.trimStart((String)sdkName, (String)"chruby:").trim();
        int n2 = (sdkName = StringUtil.trimStart((String)sdkName, (String)"asdf:").trim()).indexOf(32);
        if (n2 != -1) {
            sdkName = sdkName.substring(0, n2);
        }
        String string = "";
        int n3 = sdkName.indexOf("jruby-");
        if (n3 != -1) {
            Map.Entry<String, String> entry = b.floorEntry(sdkName = sdkName.substring(n3 + 6));
            String string2 = entry != null ? entry.getValue() : "1.1.1";
            string = " (" + string2 + ") VM";
        } else {
            n3 = sdkName.indexOf("ruby-");
            if (n3 != -1) {
                sdkName = sdkName.substring(n3 + 5);
            } else {
                n3 = sdkName.indexOf("rbx-");
                if (n3 != -1) {
                    String string3 = "rubinius " + sdkName.substring(n3 + 4) + " p0";
                    if (string3 == null) {
                        RubyVersionUtil.a(16);
                    }
                    return string3;
                }
            }
        }
        n3 = sdkName.indexOf(45);
        if (n3 > 0) {
            sdkName = sdkName.substring(0, n3);
        }
        String string4 = "ver." + sdkName + "p0" + string;
        if (string4 == null) {
            RubyVersionUtil.a(17);
        }
        return string4;
    }

    static String normalizeSdkVersionText(String rawVersionText) {
        long l2 = h ^ 0x2D9885BD9F47L;
        String string = rawVersionText.replaceFirst(" patchlevel \\d+\\s*\\)", ")");
        int n2 = (string = string.replace(") (", ", ")).indexOf(91);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        string = string.replaceFirst("\\d{4}-\\d{2}-\\d{2}", "");
        string = string.replaceAll("\\(\\)", "");
        string = string.replaceAll("\\s\\s+", " ");
        string = string.replaceFirst("^j?ruby ", "ver.");
        string = string.replaceFirst("^IronRuby", "IR");
        string = string.replaceFirst("\\sversion\\s+", " ver.");
        string = string.trim();
        return string;
    }

    public static boolean isVersionGreaterOrEqual(@NotNull Sdk sdk, @NotNull String requiredVersionString) {
        String string;
        if (sdk == null) {
            RubyVersionUtil.a(18);
        }
        if (requiredVersionString == null) {
            RubyVersionUtil.a(19);
        }
        if ((string = sdk.getVersionString()) == null) {
            return false;
        }
        return VersionComparatorUtil.compare((String)RubyVersionUtil.getShortVersion(string), (String)requiredVersionString) >= 0;
    }

    public static boolean isVersionLesser(@NotNull Sdk sdk, @NotNull String requiredVersionString) {
        String string;
        if (sdk == null) {
            RubyVersionUtil.a(20);
        }
        if (requiredVersionString == null) {
            RubyVersionUtil.a(21);
        }
        if ((string = sdk.getVersionString()) == null) {
            return false;
        }
        return VersionComparatorUtil.compare((String)RubyVersionUtil.getShortVersion(string), (String)requiredVersionString) < 0;
    }

    @NotNull
    public static String getShortVersion(@NotNull String version) {
        String string;
        if (version == null) {
            RubyVersionUtil.a(22);
        }
        if ((string = RubyVersionUtil.a(version)) != null) {
            String string2 = string;
            if (string2 == null) {
                RubyVersionUtil.a(23);
            }
            return string2;
        }
        String string3 = JRubySdkUtil.getJRubyMRILikeShortVersion(version);
        if (string3 != null) {
            String string4 = string3;
            if (string4 == null) {
                RubyVersionUtil.a(24);
            }
            return string4;
        }
        String string5 = RubyVersionUtil.getRubiniusShortVersion(version);
        if (string5 == null) {
            RubyVersionUtil.a(25);
        }
        return string5;
    }

    @Nullable
    private static String a(@NotNull String string) {
        long l2 = h ^ 0x690C6A8A0875L;
        if (string == null) {
            RubyVersionUtil.a(26);
        }
        if (!string.startsWith("ver.") || string.contains("VM") || !string.contains("p")) {
            return null;
        }
        return string.substring(4, StringUtil.indexOfAny((String)string, (String)"pr", (int)4, (int)string.length())).trim();
    }

    @Contract(value="!null->!null")
    @Nullable
    public static String getRubiniusShortVersion(@Nullable String version) {
        if (version == null) {
            return null;
        }
        Matcher matcher = e.matcher(version);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return version;
    }

    static boolean isIronRuby(@Nullable String version) {
        long l2 = h ^ 0x64D6B9F737D9L;
        return version != null && StringUtil.toLowerCase((String)version).contains(f);
    }

    static boolean isMacRuby(@Nullable String version) {
        long l2 = h ^ 0x39FA90818DDAL;
        return version != null && StringUtil.toLowerCase((String)version).contains(g);
    }

    static boolean isRubinius(@Nullable String version) {
        long l2 = h ^ 0x3018C97AAEC6L;
        return version != null && StringUtil.toLowerCase((String)version).contains(d);
    }

    static boolean isMaglev(@Nullable String version) {
        long l2 = h ^ 0x6BA89C107CBDL;
        return version != null && StringUtil.toLowerCase((String)version).contains(c);
    }

    static {
        h = com.jetbrains.python.psi.c.a(8683304296277244522L, 8663157430880239634L, MethodHandles.lookup().lookupClass()).a(108524682391119L);
        long l2 = h ^ 0xAFCAA2EADC3L;
        a = Arrays.asList("-e", "puts RUBY_DESCRIPTION.strip; puts RUBY_PATCHLEVEL.to_s");
        LOG = Logger.getInstance(RubySdkType.class);
        e = Pattern.compile("rubinius\\s*([0-9]+(\\.[0-9A-z]+)*)\\s*.*");
        b = new TreeMap(ContainerUtil.newHashMap(Arrays.asList("0", "1.6", "1.7", "9.0.0.0", "9.1.0.0", "9.2.0.0"), Arrays.asList("1.8.0", "1.9.0", "1.9.3", "2.2.0", "2.3.0", "2.5.0")));
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = h ^ 0x63B67C433830L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validationCallback";
                break;
            }
            case 1: 
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 2: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedVersion";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyVersionUtil";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredVersionString";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/sdk/RubyVersionUtil";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractLanguageLevelFromSdkName";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFakeVersionStringFromSdkName";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVersion";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateSDKVersionOutput";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSDKVersionByOutput";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPatchLevel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractLanguageLevelFromSdkName";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFakeVersionStringFromSdkName";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqual";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isVersionLesser";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getShortVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getMriShortVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 23: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

