/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.ShimsBasedVersionManagerHandler;

public abstract class RubyVersionManagerHandler<Data extends RubyVersionManagerSdkData<Data>> {
    private static final Logger a;
    private static final ExtensionPointName<RubyVersionManagerHandler> b;
    private static final Key<Boolean> c;
    private static final long o;

    @NotNull
    public abstract String getId();

    @NotNull
    public String getRemoteNameSuffix() {
        String string = "-" + this.getId();
        if (string == null) {
            RubyVersionManagerHandler.a(0);
        }
        return string;
    }

    @NotNull
    public abstract Data createAdditionalData();

    @Nullable
    protected abstract Data doCreateAdditionalData(@NotNull RubyRemoteSdkAdditionalData var1) throws RemoteSdkException;

    @Nullable
    protected abstract RubyVersionManagerSdkData doLoadLegacy(@NotNull Element var1, @NotNull String var2);

    public abstract void doPatchCommandLine(@NotNull RubyAbstractRunner var1, @NotNull GeneralCommandLine var2, @NotNull Map<String, String> var3, @NotNull Map<String, String> var4, @NotNull Sdk var5, @NotNull PathMappingSettings var6) throws ExecutionException;

    @Contract(pure=true)
    @NotNull
    public String getAdjustedGemScriptPathForExecution(@NotNull String fullScriptPath) {
        if (fullScriptPath == null) {
            RubyVersionManagerHandler.a(1);
        }
        String string = ShimsBasedVersionManagerHandler.is(this) ? Paths.get(fullScriptPath, new String[0]).getFileName().toString() : fullScriptPath;
        if (string == null) {
            RubyVersionManagerHandler.a(2);
        }
        return string;
    }

    @NotNull
    public static RubyVersionManagerSdkData createAdditionalData(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        long l2 = o ^ 0x717E67BC4628L;
        if (remoteSdkAdditionalData == null) {
            RubyVersionManagerHandler.a(3);
        }
        for (RubyVersionManagerHandler rubyVersionManagerHandler : (RubyVersionManagerHandler[])b.getExtensions()) {
            Object Data2 = rubyVersionManagerHandler.doCreateAdditionalData(remoteSdkAdditionalData);
            if (Data2 == null) continue;
            Object Data3 = Data2;
            if (Data3 == null) {
                RubyVersionManagerHandler.a(4);
            }
            return Data3;
        }
        throw new RuntimeException("RubySystemVersionManagerHandler should be registered as last and eat any path");
    }

    @Nullable
    public static RubyVersionManagerHandler findHandler(@NotNull Predicate<? super RubyVersionManagerHandler> predicate) {
        if (predicate == null) {
            RubyVersionManagerHandler.a(5);
        }
        return Arrays.stream(b.getExtensions()).filter(predicate).findFirst().orElse(null);
    }

    @NotNull
    static RubyVersionManagerSdkData loadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        if (rootElement == null) {
            RubyVersionManagerHandler.a(6);
        }
        if (interpreterPath == null) {
            RubyVersionManagerHandler.a(7);
        }
        RubyVersionManagerSdkData rubyVersionManagerSdkData = Stream.of(b.getExtensions()).map(rubyVersionManagerHandler -> rubyVersionManagerHandler.doLoadLegacy(rootElement, interpreterPath)).filter(Objects::nonNull).findFirst().orElseThrow(() -> {
            long l2 = o ^ 0x35A3C3358EC4L;
            return new RuntimeException("RubySystemVersionManagerHandler should be registered as last and work as fallback");
        });
        if (rubyVersionManagerSdkData == null) {
            RubyVersionManagerHandler.a(8);
        }
        return rubyVersionManagerSdkData;
    }

    public static void patchCommandLine(@NotNull RubyAbstractRunner rubyRunner, @NotNull GeneralCommandLine commandLine, @NotNull Map<String, String> envParams, @NotNull Map<String, String> customEnvVariables, @NotNull Sdk sdk, @NotNull PathMappingSettings pathMappings) throws ExecutionException {
        RubyVersionManagerHandler rubyVersionManagerHandler;
        long l2 = o ^ 0x5EE516755DC9L;
        if (rubyRunner == null) {
            RubyVersionManagerHandler.a(9);
        }
        if (commandLine == null) {
            RubyVersionManagerHandler.a(10);
        }
        if (envParams == null) {
            RubyVersionManagerHandler.a(11);
        }
        if (customEnvVariables == null) {
            RubyVersionManagerHandler.a(12);
        }
        if (sdk == null) {
            RubyVersionManagerHandler.a(13);
        }
        if (pathMappings == null) {
            RubyVersionManagerHandler.a(14);
        }
        if ((rubyVersionManagerHandler = RubyVersionManagerHandler.from(sdk)) != null) {
            rubyVersionManagerHandler.doPatchCommandLine(rubyRunner, commandLine, envParams, customEnvVariables, sdk, pathMappings);
        } else {
            a.error("Attempt to patch command-line with non-ruby SDK: " + sdk);
        }
    }

    public boolean canRunArbitraryCommand() {
        return true;
    }

    @Contract(pure=true, value="null -> null")
    @Nullable
    public static RubyVersionManagerHandler from(@Nullable Sdk sdk) {
        RubyVersionManagerSdkData rubyVersionManagerSdkData = RubyVersionManagerSdkData.from(sdk);
        return rubyVersionManagerSdkData == null ? null : rubyVersionManagerSdkData.getHandler();
    }

    @Contract(pure=true)
    @NotNull
    public static RubyVersionManagerHandler notNullFrom(@NotNull Sdk sdk) {
        if (sdk == null) {
            RubyVersionManagerHandler.a(15);
        }
        RubyVersionManagerHandler rubyVersionManagerHandler = Objects.requireNonNull(RubyVersionManagerHandler.from(sdk), () -> {
            long l2 = o ^ 0x3D7C4FBC5D01L;
            return "Failed to extract from " + sdk;
        });
        if (rubyVersionManagerHandler == null) {
            RubyVersionManagerHandler.a(16);
        }
        return rubyVersionManagerHandler;
    }

    public static void removeGemHomeAndGemPath(@NotNull Map<String, String> envParams, @NotNull GeneralCommandLine commandLine) {
        long l2 = o ^ 0x3612DDBC915FL;
        if (envParams == null) {
            RubyVersionManagerHandler.a(17);
        }
        if (commandLine == null) {
            RubyVersionManagerHandler.a(18);
        }
        if (Experiments.isFeatureEnabled((String)"ruby.force.gempath.removal")) {
            envParams.remove("GEM_PATH");
            envParams.remove("GEM_HOME");
            c.set((UserDataHolder)commandLine, (Object)true);
        }
    }

    public static boolean shouldRemoveGemHome(@NotNull GeneralCommandLine commandLine) {
        if (commandLine == null) {
            RubyVersionManagerHandler.a(19);
        }
        return c.get((UserDataHolder)commandLine) != null;
    }

    static {
        o = com.jetbrains.python.psi.c.a(1345199324778307941L, 6284720962724174906L, MethodHandles.lookup().lookupClass()).a(11020890400366L);
        long l2 = o ^ 0xD590702A55L;
        a = Logger.getInstance(RubyVersionManagerHandler.class);
        b = new ExtensionPointName("org.jetbrains.plugins.ruby.versionManagerHandler");
        c = Key.create((String)"ruby.remove.gem.home");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = o ^ 0x556146095661L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullScriptPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 10: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 11: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvVariables";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteNameSuffix";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdjustedGemScriptPathForExecution";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadLegacy";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullFrom";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedGemScriptPathForExecution";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadLegacy";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLine";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "notNullFrom";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "removeGemHomeAndGemPath";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shouldRemoveGemHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

