/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.RubyGemsEnvironment;
import org.jetbrains.plugins.ruby.remote.RubyRemoteSdkAdditionalData;
import org.jetbrains.plugins.ruby.ruby.run.RubyAbstractRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkDataBase;

public abstract class RubyVersionManagerHandlerBase<Data extends RubyVersionManagerSdkDataBase<Data>>
extends RubyVersionManagerHandler<Data> {
    private static final Logger e;
    private static String d;
    private static final long p;

    @Override
    @NotNull
    public String getId() {
        String string = this.getVersionManagerExecutableName();
        if (string == null) {
            RubyVersionManagerHandlerBase.b(0);
        }
        return string;
    }

    protected boolean isMyPath(@NotNull String interpreterPath) {
        long l2 = p ^ 0x1C5DE9612D06L;
        if (interpreterPath == null) {
            RubyVersionManagerHandlerBase.b(1);
        }
        Path path = Paths.get(interpreterPath, new String[0]);
        if (!this.getVersionManagerExecutableName().equals(path.getFileName().toString())) {
            return false;
        }
        Path path2 = path.getParent();
        return path2 != null && "bin".equals(path2.getFileName().toString());
    }

    @NotNull
    public abstract String getVersionManagerExecutableName();

    @Override
    @Nullable
    protected Data doCreateAdditionalData(@NotNull RubyRemoteSdkAdditionalData remoteSdkAdditionalData) throws RemoteSdkException {
        String string;
        if (remoteSdkAdditionalData == null) {
            RubyVersionManagerHandlerBase.b(2);
        }
        if (!this.isMyPath(string = remoteSdkAdditionalData.getInterpreterPath())) {
            return null;
        }
        RubyRunner rubyRunner = remoteSdkAdditionalData.getRunner(null);
        String string2 = this.chooseDistribution(rubyRunner, string);
        remoteSdkAdditionalData.setInterpreterPath(this.computeInterpreterPath(rubyRunner, string, string2));
        return ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)this.createAdditionalData()).withDistributionId(string2)).withVersionManagerPath(FileUtil.toSystemIndependentName((String)string));
    }

    @NotNull
    protected String chooseDistribution(@NotNull RubyRunner runner, @NotNull String versionManagerPath) throws RemoteSdkException {
        List<String> list2;
        long l2 = p ^ 0x62BE5C93FB4EL;
        if (runner == null) {
            RubyVersionManagerHandlerBase.b(3);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.b(4);
        }
        if ((list2 = this.getAvailableDistributions(runner, versionManagerPath)).isEmpty()) {
            throw new RemoteSdkException(RBundle.message("version.manager.no.rubies.installed"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (list2.indexOf(d) < 0) {
                throw new RemoteSdkException("There is no such ruby in list. Enforced ruby: " + d + "; Available: " + list2);
            }
            String string = d;
            if (string == null) {
                RubyVersionManagerHandlerBase.b(5);
            }
            return string;
        }
        Ref ref = Ref.create((Object)-1);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            long l2 = p ^ 0x203EAF0528A9L;
            ref.set((Object)Messages.showChooseDialog((String)"", (String)RBundle.message("version.manager.select.distribution"), (String[])ArrayUtilRt.toStringArray((Collection)list2), (String)((String)list2.get(0)), null));
        });
        if ((Integer)ref.get() == -1) {
            throw new RemoteSdkException(RBundle.message("version.manager.you.should.choose"));
        }
        String string = list2.get((Integer)ref.get());
        if (string == null) {
            RubyVersionManagerHandlerBase.b(6);
        }
        return string;
    }

    @NotNull
    public List<String> getAvailableDistributions(@NotNull RubyRunner runner, @NotNull String versionManagerPath) throws RemoteSdkException {
        ProcessOutput processOutput;
        long l2 = p ^ 0x4D1547B30512L;
        if (runner == null) {
            RubyVersionManagerHandlerBase.b(7);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.b(8);
        }
        try {
            processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(this.getAvailableDistributionsCommands(runner, versionManagerPath)).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message("version.manager.fetching.distributions.list")));
        }
        catch (ExecutionException executionException) {
            throw new RemoteSdkException(RBundle.message("version.manager.error.fetching.distributions.list"), (Throwable)executionException);
        }
        if (processOutput == null) {
            throw new RemoteSdkException(RBundle.message("version.manager.error.fetching.distributions.list"));
        }
        List<String> list2 = this.processAvailableDistributionsOutput(processOutput.getStdoutLines());
        if (list2 == null) {
            RubyVersionManagerHandlerBase.b(9);
        }
        return list2;
    }

    @NotNull
    protected abstract List<String> getAvailableDistributionsCommands(@NotNull RubyRunner var1, @NotNull String var2);

    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RubyVersionManagerHandlerBase.b(10);
        }
        List<String> list2 = rawOutput;
        if (list2 == null) {
            RubyVersionManagerHandlerBase.b(11);
        }
        return list2;
    }

    @NotNull
    protected String computeInterpreterPath(@NotNull RubyRunner runner, @NotNull String versionManagerPath, @NotNull String distributionId) throws RemoteSdkException {
        String string;
        long l2 = p ^ 0x2653DB8E25B5L;
        if (runner == null) {
            RubyVersionManagerHandlerBase.b(12);
        }
        if (versionManagerPath == null) {
            RubyVersionManagerHandlerBase.b(13);
        }
        if (distributionId == null) {
            RubyVersionManagerHandlerBase.b(14);
        }
        try {
            String string2;
            ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(this.patchCommands(runner, versionManagerPath, distributionId, Arrays.asList("gem", "env"))).inSameThread(RubyRunner.DEFAULT_EXECUTION_TIMEOUT, RBundle.message("version.manager.computing.interpreter.path")));
            String string3 = string2 = processOutput == null ? null : RubyGemsEnvironment.parse(processOutput.getStdout()).getRubyExecutable();
            if (StringUtil.isEmpty((String)string2)) {
                e.warn("Error computing interpreter path for " + versionManagerPath + " and " + distributionId);
                if (processOutput == null) {
                    e.warn("\tOutput is null.");
                } else {
                    e.warn("\tExit code: " + processOutput.getExitCode());
                    e.warn("\tStdout: " + processOutput.getStdout());
                    e.warn("\tStderr: " + processOutput.getStderr());
                }
                throw new RemoteSdkException(RBundle.message("version.manager.unable.to.find.executable", distributionId));
            }
            string = string2;
        }
        catch (ExecutionException executionException) {
            throw new RemoteSdkException(RBundle.message("version.manager.unable.to.get.environment", distributionId, executionException.getMessage()), (Throwable)executionException);
        }
        if (string == null) {
            RubyVersionManagerHandlerBase.b(15);
        }
        return string;
    }

    @Override
    public void doPatchCommandLine(@NotNull RubyAbstractRunner rubyRunner, @NotNull GeneralCommandLine commandLine, @NotNull Map<String, String> envParams, @NotNull Map<String, String> customEnvVariables, @NotNull Sdk sdk, @NotNull PathMappingSettings pathMappings) throws ExecutionException {
        RubyVersionManagerSdkDataBase rubyVersionManagerSdkDataBase;
        if (rubyRunner == null) {
            RubyVersionManagerHandlerBase.b(16);
        }
        if (commandLine == null) {
            RubyVersionManagerHandlerBase.b(17);
        }
        if (envParams == null) {
            RubyVersionManagerHandlerBase.b(18);
        }
        if (customEnvVariables == null) {
            RubyVersionManagerHandlerBase.b(19);
        }
        if (sdk == null) {
            RubyVersionManagerHandlerBase.b(20);
        }
        if (pathMappings == null) {
            RubyVersionManagerHandlerBase.b(21);
        }
        if (!(rubyVersionManagerSdkDataBase = RubyVersionManagerSdkDataBase.notNullFrom(sdk)).hasVersionManagerPath()) {
            this.clarifyVersionManagerPath(sdk);
        }
        List<String> list2 = this.patchCommands(rubyRunner, rubyVersionManagerSdkDataBase.getVersionManagerPath(), rubyVersionManagerSdkDataBase.getDistributionId(), commandLine.getCommandLineList(null));
        commandLine.setExePath(list2.remove(0));
        commandLine.getParametersList().clearAll();
        commandLine.withParameters(list2);
        RubyVersionManagerHandlerBase.removeGemHomeAndGemPath(envParams, commandLine);
    }

    @NotNull
    protected abstract List<String> patchCommands(@NotNull RubyRunner var1, @NotNull String var2, @NotNull String var3, @NotNull List<String> var4);

    @NotNull
    public Data createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RubyVersionManagerHandlerBase.b(22);
        }
        Object Data2 = ((RubyVersionManagerSdkDataBase)((RubyVersionManagerSdkDataBase)this.createAdditionalData()).withVersionManagerPath(sdkInfo.getPathToVersionManager())).withDistributionId(sdkInfo.getInterpreterHome().getName());
        if (Data2 == null) {
            RubyVersionManagerHandlerBase.b(23);
        }
        return Data2;
    }

    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list2 = Collections.emptyList();
        if (list2 == null) {
            RubyVersionManagerHandlerBase.b(24);
        }
        return list2;
    }

    protected void clarifyVersionManagerPath(@NotNull Sdk sdk) throws ExecutionException {
        long l2 = p ^ 0x6C37291110B2L;
        if (sdk == null) {
            RubyVersionManagerHandlerBase.b(25);
        }
        e.info("Clarifying version manager path for " + sdk);
        RubyRunner rubyRunner = RubyRunner.notNullFrom(sdk);
        String string = this.getVersionManagerExecutableName();
        String string2 = StringUtil.toUpperCase((String)string);
        ExecutionModes.SameThreadMode sameThreadMode = new ExecutionModes.SameThreadMode(false, RBundle.message("version.manager.detection.path", string), RubyRunner.DEFAULT_EXECUTION_TIMEOUT);
        sameThreadMode.addProcessListener((ProcessListener)RubyRunner.CLOSE_INPUT_ADAPTER);
        ProcessOutput processOutput = null;
        ArrayList<String> arrayList = new ArrayList<String>(this.getAdditionalPathsToSearch());
        arrayList.add("$PATH");
        try {
            processOutput = rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(rubyRunner.wrapWithShell(true, false, "PATH=" + StringUtil.join(arrayList, (String)":") + " \\which " + string)).withExecutionMode((ExecutionMode)sameThreadMode)).withPty(true));
        }
        catch (ExecutionException executionException) {
            e.warn("Error looking for version manager executable: executableName: [" + string + "]; paths: [" + arrayList + "]; runner: [" + rubyRunner + "]", (Throwable)executionException);
        }
        if (processOutput != null && processOutput.getExitCode() == 0 && !processOutput.getStdoutLines().isEmpty()) {
            RubyVersionManagerSdkDataBase.notNullFrom(sdk).withVersionManagerPath((String)processOutput.getStdoutLines().get(0));
        } else {
            Ref ref = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                long l2 = p ^ 0x7CBBF0EBA13FL;
                ref.set((Object)Messages.showInputDialog((String)RBundle.message("version.manager.detection.dialog.message", string, sdk.toString()), (String)RBundle.message("version.manager.detection.dialog.title", string2), (Icon)Messages.getQuestionIcon()));
            });
            if (StringUtil.isNotEmpty((String)((String)ref.get()))) {
                RubyVersionManagerSdkDataBase.notNullFrom(sdk).withVersionManagerPath((String)ref.get());
            } else {
                throw new ExecutionException(RBundle.message("version.manager.detection.not.found", string2));
            }
        }
    }

    @Contract(pure=true)
    @NotNull
    protected static String getVersionFromInterpreterPath(@NotNull String interpreterPath) {
        Path path;
        Path path2;
        Path path3;
        long l2 = p ^ 0x69DC108A291CL;
        if (interpreterPath == null) {
            RubyVersionManagerHandlerBase.b(26);
        }
        Path path4 = path3 = (path2 = (path = Paths.get(interpreterPath, new String[0])).getParent()) == null ? null : path2.getParent();
        if (path3 == null) {
            throw new InvalidDataException("Invalid interpreter path: " + interpreterPath);
        }
        String string = path3.getFileName().toString();
        if (string == null) {
            RubyVersionManagerHandlerBase.b(27);
        }
        return string;
    }

    public static void runWithChoosingRuby(@NotNull String rubyToChoose, @NotNull Runnable runnable) {
        if (rubyToChoose == null) {
            RubyVersionManagerHandlerBase.b(28);
        }
        if (runnable == null) {
            RubyVersionManagerHandlerBase.b(29);
        }
        d = rubyToChoose;
        try {
            runnable.run();
        }
        finally {
            d = null;
        }
    }

    static {
        p = c.a(-1952918512530330374L, -6437649372557056785L, MethodHandles.lookup().lookupClass()).a(187035701527388L);
        e = Logger.getInstance(RubyVersionManagerHandlerBase.class);
        d = null;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = p ^ 0x7F6FBB30D0C9L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase";
                break;
            }
            case 1: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteSdkAdditionalData";
                break;
            }
            case 3: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envParams";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customEnvVariables";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMappings";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyToChoose";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/RubyVersionManagerHandlerBase";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseDistribution";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeInterpreterPath";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionFromInterpreterPath";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMyPath";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doCreateAdditionalData";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "chooseDistribution";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "computeInterpreterPath";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doPatchCommandLine";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clarifyVersionManagerPath";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getVersionFromInterpreterPath";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "runWithChoosingRuby";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

