/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rbenv;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.gem.ui.RubySdkGemsetsSettings;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvSdkData;
import org.jetbrains.plugins.ruby.version.management.rbenv.RbenvVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.rbenv.a;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;

@VisibleForTesting
public final class RbenvSdkRefresher
extends SdkRefresherBase {
    private static final Logger i;
    private static final String h = ".rbenv-version";
    private static final String k = ".ruby-version";
    private static final CharsetDecoder l;
    private static final Map<Path, String> j;
    private static final long m;

    @Override
    protected void doAdditionalInitialization() {
        this.getInstallationsRoots().stream().flatMap(virtualFile -> Stream.of(virtualFile.getChildren())).filter(virtualFile -> virtualFile.isDirectory()).forEach(virtualFile -> this.a((VirtualFile)virtualFile));
    }

    @Override
    @NotNull
    public RbenvVersionManagerHandler getVersionManagerHandler() {
        RbenvVersionManagerHandler rbenvVersionManagerHandler = RbenvVersionManagerHandler.getInstance();
        if (rbenvVersionManagerHandler == null) {
            RbenvSdkRefresher.d(0);
        }
        return rbenvVersionManagerHandler;
    }

    private void a(@NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        long l2 = m ^ 0xE3BDACB1521L;
        if (virtualFile == null) {
            RbenvSdkRefresher.d(1);
        }
        if ((virtualFile2 = virtualFile.findChild("gemsets")) == null || !virtualFile2.isDirectory()) {
            i.debug("No gemset directory for " + virtualFile);
            return;
        }
        this.addRootToWatch(virtualFile2);
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        List<String> list2 = RbenvVersionManagerHandler.POSSIBLE_RBENV_PATHS;
        if (list2 == null) {
            RbenvSdkRefresher.d(2);
        }
        return list2;
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        long l2 = m ^ 0x4B15402F533CL;
        if (versionManagerPathName == null) {
            RbenvSdkRefresher.d(3);
        }
        if (interpreterHome == null) {
            RbenvSdkRefresher.d(4);
        }
        i.debug("Processing potential home " + interpreterHome);
        Stream<RubySdkInfo> stream2 = Stream.of(new RubySdkInfo(versionManagerPathName, interpreterHome, null));
        VirtualFile virtualFile3 = interpreterHome.findChild("gemsets");
        if (virtualFile3 != null) {
            this.myLog.debug("Got a gemset directory: " + virtualFile3);
            stream2 = Stream.concat(stream2, Stream.of(virtualFile3.getChildren()).filter(virtualFile -> virtualFile.isDirectory() && !FileTypeManager.getInstance().isFileIgnored(virtualFile)).map(virtualFile2 -> {
                long l2 = m ^ 0x58B1CD1DC79FL;
                this.myLog.debug("Found gemset: " + virtualFile2);
                return new RubySdkInfo(versionManagerPathName, interpreterHome, virtualFile2.getName());
            }));
        }
        Stream<RubySdkInfo> stream3 = stream2;
        if (stream3 == null) {
            RbenvSdkRefresher.d(5);
        }
        return stream3;
    }

    @Override
    protected void runPostCreateSdkAction(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RbenvSdkRefresher.d(6);
        }
        if (!RbenvGemsetManager.isGemsetSdk(sdkInfo)) {
            LocalFileSystem.getInstance().addRootToWatch(sdkInfo.getInterpreterHome().getPath(), false);
        }
        this.a(sdkInfo.getInterpreterHome());
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String sdkHomePath, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        String string;
        long l2 = m ^ 0x547154785A43L;
        if (executablePath == null) {
            RbenvSdkRefresher.d(7);
        }
        if (sdkHomePath == null) {
            RbenvSdkRefresher.d(8);
        }
        if (versionManagerSdkAdditionalData == null) {
            RbenvSdkRefresher.d(9);
        }
        if ((string = super.suggestSdkName(executablePath, sdkHomePath, versionManagerSdkAdditionalData)) == null) {
            return null;
        }
        String string2 = ((RbenvSdkData)versionManagerSdkAdditionalData).getGemsetName();
        if (string2 != null && !StringUtil.isEmpty((String)string2)) {
            return string + " [" + string2 + ']';
        }
        return string;
    }

    @Override
    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            RbenvSdkRefresher.d(10);
        }
        RbenvGemsetManager.RBENV_PLUGIN_INSTALLED.drop();
        LocalVersionWatcher localVersionWatcher = new LocalVersionWatcher(project, null);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)localVersionWatcher, (Disposable)project);
        ApplicationManager.getApplication().invokeLater(() -> {
            this.a(project);
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
                for (Module module2 : RModuleUtil.getInstance().getAllModulesWithRubySupport(project)) {
                    RbenvGemsetManager.excludeLocalGemsets(module2);
                    RbenvGemsetsConfigFileListener rbenvGemsetsConfigFileListener = new RbenvGemsetsConfigFileListener(module2);
                    VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)rbenvGemsetsConfigFileListener, (Disposable)project);
                }
            });
        });
    }

    private void a(@NotNull Project project) {
        long l2 = m ^ 0xB033B75FCC1L;
        if (project == null) {
            RbenvSdkRefresher.d(11);
        }
        if (this.getInstallationsRoots().isEmpty()) {
            return;
        }
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (moduleArray.length == 0) {
            return;
        }
        Set<? extends RubySdkInfo> set = this.getSdkInfos();
        if (set.isEmpty()) {
            return;
        }
        for (Module module2 : moduleArray) {
            if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(RModuleUtil.getInstance().findRubySdkForModule(module2))) {
                i.debug(module2.getName() + " configured to use remote sdk thus let's ignore rbenv config");
                continue;
            }
            VirtualFile virtualFile = RbenvSdkRefresher.a(module2);
            if (virtualFile == null) continue;
            i.debug("Local rbenv version config found " + virtualFile + " for " + module2.getName());
            String string = RbenvSdkRefresher.f(virtualFile);
            if (StringUtil.isEmpty((String)string)) {
                i.debug("no version specified");
                continue;
            }
            VirtualFile virtualFile2 = RbenvSdkRefresher.a(set, string);
            if (virtualFile2 == null) {
                i.warn("Unable to find rbenv sdk for >" + string + "<");
                continue;
            }
            Sdk sdk = RbenvSdkRefresher.d(virtualFile2);
            if (sdk != null) {
                if (RModuleUtil.getInstance().changeModuleSdk(sdk, module2)) {
                    i.debug("Sdk for " + module2.getName() + " changed to " + sdk.getName());
                    GemManager.addGemsForSdk(sdk);
                    continue;
                }
                i.warn("Unable to change sdk for " + module2.getName());
                continue;
            }
            i.warn("unable to find sdk for " + virtualFile2);
        }
    }

    @Nullable
    private static VirtualFile a(@NotNull Collection<? extends RubySdkInfo> collection, @NotNull String string) {
        if (collection == null) {
            RbenvSdkRefresher.d(12);
        }
        if (string == null) {
            RbenvSdkRefresher.d(13);
        }
        for (RubySdkInfo rubySdkInfo : collection) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = rubySdkInfo.getInterpreterHome();
            if (!virtualFile2.getPath().endsWith(string) || (virtualFile = rubySdkInfo.getRubyExecutable()) == null) continue;
            return virtualFile;
        }
        return null;
    }

    @Nullable
    private static Sdk d(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            RbenvSdkRefresher.d(14);
        }
        for (Sdk sdk : ProjectJdkTable.getInstance().getAllJdks()) {
            VirtualFile virtualFile2 = sdk.getHomeDirectory();
            if (virtualFile2 == null || !virtualFile2.equals(virtualFile) || !RbenvGemsetManager.isRootRbenvSdk(sdk)) continue;
            return sdk;
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(@NotNull Module module2) {
        long l2 = m ^ 0x6EBB76747B9FL;
        if (module2 == null) {
            RbenvSdkRefresher.d(15);
        }
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            if (virtualFile == null) continue;
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(k);
            if (virtualFile2 != null) {
                return virtualFile2;
            }
            VirtualFile virtualFile3 = virtualFile.findFileByRelativePath(h);
            if (virtualFile3 == null) continue;
            return virtualFile3;
        }
        return null;
    }

    @Nullable
    private static String f(@NotNull VirtualFile virtualFile) {
        long l2 = m ^ 0x61CB87CD937FL;
        if (virtualFile == null) {
            RbenvSdkRefresher.d(16);
        }
        try {
            byte[] byArray = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            StringBuilder stringBuilder = new StringBuilder((int)virtualFile.getLength());
            InputStream inputStream2 = virtualFile.getInputStream();
            while (inputStream2.available() > 0) {
                int n2 = inputStream2.read(byArray);
                byteBuffer.clear();
                byteBuffer.put(byArray, 0, n2);
                byteBuffer.flip();
                stringBuilder.append(l.decode(byteBuffer));
            }
            inputStream2.close();
            return stringBuilder.toString().trim();
        }
        catch (IOException iOException) {
            i.warn("Unable to read version file - " + virtualFile, (Throwable)iOException);
            return null;
        }
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        long l2 = m ^ 0x5A7A8C5B553L;
        this.myLog.debug("Seeking for installation root");
        String string = (String)ObjectUtils.doIfNotNull((Object)this.getVersionManagerPath(), path2 -> j.computeIfAbsent((Path)path2, path -> StringUtil.notNullize((String)RbenvVersionManagerHandler.computeRootFor(path, RubyLocalRunner.getRunner(null)))));
        if (string == null || string.isEmpty()) {
            this.myLog.debug("Could not find rbenv root");
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RbenvSdkRefresher.d(17);
            }
            return list2;
        }
        this.myLog.debug("Found root at " + string);
        List<String> list3 = Collections.singletonList(Paths.get(string, new String[0]).resolve("versions").toString());
        if (list3 == null) {
            RbenvSdkRefresher.d(18);
        }
        return list3;
    }

    static {
        m = c.a(8431150398359883277L, -5747391258553512256L, MethodHandles.lookup().lookupClass()).a(1168190666149L);
        long l2 = m ^ 0x2372BFAA7D4L;
        i = Logger.getInstance(RbenvSdkRefresher.class);
        l = Charset.forName(System.getProperty("file.encoding")).newDecoder();
        j = ContainerUtil.newConcurrentMap();
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x2715E622133EL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyHome";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfos";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyExecutable";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandler";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleVersionManagersPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addGemsetsToWatchRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "runPostCreateSdkAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyLocalVersionToProject";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findRubyExecutable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSuitableSdk";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRbenvLocal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getLocalVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RbenvGemsetsConfigFileListener
    implements VirtualFileListener {
        private final Module a;
        private static final long b = c.a(-7683382089814556256L, 8568523404946772051L, MethodHandles.lookup().lookupClass()).a(201658630591560L);

        RbenvGemsetsConfigFileListener(@NotNull Module module2) {
            if (module2 == null) {
                RbenvGemsetsConfigFileListener.a(0);
            }
            this.a = module2;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                RbenvGemsetsConfigFileListener.a(1);
            }
            this.a(event);
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                RbenvGemsetsConfigFileListener.a(2);
            }
            this.a(event);
        }

        private void a(@NotNull VirtualFileEvent virtualFileEvent) {
            if (virtualFileEvent == null) {
                RbenvGemsetsConfigFileListener.a(3);
            }
            if (virtualFileEvent.getRequestor() == RbenvGemsetManager.RBENV_GEMSETS_CONFIG_REQUESTOR) {
                return;
            }
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(this.a);
            if (sdk == null) {
                return;
            }
            if (RbenvGemsetManager.isRbenvGemsetConfig(this.a, virtualFileEvent.getFile())) {
                List<String> list2 = RbenvGemsetManager.getCommandLineRbenvGemsets(this.a, sdk);
                MultiMap<String, String> multiMap = RubySdkGemsetsSettings.getInstance().getOrCreateModuleSdkGemsetsMap(this.a);
                multiMap.put((Object)sdk.getHomePath(), list2);
                RubySdkGemsetsSettings.getInstance().putModuleSdkGemsetsMap(this.a, multiMap);
                RbenvGemsetManager.updateLibraries(sdk, this.a);
            }
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x560EB747D9B3L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher$RbenvGemsetsConfigFileListener";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "applyGemsetConfigChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class LocalVersionWatcher
    implements VirtualFileListener {
        @NotNull
        final Project myProject;
        private static final long a = c.a(-2311638554860624578L, 8637926593382152540L, MethodHandles.lookup().lookupClass()).a(214143743035148L);

        private LocalVersionWatcher(Project project) {
            if (project == null) {
                LocalVersionWatcher.a(0);
            }
            this.myProject = project;
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LocalVersionWatcher.a(1);
            }
            this.a(event.getFile());
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                LocalVersionWatcher.a(2);
            }
            this.a(event.getFile());
        }

        private void a(@NotNull VirtualFile virtualFile) {
            long l2 = a ^ 0x7FD4D6AB91E8L;
            if (virtualFile == null) {
                LocalVersionWatcher.a(3);
            }
            if (virtualFile.isDirectory()) {
                return;
            }
            if (!RbenvSdkRefresher.h.equals(virtualFile.getName()) && !RbenvSdkRefresher.k.equals(virtualFile.getName())) {
                return;
            }
            i.debug("It looks like " + virtualFile.getName() + " (" + virtualFile.getPath() + ") has been changed (or created), let's update sdk for the project (" + this.myProject + ")");
            RbenvSdkRefresher.this.a(this.myProject);
        }

        /* synthetic */ LocalVersionWatcher(Project x1, a x2) {
            this(x1);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = a ^ 0x3FCDEAC73F49L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rbenv/RbenvSdkRefresher$LocalVersionWatcher";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSelectedSdkIfNeeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

