/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.NullableConsumer;
import com.intellij.util.PairConsumer;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.gem.GemManager;
import org.jetbrains.plugins.ruby.remote.RubyRemoteInterpreterManager;
import org.jetbrains.plugins.ruby.ruby.RModuleUtil;
import org.jetbrains.plugins.ruby.ruby.run.RubyLocalRunner;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.RunnerUtil;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.SdkRefresher;
import org.jetbrains.plugins.ruby.version.management.SdkRefresherBase;
import org.jetbrains.plugins.ruby.version.management.rbenv.gemsets.RbenvGemsetManager;
import org.jetbrains.plugins.ruby.version.management.rvm.ConfiguredRvmSdk;
import org.jetbrains.plugins.ruby.version.management.rvm.LocalRvmPathsSettings;
import org.jetbrains.plugins.ruby.version.management.rvm.RVMSupportUtil;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmVersionManagerHandler;

public final class RvmSdkRefresher
extends SdkRefresherBase {
    public static final Object REQUESTOR;
    @NonNls
    public static final String RUBY_GEMSET_FILE_NAME = ".ruby-gemset";
    @NonNls
    public static final String RUBY_VERSION_FILE_NAME = ".ruby-version";
    @NonNls
    public static final String RVMRC_FILE_NAME = ".rvmrc";
    private static final Logger r;
    @NonNls
    private static final String s = "RVM Support";
    private static final Pattern h;
    private static final Pattern k;
    private static final Pattern l;
    private static final Pattern j;
    @NonNls
    private static final String p = ".versions.conf";
    public static final Set<String> VERSION_CONFIG_FILE_NAMES;
    private static final Set<String> i;
    private static final Set<String> q;
    private static volatile boolean n;
    private static final Key<String> t;
    private final LocalRvmPathsSettings o = LocalRvmPathsSettings.getInstance();
    private AtomicNullableLazyValue<RvmVersionManagerHandler.RvmEnvironment> m;
    private static final long x;

    public RvmSdkRefresher() {
        this.c();
    }

    @Override
    @Nullable
    public String suggestSdkName(@NotNull String executablePath, @NotNull String sdkHomePath, @NotNull RubyVersionManagerSdkData versionManagerSdkAdditionalData) {
        long l2 = x ^ 0x52D5C569F3B5L;
        if (executablePath == null) {
            RvmSdkRefresher.d(0);
        }
        if (sdkHomePath == null) {
            RvmSdkRefresher.d(1);
        }
        if (versionManagerSdkAdditionalData == null) {
            RvmSdkRefresher.d(2);
        }
        if (!(versionManagerSdkAdditionalData instanceof RvmSdkData)) {
            return null;
        }
        String string = "RVM: " + sdkHomePath;
        String string2 = ((RvmSdkData)versionManagerSdkAdditionalData).getGemsetName();
        if (!StringUtil.isEmpty((String)string2)) {
            return string + RVMSupportUtil.getGemsetSuffix(string2);
        }
        return string;
    }

    @Override
    protected void doAdditionalInitialization() {
        super.doAdditionalInitialization();
        LocalRvmPathsSettings localRvmPathsSettings = LocalRvmPathsSettings.getInstance();
        localRvmPathsSettings.getRvmExecutable();
        localRvmPathsSettings.getInterpretersFolder();
        localRvmPathsSettings.getGemsFolder();
        n = true;
    }

    public static boolean isInitialized() {
        return n;
    }

    @Override
    public void onProjectOpened(@NotNull Project project) {
        if (project == null) {
            RvmSdkRefresher.d(3);
        }
        RvmrcWatcher rvmrcWatcher = new RvmrcWatcher(project, this.o);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)rvmrcWatcher, (Disposable)project);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isDisposed()) {
                RvmSdkRefresher.a(project, this.o);
            }
        });
    }

    @Override
    @NotNull
    protected List<String> getPossibleVersionManagersPaths() {
        List list2 = ContainerUtil.map(RvmVersionManagerHandler.RVM_SEARCH_PATHS_LIST, string -> Paths.get(string, this.getVersionManagerHandler().getVersionManagerExecutableName()).toString());
        if (list2 == null) {
            RvmSdkRefresher.d(4);
        }
        return list2;
    }

    private void c() {
        this.m = AtomicNullableLazyValue.createValue(() -> RvmVersionManagerHandler.RvmEnvironment.compute(this.getVersionManagerPath(), RubyLocalRunner.getRunner(null)));
    }

    @Nullable
    private RvmVersionManagerHandler.RvmEnvironment b() {
        return (RvmVersionManagerHandler.RvmEnvironment)Objects.requireNonNull(this.m).getValue();
    }

    @Override
    @NotNull
    protected List<String> getInstallationsRootsPathNames() {
        RvmVersionManagerHandler.RvmEnvironment rvmEnvironment = this.b();
        List<String> list2 = rvmEnvironment == null ? Collections.emptyList() : Collections.singletonList(rvmEnvironment.getGemsPath());
        if (list2 == null) {
            RvmSdkRefresher.d(5);
        }
        return list2;
    }

    @Override
    @NotNull
    protected Stream<? extends RubySdkInfo> getSdkInfosForInterpreterHome(@NotNull String versionManagerPathName, @NotNull VirtualFile interpreterHome) {
        String string;
        long l2 = x ^ 0x4DB1D13EFACAL;
        if (versionManagerPathName == null) {
            RvmSdkRefresher.d(6);
        }
        if (interpreterHome == null) {
            RvmSdkRefresher.d(7);
        }
        if (q.contains(string = interpreterHome.getName())) {
            this.myLog.debug("Skipping directory: " + string);
            Stream stream2 = Stream.empty();
            if (stream2 == null) {
                RvmSdkRefresher.d(8);
            }
            return stream2;
        }
        RvmVersionManagerHandler.RvmEnvironment rvmEnvironment = this.b();
        if (rvmEnvironment == null) {
            this.myLog.debug("Something is wrong, environment is empty");
            Stream stream3 = Stream.empty();
            if (stream3 == null) {
                RvmSdkRefresher.d(9);
            }
            return stream3;
        }
        ArrayList arrayList = new ArrayList(StringUtil.split((String)string, (String)"@", (boolean)true));
        String string2 = (String)arrayList.remove(0);
        VirtualFile virtualFile = VfsUtil.findRelativeFile((VirtualFile)rvmEnvironment.getRubiesVirtualFile(), (String[])new String[]{string2});
        if (virtualFile == null) {
            this.myLog.debug("Unable to find interpreter home: [gem home: " + interpreterHome + "; interpreter name: " + string2 + "; rubies home: " + rvmEnvironment.getRubiesVirtualFile() + "]");
            Stream stream4 = Stream.empty();
            if (stream4 == null) {
                RvmSdkRefresher.d(10);
            }
            return stream4;
        }
        Stream<RubySdkInfo> stream5 = Stream.of(new RubySdkInfo(versionManagerPathName, virtualFile, arrayList.isEmpty() ? null : (String)arrayList.get(0)));
        if (stream5 == null) {
            RvmSdkRefresher.d(11);
        }
        return stream5;
    }

    @Override
    @NotNull
    protected Set<? extends RubySdkInfo> getSdkInfos() {
        r.assertTrue(n);
        this.c();
        Set<? extends RubySdkInfo> set = super.getSdkInfos();
        if (set == null) {
            RvmSdkRefresher.d(12);
        }
        return set;
    }

    public static void updateRVMSdks() {
        SdkRefresher.getRefreshers().stream().filter(sdkRefresher -> sdkRefresher instanceof RvmSdkRefresher).forEach(SdkRefresher::refreshSDKs);
    }

    public static boolean applySdkToRubyVersionFile(@NotNull Module module2, @NotNull String gemset, @NotNull String sdkVersion) throws IOException {
        VirtualFile virtualFile;
        long l2 = x ^ 0x3E30C9513FDFL;
        if (module2 == null) {
            RvmSdkRefresher.d(13);
        }
        if (gemset == null) {
            RvmSdkRefresher.d(14);
        }
        if (sdkVersion == null) {
            RvmSdkRefresher.d(15);
        }
        if ((virtualFile = RModuleUtil.getInstance().getFirstContentRoot(module2)) == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile.findOrCreateChildData((Object)virtualFile, RUBY_VERSION_FILE_NAME);
        LoadTextUtil.write((Project)module2.getProject(), (VirtualFile)virtualFile2, (Object)REQUESTOR, (String)sdkVersion, (long)-1L);
        VirtualFile virtualFile3 = virtualFile.findOrCreateChildData((Object)virtualFile, RUBY_GEMSET_FILE_NAME);
        LoadTextUtil.write((Project)module2.getProject(), (VirtualFile)virtualFile3, (Object)new Object(), (String)gemset, (long)-1L);
        return true;
    }

    @Nullable
    public static String getVersion(@NotNull Sdk sdk) {
        String string;
        if (sdk == null) {
            RvmSdkRefresher.d(16);
        }
        if (RVMSupportUtil.isRVMInterpreter(sdk) && (string = RVMSupportUtil.getRVMSdkVersion(sdk)) != null) {
            return string;
        }
        if (RbenvGemsetManager.isRbenvSdk(sdk) && (string = RbenvGemsetManager.getSdkVersion(sdk)) != null) {
            return string;
        }
        return null;
    }

    public static void createRVMGemset(@Nullable Project project, @NotNull Sdk rootRVMSdk, @NotNull String gemset, @NotNull NullableConsumer<? super Sdk> postAction) {
        if (rootRVMSdk == null) {
            RvmSdkRefresher.d(17);
        }
        if (gemset == null) {
            RvmSdkRefresher.d(18);
        }
        if (postAction == null) {
            RvmSdkRefresher.d(19);
        }
        MultiMap multiMap = new MultiMap();
        multiMap.putValue((Object)rootRVMSdk, (Object)gemset);
        RvmSdkRefresher.createRVMGemsets(project, (MultiMap<Sdk, String>)multiMap, postAction);
    }

    public static void createRVMGemsets(@Nullable Project project, final @NotNull MultiMap<Sdk, String> rootRVMSdkToNewGemsets, @NotNull NullableConsumer<? super Sdk> postAction) {
        long l2 = x ^ 0x4EC54B8AD08L;
        if (rootRVMSdkToNewGemsets == null) {
            RvmSdkRefresher.d(20);
        }
        if (postAction == null) {
            RvmSdkRefresher.d(21);
        }
        final PairConsumer pairConsumer = (sdk, string) -> {
            long l2 = x ^ 0x1C132A40687EL;
            RubyRunner rubyRunner = RunnerUtil.getRunner(sdk, null);
            VirtualFile virtualFile = LocalRvmPathsSettings.getInstance().getRvmExecutable();
            if (virtualFile == null) {
                return;
            }
            String string2 = virtualFile.getCanonicalPath();
            if (string2 == null) {
                return;
            }
            try {
                String string3 = RvmSdkRefresher.getVersion(sdk);
                rubyRunner.execute((RubyRunnerExecutionContext)((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(sdk, string2, string3, "gemset", "create", string).withProject(project)).inSameThread(Registry.intValue((String)"command.line.execution.timeout")));
                VirtualFile virtualFile2 = LocalRvmPathsSettings.getInstance().getGemsFolder();
                VirtualFile virtualFile3 = LocalRvmPathsSettings.getInstance().getInterpretersFolder();
                if (virtualFile2 == null || virtualFile3 == null) {
                    return;
                }
                RefreshQueue.getInstance().refresh(false, false, () -> {
                    long l2 = x ^ 0x21F7E05BDFEDL;
                    new Task.Backgroundable(project, RBundle.message("rvm.gemset.create.refreshing.sdk.progress.title"), (NullableConsumer)postAction, (Sdk)sdk, (String)string){
                        final /* synthetic */ NullableConsumer val$postAction;
                        final /* synthetic */ Sdk val$sdk;
                        final /* synthetic */ String val$gemset;
                        private static final long a = c.a(4055483298207744423L, 5159461545767399523L, MethodHandles.lookup().lookupClass()).a(218635664690411L);
                        {
                            this.val$postAction = nullableConsumer;
                            this.val$sdk = sdk;
                            this.val$gemset = string;
                            super(arg0, arg1);
                        }

                        public void run(@NotNull ProgressIndicator indicator) {
                            if (indicator == null) {
                                1.a(0);
                            }
                            RvmSdkRefresher.updateRVMSdks();
                            ApplicationManager.getApplication().invokeLater(() -> this.val$postAction.consume((Object)RVMSupportUtil.findRVMGemsetSdk(this.val$sdk, this.val$gemset)));
                        }

                        private static /* synthetic */ void a(int n2) {
                            long l2 = a ^ 0x19E831937ADDL;
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$1", "run"));
                        }
                    }.queue();
                }, new VirtualFile[]{virtualFile2, virtualFile3});
            }
            catch (ExecutionException executionException) {
                r.error("Cannot create rvm gemset; " + executionException.getMessage());
            }
        };
        Task.Backgroundable backgroundable = new Task.Backgroundable(project, RBundle.message("new.project.wizard.rvm.gemset.create.gemsets.title"), false){
            private static final long a = c.a(4759751217535831187L, -3415160215615829043L, MethodHandles.lookup().lookupClass()).a(260238629190676L);

            public void run(@NotNull ProgressIndicator indicator) {
                long l2 = a ^ 0x55CA08A0BA48L;
                if (indicator == null) {
                    2.a(0);
                }
                int n2 = rootRVMSdkToNewGemsets.values().size();
                int n3 = 0;
                indicator.setIndeterminate(false);
                for (Sdk sdk : rootRVMSdkToNewGemsets.keySet()) {
                    for (String string : rootRVMSdkToNewGemsets.get((Object)sdk)) {
                        indicator.setFraction((double)n3++ / (double)n2);
                        indicator.setText(RBundle.message("new.project.wizard.rvm.gemset.create.title", RvmSdkRefresher.getVersion(sdk) + '@' + string));
                        pairConsumer.consume((Object)sdk, (Object)string);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x16BE7AD9EC3FL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$2", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)backgroundable);
    }

    public static boolean applyGemsetToConfig(@NotNull Module module2, @NotNull String gemset, @NotNull String sdkVersion) {
        if (module2 == null) {
            RvmSdkRefresher.d(22);
        }
        if (gemset == null) {
            RvmSdkRefresher.d(23);
        }
        if (sdkVersion == null) {
            RvmSdkRefresher.d(24);
        }
        return (Boolean)WriteAction.compute(() -> {
            long l2 = x ^ 0x25AA077BEDC5L;
            try {
                return RvmSdkRefresher.applySdkToRubyVersionFile(module2, gemset, sdkVersion);
            }
            catch (IOException iOException) {
                r.error("Cannot apply " + sdkVersion + " version to rvm 'version' config file. " + iOException.getMessage());
                return false;
            }
        });
    }

    @Nullable
    public static String loadText(@NotNull VirtualFile file) {
        if (file == null) {
            RvmSdkRefresher.d(25);
        }
        try {
            return VfsUtilCore.loadText((VirtualFile)file);
        }
        catch (IOException iOException) {
            r.warn((Throwable)iOException);
            return null;
        }
    }

    @NotNull
    public static String getRvmRubyDistName(@NotNull VirtualFile rubyInterpreter) {
        if (rubyInterpreter == null) {
            RvmSdkRefresher.d(26);
        }
        VirtualFile virtualFile = rubyInterpreter.getParent();
        VirtualFile virtualFile2 = virtualFile.getParent();
        String string = virtualFile2.getName();
        if (string == null) {
            RvmSdkRefresher.d(27);
        }
        return string;
    }

    private static boolean a(@Nullable String string) {
        return i.contains(string);
    }

    private static void a(@NotNull Project project, final @NotNull LocalRvmPathsSettings localRvmPathsSettings) {
        long l2 = x ^ 0x6AB249EF1000L;
        if (project == null) {
            RvmSdkRefresher.d(28);
        }
        if (localRvmPathsSettings == null) {
            RvmSdkRefresher.d(29);
        }
        if (!localRvmPathsSettings.isRvmSupportEnabled()) {
            return;
        }
        Module[] moduleArray = RModuleUtil.getInstance().getAllModulesWithRubySupport(project);
        if (moduleArray.length == 0) {
            return;
        }
        NotNullLazyValue<RVMSupportUtil.RubyDistToGemsetTable> notNullLazyValue = new NotNullLazyValue<RVMSupportUtil.RubyDistToGemsetTable>(){
            private static final long a = c.a(4899704418197351631L, 9006171810869714744L, MethodHandles.lookup().lookupClass()).a(281419861562586L);

            @NotNull
            protected RVMSupportUtil.RubyDistToGemsetTable compute() {
                RVMSupportUtil.RubyDistToGemsetTable rubyDistToGemsetTable = RvmSdkRefresher.a(localRvmPathsSettings);
                if (rubyDistToGemsetTable == null) {
                    3.a(0);
                }
                return rubyDistToGemsetTable;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x30A4047F5C68L;
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$3", "compute"));
            }
        };
        for (Module module2 : moduleArray) {
            Project project2;
            String string;
            String string2;
            Sdk sdk = RModuleUtil.getInstance().findRubySdkForModule(module2);
            if (!RVMSupportUtil.isRVMInterpreter(sdk)) continue;
            if (RubyRemoteInterpreterManager.getInstance().isRemoteSdk(sdk)) {
                r.debug(module2.getName() + " configured to use remote sdk thus let's ignore rvm config file");
                continue;
            }
            ConfiguredRvmSdk configuredRvmSdk = RvmSdkRefresher.readSdkRefAndGemset(module2);
            if (configuredRvmSdk == null || ((RVMSupportUtil.RubyDistToGemsetTable)notNullLazyValue.getValue()).isEmpty()) continue;
            String string3 = RVMSupportUtil.determineSuitableRVMSdkDist(configuredRvmSdk.getSdkDistName(), configuredRvmSdk.getGemset(), (RVMSupportUtil.RubyDistToGemsetTable)notNullLazyValue.getValue());
            if (string3 == null) {
                string2 = RBundle.message("rvm.rvmrc.project.cannot.find.sdk.message", configuredRvmSdk.getSdkFullName());
                if (!StringUtil.equals((CharSequence)((CharSequence)module2.getUserData(t)), (CharSequence)string2)) {
                    string = new Notification(s, RBundle.message("rvm.rvmrc.project.notifications.title", configuredRvmSdk.getSource()), string2, NotificationType.WARNING);
                    Notifications.Bus.notify((Notification)string, (Project)project);
                    r.warn("Cannot find RVM '" + configuredRvmSdk.getSdkFullName() + "' sdk");
                }
                module2.putUserData(t, (Object)string2);
                continue;
            }
            if (string3.equals(RVMSupportUtil.getRVMSdkDistName(sdk))) {
                return;
            }
            string2 = RVMSupportUtil.findSdkBy(string3, configuredRvmSdk.getGemset());
            if (string2 != null) {
                boolean bl2 = RModuleUtil.getInstance().changeModuleSdk((Sdk)string2, module2);
                if (!bl2) continue;
                project2 = module2.getProject();
                String string4 = PlatformUtils.isRubyMine() ? project2.getName() : module2.getName();
                Notification notification2 = new Notification(s, RBundle.message("rvm.rvmrc.project.notifications.title", configuredRvmSdk.getSource()), RBundle.message("rvm.rvmrc.project.sdk.changed.message", string4, configuredRvmSdk.getSource(), string2.getName()), NotificationType.INFORMATION);
                Notifications.Bus.notify((Notification)notification2, (Project)project2);
                module2.putUserData(t, (Object)"");
                GemManager.addGemsForSdk((Sdk)string2);
                continue;
            }
            string = RBundle.message("rvm.rvmrc.project.cannot.find.gemset.for.sdk.message", configuredRvmSdk.getGemset(), configuredRvmSdk.getSdkDistName(), ApplicationNamesInfo.getInstance().getProductName());
            if (StringUtil.equals((CharSequence)((CharSequence)module2.getUserData(t)), (CharSequence)string)) continue;
            project2 = new Notification(s, RBundle.message("rvm.rvmrc.project.notifications.title", configuredRvmSdk.getSource()), string, NotificationType.WARNING);
            Notifications.Bus.notify((Notification)project2, (Project)project);
            r.warn("Cannot find gemset '" + configuredRvmSdk.getGemset() + "' for dist: '" + string3 + "'");
            module2.putUserData(t, (Object)string);
        }
    }

    @Nullable
    public static ConfiguredRvmSdk readSdkRefAndGemset(@NotNull Module module2) {
        VirtualFile[] virtualFileArray;
        long l2 = x ^ 0x31C08A6E3B4DL;
        if (module2 == null) {
            RvmSdkRefresher.d(30);
        }
        for (VirtualFile virtualFile : virtualFileArray = ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            VirtualFile virtualFile2 = virtualFile.findChild(RVMRC_FILE_NAME);
            if (virtualFile2 != null) {
                return RvmSdkRefresher.a(virtualFile2);
            }
            VirtualFile virtualFile3 = virtualFile.findChild(RUBY_VERSION_FILE_NAME);
            VirtualFile virtualFile4 = virtualFile.findChild(RUBY_GEMSET_FILE_NAME);
            if (virtualFile3 != null) {
                return RvmSdkRefresher.a(virtualFile3, virtualFile4);
            }
            VirtualFile virtualFile5 = virtualFile.findChild(p);
            if (virtualFile5 == null) continue;
            return RvmSdkRefresher.b(virtualFile5);
        }
        return null;
    }

    @Nullable
    private static ConfiguredRvmSdk b(@NotNull VirtualFile virtualFile) {
        long l2 = x ^ 0x1560A729D346L;
        if (virtualFile == null) {
            RvmSdkRefresher.d(31);
        }
        r.debug("Extracting ruby and gemset from " + virtualFile.getPath());
        String string = RvmSdkRefresher.loadText(virtualFile);
        if (StringUtil.isEmptyOrSpaces((String)string)) {
            return null;
        }
        Matcher matcher = l.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1).trim();
            Matcher matcher2 = j.matcher(string);
            return new ConfiguredRvmSdk(string2, matcher2.find() ? matcher2.group(1).trim() : null, p);
        }
        r.warn("unable to find sdk definition in " + virtualFile.getPath());
        return null;
    }

    @Nullable
    private static ConfiguredRvmSdk a(@NotNull VirtualFile virtualFile, @Nullable VirtualFile virtualFile2) {
        long l2 = x ^ 0x1FC32267EEC1L;
        if (virtualFile == null) {
            RvmSdkRefresher.d(32);
        }
        r.debug("Extracting ruby and gemset from " + virtualFile.getPath());
        String string = RvmSdkRefresher.b(RvmSdkRefresher.loadText(virtualFile));
        if (string == null) {
            return null;
        }
        if (virtualFile2 != null) {
            String string2 = RvmSdkRefresher.b(RvmSdkRefresher.loadText(virtualFile2));
            return new ConfiguredRvmSdk(string, string2, RUBY_VERSION_FILE_NAME);
        }
        return RVMSupportUtil.splitToRVMDistAndGemset(string, RUBY_VERSION_FILE_NAME);
    }

    @Nullable
    private static String b(@Nullable String string) {
        long l2 = x ^ 0x713E6F97B6F2L;
        if (string == null) {
            return null;
        }
        String string2 = string.replaceAll("\n|\r", "").trim();
        if (StringUtil.isEmptyOrSpaces((String)string2)) {
            return null;
        }
        return string2;
    }

    @Nullable
    private static ConfiguredRvmSdk a(@NotNull VirtualFile virtualFile) {
        long l2 = x ^ 0xBBBDE9D2FACL;
        if (virtualFile == null) {
            RvmSdkRefresher.d(33);
        }
        r.debug("Extracting ruby and gemset from " + virtualFile.getPath());
        String string = RvmSdkRefresher.loadText(virtualFile);
        if (!StringUtil.isEmpty((String)string)) {
            Object object;
            Matcher matcher;
            Matcher matcher2 = h.matcher(string);
            if (matcher2.find()) {
                matcher = matcher2;
            } else {
                object = k.matcher(string);
                Matcher matcher3 = matcher = ((Matcher)object).find() ? object : null;
            }
            if (matcher != null) {
                object = StringUtil.unquoteString((String)matcher.group(1).replace('\'', '\"').replace(";", ""));
                if (((String)object).startsWith("$")) {
                    object = RvmSdkRefresher.a(string, (String)object);
                }
            } else {
                object = RvmSdkRefresher.a(string, "$environment_id");
            }
            if (object != null) {
                return RVMSupportUtil.splitToRVMDistAndGemset((String)object, RVMRC_FILE_NAME);
            }
        }
        return null;
    }

    private static String a(String string, String string2) {
        long l2 = x ^ 0x74A0F070AED2L;
        try {
            Pattern pattern = Pattern.compile("^\\s*" + string2.substring(1) + "\\s*=\\s*(\\S*);?$", 8);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                return StringUtil.unquoteString((String)matcher.group(1).replace('\'', '\"').replace(";", ""));
            }
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static RVMSupportUtil.RubyDistToGemsetTable a(@NotNull LocalRvmPathsSettings localRvmPathsSettings) {
        if (localRvmPathsSettings == null) {
            RvmSdkRefresher.d(34);
        }
        if (SystemInfo.isUnix) {
            RVMSupportUtil.RubyDistToGemsetTable rubyDistToGemsetTable = RVMSupportUtil.getInterpreterDistName2GemSetsTable(localRvmPathsSettings.getInterpretersFolder(), localRvmPathsSettings.getGemsFolder());
            if (rubyDistToGemsetTable == null) {
                RvmSdkRefresher.d(35);
            }
            return rubyDistToGemsetTable;
        }
        RVMSupportUtil.RubyDistToGemsetTable rubyDistToGemsetTable = RVMSupportUtil.RubyDistToGemsetTable.emptyTable();
        if (rubyDistToGemsetTable == null) {
            RvmSdkRefresher.d(36);
        }
        return rubyDistToGemsetTable;
    }

    @Override
    @NotNull
    public RvmVersionManagerHandler getVersionManagerHandler() {
        RvmVersionManagerHandler rvmVersionManagerHandler = RvmVersionManagerHandler.getInstance();
        if (rvmVersionManagerHandler == null) {
            RvmSdkRefresher.d(37);
        }
        return rvmVersionManagerHandler;
    }

    static {
        x = c.a(5987801181673852681L, 5876188995757462458L, MethodHandles.lookup().lookupClass()).a(231439564437847L);
        long l2 = x ^ 0x3EFC4FDACCDL;
        REQUESTOR = new Object();
        r = Logger.getInstance(RvmSdkRefresher.class);
        h = Pattern.compile("(?:^|.*\\n)\\s*rvm\\s(?:.+[\\t ])?use\\s+(?:\\-\\-?\\w+\\s+)*(system|\\S*)?(\\s|;|$)");
        k = Pattern.compile("(?:^|.*\\n)\\s*rvm\\s+(?:\\-\\-?\\w+\\s+)*(system|\\S*)?(\\s|;|$)");
        l = Pattern.compile("^ruby=(.+)$", 8);
        j = Pattern.compile("^ruby-gemset=(.+)$", 8);
        VERSION_CONFIG_FILE_NAMES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{p, RUBY_VERSION_FILE_NAME}));
        i = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{RVMRC_FILE_NAME, p, RUBY_VERSION_FILE_NAME, RUBY_GEMSET_FILE_NAME}));
        q = ContainerUtil.newHashSet((Object[])new String[]{"default", "cache"});
        n = false;
        t = Key.create((String)"SDK warning message");
        NotificationGroup.balloonGroup((String)s);
    }

    private static /* synthetic */ void d(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = x ^ 0x71CF6EF147C6L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executablePath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerSdkAdditionalData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPathName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterHome";
                break;
            }
            case 13: 
            case 22: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 14: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gemset";
                break;
            }
            case 15: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkVersion";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdk";
                break;
            }
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postAction";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootRVMSdkToNewGemsets";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyInterpreter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProject";
                break;
            }
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rvmPathsSettings";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionsConf";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyVersion";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRvmrc";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleVersionManagersPaths";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallationsRootsPathNames";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkInfos";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getRvmRubyDistName";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterDistName2GemSetsTable";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "onProjectOpened";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSdkInfosForInterpreterHome";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applySdkToRubyVersionFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getVersion";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemset";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createRVMGemsets";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "applyGemsetToConfig";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getRvmRubyDistName";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "applyRvmRCToModule";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "readSdkRefAndGemset";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigFromVersionsConf";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigFromRubyVersion";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "extractConfigFromRvmrc";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getInterpreterDistName2GemSetsTable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 27: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class RvmrcWatcher
    implements VirtualFileListener {
        @NotNull
        final Project myProject;
        @NotNull
        private final LocalRvmPathsSettings a;
        private static final long b = c.a(8178102273990692890L, -905074010397014757L, MethodHandles.lookup().lookupClass()).a(188809724199664L);

        private RvmrcWatcher(@NotNull Project project, @NotNull LocalRvmPathsSettings rvmPathsSettings) {
            if (project == null) {
                RvmrcWatcher.a(0);
            }
            if (rvmPathsSettings == null) {
                RvmrcWatcher.a(1);
            }
            this.myProject = project;
            this.a = rvmPathsSettings;
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                RvmrcWatcher.a(2);
            }
            if (REQUESTOR == event.getRequestor()) {
                return;
            }
            this.a(event.getFile());
        }

        private void a(@NotNull VirtualFile virtualFile) {
            long l2 = b ^ 0x76FF4FCA4056L;
            if (virtualFile == null) {
                RvmrcWatcher.a(3);
            }
            if (virtualFile.isDirectory()) {
                return;
            }
            if (!RvmSdkRefresher.a(virtualFile.getName())) {
                return;
            }
            r.debug("It looks like rvm config file (" + virtualFile.getPath() + ") has been changed (or created), let's update sdk for the project (" + this.myProject + ")");
            RvmSdkRefresher.a(this.myProject, this.a);
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = b ^ 0x143F4EFEF3FCL;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rvmPathsSettings";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmSdkRefresher$RvmrcWatcher";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateSelectedSdkIfNeeded";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

