/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.version.management.rvm;

import com.intellij.execution.ExecutionMode;
import com.intellij.execution.ExecutionModes;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.run.RubyRunner;
import org.jetbrains.plugins.ruby.ruby.run.context.RubyRunnerExecutionContext;
import org.jetbrains.plugins.ruby.version.management.RubySdkInfo;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandler;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerHandlerBase;
import org.jetbrains.plugins.ruby.version.management.RubyVersionManagerSdkData;
import org.jetbrains.plugins.ruby.version.management.rvm.RvmSdkData;

public class RvmVersionManagerHandler
extends RubyVersionManagerHandlerBase<RvmSdkData> {
    private static final Logger j;
    @NonNls
    private static final String n = "IS_RVM_SDK";
    @NonNls
    private static final String g = "RVM_GEMSET_NAME";
    @NonNls
    private static final String l = "RVM_IGNORE_GLOBAL";
    private static final String h = "rvm_path";
    private static final String f = "rvm_rubies_path";
    private static final String i = "rvm_gems_path";
    private static final String k = "gems";
    private static final String m = "rubies";
    static final String RVM_DEFAULT_RUBY = "default";
    static final List<String> RVM_SEARCH_PATHS_LIST;
    private static final long q;

    @Override
    @NotNull
    protected List<String> getAdditionalPathsToSearch() {
        List<String> list2 = RVM_SEARCH_PATHS_LIST;
        if (list2 == null) {
            RvmVersionManagerHandler.c(0);
        }
        return list2;
    }

    @Override
    @NotNull
    public String getVersionManagerExecutableName() {
        long l2 = q ^ 0x63F7B185E3C6L;
        if ("rvm" == null) {
            RvmVersionManagerHandler.c(1);
        }
        return "rvm";
    }

    @Override
    @NotNull
    public RvmSdkData createAdditionalData() {
        RvmSdkData rvmSdkData = new RvmSdkData(this);
        if (rvmSdkData == null) {
            RvmVersionManagerHandler.c(2);
        }
        return rvmSdkData;
    }

    @Override
    @NotNull
    protected List<String> processAvailableDistributionsOutput(@NotNull List<String> rawOutput) {
        if (rawOutput == null) {
            RvmVersionManagerHandler.c(3);
        }
        List list2 = ContainerUtil.filter(rawOutput, string -> {
            long l2 = q ^ 0xEE31137C10DL;
            return string != null && !StringUtil.endsWith((CharSequence)string, (CharSequence)"@global");
        });
        if (list2 == null) {
            RvmVersionManagerHandler.c(4);
        }
        return list2;
    }

    @Override
    @NotNull
    protected List<String> getAvailableDistributionsCommands(@NotNull RubyRunner runner, @NotNull String versionManagerPath) {
        long l2 = q ^ 0x193489FDF790L;
        if (runner == null) {
            RvmVersionManagerHandler.c(5);
        }
        if (versionManagerPath == null) {
            RvmVersionManagerHandler.c(6);
        }
        List<String> list2 = Arrays.asList(versionManagerPath, "list", "gemsets", "strings");
        if (list2 == null) {
            RvmVersionManagerHandler.c(7);
        }
        return list2;
    }

    @Override
    @Nullable
    protected RubyVersionManagerSdkData doLoadLegacy(@NotNull Element rootElement, @NotNull String interpreterPath) {
        long l2 = q ^ 0x3C06F826C9A8L;
        if (rootElement == null) {
            RvmVersionManagerHandler.c(8);
        }
        if (interpreterPath == null) {
            RvmVersionManagerHandler.c(9);
        }
        String string = rootElement.getAttributeValue(n);
        String string2 = rootElement.getAttributeValue(g);
        if (string != null && Boolean.valueOf(string).booleanValue() || string2 != null) {
            RvmSdkData rvmSdkData = this.createAdditionalData().withDistributionId(RvmVersionManagerHandler.getVersionFromInterpreterPath(interpreterPath), string2);
            rvmSdkData.withRVMIgnoreGlobalGemset(Boolean.valueOf(rootElement.getAttributeValue(l, "false")));
            return rvmSdkData;
        }
        return null;
    }

    @Override
    @NotNull
    public RvmSdkData createAdditionalData(@NotNull RubySdkInfo sdkInfo) {
        if (sdkInfo == null) {
            RvmVersionManagerHandler.c(10);
        }
        RvmSdkData rvmSdkData = ((RvmSdkData)super.createAdditionalData(sdkInfo)).withDistributionId(sdkInfo.getInterpreterHome().getName(), sdkInfo.getGemSet());
        if (rvmSdkData == null) {
            RvmVersionManagerHandler.c(11);
        }
        return rvmSdkData;
    }

    @Override
    @NotNull
    protected List<String> patchCommands(@NotNull RubyRunner rubyRunner, @NotNull String versionManagerPath, @NotNull String distributionId, @NotNull List<String> commandsToPatch) {
        long l2 = q ^ 0x1D9EE3673F81L;
        if (rubyRunner == null) {
            RvmVersionManagerHandler.c(12);
        }
        if (versionManagerPath == null) {
            RvmVersionManagerHandler.c(13);
        }
        if (distributionId == null) {
            RvmVersionManagerHandler.c(14);
        }
        if (commandsToPatch == null) {
            RvmVersionManagerHandler.c(15);
        }
        List<String> list2 = rubyRunner.getCommandsSequence(ContainerUtil.concat(Arrays.asList(versionManagerPath, distributionId, "do"), commandsToPatch));
        if (list2 == null) {
            RvmVersionManagerHandler.c(16);
        }
        return list2;
    }

    @NotNull
    public static RvmVersionManagerHandler getInstance() {
        RvmVersionManagerHandler rvmVersionManagerHandler = Objects.requireNonNull((RvmVersionManagerHandler)RubyVersionManagerHandler.findHandler(rubyVersionManagerHandler -> rubyVersionManagerHandler instanceof RvmVersionManagerHandler));
        if (rvmVersionManagerHandler == null) {
            RvmVersionManagerHandler.c(17);
        }
        return rvmVersionManagerHandler;
    }

    static {
        q = c.a(8966484525867848122L, -9085342118930573078L, MethodHandles.lookup().lookupClass()).a(233916194760750L);
        long l2 = q ^ 0x30CF12E57CAAL;
        j = Logger.getInstance(RvmVersionManagerHandler.class);
        RVM_SEARCH_PATHS_LIST = Arrays.asList("~/.rvm/bin", "/usr/local/rvm/bin", "/usr/share/rvm/bin", "/opt/rvm/bin");
    }

    private static /* synthetic */ void c(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = q ^ 0x29CF05982679L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawOutput";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionManagerPath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterPath";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkInfo";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rubyRunner";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "distributionId";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandsToPatch";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalPathsToSearch";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVersionManagerExecutableName";
                break;
            }
            case 2: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createAdditionalData";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processAvailableDistributionsOutput";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDistributionsCommands";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "patchCommands";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processAvailableDistributionsOutput";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableDistributionsCommands";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doLoadLegacy";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalData";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchCommands";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RvmEnvironment {
        @NotNull
        private final String a;
        @NotNull
        private final String c;
        private final AtomicNullableLazyValue<VirtualFile> b;
        private static final long d = com.jetbrains.python.psi.c.a(-8037878898938927951L, -8612364282458712023L, MethodHandles.lookup().lookupClass()).a(31169818033884L);

        RvmEnvironment(@NotNull Map<String, String> rvmEnvironment) {
            long l2 = d ^ 0x2C1578404477L;
            if (rvmEnvironment == null) {
                RvmEnvironment.a(0);
            }
            this.b = AtomicNullableLazyValue.createValue(() -> VfsUtil.findFileByIoFile((File)new File(this.getRubiesPath()), (boolean)false));
            this.a = rvmEnvironment.get(RvmVersionManagerHandler.f);
            this.c = rvmEnvironment.get(RvmVersionManagerHandler.i);
        }

        @NotNull
        String getRubiesPath() {
            String string = this.a;
            if (string == null) {
                RvmEnvironment.a(1);
            }
            return string;
        }

        @NotNull
        String getGemsPath() {
            String string = this.c;
            if (string == null) {
                RvmEnvironment.a(2);
            }
            return string;
        }

        @Nullable
        VirtualFile getRubiesVirtualFile() {
            return (VirtualFile)this.b.getValue();
        }

        @Nullable
        @Contract(value="null, _ -> null")
        static RvmEnvironment compute(@Nullable Path pathToRvm, @NotNull RubyRunner runner) {
            long l2 = d ^ 0x504DC5B1D495L;
            if (runner == null) {
                RvmEnvironment.a(3);
            }
            if (pathToRvm == null) {
                return null;
            }
            try {
                j.debug("Getting rvm environment from " + pathToRvm.toString());
                GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{pathToRvm.toString(), RvmVersionManagerHandler.RVM_DEFAULT_RUBY, "do", "ruby", "-e", "ENV.each{|k,v| print %Q<#{k}=#{v}\\0>}"});
                ExecutionModes.SameThreadMode sameThreadMode = new ExecutionModes.SameThreadMode(false, RBundle.message("version.manager.rvm.fetching.environment"), RubyRunner.DEFAULT_EXECUTION_TIMEOUT);
                sameThreadMode.addProcessListener((ProcessListener)RubyRunner.CLOSE_INPUT_ADAPTER);
                ProcessOutput processOutput = runner.execute((RubyRunnerExecutionContext)RubyRunnerExecutionContext.create(runner.wrapWithShell(true, false, generalCommandLine.getCommandLineString())).withExecutionMode((ExecutionMode)sameThreadMode));
                assert (processOutput != null);
                if (processOutput.getExitCode() != 0) {
                    j.warn("Error getting rvm environment from script, error code " + processOutput.getExitCode() + "; STDOUT: " + processOutput.getStdout() + "; STDERR: " + processOutput.getStderr());
                    return null;
                }
                Map map2 = EnvironmentUtil.parseEnv((String[])processOutput.getStdout().split("\u0000"));
                String string = (String)map2.get(RvmVersionManagerHandler.i);
                String string2 = (String)map2.get(RvmVersionManagerHandler.f);
                String string3 = (String)map2.get(RvmVersionManagerHandler.h);
                if (StringUtil.isEmpty((String)string2) && StringUtil.isNotEmpty((String)string3)) {
                    string2 = FileUtil.toSystemIndependentName((String)Paths.get(string3, new String[0]).resolve(RvmVersionManagerHandler.m).toString());
                    j.warn("rvm_rubies_path(" + string2 + ") inferred from " + RvmVersionManagerHandler.h + "(" + string3 + ")");
                    map2.put(RvmVersionManagerHandler.f, string2);
                }
                if (StringUtil.isEmpty((String)string) && StringUtil.isNotEmpty((String)string2)) {
                    string = FileUtil.toSystemIndependentName((String)Paths.get(string2, new String[0]).getParent().resolve(RvmVersionManagerHandler.k).toString());
                    j.warn("rvm_gems_path(" + string + ") inferred from " + RvmVersionManagerHandler.f + "(" + string2 + ")");
                    map2.put(RvmVersionManagerHandler.i, string);
                }
                if (StringUtil.isEmpty((String)string2) || StringUtil.isEmpty((String)string)) {
                    j.warn("RVM environment is not good:\n" + map2);
                    j.warn("Inferring paths from the path to RVM " + pathToRvm);
                    Path path = pathToRvm.getParent();
                    if (path == null) {
                        j.warn("No bin path in " + pathToRvm.toString());
                        return null;
                    }
                    Path path2 = path.getParent();
                    if (path2 == null) {
                        j.warn("No rvm root path in " + pathToRvm.toString());
                        return null;
                    }
                    string2 = FileUtil.toSystemIndependentName((String)path2.resolve(RvmVersionManagerHandler.m).toString());
                    j.warn("rvm_rubies_path(" + string2 + ") inferred from path to rvm executable (" + pathToRvm + ")");
                    map2.put(RvmVersionManagerHandler.f, string2);
                    string = FileUtil.toSystemIndependentName((String)path2.resolve(RvmVersionManagerHandler.k).toString());
                    j.warn("rvm_gems_path(" + string + ") inferred from path to rvm executable (" + pathToRvm + ")");
                    map2.put(RvmVersionManagerHandler.i, string);
                }
                return new RvmEnvironment(map2);
            }
            catch (Exception exception) {
                j.warn("Error getting rvm environment", (Throwable)exception);
                return null;
            }
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x48D7E1C18387L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rvmEnvironment";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler$RvmEnvironment";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runner";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/plugins/ruby/version/management/rvm/RvmVersionManagerHandler$RvmEnvironment";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRubiesPath";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGemsPath";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "compute";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

