/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.schema;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.schema.YamlJsonPsiWalker;

public class YamlJsonSchemaGotoDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor2) {
        PsiElement psiElement;
        IElementType iElementType = PsiUtilCore.getElementType((PsiElement)sourceElement);
        if (iElementType != YAMLTokenTypes.SCALAR_KEY) {
            return null;
        }
        YAMLKeyValue yAMLKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, YAMLKeyValue.class);
        if (yAMLKeyValue == null || yAMLKeyValue.getKey() != sourceElement) {
            return null;
        }
        JsonSchemaService jsonSchemaService = JsonSchemaService.Impl.get((Project)yAMLKeyValue.getProject());
        PsiFile psiFile = yAMLKeyValue.getContainingFile();
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null || !jsonSchemaService.isApplicableToFile(virtualFile)) {
            return null;
        }
        JsonPointerPosition jsonPointerPosition = YamlJsonPsiWalker.INSTANCE.findPosition((PsiElement)yAMLKeyValue, true);
        if (jsonPointerPosition == null) {
            return null;
        }
        JsonSchemaObject jsonSchemaObject = jsonSchemaService.getSchemaObject(psiFile);
        if (jsonSchemaObject != null && (psiElement = new JsonSchemaResolver(sourceElement.getProject(), jsonSchemaObject, jsonPointerPosition).findNavigationTarget((PsiElement)yAMLKeyValue.getValue())) != null) {
            return new PsiElement[]{psiElement};
        }
        return null;
    }
}

