/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.commit;

import com.intellij.AppTopics;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.AbstractCommitter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class VetoSavingCommittingDocumentsAdapter {
    static final Object SAVE_DENIED = new Object();
    private final FileDocumentManager myFileDocumentManager;

    public VetoSavingCommittingDocumentsAdapter(FileDocumentManager fileDocumentManager) {
        this.myFileDocumentManager = fileDocumentManager;
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerListener(){

            public void beforeAllDocumentsSaving() {
                Map documentsToWarn = VetoSavingCommittingDocumentsAdapter.this.getDocumentsBeingCommitted();
                if (!documentsToWarn.isEmpty()) {
                    boolean allowSave = VetoSavingCommittingDocumentsAdapter.this.showAllowSaveDialog(documentsToWarn);
                    VetoSavingCommittingDocumentsAdapter.updateSaveability(documentsToWarn, allowSave);
                }
            }
        });
    }

    private Map<Document, Project> getDocumentsBeingCommitted() {
        HashMap<Document, Project> documentsToWarn = new HashMap<Document, Project>();
        for (Document unsavedDocument : this.myFileDocumentManager.getUnsavedDocuments()) {
            Object data = unsavedDocument.getUserData(AbstractCommitter.DOCUMENT_BEING_COMMITTED_KEY);
            if (!(data instanceof Project)) continue;
            documentsToWarn.put(unsavedDocument, (Project)data);
        }
        return documentsToWarn;
    }

    private static void updateSaveability(Map<Document, Project> documentsToWarn, boolean allowSave) {
        Object newValue = allowSave ? null : SAVE_DENIED;
        for (Document document : documentsToWarn.keySet()) {
            Project oldData = documentsToWarn.get(document);
            ((UserDataHolderEx)document).replace(AbstractCommitter.DOCUMENT_BEING_COMMITTED_KEY, (Object)oldData, newValue);
        }
    }

    boolean showAllowSaveDialog(Map<Document, Project> documentsToWarn) {
        StringBuilder messageBuilder = new StringBuilder("The following " + (documentsToWarn.size() == 1 ? "file is" : "files are") + " currently being committed to the VCS. Saving now could cause inconsistent data to be committed.\n");
        for (Document document : documentsToWarn.keySet()) {
            VirtualFile file = this.myFileDocumentManager.getFile(document);
            messageBuilder.append(FileUtil.toSystemDependentName((String)file.getPath())).append("\n");
        }
        messageBuilder.append("Save the ").append(documentsToWarn.size() == 1 ? "file" : "files").append(" now?");
        Project project = documentsToWarn.values().iterator().next();
        int rc = Messages.showOkCancelDialog((Project)project, (String)messageBuilder.toString(), (String)"Save Files During Commit", (String)"Save Now", (String)"Postpone Save", (Icon)Messages.getQuestionIcon());
        return rc == 0;
    }
}

