/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.ui.navigation.History;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PairFunction;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.GraphTableModel;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.visible.VisiblePackRefresher;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.awt.Component;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogUiImpl
extends AbstractVcsLogUi {
    private static final String HELP_ID = "reference.changesToolWindow.log";
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final MyVcsLogUiPropertiesListener myPropertiesListener;
    @NotNull
    private final History myHistory;
    @NotNull
    private final EventDispatcher<VcsLogFilterListener> myFilterListenerDispatcher;

    public VcsLogUiImpl(@NotNull String id, @NotNull VcsLogData logData, @NotNull VcsLogColorManager manager, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VisiblePackRefresher refresher, @Nullable VcsLogFilterCollection filters) {
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(0);
        }
        if (logData == null) {
            VcsLogUiImpl.$$$reportNull$$$0(1);
        }
        if (manager == null) {
            VcsLogUiImpl.$$$reportNull$$$0(2);
        }
        if (uiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(3);
        }
        if (refresher == null) {
            VcsLogUiImpl.$$$reportNull$$$0(4);
        }
        super(id, logData, manager, refresher);
        this.myFilterListenerDispatcher = EventDispatcher.create(VcsLogFilterListener.class);
        this.myUiProperties = uiProperties;
        this.myMainFrame = new MainFrame(logData, this, uiProperties, this.myVisiblePack, filters);
        for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)this.myProject)) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myPropertiesListener = new MyVcsLogUiPropertiesListener();
        this.myUiProperties.addChangeListener(this.myPropertiesListener);
        this.myHistory = VcsLogUiUtil.installNavigationHistory(this);
    }

    @Override
    protected void onVisiblePackUpdated(boolean permGraphChanged) {
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.myPropertiesListener.onShowLongEdgesChanged();
    }

    @NotNull
    public MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            VcsLogUiImpl.$$$reportNull$$$0(5);
        }
        return mainFrame;
    }

    private void performLongAction(@NotNull GraphAction graphAction, @NotNull String title) {
        if (graphAction == null) {
            VcsLogUiImpl.$$$reportNull$$$0(6);
        }
        if (title == null) {
            VcsLogUiImpl.$$$reportNull$$$0(7);
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            GraphAnswer answer = this.myVisiblePack.getVisibleGraph().getActionController().performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                assert (updater != null) : "Action:" + title + "\nController: " + this.myVisiblePack.getVisibleGraph().getActionController() + "\nAnswer:" + answer;
                updater.run();
                this.getTable().handleAnswer((GraphAnswer<Integer>)answer);
            });
        }, title, false, null, this.getMainFrame().getMainComponent());
    }

    public void expandAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_EXPAND), "Expanding " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    public void collapseAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_COLLAPSE), "Collapsing " + (this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE) == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    @Override
    protected <T> void handleCommitNotFound(final @NotNull T commitId, boolean commitExists, final @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter) {
        if (commitId == null) {
            VcsLogUiImpl.$$$reportNull$$$0(8);
        }
        if (rowGetter == null) {
            VcsLogUiImpl.$$$reportNull$$$0(9);
        }
        if (this.getFilterUi().getFilters().isEmpty() || !commitExists) {
            super.handleCommitNotFound(commitId, commitExists, rowGetter);
            return;
        }
        ArrayList<NamedRunnable> runnables = new ArrayList<NamedRunnable>();
        runnables.add(new NamedRunnable("View and Reset Filters"){

            public void run() {
                VcsLogUiImpl.this.getFilterUi().setFilter(null);
                VcsLogUiImpl.this.invokeOnChange(() -> VcsLogUiImpl.this.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create()), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
            }
        });
        final VcsProjectLog projectLog = VcsProjectLog.getInstance(this.myProject);
        final VcsLogManager logManager = projectLog.getLogManager();
        if (logManager != null && logManager.getDataManager() == this.myLogData) {
            runnables.add(new NamedRunnable("View in New Tab"){

                public void run() {
                    VcsLogUiImpl ui2 = projectLog.getTabsManager().openAnotherLogTab(logManager, VcsLogFilterObject.collection(new VcsLogFilter[0]));
                    ui2.invokeOnChange(() -> ui2.jumpTo(commitId, rowGetter, (SettableFuture<? super Boolean>)SettableFuture.create()), (Condition<? super VcsLogDataPack>)((Condition)pack -> pack.getFilters().isEmpty()));
                }
            });
        }
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, VcsLogUiImpl.getCommitNotFoundMessage(commitId, true), MessageType.WARNING, runnables.toArray(new NamedRunnable[0]));
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        MainVcsLogUiProperties.VcsLogHighlighterProperty property;
        if (id == null) {
            VcsLogUiImpl.$$$reportNull$$$0(10);
        }
        return this.myUiProperties.exists(property = MainVcsLogUiProperties.VcsLogHighlighterProperty.get(id)) && this.myUiProperties.get(property) != false;
    }

    public void applyFiltersAndUpdateUi(@NotNull VcsLogFilterCollection filters) {
        if (filters == null) {
            VcsLogUiImpl.$$$reportNull$$$0(11);
        }
        this.myRefresher.onFiltersChange(filters);
        ((VcsLogFilterListener)this.myFilterListenerDispatcher.getMulticaster()).onFiltersChanged();
    }

    public void addFilterListener(@NotNull VcsLogFilterListener listener) {
        if (listener == null) {
            VcsLogUiImpl.$$$reportNull$$$0(12);
        }
        this.myFilterListenerDispatcher.addListener((EventListener)listener);
    }

    @Override
    @NotNull
    public VcsLogGraphTable getTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myMainFrame.getGraphTable();
        if (vcsLogGraphTable == null) {
            VcsLogUiImpl.$$$reportNull$$$0(13);
        }
        return vcsLogGraphTable;
    }

    @Override
    @NotNull
    public Component getMainComponent() {
        JComponent jComponent = this.myMainFrame.getMainComponent();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(14);
        }
        return jComponent;
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myMainFrame.getToolbar();
        if (jComponent == null) {
            VcsLogUiImpl.$$$reportNull$$$0(15);
        }
        return jComponent;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogFilterUi vcsLogFilterUi = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUi == null) {
            VcsLogUiImpl.$$$reportNull$$$0(16);
        }
        return vcsLogFilterUi;
    }

    @Override
    @NotNull
    public MainVcsLogUiProperties getProperties() {
        MainVcsLogUiProperties mainVcsLogUiProperties = this.myUiProperties;
        if (mainVcsLogUiProperties == null) {
            VcsLogUiImpl.$$$reportNull$$$0(17);
        }
        return mainVcsLogUiProperties;
    }

    @Override
    @Nullable
    public String getHelpId() {
        return HELP_ID;
    }

    @Override
    @Nullable
    public History getNavigationHistory() {
        return this.myHistory;
    }

    @Override
    public void dispose() {
        this.myUiProperties.removeChangeListener(this.myPropertiesListener);
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphAction";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rowGetter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/VcsLogUiImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainFrame";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTable";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainComponent";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performLongAction";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleCommitNotFound";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isHighlighterEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "applyFiltersAndUpdateUi";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addFilterListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface VcsLogFilterListener
    extends EventListener {
        public void onFiltersChanged();
    }

    private class MyVcsLogUiPropertiesListener
    implements VcsLogUiProperties.PropertiesChangeListener {
        private MyVcsLogUiPropertiesListener() {
        }

        @Override
        public <T> void onPropertyChanged(@NotNull VcsLogUiProperties.VcsLogUiProperty<T> property) {
            if (property == null) {
                MyVcsLogUiPropertiesListener.$$$reportNull$$$0(0);
            }
            if (CommonUiProperties.SHOW_DETAILS.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.showDetails(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
            } else if (CommonUiProperties.SHOW_DIFF_PREVIEW.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.showDiffPreview(VcsLogUiImpl.this.myUiProperties.get(CommonUiProperties.SHOW_DIFF_PREVIEW));
            } else if (MainVcsLogUiProperties.SHOW_LONG_EDGES.equals(property)) {
                this.onShowLongEdgesChanged();
            } else if (CommonUiProperties.SHOW_ROOT_NAMES.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().rootColumnUpdated();
            } else if (MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().setCompactReferencesView(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW));
            } else if (MainVcsLogUiProperties.SHOW_TAG_NAMES.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().setShowTagNames(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_TAG_NAMES));
            } else if (MainVcsLogUiProperties.BEK_SORT_TYPE.equals(property)) {
                VcsLogUiImpl.this.myRefresher.onSortTypeChange(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.BEK_SORT_TYPE));
            } else if (CommonUiProperties.COLUMN_ORDER.equals(property)) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().onColumnOrderSettingChanged();
            } else if (property instanceof MainVcsLogUiProperties.VcsLogHighlighterProperty) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().repaint();
            } else if (property instanceof CommonUiProperties.TableColumnProperty) {
                VcsLogUiImpl.this.myMainFrame.getGraphTable().forceReLayout(((CommonUiProperties.TableColumnProperty)property).getColumn());
            }
        }

        private void onShowLongEdgesChanged() {
            VcsLogUiImpl.this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(VcsLogUiImpl.this.myUiProperties.get(MainVcsLogUiProperties.SHOW_LONG_EDGES) == false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/vcs/log/ui/VcsLogUiImpl$MyVcsLogUiPropertiesListener", "onPropertyChanged"));
        }
    }
}

