/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.docker;

import com.google.common.base.Joiner;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.DockerAgentApplication;
import com.intellij.docker.agent.DockerAgentDeploymentConfig;
import com.intellij.docker.remote.run.common.VolumesBuilder;
import com.intellij.docker.remote.run.runtime.DockerAgentDeploymentConfigImpl;
import com.intellij.docker.remote.run.runtime.RemoteDockerApplicationRuntime;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntime;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.docker.PyDockerAgentDeploymentConfigImpl;
import com.jetbrains.python.docker.PyDockerProcessConnectionData;
import com.jetbrains.python.docker.PyDockerProcessUtil;
import com.jetbrains.python.docker.PyDockerSkeletonGeneratorBase;
import com.jetbrains.python.remote.PyRemotePathMapper;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalData;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSkeletonGeneratorBase;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDockerSkeletonGenerator
extends PyDockerSkeletonGeneratorBase {
    public PyDockerSkeletonGenerator(@Nullable Project project, String skeletonsPath, Sdk sdk) {
        super(project, skeletonsPath, sdk);
    }

    @NotNull
    public ProcessOutput getProcessOutput(String homePath, @NotNull String[] commandLine, Map<String, String> extraEnv, int timeout) throws InvalidSdkException {
        ProcessOutput processOutput;
        if (commandLine == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(0);
        }
        Object[] extendedCommandLine = PyRemoteSkeletonGeneratorBase.addUnbuffered((String)homePath, (String[])commandLine);
        RemoteDockerApplicationRuntime applicationRuntime = this.createContainer((String[])extendedCommandLine);
        try {
            processOutput = applicationRuntime.startAndGetOutput();
        }
        catch (ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join(extendedCommandLine), e});
            throw PyDockerSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        if (processOutput == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(1);
        }
        return processOutput;
    }

    @Override
    @NotNull
    protected RemoteDockerRuntime createDockerRuntime() throws ServerRuntimeException, RemoteSdkException {
        RemoteDockerRuntime remoteDockerRuntime = RemoteDockerRuntime.create((DockerCloudConfiguration)this.getProcessConnectionData().getAccount(), (Project)this.getProject());
        if (remoteDockerRuntime == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(2);
        }
        return remoteDockerRuntime;
    }

    public ProcessOutput runSkeletonGeneration(String modname, String modfilename, List<String> assemblyRefs, String binaryPath, String extraSyspath) throws InvalidSdkException {
        RemoteDockerApplicationRuntime container = this.getOrCreateSkeletonGenerationContainer(binaryPath, extraSyspath);
        try {
            container.startAndAttach();
            try (PrintStream stdin = new PrintStream(container.getStdin());){
                stdin.println(modname);
                stdin.println(modfilename);
                stdin.println(assemblyRefs != null ? StringUtil.join(assemblyRefs, (String)";") : "");
                stdin.flush();
            }
            return container.wait4AndGetOutput();
        }
        catch (ServerRuntimeException | IOException e) {
            LOG.debug("Skeleton generation for " + modname + " failed", e);
            throw PyDockerSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private RemoteDockerApplicationRuntime getOrCreateSkeletonGenerationContainer(String binaryPath, String extraSyspath) throws InvalidSdkException {
        Object object = this.getSkeletonGenerationContainerLock();
        // MONITORENTER : object
        RemoteDockerApplicationRuntime skeletonGenerationContainer = this.getSkeletonGenerationContainer();
        if (skeletonGenerationContainer == null) {
            String parentDir = new File(binaryPath).getParent();
            ArrayList<String> commandLine = new ArrayList<String>();
            commandLine.add(binaryPath);
            commandLine.add(PythonHelpersLocator.getHelperPath((String)"generator3.py"));
            commandLine.add("-d");
            commandLine.add(this.getSkeletonsPath());
            if (ApplicationManager.getApplication().isInternal()) {
                commandLine.add("-x");
            }
            if (!StringUtil.isEmpty((String)extraSyspath)) {
                commandLine.add("-s");
                commandLine.add(extraSyspath);
            }
            commandLine.add("-i");
            String[] extendedCommandLine = PyDockerSkeletonGenerator.addUnbuffered((String)parentDir, (String[])ArrayUtilRt.toStringArray(commandLine));
            skeletonGenerationContainer = this.createContainer(extendedCommandLine);
            this.setSkeletonGenerationContainer(skeletonGenerationContainer);
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = skeletonGenerationContainer;
        // MONITOREXIT : object
        if (remoteDockerApplicationRuntime != null) return remoteDockerApplicationRuntime;
        PyDockerSkeletonGenerator.$$$reportNull$$$0(3);
        return remoteDockerApplicationRuntime;
    }

    @NotNull
    private RemoteDockerApplicationRuntime createContainer(@NotNull String[] extendedCommandLine) throws InvalidSdkException {
        RemoteDockerApplicationRuntime applicationRuntime;
        if (extendedCommandLine == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(4);
        }
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerProcessConnectionData data = PyDockerProcessUtil.getPyDockerProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        PyRemotePathMapper pathMapper = this.createPathMappings(this.getProject(), (PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        try {
            RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
            VolumesBuilder bindingBuilder = VolumesBuilder.builder();
            bindingBuilder.addBoundVolume(this.getRemoteSkeletonsPath(), this.prepareSkeletonsVolume());
            HashMap<String, String> env = new HashMap<String, String>();
            PythonEnvUtil.setPythonUnbuffered(env);
            env.put("JETBRAINS_REMOTE_RUN", "1");
            PyDockerAgentDeploymentConfigImpl config = new PyDockerAgentDeploymentConfigImpl(data.getImage(), bindingBuilder.build());
            config.withEnvs(env);
            config.withEntrypoint(new String[0]);
            config.setupHelpers(dockerRuntime);
            config.setupRemoteCommandLine(pathMapper, extendedCommandLine, null, sdkAdditionalData.getInterpreterPath());
            applicationRuntime = RemoteDockerApplicationRuntime.createWithPullImage((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfigImpl)config);
        }
        catch (RemoteSdkException | ServerRuntimeException | IOException e) {
            LOG.debug("Unable to execute command ", new Object[]{Joiner.on((String)" ").join((Object[])extendedCommandLine), e});
            throw PyDockerSkeletonGenerator.propagateRecoverableException((Exception)e);
        }
        RemoteDockerApplicationRuntime remoteDockerApplicationRuntime = applicationRuntime;
        if (remoteDockerApplicationRuntime == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(5);
        }
        return remoteDockerApplicationRuntime;
    }

    @Override
    @NotNull
    protected String setupSkeletonsVolume() throws ServerRuntimeException, RemoteSdkException, IOException {
        String user;
        String volumeName = this.computeSkeletonsVolumeName();
        PyDockerProcessConnectionData data = this.getProcessConnectionData();
        LOG.debug("Setting up volume \"" + volumeName + "\" for skeletons for image \"" + data.getImage() + "\"");
        RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
        DockerAgentApplication image = dockerRuntime.findImageByName(data.getImage());
        String string = user = image == null ? null : (String)dockerRuntime.executeAgentTask(() -> ((DockerAgentApplication)image).getImageUser());
        if (StringUtil.isNotEmpty(user)) {
            LOG.debug("User for image \"" + data.getImage() + "\" is " + user + ", permissions setup for skeletons volume \"" + volumeName + "\" required");
            VolumesBuilder volumesBuilder = VolumesBuilder.builder().addBoundVolume(this.getRemoteSkeletonsPath(), volumeName);
            DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(data.getImage(), volumesBuilder.build()).withUser("root").withEntrypoint(ArrayUtilRt.EMPTY_STRING_ARRAY).withCommand(new String[]{"chown", "-R", user, this.getRemoteSkeletonsPath()});
            RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
            ProcessOutput output = applicationRuntime.startAndGetOutput();
            if (!output.checkSuccess(LOG)) {
                throw new RemoteSdkException("Failed to change owner of skeletons volume for Docker image \"" + data.getImage() + "\"");
            }
        } else {
            LOG.debug("User for image \"" + data.getImage() + "\" is default (root)");
        }
        String string2 = volumeName;
        if (string2 == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    private PyDockerProcessConnectionData getProcessConnectionData() {
        PyRemoteSdkAdditionalData sdkAdditionalData = this.getRemoteSdkAdditionalData();
        PyDockerProcessConnectionData pyDockerProcessConnectionData = PyDockerProcessUtil.getPyDockerProcessConnectionData((PyRemoteSdkAdditionalDataBase)sdkAdditionalData);
        if (pyDockerProcessConnectionData == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(7);
        }
        return pyDockerProcessConnectionData;
    }

    @Override
    protected void doDownloadSources(@NotNull String srcRemotePath, @NotNull File targetLocalDir, @NotNull VolumesBuilder bindingBuilder, @Nullable Map<String, String> map) throws RemoteSdkException, IOException, ServerRuntimeException {
        if (srcRemotePath == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(8);
        }
        if (targetLocalDir == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(9);
        }
        if (bindingBuilder == null) {
            PyDockerSkeletonGenerator.$$$reportNull$$$0(10);
        }
        PyDockerProcessConnectionData data = this.getProcessConnectionData();
        RemoteDockerRuntime dockerRuntime = this.createDockerRuntime();
        DockerAgentDeploymentConfigImpl config = new DockerAgentDeploymentConfigImpl(data.getImage(), bindingBuilder.build()).withCommand(new String[]{"/bin/true"});
        RemoteDockerApplicationRuntime applicationRuntime = RemoteDockerApplicationRuntime.create((RemoteDockerRuntime)dockerRuntime, (DockerAgentDeploymentConfig)config);
        applicationRuntime.downloadDirectoryAndRemove(srcRemotePath, targetLocalDir, map, data.getAccount().getMachine());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/docker/PyDockerSkeletonGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extendedCommandLine";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "srcRemotePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetLocalDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/docker/PyDockerSkeletonGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessOutput";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createDockerRuntime";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSkeletonGenerationContainer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createContainer";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "setupSkeletonsVolume";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessConnectionData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessOutput";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doDownloadSources";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

