/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.less.completion.provider;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSelectorSuffix;
import com.intellij.psi.css.CssSelectorSuffixType;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.completion.provider.CssSelectorSuffixCompletionProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.less.LESSUtil;
import org.jetbrains.plugins.less.psi.LESSMixin;
import org.jetbrains.plugins.less.psi.LESSMixinInvocation;
import org.jetbrains.plugins.less.psi.impl.LESSPrimitiveMixin;
import org.jetbrains.plugins.less.psi.stubs.LessMixinIndex;

public class LessMixinCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final boolean myInPureMixinInvocation;

    public LessMixinCompletionProvider(boolean inPureMixinInvocation) {
        this.myInPureMixinInvocation = inPureMixinInvocation;
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        if (this.myInPureMixinInvocation) {
            LESSMixinInvocation mixinInvocation = (LESSMixinInvocation)PsiTreeUtil.getParentOfType((PsiElement)position, LESSMixinInvocation.class);
            String invocationNamespace = mixinInvocation != null ? mixinInvocation.getNamespace() : "";
            String prefix = mixinInvocation != null ? mixinInvocation.getPrefix() : "";
            HashSet ignoreSelectors = Sets.newHashSet();
            LessMixinCompletionProvider.addCompletions(result, position, project, (PsiElement)mixinInvocation, invocationNamespace, prefix, parameters.getOriginalFile(), ignoreSelectors);
            if (mixinInvocation != null) {
                PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)mixinInvocation);
                while (nextLeaf != null && nextLeaf.getText().trim().isEmpty()) {
                    nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
                }
                if (nextLeaf != null) {
                    IElementType type = nextLeaf.getNode().getElementType();
                    if (type == CssElementTypes.CSS_RBRACE || !type.getLanguage().isKindOf((Language)CSSLanguage.INSTANCE)) {
                        LessMixinCompletionProvider.addSelectorsCompletion(parameters, prefix, result, ignoreSelectors);
                    }
                } else {
                    LessMixinCompletionProvider.addSelectorsCompletion(parameters, prefix, result, ignoreSelectors);
                }
            }
        } else {
            CssSelectorList cssSelectorList = (CssSelectorList)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorList.class);
            CssSelectorSuffix cssSelectorSuffix = (CssSelectorSuffix)PsiTreeUtil.getParentOfType((PsiElement)position, CssSelectorSuffix.class);
            if (cssSelectorList != null && cssSelectorSuffix != null) {
                PsiElement simpleSelector = PsiTreeUtil.getParentOfType((PsiElement)cssSelectorSuffix, CssSimpleSelector.class);
                if (simpleSelector == null || !simpleSelector.getText().equals(cssSelectorSuffix.getText())) {
                    return;
                }
                CssSelector[] selectors = cssSelectorList.getSelectors();
                if (selectors.length == 1) {
                    CssSelector cssSelector = selectors[0];
                    String invocationNamespace = LESSUtil.getNamespaceForSelector(cssSelector, cssSelectorSuffix);
                    String prefix = LESSUtil.getSelectorPrefix(cssSelectorSuffix);
                    LessMixinCompletionProvider.addCompletions(result, position, project, (PsiElement)cssSelectorSuffix, invocationNamespace, prefix, parameters.getOriginalFile(), null);
                }
            }
        }
    }

    private static void addSelectorsCompletion(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result, @NotNull Set<String> ignoreSelectors) {
        if (parameters == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(3);
        }
        if (prefix == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(4);
        }
        if (result == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(5);
        }
        if (ignoreSelectors == null) {
            LessMixinCompletionProvider.$$$reportNull$$$0(6);
        }
        CssSelectorSuffixType selectorType = "#".equals(prefix) ? CssSelectorSuffixType.ID : CssSelectorSuffixType.CLASS;
        new CssSelectorSuffixCompletionProvider(selectorType, s -> !ignoreSelectors.contains(s)).addCompletionVariants(parameters, new ProcessingContext(), result);
    }

    private static void addCompletions(CompletionResultSet result, PsiElement position, Project project, @Nullable PsiElement mixinInvocation, String invocationNamespace, String prefix, PsiFile file, Collection<String> ignoreSelectors) {
        boolean inBlock = PsiTreeUtil.getParentOfType((PsiElement)position, CssBlock.class) != null;
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        Set importedFiles = CssUtil.getImportedFiles((PsiFile)file, (PsiElement)position, (boolean)false);
        for (String name : StubIndex.getInstance().getAllKeys(LessMixinIndex.KEY, project)) {
            if (name.isEmpty() || !name.startsWith(prefix)) continue;
            LessMixinIndex.process(name, project, scope, (Processor<? super LESSMixin>)((Processor)mixin -> {
                if ((inBlock || !(mixin instanceof LESSPrimitiveMixin)) && LESSUtil.isMixinMatchesWithInvocation(mixin, mixinInvocation, invocationNamespace)) {
                    if (ignoreSelectors != null && mixin instanceof LESSPrimitiveMixin) {
                        ignoreSelectors.add(mixin.getName());
                    }
                    boolean validResult = importedFiles.contains(mixin.getContainingFile().getVirtualFile());
                    result.addElement(LESSUtil.createMixinLookupItem(mixin, validResult));
                }
                return true;
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreSelectors";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/less/completion/provider/LessMixinCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addSelectorsCompletion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

