/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.extensions.compass;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.CommonProcessors;
import com.intellij.util.PathUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSBundle;
import org.jetbrains.plugins.sass.extensions.compass.CompassConfigParser;
import org.jetbrains.plugins.sass.extensions.compass.CompassSettings;
import org.jetbrains.plugins.sass.extensions.compass.CompassUtil;

public abstract class CompassImportPathRegistrationWatcher
implements Disposable {
    public static final Topic<ImportPathsListener> IMPORT_PATHS_CHANGED = Topic.create((String)"compass import paths changed", ImportPathsListener.class, (Topic.BroadcastDirection)Topic.BroadcastDirection.TO_PARENT);
    protected final Module myModule;
    private static final int QUEUE_UPDATE_TIMEOUT = 5000;
    @Nullable
    private MergingUpdateQueue myQueue;
    @NotNull
    private final CompassConfigParser myConfigParser;
    @NotNull
    private final Object mySyncObject;
    private boolean myStarted;

    public CompassImportPathRegistrationWatcher(@NotNull Module module, @NotNull CompassConfigParser configParser) {
        if (module == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(0);
        }
        if (configParser == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(1);
        }
        this.mySyncObject = new Object();
        this.myStarted = false;
        this.myModule = module;
        this.myConfigParser = configParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.mySyncObject;
        synchronized (object) {
            return this.myStarted;
        }
    }

    private boolean isFileToScan(@Nullable VirtualFile file) {
        CompassSettings settings = CompassSettings.getInstance(this.myModule);
        return file != null && settings != null && PathUtil.getFileName((String)settings.getCompassConfigPath()).equals(file.getName()) && FileUtil.pathsEqual((String)settings.getCompassConfigPath(), (String)file.getPath());
    }

    private boolean isEventToScan(@NotNull VirtualFileEvent event) {
        VirtualFile file;
        VirtualFile parent;
        CompassSettings settings;
        if (event == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(2);
        }
        if ((settings = CompassSettings.getInstance(this.myModule)) != null && event instanceof VirtualFilePropertyEvent && "name".equals(((VirtualFilePropertyEvent)event).getPropertyName()) && (parent = (file = event.getFile()).getParent()) != null) {
            String configPath = settings.getCompassConfigPath();
            String configFileName = PathUtil.getFileName((String)configPath);
            Object oldName = ((VirtualFilePropertyEvent)event).getOldValue();
            Object newName = ((VirtualFilePropertyEvent)event).getNewValue();
            return (configFileName.equals(oldName) || configFileName.equals(newName)) && FileUtil.pathsEqual((String)PathUtil.getParentPath((String)configPath), (String)parent.getPath());
        }
        return this.isFileToScan(event.getFile());
    }

    @NotNull
    private Collection<VirtualFile> getFilesToScan() {
        String compassConfigPath;
        CompassSettings settings = CompassSettings.getInstance(this.myModule);
        if (settings != null && !(compassConfigPath = settings.getCompassConfigPath()).trim().isEmpty()) {
            VirtualFile configFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)compassConfigPath));
            List list = ContainerUtil.createMaybeSingletonList((Object)configFile);
            if (list == null) {
                CompassImportPathRegistrationWatcher.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(4);
        }
        return list;
    }

    private void fillWithImportPathsFromConfig(@NotNull Module module, @NotNull VirtualFile file, @NotNull Collection<String> importPaths) {
        if (module == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(5);
        }
        if (file == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(6);
        }
        if (importPaths == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(7);
        }
        importPaths.addAll(this.myConfigParser.parse(file, PsiManager.getInstance((Project)module.getProject())).getImportPaths());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleImportPathsRefresh() {
        Object object = this.mySyncObject;
        synchronized (object) {
            if (this.myQueue != null) {
                this.myQueue.queue((Update)new MyImportPathsScan(this.myModule));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(@NotNull ImportPathsListener importPathsListener, boolean enableFileWatchers) {
        if (importPathsListener == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(8);
        }
        if (this.myModule.isDisposed()) {
            return;
        }
        Object object = this.mySyncObject;
        synchronized (object) {
            if (!this.myStarted) {
                MessageBusConnection connection = this.myModule.getProject().getMessageBus().connect((Disposable)this);
                connection.subscribe(IMPORT_PATHS_CHANGED, (Object)importPathsListener);
                this.myQueue = new MergingUpdateQueue("CompassImportPathsRegistrationWatcher", 5000, true, null, (Disposable)this).setRestartTimerOnAdd(true);
                this.myStarted = true;
                StartupManager.getInstance((Project)this.myModule.getProject()).runWhenProjectIsInitialized(() -> {
                    Object object = this.mySyncObject;
                    synchronized (object) {
                        if (!this.myStarted) {
                            return;
                        }
                        if (enableFileWatchers) {
                            this.enableWatchers();
                        }
                    }
                    if (!ApplicationManager.getApplication().isUnitTestMode()) {
                        ApplicationManager.getApplication().invokeLater((Runnable)((Object)new MyImportPathsScan(this.myModule)));
                    } else {
                        ApplicationManager.getApplication().invokeAndWait((Runnable)((Object)new MyImportPathsScan(this.myModule)), ModalityState.any());
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mySyncObject;
        synchronized (object) {
            this.myStarted = false;
        }
    }

    public void dispose() {
    }

    private void enableWatchers() {
        PsiManager.getInstance((Project)this.myModule.getProject()).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeAdapter(), (Disposable)this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVirtualFileListener(), (Disposable)this);
    }

    private void doScanImportPaths(@NotNull Module module) {
        if (module == null) {
            CompassImportPathRegistrationWatcher.$$$reportNull$$$0(9);
        }
        if (module.isDisposed()) {
            return;
        }
        HashSet<String> importPaths = new HashSet<String>();
        Collection<VirtualFile> filesToScan = this.getFilesToScan();
        for (VirtualFile file : filesToScan) {
            if (file == null || !file.isValid()) continue;
            this.fillWithImportPathsFromConfig(module, file, importPaths);
            CompassUtil.runCompassImportsAndProcessPaths(module, file, (Processor<? super String>)new CommonProcessors.CollectProcessor(importPaths), true);
        }
        if (filesToScan.isEmpty()) {
            CompassUtil.runCompassImportsAndProcessPaths(module, null, (Processor<? super String>)new CommonProcessors.CollectProcessor(importPaths), true);
        }
        ((ImportPathsListener)module.getMessageBus().syncPublisher(IMPORT_PATHS_CHANGED)).pathsChanged(module, importPaths);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPaths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPathsListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToScan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEventToScan";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fillWithImportPathsFromConfig";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doScanImportPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyVirtualFileListener
    implements VirtualFileListener {
        private MyVirtualFileListener() {
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(0);
            }
            this.processFileEvent(event);
        }

        public void fileDeleted(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(1);
            }
            this.processFileEvent(event);
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(2);
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(3);
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(4);
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(5);
            }
            this.processFileEvent((VirtualFileEvent)event);
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(6);
            }
            this.processFileEvent(event);
        }

        private void processFileEvent(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVirtualFileListener.$$$reportNull$$$0(7);
            }
            if (CompassImportPathRegistrationWatcher.this.isEventToScan(event)) {
                CompassImportPathRegistrationWatcher.this.scheduleImportPathsRefresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyVirtualFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileDeleted";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFileEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyPsiTreeChangeAdapter
    extends PsiTreeChangeAdapter {
        private MyPsiTreeChangeAdapter() {
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(0);
            }
            this.processPsiEvent(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(1);
            }
            this.processPsiEvent(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(2);
            }
            this.processPsiEvent(event);
        }

        public void childMoved(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(3);
            }
            this.processPsiEvent(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            if (event == null) {
                MyPsiTreeChangeAdapter.$$$reportNull$$$0(4);
            }
            this.processPsiEvent(event);
        }

        private void processPsiEvent(PsiTreeChangeEvent event) {
            PsiFile file = event.getFile();
            if (file != null && CompassImportPathRegistrationWatcher.this.isFileToScan(file.getVirtualFile())) {
                CompassImportPathRegistrationWatcher.this.scheduleImportPathsRefresh();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyPsiTreeChangeAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childRemoved";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childReplaced";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "childrenChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyImportPathsScan
    extends Update {
        private final Module myModule;

        public boolean canEat(Update update) {
            return true;
        }

        MyImportPathsScan(Module module) {
            if (module == null) {
                MyImportPathsScan.$$$reportNull$$$0(0);
            }
            super((Object)"Compass import paths scan");
            this.myModule = module;
        }

        public void run() {
            if (this.myModule.isDisposed()) {
                return;
            }
            Project project = this.myModule.getProject();
            DumbService.getInstance((Project)project).runWhenSmart(() -> {
                String title = SASSBundle.message("compass.scan.import.paths");
                ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, title, false){

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (this.myProject == null || this.myProject.isDisposed()) {
                            return;
                        }
                        CompassImportPathRegistrationWatcher.this.doScanImportPaths(MyImportPathsScan.this.myModule);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyImportPathsScan$1", "run"));
                    }
                });
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/sass/extensions/compass/CompassImportPathRegistrationWatcher$MyImportPathsScan", "<init>"));
        }
    }

    public static interface ImportPathsListener {
        public void pathsChanged(@NotNull Module var1, @NotNull Set<String> var2);
    }
}

