/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.htmltools.xml.util;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.htmltools.xml.util.HtmlReferenceProvider;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.util.HtmlUtil;
import org.intellij.images.util.ImageInfo;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUpdateImageSizeIntention
extends BaseIntentionAction {
    private boolean myUseElementToTheLeft = false;

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)"html.intentions.update.image.size", (Object[])new Object[0]);
        if (string == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        int offset;
        if (project == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(1);
        }
        if (this.isAvailable(HtmlUpdateImageSizeIntention.getTag(file, offset = editor.getCaretModel().getOffset()))) {
            return true;
        }
        if (offset > 0 && this.isAvailable(HtmlUpdateImageSizeIntention.getTag(file, offset - 1))) {
            this.myUseElementToTheLeft = true;
            return true;
        }
        return false;
    }

    public boolean isAvailable(@Nullable XmlTag tag) {
        if (tag == null) {
            return false;
        }
        ImageInfo imageInfo = HtmlUpdateImageSizeIntention.getImageInfo(tag);
        if (imageInfo == null || imageInfo.height == 0 || imageInfo.width == 0) {
            return false;
        }
        String widthValue = tag.getAttributeValue("width");
        String heightValue = tag.getAttributeValue("height");
        this.setText(widthValue != null || heightValue != null ? XmlBundle.message((String)"html.intentions.update.image.size", (Object[])new Object[0]) : XmlBundle.message((String)"html.intentions.insert.image.size", (Object[])new Object[0]));
        return imageInfo.width != HtmlReferenceProvider.SizeReference.getSizeValue(widthValue, (XmlElement)tag) || imageInfo.height != HtmlReferenceProvider.SizeReference.getSizeValue(heightValue, (XmlElement)tag);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        XmlTag tag = HtmlUpdateImageSizeIntention.getTag(file, this.myUseElementToTheLeft ? offset - 1 : offset);
        if (tag == null) {
            return;
        }
        ImageInfo imageInfo = HtmlUpdateImageSizeIntention.getImageInfo(tag);
        if (imageInfo != null && imageInfo.height != 0 && imageInfo.width != 0) {
            WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{file}).run(() -> {
                tag.setAttribute("width", String.valueOf(imageInfo.width));
                tag.setAttribute("height", String.valueOf(imageInfo.height));
            });
        }
    }

    @Nullable
    private static ImageInfo getImageInfo(@NotNull XmlTag xmlTag) {
        if (xmlTag == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(3);
        }
        if ("img".equalsIgnoreCase(xmlTag.getName())) {
            return HtmlReferenceProvider.SizeReference.getImageInfo(xmlTag);
        }
        return null;
    }

    @Nullable
    private static XmlTag getTag(@NotNull PsiFile file, int offset) {
        if (file == null) {
            HtmlUpdateImageSizeIntention.$$$reportNull$$$0(4);
        }
        if (!HtmlUtil.hasHtml((PsiFile)file)) {
            return null;
        }
        return (XmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)file.getViewProvider().findElementAt(offset, (Language)HTMLLanguage.INSTANCE), (Class[])new Class[]{XmlTag.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/htmltools/xml/util/HtmlUpdateImageSizeIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getImageInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

