/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.JSFileFinderBase;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.debugger.Script;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fH\u0014\u00a2\u0006\u0002\u0010\u000fJ6\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010$\u001a\u00020\bH\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/javascript/debugger/DebuggableFileFinderImpl;", "Lcom/intellij/javascript/debugger/JSFileFinderBase;", "project", "Lcom/intellij/openapi/project/Project;", "requestor", "Lcom/intellij/util/Url;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/util/Url;)V", "authority", "", "getAuthority$intellij_javascript_debugger", "()Ljava/lang/String;", "fileUrlMappers", "", "Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "getFileUrlMappers", "()[Lcom/jetbrains/javascript/debugger/FileUrlMapper;", "lazyFileUrlMappers", "Lkotlin/Lazy;", "scheme", "computeFileUrlMappers", "doFindFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "findByName", "", "sourceContent", "script", "Lorg/jetbrains/debugger/Script;", "doFindUrls", "", "file", "findFileByAuthority", "findNavigatable", "Lcom/intellij/pom/Navigatable;", "findRemoteUrlByExtensionMappers", "isDebuggable", "toString", "intellij.javascript.debugger"})
public class DebuggableFileFinderImpl
extends JSFileFinderBase {
    private final String scheme;
    @Nullable
    private final String authority;
    private final Lazy<FileUrlMapper[]> lazyFileUrlMappers;
    private final Project project;
    private final Url requestor;

    @Nullable
    public final String getAuthority$intellij_javascript_debugger() {
        return this.authority;
    }

    private final FileUrlMapper[] getFileUrlMappers() {
        return (FileUrlMapper[])this.lazyFileUrlMappers.getValue();
    }

    @Nullable
    protected FileUrlMapper[] computeFileUrlMappers() {
        FileUrlMapper[] extensions;
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            return null;
        }
        Object[] objectArray = FileUrlMapper.EP_NAME.getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"FileUrlMapper.EP_NAME.extensions");
        FileUrlMapper[] fileUrlMapperArray = extensions = (FileUrlMapper[])objectArray;
        boolean bl = false;
        return fileUrlMapperArray.length == 0 ? null : extensions;
    }

    public final boolean isDebuggable(@NotNull VirtualFile file, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.authority == null || WebServerPathToFileManager.Companion.getInstance(project).getPath(file) != null || !this.findRemoteUrlByExtensionMappers(file).isEmpty();
    }

    private final List<Url> findRemoteUrlByExtensionMappers(VirtualFile file) {
        List list;
        List result2 = null;
        if (this.getFileUrlMappers() != null) {
            FileUrlMapper[] fileUrlMapperArray = this.getFileUrlMappers();
            if (fileUrlMapperArray == null) {
                Intrinsics.throwNpe();
            }
            for (FileUrlMapper mapper : fileUrlMapperArray) {
                List urls = mapper.getUrls(file, this.project, this.authority);
                if (urls.isEmpty()) continue;
                if (result2 == null) {
                    result2 = (List)new SmartList();
                }
                result2.addAll(urls);
            }
        }
        if ((list = result2) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @Nullable
    public Navigatable findNavigatable(@NotNull Url url, @NotNull Project project) {
        Navigatable navigatable;
        block7: {
            block6: {
                Navigatable navigatable2;
                block5: {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        return (Navigatable)JsFileUtil.createNavigatable(project, LocalFileFinder.findFile((String)url.getPath()));
                    }
                    navigatable = this.getFileUrlMappers();
                    if (navigatable == null) break block6;
                    Navigatable $this$computeIfAny$iv = navigatable;
                    boolean $i$f$computeIfAny = false;
                    Navigatable navigatable3 = $this$computeIfAny$iv;
                    int n = ((FileUrlMapper[])navigatable3).length;
                    for (int i = 0; i < n; ++i) {
                        Navigatable file$iv;
                        Navigatable it = file$iv = navigatable3[i];
                        boolean bl = false;
                        Navigatable result$iv = it.getNavigatable(url, project, this.requestor);
                        if (result$iv == null) continue;
                        navigatable2 = result$iv;
                        break block5;
                    }
                    navigatable2 = navigatable = null;
                }
                if (navigatable2 != null) break block7;
            }
            navigatable = (Navigatable)JsFileUtil.createNavigatable(project, this.findFileByAuthority(url, project));
        }
        return navigatable;
    }

    @Override
    @Nullable
    public VirtualFile doFindFile(@NotNull Url url, @NotNull Project project, boolean findByName2, @Nullable String sourceContent, @Nullable Script script) {
        VirtualFile virtualFile;
        block9: {
            block8: {
                VirtualFile virtualFile2;
                block7: {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    if (url.isInLocalFileSystem()) {
                        String string = url.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
                        String path = string;
                        if (LocalFileFinder.windowsDriveExists((String)path)) {
                            LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                            VirtualFile virtualFile3 = localFileSystem.findFileByPath(path);
                            if (virtualFile3 == null) {
                                virtualFile3 = localFileSystem.refreshAndFindFileByPath(path);
                            }
                            return virtualFile3;
                        }
                        return null;
                    }
                    virtualFile = this.getFileUrlMappers();
                    if (virtualFile == null) break block8;
                    VirtualFile $this$computeIfAny$iv = virtualFile;
                    boolean $i$f$computeIfAny = false;
                    VirtualFile virtualFile4 = $this$computeIfAny$iv;
                    int n = ((VirtualFile)virtualFile4).length;
                    for (int i = 0; i < n; ++i) {
                        VirtualFile file$iv;
                        VirtualFile it = file$iv = virtualFile4[i];
                        boolean bl = false;
                        VirtualFile result$iv = it.getFile(url, project, this.requestor);
                        if (result$iv == null) continue;
                        virtualFile2 = result$iv;
                        break block7;
                    }
                    virtualFile2 = virtualFile = null;
                }
                if (virtualFile2 != null) break block9;
            }
            virtualFile = this.findFileByAuthority(url, project);
        }
        return virtualFile;
    }

    private final VirtualFile findFileByAuthority(Url url, Project project) {
        if (this.authority != null && StringsKt.equals((String)this.authority, (String)url.getAuthority(), (boolean)true)) {
            WebServerPathToFileManager webServerPathToFileManager = WebServerPathToFileManager.Companion.getInstance(project);
            String string = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.path");
            return WebServerPathToFileManager.findVirtualFile$default((WebServerPathToFileManager)webServerPathToFileManager, (String)string, (boolean)false, null, (int)6, null);
        }
        return null;
    }

    @Override
    @NotNull
    public List<Url> doFindUrls(@NotNull VirtualFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        List<Url> urls = this.findRemoteUrlByExtensionMappers(file);
        if (!urls.isEmpty()) {
            return urls;
        }
        if (this.authority != null) {
            String string = WebServerPathToFileManager.Companion.getInstance(this.project).getPath(file);
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = this.scheme;
                if (string3 == null) {
                    Intrinsics.throwNpe();
                }
                return CollectionsKt.listOf((Object)Urls.newUrl((String)string3, (String)this.authority, (String)('/' + it)));
            }
        }
        return CollectionsKt.listOf((Object)Urls.newFromVirtualFile((VirtualFile)file));
    }

    @NotNull
    public String toString() {
        return "DefaultFileFinder";
    }

    public DebuggableFileFinderImpl(@NotNull Project project, @Nullable Url requestor) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        this.requestor = requestor;
        this.lazyFileUrlMappers = LazyKt.lazy((Function0)((Function0)new Function0<FileUrlMapper[]>(this){
            final /* synthetic */ DebuggableFileFinderImpl this$0;

            @Nullable
            public final FileUrlMapper[] invoke() {
                return this.this$0.computeFileUrlMappers();
            }
            {
                this.this$0 = debuggableFileFinderImpl;
                super(0);
            }
        }));
        if (this.requestor != null && this.requestor.isInLocalFileSystem()) {
            this.authority = null;
            this.scheme = null;
        } else if (this.requestor == null) {
            this.authority = null;
            this.scheme = null;
        } else {
            this.authority = this.requestor.getAuthority();
            this.scheme = this.requestor.getScheme();
        }
    }
}

