/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.http.request.cookies.annotator;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ws.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.ws.http.request.cookies.psi.CookieDate;
import com.intellij.ws.http.request.cookies.psi.CookieDomain;
import com.intellij.ws.http.request.cookies.psi.CookieElementVisitor;
import com.intellij.ws.http.request.cookies.psi.CookiePath;
import com.intellij.ws.http.request.cookies.psi.CookieRecord;
import com.intellij.ws.http.request.cookies.psi.MalformedCookie;
import com.intellij.ws.http.request.cookies.psi.RecordRest;
import java.text.ParseException;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

class CookieLanguageAnnotatorVisitor
extends CookieElementVisitor {
    private final AnnotationHolder myHolder;

    CookieLanguageAnnotatorVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    @Override
    public void visitMalformedCookie(@NotNull MalformedCookie malformedCookie) {
        if (malformedCookie == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        super.visitMalformedCookie(malformedCookie);
        String value = malformedCookie.getText();
        if (value != null) {
            TextRange range = new TextRange(malformedCookie.getTextRange().getStartOffset(), malformedCookie.getTextRange().getEndOffset());
            this.myHolder.createErrorAnnotation(range, "Malformed cookie: some TAB-separated attributes are missing. Cookie must follow the next format: \"domain\tpath\tname\tvalue\texpirationDate\"");
        }
    }

    @Override
    public void visitRecordRest(@NotNull RecordRest cookieRecordRest) {
        if (cookieRecordRest == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        super.visitRecordRest(cookieRecordRest);
        String value = cookieRecordRest.getText();
        if (value != null && !value.isEmpty()) {
            CookieRecord parentElement = (CookieRecord)cookieRecordRest.getParent();
            TextRange range = new TextRange(parentElement.getTextRange().getStartOffset(), parentElement.getTextRange().getEndOffset());
            this.myHolder.createErrorAnnotation(range, "Malformed cookie: too many TAB-separated attributes for Cookie. Cookie must follow the next format: \"domain\tpath\tname\tvalue\texpirationDate\"");
        }
    }

    @Override
    public void visitCookieDomain(@NotNull CookieDomain cookieDomain) {
        if (cookieDomain == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        super.visitCookieDomain(cookieDomain);
        String value = cookieDomain.getText();
        PsiElement rightSibling = cookieDomain.getNextSibling();
        if (value != null && StringUtil.isEmptyOrSpaces((String)value)) {
            TextRange range = new TextRange(cookieDomain.getTextRange().getStartOffset(), rightSibling.getTextRange().getEndOffset());
            this.myHolder.createErrorAnnotation(range, "Malformed cookie: empty domain attribute is not allowed");
        }
    }

    @Override
    public void visitCookiePath(@NotNull CookiePath cookiePath) {
        if (cookiePath == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        super.visitCookiePath(cookiePath);
        String value = cookiePath.getText();
        PsiElement rightSibling = cookiePath.getNextSibling();
        if (value != null && StringUtil.isEmptyOrSpaces((String)value)) {
            TextRange range = new TextRange(cookiePath.getTextRange().getStartOffset(), rightSibling.getTextRange().getEndOffset());
            this.myHolder.createErrorAnnotation(range, "Malformed cookie: empty path attribute is not allowed");
        }
    }

    @Override
    public void visitCookieDate(@NotNull CookieDate cookieDate) {
        if (cookieDate == null) {
            CookieLanguageAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        super.visitCookieDate(cookieDate);
        String value = cookieDate.getText();
        if (value != null && StringUtil.isEmptyOrSpaces((String)value)) {
            TextRange range = new TextRange(cookieDate.getTextRange().getStartOffset(), cookieDate.getTextRange().getEndOffset());
            this.myHolder.createErrorAnnotation(range, "Malformed cookie: empty date attribute is not allowed. Expected date format: \"Tue, 01-Jan-2019 00:00:00\" or \"-1\" for session cookie").setAfterEndOfLine(true);
        } else if (value != null && !value.equals("-1")) {
            try {
                Date date = new HttpRequestCookiesStorage.CookieDateFormat().parse(value);
                if (date.compareTo(new Date()) < 0) {
                    CookieRecord parentElement = (CookieRecord)cookieDate.getParent();
                    TextRange range = new TextRange(parentElement.getTextRange().getStartOffset(), parentElement.getTextRange().getEndOffset());
                    this.myHolder.createWarningAnnotation(range, "Expired cookie. Adjust the expiration date, otherwise this cookie will be deleted after the next request");
                }
            }
            catch (ParseException e) {
                TextRange range = new TextRange(cookieDate.getTextRange().getStartOffset(), cookieDate.getTextRange().getEndOffset());
                this.myHolder.createErrorAnnotation(range, "Malformed cookie: wrong date format. Expected date format: \"Tue, 01-Jan-2019 00:00:00\" or \"-1\" for session cookie");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "malformedCookie";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieRecordRest";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieDomain";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookiePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cookieDate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/http/request/cookies/annotator/CookieLanguageAnnotatorVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitMalformedCookie";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitRecordRest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCookieDomain";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCookiePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCookieDate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

