/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action;

import com.intellij.docker.action.DockerActionUtils;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.view.DockerTreeStructure;
import com.intellij.ide.DeleteProvider;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeStructure;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class DockerDeleteProvider
implements DeleteProvider,
TitledHandler {
    public String getActionTitle() {
        return DockerBundle.getText("DockerDeleteProvider.title", new Object[0]);
    }

    @NotNull
    @Nls
    private static String getUserConfirmationText(int images, int containers) {
        if (images < 0 || containers < 0 || images + containers == 0) {
            throw new IllegalArgumentException("Request for deletion: Images: " + images + ", containers: " + containers);
        }
        String imagesPiece = null;
        if (images > 0) {
            imagesPiece = images == 1 ? DockerBundle.getText("DockerDeleteProvider.confirmation.image.one", new Object[0]) : DockerBundle.getText("DockerDeleteProvider.confirmation.image.many", images);
        }
        String containersPiece = null;
        if (containers > 0) {
            String string = containersPiece = containers == 1 ? DockerBundle.getText("DockerDeleteProvider.confirmation.container.one", new Object[0]) : DockerBundle.getText("DockerDeleteProvider.confirmation.container.many", containers);
        }
        String string = containersPiece != null && imagesPiece != null ? DockerBundle.getText("DockerDeleteProvider.confirmation.text.both.types", containersPiece, imagesPiece) : DockerBundle.getText("DockerDeleteProvider.confirmation.text.single.type", containersPiece != null ? containersPiece : imagesPiece);
        if (string == null) {
            DockerDeleteProvider.$$$reportNull$$$0(0);
        }
        return string;
    }

    public static boolean getUserConfirmation(int images, int containers) {
        int yesNo = Messages.showYesNoDialog((Project)null, (String)DockerDeleteProvider.getUserConfirmationText(images, containers), (String)DockerBundle.getText("DockerDeleteProvider.confirmation.title", new Object[0]), (Icon)Messages.getWarningIcon());
        return yesNo == 0;
    }

    @NotNull
    private List<DockerApplicationRuntime> getSelectedRuntimes(@NotNull DataContext dataContext) {
        Object[] items;
        if (dataContext == null) {
            DockerDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((items = (Object[])dataContext.getData(PlatformDataKeys.SELECTED_ITEMS)) == null) {
            List<DockerApplicationRuntime> list = Collections.emptyList();
            if (list == null) {
                DockerDeleteProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<DockerApplicationRuntime> list = Arrays.stream(items).map(o -> (DockerTreeStructure.DockerDeploymentNode)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerTreeStructure.DockerDeploymentNode.class)))).filter(Objects::nonNull).map(ServersTreeStructure.DeploymentNodeImpl::getDeployment).filter(deployment -> deployment.getStatus() != DeploymentStatus.NOT_DEPLOYED).map(Deployment::getRuntime).map(rt -> (DockerApplicationRuntime)((Object)((Object)ObjectUtils.tryCast((Object)rt, DockerApplicationRuntime.class)))).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            DockerDeleteProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DockerDeleteProvider.$$$reportNull$$$0(4);
        }
        List<DockerApplicationRuntime> selectedRuntimes = this.getSelectedRuntimes(dataContext);
        List images = ContainerUtil.filter(selectedRuntimes, DockerActionUtils::isImageRuntime);
        List containers = ContainerUtil.filter(selectedRuntimes, DockerActionUtils::isContainerRuntime);
        return !containers.isEmpty() || !images.isEmpty();
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DockerDeleteProvider.$$$reportNull$$$0(5);
        }
        List<DockerApplicationRuntime> selectedRuntimes = this.getSelectedRuntimes(dataContext);
        List images = ContainerUtil.filter(selectedRuntimes, DockerActionUtils::isImageRuntime);
        List containers = ContainerUtil.filter(selectedRuntimes, DockerActionUtils::isContainerRuntime);
        if (containers.isEmpty() && images.isEmpty()) {
            return;
        }
        if (DockerDeleteProvider.getUserConfirmation(images.size(), containers.size())) {
            for (DockerApplicationRuntime nextContainer : containers) {
                nextContainer.deleteContainer();
            }
            for (DockerApplicationRuntime nextImage : images) {
                nextImage.deleteImage();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/action/DockerDeleteProvider";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserConfirmationText";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/action/DockerDeleteProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRuntimes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedRuntimes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

