/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.vfs;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.remote.run.runtime.RemoteDockerRuntimeUtil;
import com.intellij.docker.remote.run.runtime.TarCompressionUtil;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.HiddenFileSystem;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.VfsImplUtil;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ThrowableConsumer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerFileSystem
extends NewVirtualFileSystem
implements HiddenFileSystem,
NonPhysicalFileSystem {
    private static final String PROTOCOL = "docker";
    private static final Pattern LS_ENTRY_PATTERN = Pattern.compile("^([-dl])(?:.{9})(?: +)(?:\\d+)(?: +)(\\d+) (\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{9}[+\\-]\\d{2}:\\d{2}) (.+)$");
    private static final String SYMLINK_DELIMITER = "\" -> \"";
    private static final Logger LOG = Logger.getInstance(DockerFileSystem.class);
    private static final Map<String, Map<String, Ref<Entry>>> ourEntries = new ConcurrentHashMap<String, Map<String, Ref<Entry>>>();
    private final DockerApplicationRuntime myRuntime;

    public DockerFileSystem(@NotNull DockerApplicationRuntime runtime) {
        if (runtime == null) {
            DockerFileSystem.$$$reportNull$$$0(0);
        }
        this.myRuntime = runtime;
    }

    @Nullable
    public VirtualFile findFileByPathIfCached(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(1);
        }
        return VfsImplUtil.findFileByPathIfCached((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    protected String extractRootPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(2);
        }
        String string = DockerFileSystem.splitPath(path, index -> path.substring(0, index + 1));
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String splitPath(@NotNull String path, @NotNull Function<Integer, String> splitter) {
        int index;
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(4);
        }
        if (splitter == null) {
            DockerFileSystem.$$$reportNull$$$0(5);
        }
        if ((index = path.indexOf(47)) < 0) {
            throw new IllegalArgumentException("Path passed to DockerFileSystem is invalid: " + path);
        }
        String string = splitter.apply(index);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(6);
        }
        return string;
    }

    public int getRank() {
        return 1;
    }

    @NotNull
    public VirtualFile copyFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent, @NotNull String copyName) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(7);
        }
        if (newParent == null) {
            DockerFileSystem.$$$reportNull$$$0(8);
        }
        if (copyName == null) {
            DockerFileSystem.$$$reportNull$$$0(9);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    @NotNull
    private static IOException createModificationNotSupportedError(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(10);
        }
        IOException iOException = new IOException(DockerBundle.getText("DockerFileSystem.error.modification.not.supported", file2.getUrl()));
        if (iOException == null) {
            DockerFileSystem.$$$reportNull$$$0(11);
        }
        return iOException;
    }

    @NotNull
    public byte[] contentsToByteArray(@NotNull VirtualFile file2) throws IOException {
        byte[] byArray;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(12);
        }
        if (this.myRuntime.getStatus() != DeploymentStatus.DEPLOYED || file2.isDirectory() || file2.is(VFileProperty.SYMLINK)) {
            throw DockerFileSystem.createGettingContentsError(file2);
        }
        try {
            Ref contents = Ref.create();
            RemoteDockerRuntimeUtil.download(this.myRuntime.getAgentApplication(), this.myRuntime.getAgentTaskExecutor(), this.getPathInsideContainer(file2), null, (ThrowableConsumer<? super File, ? extends IOException>)((ThrowableConsumer)tarFile -> {
                try (TarArchiveInputStream tarInputStream = new TarArchiveInputStream(TarCompressionUtil.uncompressStream(new BufferedInputStream(new FileInputStream((File)tarFile))));){
                    TarArchiveEntry tarEntry = tarInputStream.getNextTarEntry();
                    if (tarEntry != null && tarEntry.getName().equals(file2.getName()) && tarEntry.isFile()) {
                        contents.set((Object)FileUtil.loadBytes((InputStream)tarInputStream));
                    }
                }
            }));
            if (contents.isNull()) {
                throw DockerFileSystem.createGettingContentsError(file2);
            }
            byArray = (byte[])contents.get();
        }
        catch (ServerRuntimeException e) {
            throw DockerFileSystem.createGettingContentsError(file2, e);
        }
        if (byArray == null) {
            DockerFileSystem.$$$reportNull$$$0(13);
        }
        return byArray;
    }

    @NotNull
    private static IOException createGettingContentsError(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(14);
        }
        IOException iOException = DockerFileSystem.createGettingContentsError(file2, null);
        if (iOException == null) {
            DockerFileSystem.$$$reportNull$$$0(15);
        }
        return iOException;
    }

    @NotNull
    private static IOException createGettingContentsError(@NotNull VirtualFile file2, @Nullable Throwable cause) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(16);
        }
        IOException iOException = new IOException(DockerBundle.getText("DockerFileSystem.error.can.not.get.contents", file2.getUrl()), cause);
        if (iOException == null) {
            DockerFileSystem.$$$reportNull$$$0(17);
        }
        return iOException;
    }

    @NotNull
    public InputStream getInputStream(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(18);
        }
        throw new IOException("Not implemented yet");
    }

    @NotNull
    public OutputStream getOutputStream(@NotNull VirtualFile file2, Object requestor, long modStamp, long l) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(19);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public long getLength(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(20);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.length : 0L;
    }

    public boolean exists(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(21);
        }
        return this.getAttributes(file2) != null;
    }

    @NotNull
    public String[] list(@NotNull VirtualFile file2) {
        String path;
        String joinedEntries;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(22);
        }
        if ((joinedEntries = this.execLs('A', path = this.getPathInsideContainer(file2))) == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                DockerFileSystem.$$$reportNull$$$0(23);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String pathWithSlash = "/".equals(path) ? path : path + "/";
        Map<String, Ref<Entry>> entries = this.getRootEntries(file2);
        ArrayList<Object> names = new ArrayList<Object>();
        for (String entry : StringUtil.splitByLinesDontTrim((String)joinedEntries)) {
            Pair<String, Entry> parsedEntry = DockerFileSystem.parseLsEntry(entry);
            if (parsedEntry == null) continue;
            names.add(parsedEntry.first);
            entries.put(pathWithSlash + (String)parsedEntry.first, (Ref<Entry>)Ref.create((Object)parsedEntry.second));
        }
        String[] stringArray = ArrayUtilRt.toStringArray(names);
        if (stringArray == null) {
            DockerFileSystem.$$$reportNull$$$0(24);
        }
        return stringArray;
    }

    @Nullable
    private String execLs(char flag, @NotNull String pathInsideContainer) {
        if (pathInsideContainer == null) {
            DockerFileSystem.$$$reportNull$$$0(25);
        }
        if (this.myRuntime.getStatus() != DeploymentStatus.DEPLOYED) {
            return null;
        }
        try {
            CompletableFuture<byte[]> outputFuture = this.myRuntime.captureExecOutput(new String[]{"ls", "-" + flag + "lgoQ", "--time-style=+%Y-%m-%dT%H:%M:%S.%N%:z", "--tabsize=0", "--width=1", pathInsideContainer}, false);
            if (outputFuture == null) {
                return null;
            }
            byte[] output = outputFuture.get();
            if (output == null) {
                return null;
            }
            return new String(output, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Pair<String, Entry> parseLsEntry(@NotNull String entry) {
        long timestamp;
        long size;
        int delimiter;
        String nameAndTarget;
        Matcher matcher;
        if (entry == null) {
            DockerFileSystem.$$$reportNull$$$0(26);
        }
        if (!(matcher = LS_ENTRY_PATTERN.matcher(entry)).find()) {
            return null;
        }
        String flags = matcher.group(1);
        char kind = flags.charAt(0);
        boolean directory = kind == 'd';
        boolean symlink = kind == 'l';
        String name = nameAndTarget = matcher.group(4);
        String target = null;
        if (symlink && (delimiter = nameAndTarget.indexOf(SYMLINK_DELIMITER)) > 0) {
            name = nameAndTarget.substring(0, delimiter + 1);
            target = nameAndTarget.substring(delimiter + SYMLINK_DELIMITER.length() - 1);
            target = DockerFileSystem.unquote(target);
        }
        name = DockerFileSystem.unquote(name);
        try {
            size = Long.parseLong(matcher.group(2));
        }
        catch (NumberFormatException e) {
            return null;
        }
        try {
            timestamp = OffsetDateTime.parse(matcher.group(3)).toInstant().toEpochMilli();
        }
        catch (DateTimeParseException e) {
            return null;
        }
        return Pair.create((Object)name, (Object)new Entry(new FileAttributes(directory, false, symlink, false, size, timestamp, false), target));
    }

    @NotNull
    private static String unquote(@NotNull String quoted) {
        if (quoted == null) {
            DockerFileSystem.$$$reportNull$$$0(27);
        }
        String string = StringUtil.unescapeStringCharacters((String)StringUtil.unquoteString((String)quoted, (char)'\"'));
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(28);
        }
        return string;
    }

    @NotNull
    private Map<String, Ref<Entry>> getRootEntries(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(29);
        }
        Map map = ourEntries.computeIfAbsent(this.extractRootPath(file2), rootPath -> new ConcurrentHashMap());
        if (map == null) {
            DockerFileSystem.$$$reportNull$$$0(30);
        }
        return map;
    }

    @NotNull
    private String extractRootPath(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(31);
        }
        String string = this.extractRootPath(file2.getPath());
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(32);
        }
        return string;
    }

    public boolean isDirectory(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(33);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isDirectory();
    }

    public long getTimeStamp(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(34);
        }
        return (attributes = this.getAttributes(file2)) != null ? attributes.lastModified : 0L;
    }

    public void setTimeStamp(@NotNull VirtualFile file2, long timeStamp) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(35);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public boolean isWritable(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(36);
        }
        return false;
    }

    public void setWritable(@NotNull VirtualFile file2, boolean writableFlag) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(37);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile parent, @NotNull String dir) throws IOException {
        if (parent == null) {
            DockerFileSystem.$$$reportNull$$$0(38);
        }
        if (dir == null) {
            DockerFileSystem.$$$reportNull$$$0(39);
        }
        throw DockerFileSystem.createModificationNotSupportedError(parent);
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile parent, @NotNull String file2) throws IOException {
        if (parent == null) {
            DockerFileSystem.$$$reportNull$$$0(40);
        }
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(41);
        }
        throw DockerFileSystem.createModificationNotSupportedError(parent);
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            DockerFileSystem.$$$reportNull$$$0(42);
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(43);
        }
        return VfsImplUtil.findFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(44);
        }
        String string = path;
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(45);
        }
        return string;
    }

    public void refresh(boolean asynchronous) {
        this.refresh(asynchronous, null);
    }

    public void refresh(boolean asynchronous, @Nullable Runnable finishRunnable) {
        ourEntries.remove(this.getRootPath());
        VirtualFile[] roots = ManagingFS.getInstance().getRoots((NewVirtualFileSystem)this);
        if (roots.length > 0) {
            RefreshQueue.getInstance().refresh(asynchronous, true, finishRunnable, roots);
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])roots);
        }
    }

    @NotNull
    private String getRootPath() {
        String string = FileUtil.sanitizeFileName((String)Objects.requireNonNull(this.myRuntime.getServer()).getName(), (boolean)false) + ":" + this.myRuntime.getContainerId() + ":/";
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(46);
        }
        return string;
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(47);
        }
        return VfsImplUtil.refreshAndFindFileByPath((NewVirtualFileSystem)this, (String)path);
    }

    public void deleteFile(Object requestor, @NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(48);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public void moveFile(Object requestor, @NotNull VirtualFile file2, @NotNull VirtualFile newParent) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(49);
        }
        if (newParent == null) {
            DockerFileSystem.$$$reportNull$$$0(50);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    public void renameFile(Object requestor, @NotNull VirtualFile file2, @NotNull String newName) throws IOException {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(51);
        }
        if (newName == null) {
            DockerFileSystem.$$$reportNull$$$0(52);
        }
        throw DockerFileSystem.createModificationNotSupportedError(file2);
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull VirtualFile file2) {
        Entry entry;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(53);
        }
        return (entry = this.getEntry(file2)) != null ? entry.attributes : null;
    }

    @Nullable
    private Entry getEntry(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(54);
        }
        return (Entry)this.getRootEntries(file2).computeIfAbsent(this.getPathInsideContainer(file2), path -> {
            Pair<String, Entry> parsedEntry;
            String entry = this.execLs('d', (String)path);
            if (entry != null && (parsedEntry = DockerFileSystem.parseLsEntry(entry)) != null) {
                return Ref.create((Object)parsedEntry.second);
            }
            return Ref.create();
        }).get();
    }

    public boolean isSymLink(@NotNull VirtualFile file2) {
        FileAttributes attributes;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(55);
        }
        return (attributes = this.getAttributes(file2)) != null && attributes.isSymLink();
    }

    public String resolveSymLink(@NotNull VirtualFile file2) {
        Entry entry;
        String target;
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(56);
        }
        String string = target = (entry = this.getEntry(file2)) != null ? entry.target : null;
        if (target == null || target.contains(":")) {
            return null;
        }
        if (target.startsWith("/")) {
            return this.extractRootPath(file2) + target.substring(1);
        }
        List pathComponents = StringUtil.split((String)this.getPathInsideContainer(file2), (String)"/");
        ArrayList<String> resolvedComponents = pathComponents.size() < 2 ? new ArrayList<String>() : new ArrayList(pathComponents.subList(0, pathComponents.size() - 1));
        for (String targetComponent : StringUtil.split((String)target, (String)"/")) {
            if ("..".equals(targetComponent)) {
                if (resolvedComponents.isEmpty()) {
                    return null;
                }
                resolvedComponents.remove(resolvedComponents.size() - 1);
                continue;
            }
            if (".".equals(targetComponent)) continue;
            resolvedComponents.add(targetComponent);
        }
        return this.extractRootPath(file2) + StringUtil.join(resolvedComponents, (String)"/");
    }

    @Nullable
    public VirtualFile getRoot() {
        VirtualFile root = this.findFileByPath(this.getRootPath());
        if (root != null) {
            VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        }
        return root;
    }

    @NotNull
    public String getPathInsideContainer(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DockerFileSystem.$$$reportNull$$$0(57);
        }
        String string = DockerFileSystem.getPathInsideContainer(file2.getPath());
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(58);
        }
        return string;
    }

    @NotNull
    private static String getPathInsideContainer(@NotNull String path) {
        if (path == null) {
            DockerFileSystem.$$$reportNull$$$0(59);
        }
        String string = DockerFileSystem.splitPath(path, path::substring);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public String getSanitizedContainerName() {
        String containerName = this.myRuntime.getContainerName();
        if (containerName == null) {
            if ("" == null) {
                DockerFileSystem.$$$reportNull$$$0(61);
            }
            return "";
        }
        String string = FileUtil.sanitizeFileName((String)StringUtil.trimStart((String)containerName, (String)"/"), (boolean)false);
        if (string == null) {
            DockerFileSystem.$$$reportNull$$$0(62);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 42: 
            case 45: 
            case 46: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 42: 
            case 45: 
            case 46: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtime";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 43: 
            case 44: 
            case 47: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 42: 
            case 45: 
            case 46: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/vfs/DockerFileSystem";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 48: 
            case 49: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathInsideContainer";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/vfs/DockerFileSystem";
                break;
            }
            case 3: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "extractRootPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createModificationNotSupportedError";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "contentsToByteArray";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createGettingContentsError";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "unquote";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootEntries";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootPath";
                break;
            }
            case 58: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathInsideContainer";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "getSanitizedContainerName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPathIfCached";
                break;
            }
            case 2: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "extractRootPath";
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 42: 
            case 45: 
            case 46: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createModificationNotSupportedError";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "contentsToByteArray";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createGettingContentsError";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInputStream";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getOutputStream";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLength";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "execLs";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "parseLsEntry";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "unquote";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getRootEntries";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isDirectory";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getTimeStamp";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setTimeStamp";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isWritable";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setWritable";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getAttributes";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getEntry";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isSymLink";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "resolveSymLink";
                break;
            }
            case 57: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getPathInsideContainer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 23: 
            case 24: 
            case 28: 
            case 30: 
            case 32: 
            case 42: 
            case 45: 
            case 46: 
            case 58: 
            case 60: 
            case 61: 
            case 62: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Entry {
        @NotNull
        public final FileAttributes attributes;
        @Nullable
        public final String target;

        Entry(@NotNull FileAttributes attributes, @Nullable String target) {
            if (attributes == null) {
                Entry.$$$reportNull$$$0(0);
            }
            this.attributes = attributes;
            this.target = target;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributes", "com/intellij/docker/vfs/DockerFileSystem$Entry", "<init>"));
        }
    }
}

