/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.agent.settings.DockerAgentContainerConfig;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.settings.DockerPortBindingsEditor;
import com.intellij.docker.view.DockerRuntimeEditorBase;
import com.intellij.docker.view.DockerTableRuntimeEditor;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBox;
import org.jetbrains.annotations.NotNull;

public class DockerPortBindingRuntimeEditor<T>
extends DockerTableRuntimeEditor<DockerPortBindingImpl> {
    private final JCheckBox myPublishAllPortsCheckBox;

    public DockerPortBindingRuntimeEditor(DockerAgentContainerConfig config, DockerRuntimeEditorBase.ConfigApplier onSave) {
        super("Port Bindings", new DockerPortBindingsEditor(), onSave);
        Object[] portBindings = config.getPortBindings();
        this.getEditor().setItems(ContainerUtil.map((Object[])(portBindings != null ? portBindings : new DockerPortBinding[]{}), binding -> new DockerPortBindingImpl(binding)));
        this.myPublishAllPortsCheckBox = new JCheckBox("Publish all ports");
        this.getEditorPlaceholder().add((Component)this.myPublishAllPortsCheckBox, "North");
        this.myPublishAllPortsCheckBox.setSelected(config.isPublishAllPorts());
        this.myPublishAllPortsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DockerPortBindingRuntimeEditor.this.updateVisibility();
            }
        });
        this.updateVisibility();
    }

    @Override
    protected DockerAgentContainerConfig createConfig(final List<DockerPortBindingImpl> items) {
        return new DockerAgentContainerConfig.Adapter(){

            public DockerPortBinding[] getPortBindings() {
                return items.toArray(new DockerPortBinding[0]);
            }

            public Boolean getPublishAllPorts() {
                return DockerPortBindingRuntimeEditor.this.myPublishAllPortsCheckBox.isSelected();
            }
        };
    }

    @Override
    @NotNull
    protected String getContextHelpId() {
        if ("reference.docker.runtime.port-bindings" == null) {
            DockerPortBindingRuntimeEditor.$$$reportNull$$$0(0);
        }
        return "reference.docker.runtime.port-bindings";
    }

    private void updateVisibility() {
        this.getEditor().setEnabled(!this.myPublishAllPortsCheckBox.isSelected());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/docker/view/DockerPortBindingRuntimeEditor", "getContextHelpId"));
    }
}

