/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.PuppetLanguage;
import com.intellij.lang.puppet.psi.PsiPuppetVarWrapper;
import com.intellij.lang.puppet.psi.PsiPuppetVisitor;
import com.intellij.lang.puppet.util.PuppetConfigurationUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class Puppet4DeprecationsInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            Puppet4DeprecationsInspection.$$$reportNull$$$0(0);
        }
        PsiPuppetVisitor psiPuppetVisitor = new PsiPuppetVisitor(){

            @Override
            public void visitVarWrapper(@NotNull PsiPuppetVarWrapper var) {
                if (var == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (PuppetConfigurationUtil.getPuppetVersion(var) != PuppetLanguage.Version.PUPPET_4) {
                    return;
                }
                String variableName = var.getName();
                if (StringUtil.isEmpty((String)variableName)) {
                    return;
                }
                if (StringUtil.isCapitalized((String)variableName)) {
                    holder.registerProblem((PsiElement)var, PuppetBundle.message("inspections.deprecated.in.puppet4.capitalized.variables", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                } else if (variableName.startsWith("_") && var.isFullQualified()) {
                    holder.registerProblem((PsiElement)var, PuppetBundle.message("inspections.deprecated.in.puppet4.underscore.in.variables", new Object[0]), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "var", "com/intellij/lang/puppet/ide/inspections/Puppet4DeprecationsInspection$1", "visitVarWrapper"));
            }
        };
        if (psiPuppetVisitor == null) {
            Puppet4DeprecationsInspection.$$$reportNull$$$0(1);
        }
        return psiPuppetVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/inspections/Puppet4DeprecationsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/inspections/Puppet4DeprecationsInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

