/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.project;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.lang.puppet.project.PuppetEnvironment;
import com.intellij.lang.puppet.project.PuppetModule;
import com.intellij.lang.puppet.project.PuppetProjectFilesListener;
import com.intellij.lang.puppet.project.PuppetProjectListener;
import com.intellij.lang.puppet.project.PuppetProjectModel;
import com.intellij.lang.puppet.project.meta.PuppetHeadlessModuleMetadata;
import com.intellij.lang.puppet.project.meta.PuppetModuleMetadata;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryIndex;
import com.intellij.lang.puppet.project.roots.PuppetDirectoryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;

public class PuppetProjectManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(PuppetProjectManager.class);
    public static final Topic<PuppetProjectListener> PUPPET_PROJECT_TOPIC = new Topic("Puppet project change", PuppetProjectListener.class);
    public static final String MODULE_META_FILE = "metadata.json";
    public static final String ENVIRONMENT_META_FILE = "environment.conf";
    public static final String PUPPET_FILE = "Puppetfile";
    private final PuppetProjectModel myModel;
    private CancellablePromise<Void> myCurrentScanning;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myUpdateQueue;
    @NotNull
    private final MergingUpdateQueue myProjectRescanQueue;
    @NotNull
    private final MessageBus myMessageBus;

    public PuppetProjectManager(@NotNull Project project) {
        if (project == null) {
            PuppetProjectManager.$$$reportNull$$$0(0);
        }
        this.myModel = new PuppetProjectModel();
        this.myCurrentScanning = null;
        this.myProject = project;
        this.myUpdateQueue = new MergingUpdateQueue("Puppet project update notification queue", 100, true, null, (Disposable)project, null, Alarm.ThreadToUse.SWING_THREAD);
        this.myProjectRescanQueue = new MergingUpdateQueue("Rescanning project structure", 100, true, null, (Disposable)project, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.myMessageBus = project.getMessageBus();
        this.myMessageBus.connect((Disposable)project).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void enteredDumbMode() {
            }

            public void exitDumbMode() {
                LOG.debug("Left dumb mode");
                PuppetProjectManager.this.queueRescanProjectStructure();
            }
        });
        this.myModel.setChangeListener(this::onProjectUpdated);
    }

    public void projectOpened() {
        LOG.debug("Project opened");
        this.myMessageBus.connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new PuppetProjectFilesListener(this.myProject));
    }

    public void queueRescanProjectStructure() {
        LOG.debug("Queuing project rescan");
        this.myProjectRescanQueue.queue(Update.create((Object)this, this::scanForEntities));
    }

    private synchronized void scanForEntities() {
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode()) {
            this.doScanForEntities();
            return;
        }
        LOG.assertTrue(!application.isDispatchThread());
        if (this.myCurrentScanning != null && !this.myCurrentScanning.isDone()) {
            this.myCurrentScanning.cancel(true);
        }
        this.myCurrentScanning = ReadAction.nonBlocking(() -> this.doScanForEntities()).expireWith((Disposable)this.myProject).inSmartMode(this.myProject).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private void doScanForEntities() {
        LOG.debug("Re-scanning project " + this.myProject);
        THashSet rootSet = new THashSet();
        Processor processor = arg_0 -> PuppetProjectManager.lambda$doScanForEntities$1((Set)rootSet, arg_0);
        GlobalSearchScope scope = ProjectScope.getContentScope((Project)this.myProject);
        FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)MODULE_META_FILE, (boolean)true, (GlobalSearchScope)scope).forEach(arg_0 -> ((Processor)processor).process(arg_0));
        FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)ENVIRONMENT_META_FILE, (boolean)true, (GlobalSearchScope)scope).forEach(arg_0 -> ((Processor)processor).process(arg_0));
        FilenameIndex.getVirtualFilesByName((Project)this.myProject, (String)PUPPET_FILE, (boolean)true, (GlobalSearchScope)scope).forEach(arg_0 -> ((Processor)processor).process(arg_0));
        this.getModel().clear();
        rootSet.forEach(virtualFile -> {
            ProgressManager.checkCanceled();
            this.refreshModelForRoot((VirtualFile)virtualFile);
        });
    }

    private void scanForImplicitModules(@NotNull PuppetEntity<?> explicitEntity) {
        if (explicitEntity == null) {
            PuppetProjectManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            LOG.debug("Scanning for implicit modules for " + explicitEntity);
            if (!explicitEntity.isValid()) {
                LOG.debug("Skipping invalid entity: " + explicitEntity);
                return;
            }
            explicitEntity.getAllDependenciesRoots().stream().flatMap(file -> Arrays.stream(file.getChildren())).filter(file -> file.isValid() && file.isDirectory() && this.getModel().getPuppetModuleOrEnvironment((VirtualFile)file) == null).forEach(implicitRoot -> this.addImplicitModule((VirtualFile)implicitRoot, explicitEntity.getRoot()));
            LOG.debug("Done scanning for implicit modules for " + explicitEntity);
        });
    }

    void refreshRoot(@NotNull VirtualFile root) {
        if (root == null) {
            PuppetProjectManager.$$$reportNull$$$0(2);
        }
        Runnable action = () -> ReadAction.run(() -> this.refreshModelForRoot(root));
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread() && !application.isUnitTestMode()) {
            application.executeOnPooledThread(action);
        } else {
            action.run();
        }
    }

    private void refreshModelForRoot(@Nullable VirtualFile root) {
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(application.isUnitTestMode() || !application.isDispatchThread());
        application.assertReadAccessAllowed();
        if (root == null || this.myProject.isDisposed() || !root.isValid()) {
            return;
        }
        LOG.debug("Updating metadata for: " + root);
        VirtualFile keyFile = root.findChild(MODULE_META_FILE);
        PuppetEntity newEntity = null;
        if (keyFile != null) {
            LOG.debug("Found a " + keyFile + ", reading metadata");
            PuppetModuleMetadata moduleMetadata = PuppetModuleMetadata.readMetadata(keyFile);
            if (moduleMetadata != null) {
                LOG.debug("Got metadata, creating a module");
                newEntity = new PuppetModule(this.myProject, root, moduleMetadata);
            } else {
                LOG.debug("No metadata found");
            }
        } else if (root.findChild(ENVIRONMENT_META_FILE) != null || root.findChild(PUPPET_FILE) != null) {
            LOG.debug("Found an environment.conf or a Puppetfile, creating an environment");
            newEntity = new PuppetEnvironment(this.myProject, root);
        }
        if (newEntity != null) {
            LOG.debug("Adding new entity: " + newEntity);
            this.getModel().removeRoot(root);
            this.getModel().addEntity(newEntity);
            this.scanForImplicitModules(newEntity);
        } else {
            PuppetEntity existingEntity = this.getModel().getPuppetModuleOrEnvironment(root);
            if (existingEntity != null) {
                LOG.debug("Currently root assigned to entity: " + existingEntity);
            }
            if (existingEntity instanceof PuppetEnvironment || existingEntity instanceof PuppetModule && !((PuppetModule)existingEntity).isHeadless()) {
                this.getModel().removeRoot(root);
            }
        }
    }

    public final PuppetProjectModel getModel() {
        return this.myModel;
    }

    private void onProjectUpdated() {
        this.myUpdateQueue.queue(Update.create((Object)this, () -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            LOG.debug("Broadcasting project updated");
            ((PuppetProjectListener)this.myMessageBus.syncPublisher(PUPPET_PROJECT_TOPIC)).projectUpdated();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                ProjectView.getInstance((Project)this.myProject).refresh();
            }
        }));
    }

    private void addImplicitModule(@NotNull VirtualFile implicitRoot, @NotNull VirtualFile parentRoot) {
        if (implicitRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(3);
        }
        if (parentRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(4);
        }
        this.getModel().addImplicitEntity(new PuppetModule(this.myProject, implicitRoot, new PuppetHeadlessModuleMetadata(implicitRoot.getName())), parentRoot);
    }

    void clearMetaData(@NotNull VirtualFile entityRoot) {
        if (entityRoot == null) {
            PuppetProjectManager.$$$reportNull$$$0(5);
        }
        LOG.debug("Clearing metadata for " + entityRoot);
        this.getModel().removeRoot(entityRoot);
    }

    @Nullable
    public PuppetEntity findExplicitModuleOrEnvironmentForFile(@Nullable VirtualFile file) {
        while (file != null) {
            PuppetEntity entity = this.findModuleOrEnvironmentForFile(file);
            if (entity instanceof PuppetModule && ((PuppetModule)entity).isHeadless()) {
                file = entity.getRoot().getParent();
                continue;
            }
            return entity;
        }
        return null;
    }

    @Nullable
    public PuppetEntity findModuleOrEnvironmentForFile(@NotNull VirtualFile file) {
        PuppetDirectoryInfo puppetDirectoryInfo;
        if (file == null) {
            PuppetProjectManager.$$$reportNull$$$0(6);
        }
        if (!(puppetDirectoryInfo = PuppetDirectoryIndex.getInstance(this.myProject).getInfoForFile(file)).isAvailable()) {
            return null;
        }
        return this.getModel().getPuppetModuleOrEnvironment(puppetDirectoryInfo.getPuppetRoot());
    }

    @NotNull
    public List<PuppetModule> getModulesInRoot(@Nullable VirtualFile root) {
        if (root == null || !root.isValid()) {
            List<PuppetModule> list = Collections.emptyList();
            if (list == null) {
                PuppetProjectManager.$$$reportNull$$$0(7);
            }
            return list;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<PuppetModule> result = new ArrayList<PuppetModule>();
        for (PuppetModule module : this.getModel().getAllModules()) {
            VirtualFile moduleRoot = module.getRoot();
            if (!moduleRoot.isValid() || !root.equals(moduleRoot.getParent())) continue;
            result.add(module);
        }
        ArrayList<PuppetModule> arrayList = result;
        if (arrayList == null) {
            PuppetProjectManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public Collection<PuppetModule> findModules(@NotNull String name) {
        if (name == null) {
            PuppetProjectManager.$$$reportNull$$$0(9);
        }
        return ContainerUtil.filter(this.getModel().getAllModules(), module -> name.equals(module.getName()) || name.equals(module.getShortName()));
    }

    public static PuppetProjectManager getInstance(@NotNull Project project) {
        if (project == null) {
            PuppetProjectManager.$$$reportNull$$$0(10);
        }
        return (PuppetProjectManager)project.getComponent(PuppetProjectManager.class);
    }

    private static /* synthetic */ boolean lambda$doScanForEntities$1(Set rootSet, VirtualFile file) {
        ProgressManager.checkCanceled();
        VirtualFile root = file.getParent();
        if (root != null) {
            rootSet.add(root);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "explicitEntity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implicitRoot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentRoot";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityRoot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/project/PuppetProjectManager";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/project/PuppetProjectManager";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesInRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "scanForImplicitModules";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "refreshRoot";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addImplicitModule";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearMetaData";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModuleOrEnvironmentForFile";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findModules";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

