/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.sftp.HostKeyCheckingLevel;
import com.jetbrains.plugins.webDeployment.config.sftp.SftpAdvancedOptions;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class SftpAdvancedOptionsPanel {
    private JPanel myMainPanel;
    private JComboBox<HostKeyCheckingLevel> myStrictHostCheckComboBox;
    private JCheckBox myHashHosts;

    public SftpAdvancedOptionsPanel() {
        this.$$$setupUI$$$();
        EnumComboBoxModel model = new EnumComboBoxModel(HostKeyCheckingLevel.class);
        this.myStrictHostCheckComboBox.setModel((ComboBoxModel<HostKeyCheckingLevel>)model);
        this.myStrictHostCheckComboBox.setRenderer((ListCellRenderer<HostKeyCheckingLevel>)SimpleListCellRenderer.create((String)"", value -> value.getPresentableName()));
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void resetFrom(GroupedServersConfigManager configManager) {
        SftpAdvancedOptions options = configManager.getSftpAdvancedOptions();
        this.myStrictHostCheckComboBox.setSelectedItem((Object)options.getHostKeyCheckingLevel());
        this.myHashHosts.setSelected(options.getHashHost());
    }

    public void applyTo(GroupedServersConfigManager configManager) {
        SftpAdvancedOptions options = new SftpAdvancedOptions();
        options.setHostKeyCheckingLevel((HostKeyCheckingLevel)((Object)this.myStrictHostCheckComboBox.getSelectedItem()));
        options.setHashHost(this.myHashHosts.isSelected());
        configManager.setSftpAdvancedOptions(options);
    }

    public boolean isModified(GroupedServersConfigManager configManager) {
        SftpAdvancedOptions options = configManager.getSftpAdvancedOptions();
        if (options.getHostKeyCheckingLevel() != this.myStrictHostCheckComboBox.getSelectedItem()) {
            return true;
        }
        return options.getHashHost() != this.myHashHosts.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JComboBox jComboBox = new JComboBox();
        this.myStrictHostCheckComboBox = jComboBox;
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 0, 2, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Add new host key to known_hosts:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myHashHosts = jCheckBox = new JCheckBox();
        jCheckBox.setText("Hash hosts in known_hosts file");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jBLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

