/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PopularPackageListGenerator {
    private static final String[] EXPLICITLY_REQUIRED_PACKAGES = new String[]{"svelte", "@angular/core", "@angular/material", "react", "@material-ui/core", "react-bootstrap", "ionic", "cordova", "vue", "vuetify", "bootstrap-vue", "quasar", "ember-cli", "react-native", "electron", "express", "gatsby", "next", "graphql", "graphql-relay", "apollo-client", "jest", "enzyme", "mocha", "karma", "protractor", "cucumber", "ava", "eslint", "tslint", "flow-bin", "prettier"};
    private static final String MOST_DEPENDED_UPON_PACKAGES_DIR = "most-depended-upon-packages";
    private static final int PACKAGES_PER_PAGE = 36;
    private static final int N = 1000;

    public static void main(String[] args) throws IOException {
        File downloadRoot = PopularPackageListGenerator.download();
        List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parseAll(downloadRoot);
        infos = PopularPackageListGenerator.ensureRequiredPackages(infos);
        PopularPackageListGenerator.writePackages(infos, new File("popular-node-packages.json"));
    }

    @NotNull
    private static List<NodePackageBasicInfo> ensureRequiredPackages(@NotNull List<NodePackageBasicInfo> infos) {
        if (infos == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(0);
        }
        ArrayList required = ContainerUtil.newArrayList((Object[])EXPLICITLY_REQUIRED_PACKAGES);
        for (NodePackageBasicInfo info : infos) {
            required.remove(info.getName());
        }
        if (required.isEmpty()) {
            List<NodePackageBasicInfo> list2 = infos;
            if (list2 == null) {
                PopularPackageListGenerator.$$$reportNull$$$0(1);
            }
            return list2;
        }
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>(infos);
        result2.addAll(ContainerUtil.map((Collection)required, name -> PopularPackageListGenerator.createInfo(name)));
        ArrayList<NodePackageBasicInfo> arrayList = result2;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static NodePackageBasicInfo createInfo(String name) {
        Ref description = new Ref();
        String url = "https://registry.npmjs.org/" + name;
        RequestBuilder requestBuilder = HttpRequests.request((String)url);
        requestBuilder.connectTimeout(10000);
        requestBuilder.readTimeout(10000);
        try {
            requestBuilder.connect(request -> {
                JsonReader reader = new JsonReader((Reader)request.getReader());
                reader.beginObject();
                while (reader.hasNext()) {
                    String key = reader.nextName();
                    if ("description".equals(key)) {
                        description.set((Object)reader.nextString());
                        return true;
                    }
                    reader.skipValue();
                }
                return false;
            });
        }
        catch (Exception e) {
            PopularPackageListGenerator.log("failed to fetch description for " + name, new Object[0]);
        }
        NodePackageBasicInfo nodePackageBasicInfo = new NodePackageBasicInfo(name, (String)description.get());
        if (nodePackageBasicInfo == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(3);
        }
        return nodePackageBasicInfo;
    }

    private static File download() throws IOException {
        File baseDir = FileUtil.createTempDirectory((String)"popular-node-packages-data", null, (boolean)false);
        if (!baseDir.isDirectory()) {
            throw new RuntimeException("Not a directory: " + baseDir.getAbsolutePath());
        }
        PopularPackageListGenerator.download("https://www.npmjs.com/browse/depended?offset=%d", new File(baseDir, MOST_DEPENDED_UPON_PACKAGES_DIR));
        return baseDir;
    }

    private static void download(@NotNull String urlPrefix, @NotNull File dir) throws IOException {
        if (urlPrefix == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(4);
        }
        if (dir == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(5);
        }
        PopularPackageListGenerator.log("\n=== Downloading to " + dir.getAbsolutePath() + " ===", new Object[0]);
        for (int i = 0; i < 28; ++i) {
            int finalInd = i;
            String url = String.format(urlPrefix, i * 36);
            long startNano = System.nanoTime();
            RequestBuilder requestBuilder = HttpRequests.request((String)url);
            requestBuilder.connectTimeout(10000);
            requestBuilder.readTimeout(10000);
            requestBuilder.tuner(new HttpRequests.ConnectionTuner(){

                public void tune(@NotNull URLConnection connection) {
                    if (connection == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    connection.setRequestProperty("Cookie", "cs=bQbyYIcbZkuSrlVZiUrUlLNe-lG04rnvX9dhX6e85K1; wub=Fe26.2**964c1d921838b724a64176c340b148896fc5cd12d3d7ecd4e11e72c3f8f6c692*beHYresG-Zk0oNSk0ByByg*iJM_tVq-R1jm94g6XtoUKJCti5jnUL-iG_lraXKEC9YyyN4ut8eQpyv6T6Sc6OG43dSKYKN99JwKE6k6DQc_FQun51Bem-ODz7Bq9zVAqpety7o37LM6NakMoFDzKzSPFLMqCKT_nyDCSex123SpNg**e8b19602750927f04439efc9a6a30204c9d90daed927ac331ff55306e58cb067*9VKRk6FuSPnYLD5ftaeRvT-WpfeziXWkogK5E-o5woQ; __cfduid=d13caedcfae62051639bb00feabe6901f1558541006; _ga=GA1.2.698343225.1474642679; optimizelyBuckets=%7B%7D; optimizelySegments=%7B%223318760495%22%3A%22false%22%2C%223320910574%22%3A%22search%22%2C%223324110209%22%3A%22safari%22%2C%223359291244%22%3A%22none%22%7D; constructorio_t=djF8fGYyNjY4YjUwLWI4NTYtNDliNy04MWY5LWExMjc4YmFmZWE1OQ==; ConstructorioID_client_id=f2668b50-b856-49b7-81f9-a1278bafea59; optimizelyEndUserId=oeu1474642679183r0.4256386800390176");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator$1", "tune"));
                }
            });
            boolean ok = false;
            int attempts = 0;
            while (!ok && attempts < 10) {
                int finalAttempts = attempts++;
                ok = (Boolean)requestBuilder.connect(request -> {
                    String content = request.readString(null);
                    HttpURLConnection connection = (HttpURLConnection)ObjectUtils.tryCast((Object)request.getConnection(), HttpURLConnection.class);
                    int responseCode = Objects.requireNonNull(connection).getResponseCode();
                    File file2 = new File(dir, finalInd + ".html");
                    PopularPackageListGenerator.log("Downloaded in %d ms, content: %s, %s, response: %d, attempts: %d, file: %s, ", TimeoutUtil.getDurationMillis((long)startNano), content.length(), url, responseCode, finalAttempts, file2.getName());
                    FileUtil.writeToFile((File)file2, (String)content);
                    TimeoutUtil.sleep((long)1000L);
                    List<NodePackageBasicInfo> infos = PopularPackageListGenerator.parsedInfos(content);
                    return infos.size() > 0;
                });
            }
        }
    }

    private static void log(String format, Object ... args) {
        System.out.printf(format + "\n", args);
    }

    @NotNull
    public static List<NodePackageBasicInfo> parseAll(@NotNull File downloadRoot) throws IOException {
        if (downloadRoot == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(6);
        }
        List<NodePackageBasicInfo> mostDependedUponInfos = PopularPackageListGenerator.parse(new File(downloadRoot, MOST_DEPENDED_UPON_PACKAGES_DIR));
        PopularPackageListGenerator.log("", new Object[0]);
        PopularPackageListGenerator.log("Most depended upon: " + mostDependedUponInfos.size(), new Object[0]);
        List<NodePackageBasicInfo> list2 = mostDependedUponInfos.stream().limit(1000L).collect(Collectors.toList());
        if (list2 == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parse(@NotNull File dir) throws IOException {
        if (dir == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(8);
        }
        if (!dir.isDirectory()) {
            throw new RuntimeException();
        }
        File[] files = (File[])ObjectUtils.notNull((Object)dir.listFiles(), (Object)ArrayUtilRt.EMPTY_FILE_ARRAY);
        Arrays.sort(files, (o1, o2) -> {
            String name1 = o1.getName();
            String name2 = o2.getName();
            int id1 = Integer.parseInt(FileUtilRt.getNameWithoutExtension((String)name1));
            int id2 = Integer.parseInt(FileUtilRt.getNameWithoutExtension((String)name2));
            return id1 - id2;
        });
        ArrayList<NodePackageBasicInfo> infos = new ArrayList<NodePackageBasicInfo>();
        HashSet<String> names = new HashSet<String>();
        for (File file2 : files) {
            PopularPackageListGenerator.log("Parsing " + file2.getAbsolutePath(), new Object[0]);
            String content = FileUtil.loadFile((File)file2);
            List<NodePackageBasicInfo> parsed = PopularPackageListGenerator.parsedInfos(content);
            for (NodePackageBasicInfo info : parsed) {
                if (!names.add(info.getName())) {
                    throw new RuntimeException("Duplicated name " + info.getName());
                }
                infos.add(info);
            }
        }
        ArrayList<NodePackageBasicInfo> arrayList = infos;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    @NotNull
    private static List<NodePackageBasicInfo> parsedInfos(@NotNull String content) {
        Matcher matcher;
        if (content == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(10);
        }
        if (!(matcher = Pattern.compile("<script integrity=\"[^\"]*\">").matcher(content)).find()) {
            throw new RuntimeException("Cannot find script content");
        }
        int start = matcher.end();
        int end = content.indexOf("</script>", start);
        if (start == -1 || end == -1) {
            throw new RuntimeException("Cannot find script content");
        }
        String inner = content.substring(start, end);
        int startObj = inner.indexOf(123);
        if (startObj == -1) {
            throw new RuntimeException("Cannot find script content");
        }
        JsonElement element = new JsonParser().parse(inner.substring(startObj));
        JsonArray packages = element.getAsJsonObject().getAsJsonObject("context").getAsJsonArray("packages");
        if (packages == null) {
            throw new RuntimeException("No packages parsed");
        }
        ArrayList<NodePackageBasicInfo> infos = new ArrayList<NodePackageBasicInfo>();
        for (JsonElement pkg : packages) {
            JsonObject obj = pkg.getAsJsonObject();
            String name = JsonUtil.getChildAsString((JsonObject)obj, (String)"name");
            String description = JsonUtil.getChildAsString((JsonObject)obj, (String)"description");
            NodePackageBasicInfo info = new NodePackageBasicInfo(Objects.requireNonNull(name), PopularPackageListGenerator.normalizeDescription(description));
            infos.add(info);
        }
        if (infos.size() != 36) {
            throw new RuntimeException("Unexpected parsed packages count. Actual: " + infos.size() + ", expected: " + 36);
        }
        ArrayList<NodePackageBasicInfo> arrayList = infos;
        if (arrayList == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    private static String normalizeDescription(@Nullable String description) {
        if (description == null) {
            return null;
        }
        if (!(description = StringUtil.unescapeXmlEntities((String)description)).contains(". ")) {
            description = StringUtil.trimEnd((String)description, (String)".");
        }
        if (description.startsWith("[![")) {
            return null;
        }
        return description;
    }

    private static void writePackages(@NotNull List<NodePackageBasicInfo> names, @NotNull File outputFile) throws IOException {
        if (names == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(12);
        }
        if (outputFile == null) {
            PopularPackageListGenerator.$$$reportNull$$$0(13);
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginArray();
            for (NodePackageBasicInfo info : names) {
                writer.beginArray();
                writer.setIndent("");
                writer.value(info.getName());
                if (info.getDescription() != null) {
                    writer.value(info.getDescription());
                }
                writer.endArray();
                writer.setIndent(" ");
            }
            writer.endArray();
        }
        PopularPackageListGenerator.log(names.size() + " packages are written to " + outputFile.getAbsolutePath(), new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlPrefix";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadRoot";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularPackageListGenerator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureRequiredPackages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createInfo";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAll";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parsedInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ensureRequiredPackages";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAll";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parsedInfos";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writePackages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

