/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lexer.FlexLexer;
import com.intellij.psi.tree.IElementType;
import java.io.IOException;

public class JSLexerUtil {
    public static boolean canBeFlowGenericArgumentList(FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.IDENTIFIER) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next == JSTokenTypes.GT || next == JSTokenTypes.COMMA || next == JSTokenTypes.EXTENDS_KEYWORD;
    }

    public static boolean shouldLexRegex(FlexLexer lexer, boolean hasTags, CharSequence buffer) {
        int start = lexer.getTokenStart();
        if (start >= buffer.length()) {
            return true;
        }
        --start;
        while (start >= 0) {
            char c = buffer.charAt(start);
            if (Character.isWhitespace(c)) {
                --start;
                continue;
            }
            if (c != '!') {
                if (hasTags && c == '<') {
                    return start + 1 >= buffer.length() || buffer.charAt(start + 1) != '/';
                }
                return true;
            }
            if (start - 1 < 0) {
                return true;
            }
            char ch = buffer.charAt(start - 1);
            if (!Character.isLetter(ch)) {
                return true;
            }
            if (ch != 'n') {
                return false;
            }
            int possible = start - 1 - "return".length();
            if (possible < 0) {
                return false;
            }
            return "return".contentEquals(buffer.subSequence(possible + 1, start));
        }
        return true;
    }

    public static boolean shouldLexTag(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.PLUS || next == JSTokenTypes.MINUS) {
            return false;
        }
        if (!JSKeywordSets.IDENTIFIER_NAMES.contains(next)) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next == JSTokenTypes.EXTENDS_KEYWORD) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            return next == JSTokenTypes.EQ;
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.EQ || next == JSTokenTypes.COMMA) {
            return false;
        }
        if (next == JSTokenTypes.GT) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            if (next != JSTokenTypes.LPAR) {
                return true;
            }
            return !JSLexerUtil.isParameterListAfterGenericParams(isFlow, lexer);
        }
        return true;
    }

    private static boolean isParameterListAfterGenericParams(boolean isFlow, FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        int balance = 1;
        if (next == JSTokenTypes.LBRACE || next == JSTokenTypes.LBRACKET) {
            if (!isFlow) {
                return false;
            }
            if (next == JSTokenTypes.LBRACKET) {
                return true;
            }
            return JSLexerUtil.isFlowGenericObjectDestructuringLambda(lexer);
        }
        if (next == JSTokenTypes.IDENTIFIER && (next = JSLexerUtil.skipCommentsAndWhitespaces(lexer)) == JSTokenTypes.QUEST) {
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        }
        if (next == JSTokenTypes.COLON || next == JSTokenTypes.COMMA) {
            return true;
        }
        if (isFlow && next == JSTokenTypes.LPAR) {
            return true;
        }
        if (next != JSTokenTypes.RPAR && !isFlow) {
            return false;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (!isFlow) {
            if (next != JSTokenTypes.LT) {
                return true;
            }
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
            return next != JSTokenTypes.DIV;
        }
        if (next != JSTokenTypes.LT) {
            while (balance > 0 && next != null) {
                if (next == JSTokenTypes.LPAR) {
                    ++balance;
                }
                if (next == JSTokenTypes.RPAR) {
                    --balance;
                }
                boolean isLt = next == JSTokenTypes.LT;
                next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
                if (!isLt || next != JSTokenTypes.REGEXP_LITERAL) continue;
                return false;
            }
        }
        if (next != JSTokenTypes.LT) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return JSLexerUtil.checkFlowToken(lexer, next);
    }

    private static boolean isFlowGenericObjectDestructuringLambda(FlexLexer lexer) throws IOException {
        IElementType next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        int balance = 1;
        while (next != null) {
            if (next == JSTokenTypes.LBRACE) {
                ++balance;
            }
            if (next == JSTokenTypes.RBRACE && --balance == 0) break;
            next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        }
        if (balance != 0) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        if (next != JSTokenTypes.RPAR) {
            return true;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return JSTokenTypes.ARROWS.contains(next);
    }

    private static boolean checkFlowToken(FlexLexer lexer, IElementType next) throws IOException {
        if (next != JSTokenTypes.IDENTIFIER) {
            return next != JSTokenTypes.REGEXP_LITERAL;
        }
        next = JSLexerUtil.skipCommentsAndWhitespaces(lexer);
        return next != JSTokenTypes.COMMA && next != JSTokenTypes.EXTENDS_KEYWORD && next != JSTokenTypes.GT;
    }

    private static IElementType skipCommentsAndWhitespaces(FlexLexer lexer) throws IOException {
        IElementType next = lexer.advance();
        while (JSTokenTypes.COMMENTS_AND_WHITESPACES.contains(next)) {
            next = lexer.advance();
        }
        return next;
    }
}

