/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.lang.ExpressionTypeProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSServerManager;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContextTypeEvaluator;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeTextStringBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.xml.util.XmlStringUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSShowTypeInfoAction
extends ExpressionTypeProvider<PsiElement> {
    public static final String UNKNOWN_TYPE_TEXT = "<unknown type>";

    @NotNull
    public String getInformationHint(@NotNull PsiElement element) {
        String typeFromService;
        if (element == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(0);
        }
        PsiFile file2 = element.getContainingFile();
        FlowJSServerService service = FlowJSServerManager.getService(file2);
        if ((element instanceof JSReferenceExpression || element instanceof JSVariable) && service != null && FlowJSSettingsManager.areOtherServicesEnabled(file2) && (typeFromService = service.getTypeOfElementUnderProgress((JSElement)element)) != null) {
            String string = typeFromService;
            if (string == null) {
                JSShowTypeInfoAction.$$$reportNull$$$0(1);
            }
            return string;
        }
        JSType type = JSShowTypeInfoAction.expandTypesForPresentation(JSShowTypeInfoAction.getTypeForDocumentation(element));
        String presentableType = JSShowTypeInfoAction.getNonEmptyPresentableType(type, (JSElement)element);
        String string = XmlStringUtil.escapeString((String)presentableType) + JSShowTypeInfoAction.getEscapedMembersPresentation(type);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public static JSType getTypeForDocumentation(@NotNull PsiElement element) {
        JSType candidate;
        JSCallExpression callExpression;
        List functionTypes;
        if (element == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(3);
        }
        JSType type = null;
        if (element instanceof JSExpression) {
            type = JSResolveUtil.getExpressionJSType((JSExpression)element);
        } else if (element instanceof JSParameter) {
            type = ((JSParameter)element).getJSType();
            if (type == null && ((JSParameter)element).getTypeElement() == null) {
                type = JSContextTypeEvaluator.getParameterType((JSParameterListElement)((JSParameter)element), new JSEvaluateContext(element.getContainingFile()), JSExpectedTypeKind.CONTEXTUAL);
            }
        } else if (element instanceof JSTypeDeclarationOwner && (type = ((JSTypeDeclarationOwner)element).getJSType()) == null) {
            type = JSResolveUtil.getElementJSType(element);
        }
        if (type != null && element instanceof JSExpression && element.getParent() instanceof JSCallExpression && (functionTypes = JSTypeUtils.getFunctionType(type, (callExpression = (JSCallExpression)element.getParent()) instanceof JSNewExpression, (PsiElement)callExpression).collect(Collectors.toList())).size() == 1 && (candidate = (JSType)functionTypes.get(0)) instanceof JSFunctionTypeImpl) {
            return TypeScriptGenericTypesEvaluator.applyTypeScriptGenericArguments((JSFunctionTypeImpl)candidate, callExpression);
        }
        return type;
    }

    @NotNull
    public String getErrorHint() {
        String string = JSBundle.message((String)"js.show.type.info.action.error", (Object[])new Object[0]);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<PsiElement> getExpressionsAt(@NotNull PsiElement elementAt) {
        if (elementAt == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(5);
        }
        List list2 = SyntaxTraverser.psiApi().parents((Object)elementAt).filter(o -> o instanceof JSExpression && (!(o instanceof JSFunctionExpression) || !((JSFunctionExpression)o).isArrowFunction()) && !(o instanceof JSDefinitionExpression) || o instanceof JSVariable).toList();
        if (list2 == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static String getNonEmptyPresentableType(@Nullable JSType type, @NotNull JSElement element) {
        if (element == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(7);
        }
        if (type == null) {
            if (!DialectDetector.isTypeScript((PsiElement)element)) {
                if (UNKNOWN_TYPE_TEXT == null) {
                    JSShowTypeInfoAction.$$$reportNull$$$0(8);
                }
                return UNKNOWN_TYPE_TEXT;
            }
            type = JSAnyType.get((PsiElement)element, false);
        }
        String string = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static String getEscapedMembersPresentation(@Nullable JSType type) {
        if (!(type instanceof JSUnionOrIntersectionType)) {
            if ("" == null) {
                JSShowTypeInfoAction.$$$reportNull$$$0(10);
            }
            return "";
        }
        JSRecordType recordType = type.asRecordType();
        List members = recordType.getTypeMembers();
        if (members.isEmpty()) {
            if ("" == null) {
                JSShowTypeInfoAction.$$$reportNull$$$0(11);
            }
            return "";
        }
        JSRecordTypeImpl wrappedRecordType = new JSRecordTypeImpl(recordType.getSource(), members){

            @Override
            public void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
                if (format == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (builder == null) {
                    1.$$$reportNull$$$0(1);
                }
                String separator = this.getTypeSeparator();
                char quote = this.getQuote();
                for (JSRecordType.TypeMember member : this.getTypeMembers()) {
                    builder.append("<br>&nbsp;&nbsp;");
                    JSTypeTextStringBuilder subBuilder = new JSTypeTextStringBuilder();
                    member.appendMemberPresentation(format, (JSTypeTextBuilder)subBuilder, separator, quote);
                    builder.append(XmlStringUtil.escapeString((String)subBuilder.getResult()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "format";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "builder";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction$1";
                objectArray[2] = "buildTypeTextImpl";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        String string = wrappedRecordType.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            JSShowTypeInfoAction.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static JSType expandTypesForPresentation(@Nullable JSType type) {
        return TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/actions/JSShowTypeInfoAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInformationHint";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorHint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionsAt";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyPresentableType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapedMembersPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInformationHint";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTypeForDocumentation";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionsAt";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyPresentableType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

