/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSFileElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.folding.JSCodeFoldingSettings;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.TypeScriptModuleElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class JavaScriptFoldingBuilderBase
extends CustomFoldingBuilder {
    private static final int IMPORT_OFFSET = "import ".length();
    private static final String SOURCE_MAPS_PREFIX = "//# sourceMappingURL=data:application/json;base64,";
    private static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT});
    private static final TokenSet IMPORTS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.IMPORT_DECLARATION, JSStubElementTypes.IMPORT_STATEMENT});
    private static final Pattern DOC_COMMENT_CONTENT = Pattern.compile("^\\s*/?\\**(\\s*)(.*?)\\s*\\**/?$");
    private static final Pattern DOC_TYPE_COMMENT = Pattern.compile("\\s*@type\\s+(?:((?:[.#~])?(?:(?:module:|event:|external:)(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+')|[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+)(?:[.#~](?:module:|event:|external:)?(?:[^.~#\\s:(){}\\[\\]<>?!='\",|&*@`\\p{C}]+|\"(?:[^\"\\\\]|\\\\.)+\"|'(?:[^'\\\\]|\\\\.)+'))*(?:[.#~])?)|\\{(.+)}) ");
    private static final int MAX_COMMENT_TEXT_LEFT = 50;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document2, boolean quick) {
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(0);
        }
        if (root == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(1);
        }
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(2);
        }
        this.appendDescriptors(root.getNode(), document2, descriptors);
    }

    protected ASTNode appendDescriptors(ASTNode node, Document document2, List<? super FoldingDescriptor> descriptors) {
        String placeHolder;
        ProgressManager.checkCanceled();
        IElementType type = node.getElementType();
        if (JavaScriptFoldingBuilderBase.isFunctionBlockBody(node) && !this.foldSmallBlock(node, document2, descriptors)) {
            boolean collapsedByDefault = this.getCodeFoldingSettings().isCollapseMethods();
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), this.getBlockPlaceholderText(), collapsedByDefault);
        } else if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(type) && !this.foldSmallBlock(node, document2, descriptors)) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), this.getBlockPlaceholderText(), false);
        } else if (type == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION && !this.foldSmallBlock(node, document2, descriptors)) {
            JSObjectLiteralExpression objectLiteralExpression = (JSObjectLiteralExpression)node.getPsi(JSObjectLiteralExpression.class);
            placeHolder = objectLiteralExpression == null ? this.getBlockPlaceholderText() : this.getObjectPlaceholderText(objectLiteralExpression);
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), placeHolder, this.getCodeFoldingSettings().isCollapseObjectLiterals());
        } else if (type == JSElementTypes.ARRAY_LITERAL_EXPRESSION && !this.foldSmallBlock(node, document2, descriptors)) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), "[...]", this.getCodeFoldingSettings().isCollapseArrayLiterals());
        } else if (JSElementTypes.XML_LITERALS.contains(type) && !this.foldSmallBlock(node, document2, descriptors)) {
            ASTNode child = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
            placeHolder = "<" + (child != null ? child.getText() : "xml") + "/>";
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), placeHolder, this.getCodeFoldingSettings().isCollapseXmlLiterals());
        } else if (type == TypeScriptElementTypes.OBJECT_TYPE && !this.foldSmallBlock(node, document2, descriptors)) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), "{...}", false);
        } else if (type == JSElementTypes.SWITCH_STATEMENT) {
            TextRange textRange;
            ASTNode lBrace = node.findChildByType(JSTokenTypes.LBRACE);
            ASTNode rBrace = node.findChildByType(JSTokenTypes.RBRACE);
            if (lBrace != null && rBrace != null && (textRange = new TextRange(lBrace.getStartOffset(), rBrace.getStartOffset() + 1)).getEndOffset() < document2.getTextLength() && document2.getLineNumber(textRange.getStartOffset()) != document2.getLineNumber(textRange.getEndOffset())) {
                this.addDescriptorForRange(node, descriptors, textRange, this.getBlockPlaceholderText(), false);
            }
        } else if (type == JSElementTypes.CASE_CLAUSE) {
            ASTNode bodyStart;
            ASTNode caseKeyword = node.findChildByType(JSTokenTypes.CASE_KEYWORD);
            ASTNode keyword = caseKeyword != null ? caseKeyword : node.findChildByType(JSTokenTypes.DEFAULT_KEYWORD);
            ASTNode labelEnd = node.findChildByType(JSTokenTypes.COLON, keyword);
            if (labelEnd != null && (bodyStart = labelEnd.getTreeNext()) != null) {
                this.addDescriptorForRange(node, descriptors, new TextRange(bodyStart.getStartOffset(), node.getTextRange().getEndOffset()), "...", false);
            }
        } else if (type == JSTokenTypes.DOC_COMMENT) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), JavaScriptFoldingBuilderBase.docCommentPlaceholder(node), this.getCodeFoldingSettings().isCollapseDocComments());
        } else if (type == JSTokenTypes.C_STYLE_COMMENT) {
            this.addDescriptorForRange(node, descriptors, node.getTextRange(), JavaScriptFoldingBuilderBase.cStyleCommentPlaceholder(node), this.isCollapseFileHeaderComment(node));
        } else {
            ASTNode lbrace;
            if (type == JSTokenTypes.END_OF_LINE_COMMENT) {
                return this.collapseConsequentNodesOfSpecifiedType(node, descriptors, COMMENTS, JavaScriptFoldingBuilderBase.endOfLineCommentPlaceholder(node), this.isCollapseFileHeaderComment(node) || JavaScriptFoldingBuilderBase.isSourceMapsComment(node));
            }
            if (this.isImportNode(type)) {
                return this.collapseImport(document2, node, descriptors);
            }
            if ((type instanceof JSClassElementTypeBase || type == JSStubElementTypes.PACKAGE_STATEMENT || type == JSStubElementTypes.TYPESCRIPT_ENUM || type instanceof TypeScriptModuleElementType) && (lbrace = node.findChildByType(JSTokenTypes.LBRACE)) != null) {
                this.addDescriptorForRange(node, descriptors, new TextRange(lbrace.getStartOffset(), node.getTextRange().getEndOffset()), this.getBlockPlaceholderText(), false);
            }
        }
        if (type instanceof JSFileElementType) {
            node.getPsi().getFirstChild();
        }
        ASTNode child = node.getFirstChildNode();
        while (child != null) {
            IElementType iElementType = child.getElementType();
            if (iElementType == JSElementTypes.BINARY_EXPRESSION || iElementType == JSElementTypes.COMMA_EXPRESSION) {
                JSBinaryExpression expression = (JSBinaryExpression)child.getPsi();
                JSExpression lOperand = expression.getLOperand();
                while (JSSymbolUtil.binaryOpTypeToAvoidRecursions(expression.getOperationSign()) && lOperand instanceof JSBinaryExpression) {
                    ASTNode rOperandNode;
                    JSExpression rOperand = expression.getROperand();
                    ASTNode aSTNode = rOperandNode = rOperand != null ? rOperand.getNode() : null;
                    if (rOperandNode != null) {
                        this.appendDescriptors(rOperandNode, document2, descriptors);
                    }
                    expression = (JSBinaryExpression)lOperand;
                    lOperand = expression.getLOperand();
                }
                this.appendDescriptors(expression.getNode(), document2, descriptors);
                child = child.getTreeNext();
                continue;
            }
            child = this.appendDescriptors(child, document2, descriptors).getTreeNext();
        }
        return node;
    }

    private boolean foldSmallBlock(ASTNode node, Document document2, List<? super FoldingDescriptor> descriptors) {
        TextRange textRange = node.getTextRange();
        return textRange.getEndOffset() > document2.getTextLength() || document2.getLineNumber(textRange.getStartOffset()) == document2.getLineNumber(textRange.getEndOffset()) || this.tryFoldOneLineFunction(node, document2, descriptors) || JavaScriptFoldingBuilderBase.isModulePatternChild(node) || JavaScriptFoldingBuilderBase.blockStatementIsEntireSwitchClause(document2, node);
    }

    private boolean tryFoldOneLineFunction(@NotNull ASTNode node, @NotNull Document document2, @NotNull List<? super FoldingDescriptor> descriptors) {
        String functionLeftText;
        int leftStart;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(3);
        }
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(4);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(5);
        }
        if (!JSCodeFoldingSettings.getInstance().isCollapseOneLineFunctions()) {
            return false;
        }
        if (!JavaScriptFoldingBuilderBase.isFunctionBlockBody(node)) {
            return false;
        }
        ASTNode nodeTreeParent = node.getTreeParent();
        JSFunction function = (JSFunction)ObjectUtils.tryCast((Object)nodeTreeParent.getPsi(), JSFunction.class);
        if (function == null) {
            return false;
        }
        JSBlockStatement body = function.getBlock();
        if (body == null) {
            return false;
        }
        JSSourceElement[] statements = body.getStatementListItems();
        if (statements.length > 1) {
            return false;
        }
        ASTNode left = body.getNode().findChildByType(JSTokenTypes.LBRACE);
        ASTNode right = body.getNode().findChildByType(JSTokenTypes.RBRACE);
        if (left == null || right == null) {
            return false;
        }
        boolean showAsAnonymous = function instanceof JSFunctionExpression && !function.isArrowFunction();
        TextRange functionRange = function.getTextRange();
        if (showAsAnonymous) {
            leftStart = functionRange.getStartOffset();
            functionLeftText = JavaScriptFoldingBuilderBase.getFunctionLeftText(function);
        } else {
            PsiElement nonSpaceBeforeLeft = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)body);
            leftStart = nonSpaceBeforeLeft != null ? nonSpaceBeforeLeft.getTextRange().getEndOffset() : left.getTextRange().getStartOffset();
            functionLeftText = " { ";
        }
        int rightEnd = functionRange.getEndOffset();
        if (statements.length == 0) {
            if (!JavaScriptFoldingBuilderBase.linesAreClose(document2, left.getTextRange().getEndOffset(), right.getTextRange().getStartOffset(), 2)) {
                return false;
            }
            FoldingGroup group = FoldingGroup.newGroup((String)"empty-one-liner");
            String text = StringUtil.trimTrailing((String)functionLeftText) + "}";
            descriptors.add((FoldingDescriptor)new FoldingDescriptor(nodeTreeParent, new TextRange(leftStart, rightEnd), group, text, Boolean.valueOf(this.getCodeFoldingSettings().isCollapseOneLineFunctions()), Collections.emptySet()));
            return true;
        }
        JSSourceElement statement = statements[0];
        if (statement == null) {
            return false;
        }
        TextRange stRange = statement.getTextRange();
        if (!JavaScriptFoldingBuilderBase.linesAreClose(document2, stRange.getStartOffset(), stRange.getEndOffset(), 0)) {
            return false;
        }
        if (!JavaScriptFoldingBuilderBase.linesAreClose(document2, left.getTextRange().getEndOffset(), stRange.getStartOffset(), 1) || !JavaScriptFoldingBuilderBase.linesAreClose(document2, stRange.getEndOffset(), right.getTextRange().getEndOffset(), 1)) {
            return false;
        }
        int leftEnd = stRange.getStartOffset();
        int rightStart = stRange.getEndOffset();
        if (leftEnd <= leftStart + 1 || rightEnd <= rightStart + 1) {
            return false;
        }
        FoldingGroup group = FoldingGroup.newGroup((String)"one-liner");
        descriptors.add((FoldingDescriptor)new FoldingDescriptor(left, new TextRange(leftStart, leftEnd), group, functionLeftText, Boolean.valueOf(true), Collections.emptySet()));
        descriptors.add((FoldingDescriptor)new FoldingDescriptor(right, new TextRange(rightStart, rightEnd), group, " }", Boolean.valueOf(true), Collections.emptySet()));
        return true;
    }

    private static String getFunctionLeftText(@NotNull JSFunction function) {
        String parameters;
        String name;
        if (function == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(6);
        }
        int length = function.getParameters().length;
        String string = name = function instanceof JSFunctionExpression ? null : function.getName();
        if (length > 0) {
            boolean wrap = length != 1 || !StringUtil.isEmptyOrSpaces((String)name);
            parameters = Arrays.stream(function.getParameters()).map(p -> p.getName()).collect(Collectors.joining(", ", wrap ? "(" : "", wrap ? ")" : ""));
        } else {
            parameters = "()";
        }
        JSAttributeList attributes = function.getAttributeList();
        String attributesText = attributes == null ? null : StringUtil.notNullize((String)attributes.getText()) + " ";
        return Stream.of(attributesText, function.isGetProperty() ? "get " : (function.isSetProperty() ? "set " : ""), function.isGenerator() ? "*" : "", name, parameters, name == null ? " => {" : " {").filter(m -> !StringUtil.isEmptyOrSpaces((String)m)).collect(Collectors.joining("", "", " "));
    }

    private static boolean linesAreClose(@NotNull Document document2, int off1, int off2, int maxDiff) {
        int ln2;
        int ln1;
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(7);
        }
        return Math.abs((ln1 = document2.getLineNumber(off1)) - (ln2 = document2.getLineNumber(off2))) <= maxDiff;
    }

    private static boolean blockStatementIsEntireSwitchClause(Document document2, ASTNode node) {
        ASTNode parent = node.getTreeParent();
        return node.getElementType() == JSElementTypes.BLOCK_STATEMENT && parent.getElementType() == JSElementTypes.CASE_CLAUSE && document2.getLineNumber(node.getStartOffset()) == document2.getLineNumber(parent.getStartOffset());
    }

    private static boolean isModulePatternChild(ASTNode node) {
        PsiElement parent = node.getTreeParent().getPsi();
        if (parent instanceof JSFunctionExpression && (parent = parent.getParent()) instanceof JSParenthesizedExpression) {
            PsiElement currentParent = parent;
            return (parent = parent.getParent()) instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == currentParent && JavaScriptFoldingBuilderBase.isModulePattern(PsiTreeUtil.getParentOfType((PsiElement)parent, JSStatement.class));
        }
        return false;
    }

    private static boolean isModulePattern(PsiElement element) {
        PsiElement sibling;
        if (element == null || !(element.getParent() instanceof JSFile)) {
            return false;
        }
        for (sibling = element.getNextSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getNextSibling()) {
        }
        if (sibling != null) {
            return false;
        }
        for (sibling = element.getPrevSibling(); sibling != null && !(sibling instanceof JSElement); sibling = sibling.getPrevSibling()) {
        }
        return sibling == null;
    }

    private void addDescriptorForRange(@NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull TextRange range, @NotNull String placeHolder, boolean collapsedByDefault) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(8);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(9);
        }
        if (range == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(10);
        }
        if (placeHolder == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(11);
        }
        if (range.getLength() > 1) {
            FoldingDescriptor descriptor2 = new FoldingDescriptor(node, range, null, placeHolder, Boolean.valueOf(collapsedByDefault), Collections.emptySet());
            descriptor2.setCanBeRemovedWhenCollapsed(this.isImportNode(node.getElementType()));
            descriptors.add((FoldingDescriptor)descriptor2);
        }
    }

    private ASTNode collapseImport(@NotNull Document document2, @NotNull ASTNode node, @NotNull List<? super FoldingDescriptor> descriptors) {
        if (document2 == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(12);
        }
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(13);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(14);
        }
        int sizeBeforeCollapse = descriptors.size();
        String placeHolder = "...";
        ASTNode nodeResult = this.collapseConsequentNodesOfSpecifiedType(node, descriptors, this.getImportTokenTypes(), placeHolder, this.getCodeFoldingSettings().isCollapseImports());
        if (descriptors.size() != sizeBeforeCollapse) {
            return nodeResult;
        }
        if (JavaScriptFoldingBuilderBase.isMultiline(document2, node)) {
            TextRange nodeRange = node.getTextRange();
            this.addDescriptorForRange(node, descriptors, new TextRange(nodeRange.getStartOffset() + IMPORT_OFFSET, nodeRange.getEndOffset()), placeHolder, this.getCodeFoldingSettings().isCollapseImports());
        }
        return node;
    }

    protected TokenSet getImportTokenTypes() {
        return IMPORTS;
    }

    private static boolean isMultiline(Document document2, ASTNode node) {
        if (!JavaScriptFoldingBuilderBase.isMultilineNodeType(node)) {
            return false;
        }
        TextRange nodeRange = node.getTextRange();
        int startNumber = document2.getLineNumber(nodeRange.getStartOffset());
        int endNumber = document2.getLineNumber(nodeRange.getEndOffset());
        return endNumber - startNumber > 0;
    }

    private static boolean isMultilineNodeType(ASTNode node) {
        return ES6ElementTypes.IMPORT_DECLARATION == node.getElementType();
    }

    @NotNull
    private ASTNode collapseConsequentNodesOfSpecifiedType(@NotNull ASTNode startNode, @NotNull List<? super FoldingDescriptor> descriptors, @NotNull TokenSet tokens, @NotNull String placeHolder, boolean collapsedBD) {
        String text;
        if (startNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(16);
        }
        if (tokens == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(17);
        }
        if (placeHolder == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(18);
        }
        PsiElement endElement = startNode.getPsi();
        PsiElement current = endElement.getNextSibling();
        boolean stopAtFirstNontrivialLine = startNode.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT;
        boolean containsCustomRegionMarker = JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)endElement);
        while (!(!(current instanceof PsiWhiteSpace) || stopAtFirstNontrivialLine && (text = current.getText()).startsWith("\n") && text.indexOf(10, 1) > 0)) {
            if ((current = current.getNextSibling()) == null || !tokens.contains(current.getNode().getElementType())) continue;
            endElement = current;
            containsCustomRegionMarker |= JavaScriptFoldingBuilderBase.isCustomRegionElement((PsiElement)endElement);
            current = current.getNextSibling();
        }
        boolean sourceMaps = JavaScriptFoldingBuilderBase.isSourceMapsComment(startNode);
        if (startNode.getPsi() != endElement || sourceMaps) {
            int adjustmentOffset = 0;
            if (this.isImportNode(startNode.getElementType())) {
                adjustmentOffset = IMPORT_OFFSET;
            } else if (sourceMaps) {
                adjustmentOffset = SOURCE_MAPS_PREFIX.length();
            }
            TextRange rangeToFold = new TextRange(startNode.getStartOffset() + adjustmentOffset, endElement.getNode().getStartOffset() + endElement.getTextLength());
            if (!containsCustomRegionMarker) {
                this.addDescriptorForRange(startNode, descriptors, rangeToFold, placeHolder, collapsedBD);
            }
            ASTNode aSTNode = endElement.getNode();
            if (aSTNode == null) {
                JavaScriptFoldingBuilderBase.$$$reportNull$$$0(19);
            }
            return aSTNode;
        }
        ASTNode aSTNode = startNode;
        if (aSTNode == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(20);
        }
        return aSTNode;
    }

    private boolean isImportNode(@NotNull IElementType type) {
        if (type == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(21);
        }
        return this.getImportTokenTypes().contains(type);
    }

    private static boolean isSourceMapsComment(@NotNull ASTNode element) {
        if (element == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(22);
        }
        return element.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT && StringUtil.startsWith((CharSequence)element.getChars(), (CharSequence)SOURCE_MAPS_PREFIX);
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(23);
        }
        if (range == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(24);
        }
        return null;
    }

    @NotNull
    private static String endOfLineCommentPlaceholder(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(25);
        }
        if (JavaScriptFoldingBuilderBase.isSourceMapsComment(node)) {
            if ("..." == null) {
                JavaScriptFoldingBuilderBase.$$$reportNull$$$0(26);
            }
            return "...";
        }
        ASTNode treeNext = node.getTreeNext();
        while (JavaScriptFoldingBuilderBase.isNewLine(treeNext)) {
            String text = node.getText();
            if (text.startsWith("//") && (text = text.substring(2).trim()).length() > 1) {
                String string = "// " + (text.length() > 50 ? text.substring(0, 50) : text) + "...";
                if (string == null) {
                    JavaScriptFoldingBuilderBase.$$$reportNull$$$0(27);
                }
                return string;
            }
            node = treeNext.getTreeNext();
            treeNext = node == null ? null : node.getTreeNext();
        }
        if ("//..." == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(28);
        }
        return "//...";
    }

    @NotNull
    private static String cStyleCommentPlaceholder(@NotNull ASTNode node) {
        String text;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(29);
        }
        ASTNode treePrev = node.getTreePrev();
        ASTNode treeNext = node.getTreeNext();
        if ((treePrev == null || JavaScriptFoldingBuilderBase.isNewLine(treePrev)) && (treeNext == null || JavaScriptFoldingBuilderBase.isNewLine(treeNext)) && (text = node.getText()).startsWith("/*") && text.endsWith("*/") && text.length() >= 4) {
            String[] parts;
            text = text.substring(2, text.length() - 2);
            for (String part : parts = text.split("[\r\n]")) {
                if ((part = StringUtil.trimLeading((String)part.trim(), (char)'*')).length() <= 1) continue;
                if (part.length() > 50) {
                    part = part.substring(0, 50);
                }
                String string = "/* " + part + "...*/";
                if (string == null) {
                    JavaScriptFoldingBuilderBase.$$$reportNull$$$0(30);
                }
                return string;
            }
        }
        if ("/*...*/" == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(31);
        }
        return "/*...*/";
    }

    @NotNull
    private static String docCommentPlaceholder(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(32);
        }
        String text = node.getText();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n\r");
        String firstLine = "";
        boolean firstToken = true;
        while (tokenizer.hasMoreTokens()) {
            String content;
            ProgressManager.checkCanceled();
            String candidate = tokenizer.nextToken();
            Matcher matcher = DOC_COMMENT_CONTENT.matcher(candidate);
            if (matcher.matches() && !StringUtil.isEmpty((String)(content = matcher.group(2)))) {
                firstLine = matcher.group(1) + content + " ";
                break;
            }
            firstToken = false;
        }
        if (firstToken) {
            Matcher matcher = DOC_TYPE_COMMENT.matcher(firstLine);
            if (matcher.matches()) {
                String typeString = matcher.group(1);
                if (StringUtil.isEmpty((String)typeString)) {
                    typeString = matcher.group(2);
                }
                if (!StringUtil.isEmpty((String)typeString)) {
                    String string = "/*" + typeString + "*/";
                    if (string == null) {
                        JavaScriptFoldingBuilderBase.$$$reportNull$$$0(33);
                    }
                    return string;
                }
            }
            if ("/**...*/" == null) {
                JavaScriptFoldingBuilderBase.$$$reportNull$$$0(34);
            }
            return "/**...*/";
        }
        String string = "/**" + firstLine + "...*/";
        if (string == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(35);
        }
        return string;
    }

    private static boolean isNewLine(ASTNode treePrev) {
        return treePrev instanceof PsiWhiteSpace && treePrev.getText().contains("\n");
    }

    protected String getBlockPlaceholderText() {
        return "{...}";
    }

    private String getObjectPlaceholderText(@NotNull JSObjectLiteralExpression node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(36);
        }
        JSProperty[] properties = node.getProperties();
        JSProperty candidate = null;
        for (JSProperty property : properties) {
            String name = property.getName();
            boolean isId = "id".equals(name) || "name".equals(name);
            JSExpression value = property.getValue();
            if (!JSSymbolUtil.isAccurateReferenceExpression(value) && (!(value instanceof JSLiteralExpression) || !isId && !((JSLiteralExpression)value).isQuotedLiteral())) continue;
            if (candidate == null || isId) {
                candidate = property;
            }
            if (isId) break;
        }
        if (candidate != null) {
            PsiElement nameElement = candidate.getNameIdentifier();
            JSExpression valueElement = candidate.getValue();
            return this.getFoldedTestByProperty(nameElement != null ? nameElement.getText() : "", valueElement != null ? valueElement.getText() : "");
        }
        return this.getBlockPlaceholderText();
    }

    @NotNull
    protected String getFoldedTestByProperty(String nameText, String valueText) {
        String string = "{" + nameText + ": " + valueText + "...}";
        if (string == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(37);
        }
        return string;
    }

    protected abstract JSCodeFoldingSettings getCodeFoldingSettings();

    private boolean isCollapseFileHeaderComment(@NotNull ASTNode node) {
        ASTNode parentNode;
        IElementType parentType;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(38);
        }
        IElementType iElementType = parentType = (parentNode = node.getTreeParent()) != null ? parentNode.getElementType() : null;
        if (parentType instanceof JSFileElementType && node.getTreePrev() == null && node.getPsi() instanceof PsiComment) {
            return this.getCodeFoldingSettings().isCollapseFileHeaders();
        }
        return false;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(39);
        }
        return false;
    }

    private static boolean isFunctionBlockBody(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(40);
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(node.getElementType())) {
            ASTNode parent = node.getTreeParent();
            return parent != null && JavaScriptFoldingBuilderBase.isFunction(parent.getElementType());
        }
        return false;
    }

    private static boolean isFunction(IElementType type) {
        return JSElementTypes.FUNCTION_DECLARATIONS.contains(type) || JSElementTypes.FUNCTION_EXPRESSIONS.contains(type) || JSStubElementTypes.TYPESCRIPT_FUNCTION.equals((Object)type) || JSStubElementTypes.TYPESCRIPT_FUNCTION_EXPRESSION.equals((Object)type);
    }

    protected final boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(41);
        }
        return node.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT || node.getPsi() instanceof PsiComment && !node.textContains('\n');
    }

    protected final boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        IElementType nodeType;
        if (node == null) {
            JavaScriptFoldingBuilderBase.$$$reportNull$$$0(42);
        }
        return (nodeType = node.getElementType()) == JSFileElementTypes.FILE || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeType) || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(nodeType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 8: 
            case 13: 
            case 23: 
            case 25: 
            case 29: 
            case 32: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 10: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokens";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/folding/JavaScriptFoldingBuilderBase";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "endOfLineCommentPlaceholder";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "cStyleCommentPlaceholder";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "docCommentPlaceholder";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getFoldedTestByProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "tryFoldOneLineFunction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLeftText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "linesAreClose";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addDescriptorForRange";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "collapseImport";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collapseConsequentNodesOfSpecifiedType";
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isImportNode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isSourceMapsComment";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagePlaceholderText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "endOfLineCommentPlaceholder";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "cStyleCommentPlaceholder";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "docCommentPlaceholder";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getObjectPlaceholderText";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isCollapseFileHeaderComment";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isFunctionBlockBody";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingCandidate";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isCustomFoldingRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 19: 
            case 20: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

