/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.webpack;

import com.intellij.lang.javascript.frameworks.webpack.WebpackInJavaScriptJsonSchemaProvider;
import com.intellij.lang.javascript.frameworks.webpack.WebpackUtil;
import com.intellij.lang.javascript.json.JSJsonLikePsiWalker;
import com.intellij.lang.javascript.json.JSJsonSchemaProviderBase;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.annotations.NotNull;

public class Webpack4PluginSchemaProvider
extends JSJsonSchemaProviderBase {
    private final String myPluginName;
    private final boolean myIsThirdParty;
    private final String myPluginPath;

    String getPluginName() {
        return this.myPluginName;
    }

    public Webpack4PluginSchemaProvider(@NotNull String pluginName, boolean isThirdParty) {
        if (pluginName == null) {
            Webpack4PluginSchemaProvider.$$$reportNull$$$0(0);
        }
        this.myPluginName = pluginName;
        this.myIsThirdParty = isThirdParty;
        this.myPluginPath = Webpack4PluginSchemaProvider.pluginNameToPath(this.myPluginName, this.myIsThirdParty);
    }

    private boolean isInSuitableInvocation(@NotNull PsiElement element) {
        PsiElement current;
        if (element == null) {
            Webpack4PluginSchemaProvider.$$$reportNull$$$0(1);
        }
        for (current = element; !(current == null || JSJsonLikePsiWalker.isTerminalInStatement(current) || current instanceof PsiFile || current instanceof JSEmbeddedContent); current = current.getParent()) {
            if (current instanceof JSProperty || current instanceof JSLiteralExpression || current instanceof JSObjectLiteralExpression || current instanceof JSArrayLiteralExpression || current instanceof JSReferenceExpression || current instanceof LeafPsiElement) {
                continue;
            }
            return false;
        }
        if (!(current instanceof JSArgumentList)) {
            return false;
        }
        PsiElement parent = current.getParent();
        if (!(parent instanceof JSNewExpression)) {
            return false;
        }
        JSNewExpression newExpression = (JSNewExpression)parent;
        JSExpression methodExpression = newExpression.getMethodExpression();
        if (!(methodExpression instanceof JSReferenceExpression)) {
            return false;
        }
        if (!this.matchPluginName(methodExpression)) {
            return false;
        }
        PsiElement parentParent = newExpression.getParent();
        if (!(parentParent instanceof JSArrayLiteralExpression)) {
            return false;
        }
        PsiElement oneMoreParent = parentParent.getParent();
        if (!(oneMoreParent instanceof JSProperty) || !"plugins".equals(((JSProperty)oneMoreParent).getName())) {
            return false;
        }
        return Webpack4PluginSchemaProvider.isInTopLevelObject(parentParent);
    }

    private boolean matchPluginName(JSExpression methodExpression) {
        JSSourceElement[] statements;
        if (!this.myIsThirdParty) {
            return methodExpression.getText().endsWith(this.myPluginName);
        }
        JSFile file2 = (JSFile)methodExpression.getContainingFile();
        for (JSSourceElement statement : statements = file2.getStatements()) {
            JSExpression argument;
            JSExpression[] arguments;
            JSExpression initializer;
            JSInitializerOwner[] declarations;
            if (!(statement instanceof JSVarStatement) || (declarations = ((JSVarStatement)statement).getDeclarations()).length != 1 || !((initializer = declarations[0].getInitializer()) instanceof JSCallExpression) || !((JSCallExpression)initializer).isRequireCall() || (arguments = ((JSCallExpression)initializer).getArguments()).length != 1 || !((argument = arguments[0]) instanceof JSLiteralExpression) || !this.myPluginName.equals(((JSLiteralExpression)argument).getStringValue())) continue;
            return methodExpression.getText().equals(declarations[0].getName());
        }
        return false;
    }

    @Override
    public boolean isAvailable(@NotNull PsiElement element) {
        if (element == null) {
            Webpack4PluginSchemaProvider.$$$reportNull$$$0(2);
        }
        if (WebpackUtil.getWebpackVersion(element.getProject()) != WebpackUtil.WebpackVersion.LIKE4) {
            return false;
        }
        if (!WebpackInJavaScriptJsonSchemaProvider.isWebpackInspectionAllowed(element)) {
            return false;
        }
        return this.isApplicable(element);
    }

    private boolean isApplicable(PsiElement element) {
        return element.getContainingFile() != null && WebpackInJavaScriptJsonSchemaProvider.isAvailableForFile(element.getContainingFile()) && Webpack4PluginSchemaProvider.isInSupportedArea(element, WebpackInJavaScriptJsonSchemaProvider::getModuleExportsParts) && this.isInSuitableInvocation(element);
    }

    @Override
    public VirtualFile getSchemaFile() {
        return Webpack4PluginSchemaProvider.loadFile(WebpackInJavaScriptJsonSchemaProvider.class, "/jsonSchemas/webpackPlugins/" + this.myPluginPath);
    }

    private static String pluginNameToPath(String name, boolean isThirdParty) {
        if (!isThirdParty) {
            int dot = name.indexOf(46);
            if (dot == -1) {
                return name + ".json";
            }
            String before = name.substring(0, dot);
            String after = name.substring(dot + 1);
            return before + "/" + after + ".json";
        }
        String[] parts = name.split("-");
        StringBuilder builder = new StringBuilder("thirdParty/");
        for (String part : parts) {
            builder.append(StringUtil.capitalize((String)part));
        }
        return builder.append(".json").toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/frameworks/webpack/Webpack4PluginSchemaProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isInSuitableInvocation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

