/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.VariableAccessUtil;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.NotImplementedError;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMismatchedCollectionQueryUpdateInspectionBase
extends JSInspection {
    protected final List<String> myQueryNames = new ArrayList<String>();
    protected final List<String> myUpdateNames = new ArrayList<String>();
    @NonNls
    public String queries = "trace,write,forEach,length";
    @NonNls
    public String updates = "pop,push,shift,splice,unshift,add,insert,remove";

    public JSMismatchedCollectionQueryUpdateInspectionBase() {
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.queries, this.myQueryNames);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.updates, this.myUpdateNames);
    }

    protected static void parseString(String string, Collection<? super String> out) {
        out.clear();
        out.addAll(StringUtil.split((String)string, (String)","));
    }

    private static String formatString(Collection<String> strings) {
        int size = strings.size();
        if (size > 0) {
            StringBuilder out = new StringBuilder();
            for (String s : strings) {
                out.append(s).append(',');
            }
            return out.substring(0, out.length() - 1);
        }
        return "";
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(0);
        }
        super.readSettings(node);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.queries, this.myQueryNames);
        JSMismatchedCollectionQueryUpdateInspectionBase.parseString(this.updates, this.myUpdateNames);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(1);
        }
        this.queries = JSMismatchedCollectionQueryUpdateInspectionBase.formatString(this.myQueryNames);
        this.updates = JSMismatchedCollectionQueryUpdateInspectionBase.formatString(this.myUpdateNames);
        super.writeSettings(node);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.mismatched.update.collection.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(3);
        }
        if (session == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(4);
        }
        MismatchedCollectionQueryUpdateVisitor mismatchedCollectionQueryUpdateVisitor = new MismatchedCollectionQueryUpdateVisitor(holder);
        if (mismatchedCollectionQueryUpdateVisitor == null) {
            JSMismatchedCollectionQueryUpdateInspectionBase.$$$reportNull$$$0(5);
        }
        return mismatchedCollectionQueryUpdateVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CollectionQueryCalledVisitor
    extends Visitor {
        private boolean queried;

        CollectionQueryCalledVisitor(JSVariable variable) {
            super(variable);
        }

        public void visitJSCallExpression(JSCallExpression node) {
            super.visitJSCallExpression(node);
            if (!this.queried) {
                PsiElement parent = node.getParent();
                JSExpression methodExpression = node.getMethodExpression();
                if (methodExpression instanceof JSReferenceExpression) {
                    if (parent instanceof JSExpressionStatement && !Visitor.checkUsageName((JSReferenceExpression)methodExpression, JSMismatchedCollectionQueryUpdateInspectionBase.this.myQueryNames)) {
                        return;
                    }
                    JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                    if (this.checkReference((PsiElement)qualifier)) {
                        this.queried = true;
                    }
                }
            }
        }

        public void visitJSReferenceExpression(JSReferenceExpression node) {
            super.visitJSReferenceExpression(node);
            if (!this.queried) {
                JSEmbeddedContent content;
                if (DialectDetector.isJSX((PsiElement)node) && (content = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)node, JSEmbeddedContent.class)) != null && this.checkReference((PsiElement)node)) {
                    this.queried = true;
                    return;
                }
                JSExpression qualifier = node.getQualifier();
                if (qualifier != null && Visitor.checkUsageName(node, JSMismatchedCollectionQueryUpdateInspectionBase.this.myQueryNames) && this.checkReference((PsiElement)qualifier)) {
                    this.queried = true;
                }
            }
        }

        public void visitJSForInStatement(JSForInStatement node) {
            super.visitJSForInStatement(node);
            if (!this.queried) {
                JSExpression collectionExpression = node.getCollectionExpression();
                this.queried = this.checkReference((PsiElement)collectionExpression);
            }
        }

        public void visitJSBinaryExpression(JSBinaryExpression node) {
            super.visitJSBinaryExpression(node);
            if (!this.queried && node.getOperationSign() == JSTokenTypes.IN_KEYWORD) {
                this.queried = this.checkReference((PsiElement)node.getROperand());
            }
        }

        public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
            PsiElement parent;
            super.visitJSIndexedPropertyAccessExpression(node);
            if (!this.queried && !((parent = node.getParent()) instanceof JSDefinitionExpression)) {
                JSExpression qualifier = node.getQualifier();
                this.queried = this.checkReference((PsiElement)qualifier);
            }
        }

        public boolean isQueryCalled() {
            return this.queried;
        }
    }

    private class CollectionUpdateCalledVisitor
    extends Visitor {
        private boolean updated;

        CollectionUpdateCalledVisitor(JSVariable variable) {
            super(variable);
        }

        public void visitElement(PsiElement element) {
            if (!this.updated) {
                super.visitElement(element);
            }
        }

        public void visitJSCallExpression(JSCallExpression node) {
            JSExpression methodExpression;
            super.visitJSCallExpression(node);
            if (!this.updated && (methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
                if (!Visitor.checkUsageName((JSReferenceExpression)methodExpression, JSMismatchedCollectionQueryUpdateInspectionBase.this.myUpdateNames)) {
                    return;
                }
                JSExpression qualifier = ((JSReferenceExpression)methodExpression).getQualifier();
                if (this.checkReference((PsiElement)qualifier)) {
                    this.updated = true;
                }
            }
        }

        public void visitJSIndexedPropertyAccessExpression(JSIndexedPropertyAccessExpression node) {
            PsiElement parent;
            super.visitJSIndexedPropertyAccessExpression(node);
            if (!this.updated && (parent = node.getParent()) instanceof JSDefinitionExpression) {
                JSExpression qualifier = node.getQualifier();
                this.updated = this.checkReference((PsiElement)qualifier);
            }
        }

        public boolean isUpdateCalled() {
            return this.updated;
        }
    }

    private class MismatchedCollectionQueryUpdateVisitor
    extends JSElementVisitor {
        private final ProblemsHolder myHolder;
        private JSType myType;

        MismatchedCollectionQueryUpdateVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        private void registerError(JSVariable variable, boolean updated) {
            PsiElement element = variable.getNameIdentifier();
            if (element == null) {
                element = variable;
            }
            this.myHolder.registerProblem(element, JSBundle.message((String)(updated ? "collection.updated.but.not.queried" : "collection.queried.but.not.update"), (Object[])new Object[0]), new LocalQuickFix[0]);
        }

        public void visitJSVarStatement(JSVarStatement varStatement) {
            super.visitJSVarStatement(varStatement);
            PsiElement nearestParent = varStatement.getParent();
            if (nearestParent instanceof JSForInStatement && ((JSForInStatement)nearestParent).getDeclarationStatement() == varStatement) {
                return;
            }
            PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)nearestParent, JSBlockStatement.class, (boolean)false);
            if (parent == null && !((parent = varStatement.getParent()) instanceof JSClass)) {
                return;
            }
            for (JSVariable variable : varStatement.getVariables()) {
                this.process(variable, (JSElement)parent);
            }
        }

        private void process(@NotNull JSVariable variable, @NotNull JSElement parent) {
            JSAttributeList attributeList;
            if (variable == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(0);
            }
            if (parent == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(1);
            }
            if (parent instanceof JSClass && ((attributeList = variable.getAttributeList()) == null || attributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE)) {
                return;
            }
            if (!this.checkVariable(variable, parent)) {
                return;
            }
            boolean written = this.collectionContentsAreUpdated(variable, parent);
            boolean read = this.collectionContentsAreQueried(variable, parent);
            if (read != written) {
                this.registerError(variable, written);
            }
        }

        private boolean collectionContentsAreQueried(JSVariable variable, JSElement context) {
            return this.collectionQueryCalled(variable, context);
        }

        private boolean collectionContentsAreUpdated(JSVariable variable, JSElement context) {
            if (this.collectionUpdateCalled(variable, context)) {
                return true;
            }
            JSExpression initializer = variable.getInitializer();
            if (initializer != null && !this.isEmptyInitializer(initializer)) {
                return true;
            }
            JSExpression destructuringInitializer = JSDestructuringUtil.getNearestDestructuringInitializer(variable);
            if (destructuringInitializer != null && !this.isEmptyInitializer(destructuringInitializer)) {
                return true;
            }
            return VariableAccessUtil.variableIsAssigned(variable, context);
        }

        private boolean isEmptyInitializer(@NotNull JSExpression initializer) {
            if (initializer == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(2);
            }
            if (initializer instanceof JSArrayLiteralExpression) {
                if (!((JSArrayLiteralExpression)initializer).isEmpty()) {
                    return false;
                }
            } else if (initializer instanceof JSNewExpression) {
                JSArrayLiteralExpression psi;
                ASTNode arrayLiteral;
                ASTNode node;
                JSExpression[] arguments;
                JSArgumentList argumentList = ((JSNewExpression)initializer).getArgumentList();
                if (argumentList != null && !JSGenericTypeImpl.isGenericActionScriptVectorType(this.myType) ? (arguments = argumentList.getArguments()).length != 0 : (node = initializer.getNode()) != null && (arrayLiteral = node.findChildByType(JSElementTypes.ARRAY_LITERAL_EXPRESSION)) != null && (psi = (JSArrayLiteralExpression)arrayLiteral.getPsi(JSArrayLiteralExpression.class)) != null && !psi.isEmpty()) {
                    return false;
                }
            } else {
                return false;
            }
            return true;
        }

        private boolean checkVariable(JSVariable variable, JSElement context) {
            this.myType = variable.getJSType();
            if (this.myType == null || !JSTypeUtils.isIndexableType(this.myType)) {
                return false;
            }
            if (VariableAccessUtil.variableIsAssignedFrom(variable, context)) {
                return false;
            }
            return ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)context).filter(Conditions.instanceOf((Class[])new Class[]{JSReturnStatement.class, JSArgumentList.class, JSObjectLiteralExpression.class, JSArrayLiteralExpression.class}))).traverse().flatMap(this::expandForCheck).filter(arg -> VariableAccessUtil.mayEvaluateToVariable(arg, variable)).isEmpty();
        }

        private JBIterable<JSExpression> expandForCheck(PsiElement e) {
            if (e instanceof JSReturnStatement) {
                return JBIterable.of((Object)((JSReturnStatement)e).getExpression());
            }
            if (e instanceof JSArgumentList) {
                return JBIterable.of((Object[])((JSArgumentList)e).getArguments());
            }
            if (e instanceof JSObjectLiteralExpression) {
                return JBIterable.of((Object[])((JSObjectLiteralExpression)e).getProperties()).map(p -> p.getValue());
            }
            if (e instanceof JSArrayLiteralExpression) {
                return JBIterable.of((Object[])((JSArrayLiteralExpression)e).getExpressions());
            }
            throw new NotImplementedError("Please implement me for: " + e.getClass().getCanonicalName());
        }

        private boolean collectionQueryCalled(JSVariable variable, JSElement context) {
            CollectionQueryCalledVisitor visitor = new CollectionQueryCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isQueryCalled();
        }

        private boolean collectionUpdateCalled(@NotNull JSVariable variable, @NotNull JSElement context) {
            if (variable == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(3);
            }
            if (context == null) {
                MismatchedCollectionQueryUpdateVisitor.$$$reportNull$$$0(4);
            }
            CollectionUpdateCalledVisitor visitor = new CollectionUpdateCalledVisitor(variable);
            context.accept((PsiElementVisitor)visitor);
            return visitor.isUpdateCalled();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "initializer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$MismatchedCollectionQueryUpdateVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "process";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEmptyInitializer";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectionUpdateCalled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class Visitor
    extends JSRecursiveElementVisitor {
        protected final JSVariable myVariable;

        Visitor(JSVariable variable) {
            this.myVariable = variable;
        }

        protected static boolean checkUsageName(@NotNull JSReferenceExpression usage, @NotNull Collection<String> names) {
            String functionName;
            if (usage == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            if (names == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((functionName = usage.getReferenceName()) == null) {
                return false;
            }
            if (!names.contains(functionName)) {
                boolean found = false;
                for (String name : names) {
                    if (!functionName.startsWith(name)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    return false;
                }
            }
            return true;
        }

        protected boolean checkReference(@Nullable PsiElement element) {
            if (element instanceof JSReferenceExpression) {
                if (this.myVariable.equals(element = ((JSReferenceExpression)element).resolve())) {
                    return true;
                }
            } else {
                if (element instanceof JSParenthesizedExpression) {
                    return this.checkReference((PsiElement)((JSParenthesizedExpression)element).getInnerExpression());
                }
                if (element instanceof JSConditionalExpression) {
                    JSExpression thenExpression = ((JSConditionalExpression)element).getThen();
                    JSExpression elseExpression = ((JSConditionalExpression)element).getElse();
                    return this.checkReference((PsiElement)thenExpression) || this.checkReference((PsiElement)elseExpression);
                }
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "usage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "names";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/JSMismatchedCollectionQueryUpdateInspectionBase$Visitor";
            objectArray[2] = "checkUsageName";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

