/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSuspiciousNameCombinationInspectionBase
extends JSInspection {
    @NotNull
    @NonNls
    private static final String ELEMENT_GROUPS = "group";
    @NotNull
    @NonNls
    private static final String ATTRIBUTE_NAMES = "names";
    @NotNull
    @NonNls
    private static final String ELEMENT_EXCLUDE = "exclude";
    @NotNull
    @NonNls
    private static final String ATTRIBUTE_CLASSES = "classes";
    @NotNull
    protected final List<String> myNameGroups = new ArrayList<String>();
    @NotNull
    private final Map<String, String> myWordToGroupMap = new HashMap<String, String>();
    @NotNull
    private final Set<String> myExcludedClasses = new HashSet<String>();
    @NotNull
    protected String myExcludedClassNames = "Math";

    public JSSuspiciousNameCombinationInspectionBase() {
        this.addNameGroup("x,width,left,right");
        this.addNameGroup("y,height,top,bottom");
        this.addExcludedClasses();
    }

    protected void addNameGroup(@NotNull String nameGroup) {
        if (nameGroup == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(0);
        }
        this.myNameGroups.add(nameGroup);
        List words = StringUtil.split((String)nameGroup, (String)",");
        for (String word : words) {
            this.myWordToGroupMap.put(StringUtil.toLowerCase((String)word.trim()), nameGroup);
        }
    }

    private void addExcludedClasses() {
        List classNames = StringUtil.split((String)this.myExcludedClassNames, (String)",");
        for (String className2 : classNames) {
            this.myExcludedClasses.add(className2.trim());
        }
    }

    protected void addExcludedClasses(String classNames) {
        this.myExcludedClassNames = classNames;
        this.addExcludedClasses();
    }

    protected void clearNameGroups() {
        this.myNameGroups.clear();
        this.myWordToGroupMap.clear();
    }

    protected void clearExcludedClasses() {
        this.myExcludedClasses.clear();
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JSBundle.message((String)"js.suspicious.name.combination.inspection.name", (Object[])new Object[0]);
        if (string == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(2);
        }
        this.clearNameGroups();
        for (Object o : node.getChildren(ELEMENT_GROUPS)) {
            Element e = (Element)o;
            this.addNameGroup(e.getAttributeValue(ATTRIBUTE_NAMES));
        }
        Element child = node.getChild(ELEMENT_EXCLUDE);
        this.clearExcludedClasses();
        if (child != null) {
            this.addExcludedClasses(child.getAttributeValue(ATTRIBUTE_CLASSES));
        }
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(3);
        }
        for (String group : this.myNameGroups) {
            Element e = new Element(ELEMENT_GROUPS);
            node.addContent(e);
            e.setAttribute(ATTRIBUTE_NAMES, group);
        }
        Element e = new Element(ELEMENT_EXCLUDE);
        node.addContent(e);
        e.setAttribute(ATTRIBUTE_CLASSES, this.myExcludedClassNames);
    }

    private boolean isExcluded(JSReferenceExpression referenceExpression) {
        JSExpression qualifier = referenceExpression.getQualifier();
        if (qualifier instanceof JSReferenceExpression) {
            JSType type;
            PsiElement element = ((JSReferenceExpression)qualifier).resolve();
            String name = null;
            if (element instanceof JSClass) {
                name = ((JSClass)element).getName();
            } else if (element instanceof JSVariable && (type = TypeScriptTypeRelations.expandAndOptimizeTypeRecursive(((JSVariable)element).getJSType())) != null) {
                name = JSTypeUtils.getQualifiedNameMatchingType(type, true);
            }
            return name != null && this.myExcludedClasses.contains(name);
        }
        return false;
    }

    @NotNull
    protected JSElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(4);
        }
        if (session == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(5);
        }
        JSElementVisitor jSElementVisitor = new JSElementVisitor(){

            public void visitJSVariable(JSVariable node) {
                JSExpression initializer;
                if (node.hasInitializer() && (initializer = node.getInitializer()) instanceof JSReferenceExpression) {
                    String referencedName = ((JSReferenceExpression)initializer).getReferencedName();
                    String name = node.getName();
                    if (JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name, referencedName)) {
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.assignment", (Object[])new Object[]{referencedName, name}), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSAssignmentExpression(@NotNull JSAssignmentExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSExpression lOperand = node.getLOperand();
                JSExpression rOperand = node.getROperand();
                if (lOperand instanceof JSDefinitionExpression) {
                    lOperand = ((JSDefinitionExpression)lOperand).getExpression();
                }
                if (lOperand instanceof JSReferenceExpression && rOperand instanceof JSReferenceExpression) {
                    String name2;
                    if (JSSuspiciousNameCombinationInspectionBase.this.isExcluded((JSReferenceExpression)lOperand)) {
                        return;
                    }
                    String name1 = ((JSReferenceExpression)lOperand).getReferencedName();
                    if (JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name1, name2 = ((JSReferenceExpression)rOperand).getReferencedName())) {
                        holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.assignment", (Object[])new Object[]{name2, name1}), new LocalQuickFix[0]);
                    }
                }
            }

            public void visitJSCallExpression(@NotNull JSCallExpression node) {
                JSExpression methodExpression;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((methodExpression = node.getMethodExpression()) instanceof JSReferenceExpression) {
                    JSArgumentList argumentList;
                    if (JSSuspiciousNameCombinationInspectionBase.this.isExcluded((JSReferenceExpression)methodExpression)) {
                        return;
                    }
                    PsiElement method = ((JSReferenceExpression)methodExpression).resolve();
                    if (method instanceof JSFunction && (argumentList = node.getArgumentList()) != null) {
                        JSExpression[] arguments = argumentList.getArguments();
                        JSParameterListElement[] parameters = ((JSFunction)method).getParameters();
                        for (int i = 0; i < parameters.length && i < arguments.length; ++i) {
                            String name;
                            String referencedName;
                            JSExpression argument = arguments[i];
                            if (!(argument instanceof JSReferenceExpression) || JSSuspiciousNameCombinationInspectionBase.this.findNameGroup(referencedName = ((JSReferenceExpression)argument).getReferencedName()) == null || !JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name = parameters[i].getName(), referencedName)) continue;
                            holder.registerProblem((PsiElement)argument, JSBundle.message((String)"js.suspicious.name.parameter", (Object[])new Object[]{referencedName, name}), new LocalQuickFix[0]);
                        }
                    }
                }
            }

            public void visitJSReturnStatement(@NotNull JSReturnStatement node) {
                String referencedName;
                String functionName;
                JSFunction function;
                JSExpression expression;
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((expression = node.getExpression()) instanceof JSReferenceExpression && (function = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)node, JSFunction.class)) != null && JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(functionName = function.getName(), referencedName = ((JSReferenceExpression)expression).getReferencedName())) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.return", (Object[])new Object[]{referencedName, functionName}), new LocalQuickFix[0]);
                }
            }

            public void visitJSProperty(@NotNull JSProperty node) {
                String referencedName;
                String name;
                JSExpression value;
                if (node == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((value = node.getValue()) instanceof JSReferenceExpression && JSSuspiciousNameCombinationInspectionBase.this.isSuspiciousNameCombination(name = node.getName(), referencedName = ((JSReferenceExpression)value).getReferencedName())) {
                    holder.registerProblem((PsiElement)node, JSBundle.message((String)"js.suspicious.name.assignment", (Object[])new Object[]{referencedName, name}), new LocalQuickFix[0]);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSAssignmentExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSCallExpression";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSReturnStatement";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSProperty";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (jSElementVisitor == null) {
            JSSuspiciousNameCombinationInspectionBase.$$$reportNull$$$0(6);
        }
        return jSElementVisitor;
    }

    private boolean isSuspiciousNameCombination(@Nullable String name1, @Nullable String name2) {
        String nameGroup1 = this.findNameGroup(name1);
        String nameGroup2 = this.findNameGroup(name2);
        return nameGroup1 != null && nameGroup2 != null && !nameGroup1.equals(nameGroup2);
    }

    @Nullable
    private String findNameGroup(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String[] words = NameUtilCore.splitNameIntoWords((String)name);
        String result2 = null;
        for (String word : words) {
            String group = this.myWordToGroupMap.get(StringUtil.toLowerCase((String)word));
            if (group == null) continue;
            if (result2 == null) {
                result2 = group;
                continue;
            }
            if (result2.equals(group)) continue;
            result2 = null;
            break;
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameGroup";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSSuspiciousNameCombinationInspectionBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addNameGroup";
                break;
            }
            case 1: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "readSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

