/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.presentable;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.presentable.Capitalization;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSPackageWrapper;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSFunctionReturnWrapperType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.util.BitUtil;
import com.intellij.util.ObjectUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFormatUtil
extends PsiFormatUtilBase {
    public static final String ANONYMOUS_ELEMENT_PRESENTATION = JSBundle.message((String)"element.name.anonymous", (Object[])new Object[0]);
    public static final String DEFAULT_MEMBER_NAME = JSBundle.message((String)"element.name.default", (Object[])new Object[0]);
    public static final String TOP_LEVEL_PACKAGE_NAME = JSBundle.message((String)"top.level.package", (Object[])new Object[0]);

    @NotNull
    public static String formatField(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(0);
        }
        String string = JSFormatUtil.formatField(field, options, null);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    private static String formatField(@NotNull JSTypeDeclarationOwner field, int options, @Nullable JSClass parentClassOverride) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(2);
        }
        StringBuilder text = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4)) {
            text.append(JSFormatUtil.getType(field, options));
        }
        JSFormatUtil.appendContainingClassIfNeeded(options, parentClassOverride, text, (PsiElement)field);
        if (BitUtil.isSet((int)options, (int)1)) {
            if (!BitUtil.isSet((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append(field.getName());
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            JSFormatUtil.appendTypeAfter((PsiElement)field, options, text, field.getJSType());
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static void appendContainingClassIfNeeded(int options, @Nullable JSClass parentClassOverride, @NotNull StringBuilder text, @Nullable PsiElement context) {
        if (text == null) {
            JSFormatUtil.$$$reportNull$$$0(4);
        }
        if (BitUtil.isSet((int)options, (int)4096)) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext(context);
            if (clazz != null && (BitUtil.isSet((int)options, (int)1) || BitUtil.isSet((int)options, (int)2048))) {
                String s;
                JSNamedElementPresenter presenter = new JSNamedElementPresenter((PsiElement)clazz);
                String string = s = BitUtil.isSet((int)options, (int)1) ? presenter.getShortName() : presenter.getQualifiedName();
                if (s.length() > 0) {
                    JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
                    text.append(s).append('.');
                }
            }
        }
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(5);
        }
        String string = JSFormatUtil.formatMethod((JSFunctionItem)method, options, parametersOptions, 7, null);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String formatTypeMember(@NotNull TypeScriptTypeMember member, int options, int parameterOptions) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(7);
        }
        if (member instanceof TypeScriptCallSignature) {
            String string = JSFormatUtil.formatMethod((JSFunctionItem)((JSFunction)member), options, parameterOptions, 7, null, "");
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (member instanceof TypeScriptIndexSignature) {
            String string = JSFormatUtil.formatIndexSignature((TypeScriptIndexSignature)member, options, parameterOptions);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (member instanceof JSFunction) {
            String string = JSFormatUtil.formatMethod((JSFunction)member, options, parameterOptions);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (member instanceof TypeScriptPropertySignature) {
            String string = JSFormatUtil.formatField((JSTypeDeclarationOwner)member, options);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = (String)ObjectUtils.coalesce((Object)member.getName(), (Object)"");
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunctionItem method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverride) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(13);
        }
        String string = JSFormatUtil.formatMethod(method, options, parametersOptions, maxParameters, parentClassOverride, ANONYMOUS_ELEMENT_PRESENTATION);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String formatMethod(@NotNull JSFunctionItem method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverride, String namePlaceholder) {
        String returnType;
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(15);
        }
        StringBuilder text = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4) && (returnType = JSFormatUtil.getReturnType(method, options)) != null) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(returnType);
        }
        JSFormatUtil.appendContainingClassIfNeeded(options, parentClassOverride, text, (PsiElement)method);
        if (BitUtil.isSet((int)options, (int)1)) {
            if (!BitUtil.isSet((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append((String)ObjectUtils.coalesce((Object)method.getName(), (Object)namePlaceholder));
        }
        if (BitUtil.isSet((int)options, (int)256) && (!(method instanceof JSFunction) || ((JSFunction)method).getKind() != JSFunction.FunctionKind.GETTER && ((JSFunction)method).getKind() != JSFunction.FunctionKind.SETTER)) {
            text.append('(');
            JSParameterItem[] params = method.getParameters();
            for (int i = 0; i < Math.min(params.length, maxParameters); ++i) {
                if (i != 0) {
                    text.append(", ");
                }
                text.append(JSFormatUtil.formatParameter(params[i], parametersOptions));
            }
            text.append(')');
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            returnType = JSFormatUtil.getReturnType(method, options);
            JSFormatUtil.appendReturnType(text, returnType, DialectDetector.isActionScript((PsiElement)method));
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void appendReturnType(StringBuilder text, String returnType, boolean isActionScript) {
        if (!StringUtil.isEmpty((String)returnType)) {
            text.append(':');
            if (!isActionScript) {
                text.append(' ');
            }
            text.append(returnType);
        }
    }

    @NotNull
    private static String formatIndexSignature(@NotNull TypeScriptIndexSignature member, int options, int parameterOptions) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(17);
        }
        StringBuilder text = new StringBuilder();
        JSFormatUtil.appendContainingClassIfNeeded(options, null, text, (PsiElement)member);
        JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
        text.append('[');
        if (BitUtil.isSet((int)parameterOptions, (int)1)) {
            PsiElement parameterName = member.getParameterNameElement();
            if (parameterName != null) {
                text.append(parameterName.getText());
            }
            if (BitUtil.isSet((int)options, (int)2)) {
                JSType type = member.getMemberParameterType();
                JSFormatUtil.appendTypeAfter((PsiElement)member, options, text, type);
            }
        }
        text.append(']');
        if (BitUtil.isSet((int)options, (int)2)) {
            JSType type = member.getMemberType();
            JSFormatUtil.appendTypeAfter((PsiElement)member, options, text, type);
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static void appendTypeAfter(@NotNull PsiElement member, int options, @NotNull StringBuilder text, @Nullable JSType type) {
        if (member == null) {
            JSFormatUtil.$$$reportNull$$$0(19);
        }
        if (text == null) {
            JSFormatUtil.$$$reportNull$$$0(20);
        }
        String typeString = JSFormatUtil.formatType(type, member, options);
        JSFormatUtil.appendReturnType(text, typeString, DialectDetector.isActionScript(member));
    }

    @NotNull
    private static String formatParameter(@NotNull JSParameterItem parameter, int options) {
        DialectOptionHolder optionHolder;
        if (parameter == null) {
            JSFormatUtil.$$$reportNull$$$0(21);
        }
        DialectOptionHolder dialectOptionHolder = optionHolder = parameter instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)parameter) : null;
        if (!(!BitUtil.isSet((int)options, (int)2) || BitUtil.isSet((int)options, (int)65536) || optionHolder != null && optionHolder.hasFeature(JSLanguageFeature.TYPES))) {
            options &= 0xFFFFFFFD;
            options |= 1;
        }
        StringBuilder text = new StringBuilder();
        if (BitUtil.isSet((int)options, (int)2) && !BitUtil.isSet((int)options, (int)4)) {
            if (parameter.isRest() && optionHolder != null && optionHolder.isECMA4) {
                text.append("Array");
            } else {
                text.append(JSFormatUtil.formatType(parameter.getSimpleType(), (PsiElement)ObjectUtils.tryCast((Object)parameter, PsiElement.class), options));
            }
        }
        if (BitUtil.isSet((int)options, (int)1)) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(parameter.getName());
            if ((optionHolder == null || !optionHolder.isJavaScript()) && parameter.isOptional()) {
                text.append("?");
            }
        }
        if (BitUtil.isSet((int)options, (int)2) && BitUtil.isSet((int)options, (int)4)) {
            String typeName = parameter.isRest() && optionHolder != null && optionHolder.isECMA4 ? "Array" : JSFormatUtil.formatType(parameter.getSimpleType(), (PsiElement)ObjectUtils.tryCast((Object)parameter, PsiElement.class), options);
            JSFormatUtil.appendReturnType(text, typeName, optionHolder != null && optionHolder.isECMA4);
        }
        String string = text.toString();
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Nullable
    private static String getReturnType(@NotNull JSFunctionItem method, int options) {
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(23);
        }
        options |= 1;
        JSFunction psiFunction = (JSFunction)ObjectUtils.tryCast((Object)method, JSFunction.class);
        if (psiFunction != null && psiFunction.getKind() == JSFunction.FunctionKind.SETTER) {
            if (psiFunction.getParameterList() != null && method.getParameters().length > 0) {
                return JSFormatUtil.formatType(psiFunction.getParameters()[0].getJSType(), (PsiElement)method, options);
            }
            return null;
        }
        if (psiFunction != null && psiFunction.getKind() == JSFunction.FunctionKind.CONSTRUCTOR && !(psiFunction instanceof TypeScriptCallSignature)) {
            return null;
        }
        return JSFormatUtil.formatType(method.getReturnType(), (PsiElement)method, options);
    }

    @NotNull
    private static String getType(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            JSFormatUtil.$$$reportNull$$$0(24);
        }
        String string = JSFormatUtil.formatType(field.getJSType(), (PsiElement)field, options);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    private static String formatType(@Nullable JSType type, @Nullable PsiElement context, int options) {
        DialectOptionHolder dialect = DialectDetector.dialectOfElement(context);
        if (BitUtil.isSet((int)options, (int)1) && !JSFormatUtil.isPossiblyPresentableType(type, context, false) && (type != null || dialect == null || !dialect.isTypeScript && !dialect.isECMA4)) {
            if ("" == null) {
                JSFormatUtil.$$$reportNull$$$0(26);
            }
            return "";
        }
        if ((dialect == null || !dialect.isTypeScript && !dialect.isECMA4) && type instanceof JSAnyType) {
            if (BitUtil.isSet((int)options, (int)1)) {
                if ("" == null) {
                    JSFormatUtil.$$$reportNull$$$0(27);
                }
                return "";
            }
            type = null;
        }
        if (type != null) {
            String typeName = type.getTypeText(dialect != null && dialect.isECMA4 ? JSType.TypeTextFormat.SIMPLE : JSType.TypeTextFormat.CODE);
            String string = BitUtil.isSet((int)options, (int)8192) ? typeName : JSResolveUtil.getShortTypeName(typeName, true);
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(28);
            }
            return string;
        }
        String string = dialect != null && dialect.isTypeScript ? "any" : "*";
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @Nullable
    public static Icon getPropertyIcon(@NotNull JSFunction method) {
        boolean isStatic;
        if (method == null) {
            JSFormatUtil.$$$reportNull$$$0(30);
        }
        boolean bl = isStatic = method.getAttributeList() != null && method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
        if (method.getKind() == JSFunction.FunctionKind.GETTER) {
            if (JSUtils.getMemberContainingClass((PsiElement)method).findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.SETTER) != null) {
                return isStatic ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
            }
            return isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
        }
        if (method.getKind() == JSFunction.FunctionKind.SETTER) {
            if (JSUtils.getMemberContainingClass((PsiElement)method).findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.GETTER) != null) {
                return isStatic ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
            }
            return isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
        }
        return null;
    }

    @NotNull
    public static String formatVisibility(@NotNull JSAttributeList.AccessType accessType, @Nullable PsiElement context) {
        String s;
        if (accessType == null) {
            JSFormatUtil.$$$reportNull$$$0(31);
        }
        if (StringUtil.isEmpty((String)(s = JSVisibilityUtil.accessTypeToKeyword(accessType, context != null ? DialectDetector.dialectOfElement(context) : null)))) {
            if ("" == null) {
                JSFormatUtil.$$$reportNull$$$0(32);
            }
            return "";
        }
        String string = JSBundle.message((String)("javascript.visibility." + s), (Object[])new Object[0]);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public static String formatVisibility(@NotNull JSAttributeList.AccessType accessType) {
        if (accessType == null) {
            JSFormatUtil.$$$reportNull$$$0(34);
        }
        String string = JSFormatUtil.formatVisibility(accessType, null);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @NotNull
    public static String formatVisibility(@NotNull PsiElement element) {
        JSAttributeList attributeList;
        if (element == null) {
            JSFormatUtil.$$$reportNull$$$0(36);
        }
        String string = (attributeList = ((JSAttributeListOwner)element).getAttributeList()) == null ? "" : JSFormatUtil.formatVisibility(attributeList.getAccessType(), element);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public static String getFunctionLongDescription(@NotNull JSFunctionItem jsFunction, boolean addElementKind, boolean includeParent, boolean htmlEmphasize, boolean includeParameters, @Nullable JSClass parentClassOverride) {
        boolean isMethod;
        if (jsFunction == null) {
            JSFormatUtil.$$$reportNull$$$0(38);
        }
        int options = 1;
        if (includeParameters) {
            options |= 0x100;
        }
        boolean bl = isMethod = JSUtils.getMemberContainingClass((PsiElement)jsFunction) != null;
        if (includeParent && isMethod) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatMethod(jsFunction, options, 2, 7, parentClassOverride);
        String string = JSFormatUtil.describeWithPresenter(addElementKind, includeParent, htmlEmphasize, parentClassOverride, isMethod, name, (PsiElement)jsFunction);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private static String describeWithPresenter(boolean addElementKind, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride, boolean isClassMember, String name, PsiElement element) {
        JSNamedElementPresenter presenter = new JSNamedElementPresenter(element, Capitalization.LowerCase, addElementKind);
        presenter.overrideShortName(name);
        if (includeParent && !isClassMember) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext(element);
            if (clazz != null) {
                String string = JSFormatUtil.presentInParent(htmlEmphasize, presenter, clazz);
                if (string == null) {
                    JSFormatUtil.$$$reportNull$$$0(40);
                }
                return string;
            }
        }
        String string = presenter.describeWithShortName(htmlEmphasize);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @NotNull
    private static String presentInParent(boolean htmlEmphasize, @NotNull JSNamedElementPresenter presenter, @NotNull JSClass clazz) {
        if (presenter == null) {
            JSFormatUtil.$$$reportNull$$$0(42);
        }
        if (clazz == null) {
            JSFormatUtil.$$$reportNull$$$0(43);
        }
        JSNamedElementPresenter parentPresenter = new JSNamedElementPresenter((PsiElement)clazz);
        String string = JSBundle.message((String)"entity.in.parent.description", (Object[])new Object[]{presenter.describeWithShortName(htmlEmphasize), parentPresenter.describeWithShortName(htmlEmphasize)});
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    public static String getVariableLongDescription(@NotNull JSVariable jsVariable, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride) {
        boolean isField;
        if (jsVariable == null) {
            JSFormatUtil.$$$reportNull$$$0(45);
        }
        int options = 1;
        boolean bl = isField = JSUtils.getMemberContainingClass((PsiElement)jsVariable) != null;
        if (includeParent && isField) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatField((JSTypeDeclarationOwner)jsVariable, options, parentClassOverride);
        String string = JSFormatUtil.describeWithPresenter(true, includeParent, htmlEmphasize, parentClassOverride, isField, name, (PsiElement)jsVariable);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(46);
        }
        return string;
    }

    @NotNull
    public static String formatPackage(@Nullable String packageName) {
        String string = !StringUtil.isEmpty((String)packageName) ? JSBundle.message((String)"package.description", (Object[])new Object[]{packageName}) : TOP_LEVEL_PACKAGE_NAME;
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    public static String getAnonymousName(@NotNull PsiElement psiElement) {
        PsiElement parent;
        if (psiElement == null) {
            JSFormatUtil.$$$reportNull$$$0(48);
        }
        if ((parent = psiElement.getParent()) instanceof ES6ExportDefaultAssignment) {
            String string = DEFAULT_MEMBER_NAME;
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(49);
            }
            return string;
        }
        if (psiElement instanceof JSPackageWrapper || psiElement instanceof JSPackageStatement) {
            String string = TOP_LEVEL_PACKAGE_NAME;
            if (string == null) {
                JSFormatUtil.$$$reportNull$$$0(50);
            }
            return string;
        }
        String string = ANONYMOUS_ELEMENT_PRESENTATION;
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(51);
        }
        return string;
    }

    @NotNull
    public static String buildFunctionSignaturePresentation(@NotNull JSFunctionItem psiElement) {
        if (psiElement == null) {
            JSFormatUtil.$$$reportNull$$$0(52);
        }
        int options = 8450;
        int parametersOptions = 73731;
        String string = JSFormatUtil.formatMethod(psiElement, options |= 4, parametersOptions |= 4, 7, null);
        if (string == null) {
            JSFormatUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isPossiblyPresentableType(@Nullable JSType type, @Nullable PsiElement owner, boolean allowTypeEvaluation) {
        if (type == null) {
            return false;
        }
        if (allowTypeEvaluation && type instanceof JSFunctionReturnWrapperType) {
            type = type.substitute();
        }
        if (owner == null) {
            owner = type.getSource().getSourceElement();
        }
        if (type instanceof JSVoidType && owner instanceof JSPsiElementBase && JSSymbolUtil.isConstructorSymbol((JSPsiElementBase)owner)) {
            return false;
        }
        return allowTypeEvaluation && !type.getSource().isJavaScript() || !JSTypeUtils.hasTypes(type, JSCodeBasedType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/presentable/JSFormatUtil";
                break;
            }
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: 
            case 13: 
            case 15: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFunction";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presenter";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsVariable";
                break;
            }
            case 48: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/presentable/JSFormatUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "formatField";
                break;
            }
            case 6: 
            case 14: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "formatMethod";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTypeMember";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatIndexSignature";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "formatParameter";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "formatType";
                break;
            }
            case 32: 
            case 33: 
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "formatVisibility";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionLongDescription";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "describeWithPresenter";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "presentInParent";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableLongDescription";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPackage";
                break;
            }
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnonymousName";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunctionSignaturePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "formatField";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendContainingClassIfNeeded";
                break;
            }
            case 5: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "formatMethod";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "formatTypeMember";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatIndexSignature";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeAfter";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "formatParameter";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyIcon";
                break;
            }
            case 31: 
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "formatVisibility";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionLongDescription";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "presentInParent";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getVariableLongDescription";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getAnonymousName";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionSignaturePresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 44: 
            case 46: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

