/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.TypeScriptUnionOrIntersectionTypeStub;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericParameterImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSNullType;
import com.intellij.lang.javascript.psi.types.primitives.JSUndefinedType;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.util.ArrayList;
import java.util.List;
import kotlin.NotImplementedError;
import org.jetbrains.annotations.NotNull;

public class TypeScriptUnionOrIntersectionTypeImpl
extends JSStubElementImpl<TypeScriptUnionOrIntersectionTypeStub>
implements TypeScriptUnionOrIntersectionType {
    public TypeScriptUnionOrIntersectionTypeImpl(ASTNode node) {
        super(node);
    }

    public TypeScriptUnionOrIntersectionTypeImpl(TypeScriptUnionOrIntersectionTypeStub stub, IStubElementType type) {
        super(stub, type);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            TypeScriptUnionOrIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitTypeScriptUnionOrIntersectionType((TypeScriptUnionOrIntersectionType)this);
        } else {
            super.accept(visitor);
        }
    }

    @NotNull
    public TypeScriptType[] getTypes() {
        TypeScriptType[] typeScriptTypeArray = TypeScriptPsiUtil.getStubOrPsiTypeElements(this);
        if (typeScriptTypeArray == null) {
            TypeScriptUnionOrIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        return typeScriptTypeArray;
    }

    public boolean isUnionType() {
        TypeScriptUnionOrIntersectionTypeStub stub = (TypeScriptUnionOrIntersectionTypeStub)this.getGreenStub();
        if (stub != null) {
            return stub.isUnion();
        }
        return this.getNode().findChildByType(JSTokenTypes.OR) != null;
    }

    public boolean isIntersectionType() {
        TypeScriptUnionOrIntersectionTypeStub stub = (TypeScriptUnionOrIntersectionTypeStub)this.getGreenStub();
        if (stub != null) {
            return !stub.isUnion();
        }
        return this.getNode().findChildByType(JSTokenTypes.AND) != null;
    }

    @NotNull
    public JSType getJSType() {
        TypeScriptType[] psiTypes = this.getTypes();
        ArrayList<JSType> types2 = new ArrayList<JSType>(psiTypes.length);
        for (TypeScriptType partType : psiTypes) {
            types2.add(partType.getJSType());
        }
        if (this.isUnionType()) {
            TypeScriptUnionOrIntersectionTypeImpl.fixUnionOrder(types2);
            JSCompositeTypeImpl jSCompositeTypeImpl = new JSCompositeTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)this, true), types2);
            if (jSCompositeTypeImpl == null) {
                TypeScriptUnionOrIntersectionTypeImpl.$$$reportNull$$$0(2);
            }
            return jSCompositeTypeImpl;
        }
        if (this.isIntersectionType()) {
            JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types2, JSTypeSourceFactory.createTypeSource((PsiElement)this, true));
            if (jSType == null) {
                TypeScriptUnionOrIntersectionTypeImpl.$$$reportNull$$$0(3);
            }
            return jSType;
        }
        throw new NotImplementedError("Should be either union or intersection, but is of some unknown kind");
    }

    private static void fixUnionOrder(@NotNull List<JSType> types2) {
        if (types2 == null) {
            TypeScriptUnionOrIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        int initialSize = types2.size();
        TIntHashSet toDrop = new TIntHashSet(initialSize);
        for (int i = 0; i < initialSize; ++i) {
            JSType type = types2.get(i);
            if (!(type instanceof JSUndefinedType) && !(type instanceof JSNullType) && !(type instanceof JSGenericParameterImpl)) continue;
            types2.add(type);
            toDrop.add(i);
        }
        TIntIterator iterator = toDrop.iterator();
        while (iterator.hasNext()) {
            types2.remove(iterator.next());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptUnionOrIntersectionTypeImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/TypeScriptUnionOrIntersectionTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fixUnionOrder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

