/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecmal4.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecmal4.JSAttribute;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSConditionalCompileVariableReference;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.stubs.JSAttributeListStub;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAttributeListImpl
extends JSStubElementImpl<JSAttributeListStub>
implements JSAttributeList {
    public static final TokenSet ourModifiersTypeSet = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PUBLIC_KEYWORD, JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PROTECTED_KEYWORD, JSTokenTypes.INTERNAL_KEYWORD, JSTokenTypes.EXPORT_KEYWORD, JSTokenTypes.DECLARE_KEYWORD, JSTokenTypes.SHARP});

    public JSAttributeListImpl(ASTNode node) {
        super(node);
    }

    public JSAttributeListImpl(@NotNull JSAttributeListStub stub, @NotNull JSStubElementType<JSAttributeListStub, JSAttributeList> elementType) {
        if (stub == null) {
            JSAttributeListImpl.$$$reportNull$$$0(0);
        }
        if (elementType == null) {
            JSAttributeListImpl.$$$reportNull$$$0(1);
        }
        super(stub, (IStubElementType)elementType);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSAttributeListImpl.$$$reportNull$$$0(2);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSAttributeList((JSAttributeList)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public boolean hasExplicitModifier(@NotNull JSAttributeList.ModifierType modifier) {
        if (modifier == null) {
            JSAttributeListImpl.$$$reportNull$$$0(3);
        }
        return this.findModifierNode(modifier) != null;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSAttributeList.AccessType explicitAccessType = this.getExplicitAccessType();
        if (explicitAccessType != null) {
            JSAttributeList.AccessType accessType = explicitAccessType;
            if (accessType == null) {
                JSAttributeListImpl.$$$reportNull$$$0(4);
            }
            return accessType;
        }
        PsiElement owner = this.getContext();
        assert (owner != null);
        JSAttributeList.AccessType accessType = JSUtils.getImplicitAccessType(owner);
        if (accessType == null) {
            JSAttributeListImpl.$$$reportNull$$$0(5);
        }
        return accessType;
    }

    @Nullable
    public JSAttributeList.AccessType getExplicitAccessType() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null) {
            return stub.getExplicitAccessType();
        }
        ASTNode node = this.getNode().findChildByType(ourModifiersTypeSet);
        if (node != null) {
            IElementType nodeType = node.getElementType();
            if (nodeType == JSTokenTypes.PUBLIC_KEYWORD || nodeType == JSTokenTypes.EXPORT_KEYWORD) {
                return JSAttributeList.AccessType.PUBLIC;
            }
            if (nodeType == JSTokenTypes.PROTECTED_KEYWORD) {
                return JSAttributeList.AccessType.PROTECTED;
            }
            if (nodeType == JSTokenTypes.PRIVATE_KEYWORD) {
                return JSAttributeList.AccessType.PRIVATE;
            }
            if (nodeType == JSTokenTypes.SHARP) {
                return JSAttributeList.AccessType.PRIVATE;
            }
            if (nodeType == JSTokenTypes.INTERNAL_KEYWORD) {
                return JSAttributeList.AccessType.PACKAGE_LOCAL;
            }
        }
        return null;
    }

    public boolean hasPrivateSharp() {
        JSAttributeListStub stub = (JSAttributeListStub)this.getGreenStub();
        if (stub != null) {
            return stub.hasPrivateSharp();
        }
        return this.getNode().findChildByType(JSTokenTypes.SHARP) != null;
    }

    public PsiElement findAccessTypeElement() {
        ASTNode modifier = this.getNode().findChildByType(ourModifiersTypeSet);
        return modifier != null ? modifier.getPsi() : null;
    }

    public boolean hasModifier(@NotNull JSAttributeList.ModifierType modifier) {
        JSAttributeListStub stub;
        if (modifier == null) {
            JSAttributeListImpl.$$$reportNull$$$0(6);
        }
        if ((stub = (JSAttributeListStub)this.getGreenStub()) != null) {
            return stub.hasModifier(modifier);
        }
        return this.hasExplicitModifier(modifier);
    }

    @Nullable
    private ASTNode findModifierNode(JSAttributeList.ModifierType modifier) {
        IElementType type = null;
        switch (modifier) {
            case DYNAMIC: {
                type = JSTokenTypes.DYNAMIC_KEYWORD;
                break;
            }
            case OVERRIDE: {
                type = JSTokenTypes.OVERRIDE_KEYWORD;
                break;
            }
            case NATIVE: {
                type = JSTokenTypes.NATIVE_KEYWORD;
                break;
            }
            case STATIC: {
                type = JSTokenTypes.STATIC_KEYWORD;
                break;
            }
            case PROTO: {
                type = JSTokenTypes.PROTO_KEYWORD;
                break;
            }
            case FINAL: {
                type = JSTokenTypes.FINAL_KEYWORD;
                break;
            }
            case VIRTUAL: {
                type = JSTokenTypes.VIRTUAL_KEYWORD;
                break;
            }
            case DECLARE: {
                type = JSTokenTypes.DECLARE_KEYWORD;
                break;
            }
            case ASYNC: {
                type = JSTokenTypes.ASYNC_KEYWORD;
                break;
            }
            case CONST: {
                type = JSTokenTypes.CONST_KEYWORD;
                break;
            }
            case ABSTRACT: {
                type = JSTokenTypes.ABSTRACT_KEYWORD;
                break;
            }
            case READONLY: {
                type = JSTokenTypes.READONLY_KEYWORD;
                break;
            }
            case EXPORT: {
                type = JSTokenTypes.EXPORT_KEYWORD;
                break;
            }
            case GENERATOR: {
                type = JSTokenTypes.MULT;
                break;
            }
            case GET: {
                type = JSTokenTypes.GET_KEYWORD;
                break;
            }
            case SET: {
                type = JSTokenTypes.SET_KEYWORD;
            }
        }
        return type != null ? this.getNode().findChildByType(type) : null;
    }

    @Nullable
    public PsiElement findModifierElement(@NotNull JSAttributeList.ModifierType modifier) {
        ASTNode node;
        if (modifier == null) {
            JSAttributeListImpl.$$$reportNull$$$0(7);
        }
        return (node = this.findModifierNode(modifier)) != null ? node.getPsi() : null;
    }

    @Override
    public PsiElement add(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            JSAttributeListImpl.$$$reportNull$$$0(8);
        }
        return JSChangeUtil.doDoAddAfter((PsiElement)this, element, this.getLastChild());
    }

    @Nullable
    public JSConditionalCompileVariableReference getConditionalCompileVariableReference() {
        return null;
    }

    @Nullable
    public String getNamespace() {
        return null;
    }

    @Nullable
    public JSReferenceExpression getNamespaceElement() {
        return null;
    }

    @Nullable
    public String resolveNamespaceValue() {
        return null;
    }

    @NotNull
    public ES6Decorator[] getDecorators() {
        ES6Decorator[] eS6DecoratorArray = (ES6Decorator[])this.getStubOrPsiChildren((IStubElementType)JSStubElementTypes.ES6_DECORATOR, ES6Decorator.ARRAY_FACTORY);
        if (eS6DecoratorArray == null) {
            JSAttributeListImpl.$$$reportNull$$$0(9);
        }
        return eS6DecoratorArray;
    }

    @NotNull
    public JSAttribute[] getAttributes() {
        if (JSAttribute.EMPTY_ARRAY == null) {
            JSAttributeListImpl.$$$reportNull$$$0(10);
        }
        return JSAttribute.EMPTY_ARRAY;
    }

    @NotNull
    public JSAttribute[] getAttributesByName(@NotNull String name) {
        if (name == null) {
            JSAttributeListImpl.$$$reportNull$$$0(11);
        }
        if (JSAttribute.EMPTY_ARRAY == null) {
            JSAttributeListImpl.$$$reportNull$$$0(12);
        }
        return JSAttribute.EMPTY_ARRAY;
    }

    @Nullable
    public JSAttribute findAttributeByName(@NotNull String name) {
        if (name == null) {
            JSAttributeListImpl.$$$reportNull$$$0(13);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifier";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecmal4/impl/JSAttributeListImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecorators";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributesByName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasExplicitModifier";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasModifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModifierElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAttributesByName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

