/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.actionscript.psi.ActionScriptPsiImplUtil;
import com.intellij.lang.ecmascript6.psi.ES6ComputedName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringArrayRestElement;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSSwitchStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSComputedPropertyNameOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSCachingNamespaceOwner;
import com.intellij.lang.javascript.psi.impl.JSCachingTypeOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSFunctionImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.impl.JSQualifiedNamedElementBaseImpl;
import com.intellij.lang.javascript.psi.impl.JSStubElementImpl;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.lang.javascript.psi.impl.JSVarStatementBase;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.lang.javascript.psi.stubs.JSVariableStubBase;
import com.intellij.lang.javascript.psi.stubs.impl.StubTreeUtil;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSDestructuringUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSVariableBaseImpl<T extends JSVariableStubBase<T2>, T2 extends JSVariable>
extends JSQualifiedNamedElementBaseImpl<T>
implements JSVariable,
JSCachingTypeOwner,
JSCachingNamespaceOwner {
    protected String myName;
    public static final TokenSet IDENTIFIER_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.JS_IDENTIFIER_TOKENS_SET, JSKeywordSets.AS_IDENTIFIER_TOKENS_SET, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});
    private static final TokenSet PROPERTY_NAME_TOKENS_SET = TokenSet.orSet((TokenSet[])new TokenSet[]{JSKeywordSets.IDENTIFIER_NAMES, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.REFERENCE_EXPRESSION})});
    private static final IElementType[] TYPES_TO_SKIP = new IElementType[]{JSTokenTypes.DOC_COMMENT, JSStubElementTypes.ATTRIBUTE_LIST, JSStubElementTypes.ACTION_SCRIPT_ATTRIBUTE_LIST, JSElementTypes.REFERENCE_EXPRESSION, JSTokenTypes.WHITE_SPACE};

    protected JSVariableBaseImpl(ASTNode node) {
        super(node);
    }

    protected <PsiT extends JSVariable> JSVariableBaseImpl(T stub, JSStubElementType<? extends JSVariableStubBase<PsiT>, PsiT> elementType) {
        super(stub, (IStubElementType)elementType);
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myName = null;
        JSExpression initializer = this.getInitializerOrStub();
        if (initializer instanceof JSFunctionExpression && initializer instanceof JSStubElementImpl) {
            ((JSStubElementImpl)initializer).clearCaches();
        }
    }

    public boolean hasOwnInitializer() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasOwnInitializer();
        }
        return this.getInitializer() != null;
    }

    public boolean hasInitializer() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasInitializer();
        }
        return this.getInitializer() != null;
    }

    @Nullable
    public JSVarStatement getStatement() {
        return (JSVarStatement)ObjectUtils.tryCast((Object)JSDestructuringUtil.getParentSkippingDestructuring(this), JSVarStatement.class);
    }

    @Nullable
    public JSExpression getInitializerOrStub() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getStub();
        if (stub != null) {
            if (!stub.keepsInitializerStub()) {
                return null;
            }
            StubElement initializerStub = StubTreeUtil.findChildStubByType(stub, JSExtendedLanguagesTokenSetProvider.EXPRESSIONS);
            return initializerStub != null ? (JSExpression)initializerStub.getPsi() : null;
        }
        return this.getInitializer();
    }

    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    @Nullable
    public String getLiteralOrReferenceInitializerText() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getLiteralOrReferenceInitializerText();
        }
        JSExpression expression = this.getInitializer();
        return JSVariableBaseImpl.isLiteralOnlyExpression(expression) && !(expression instanceof JSXmlLiteralExpression) || JSSymbolUtil.isAccurateReferenceExpression(expression) ? expression.getText() : null;
    }

    private static boolean isLiteralOnlyExpression(@Nullable JSExpression expression) {
        IElementType sign;
        if (expression instanceof JSLiteralExpression) {
            return true;
        }
        return expression instanceof JSPrefixExpression && ((sign = ((JSPrefixExpression)expression).getOperationSign()) == JSTokenTypes.MINUS || sign == JSTokenTypes.PLUS) && ((JSPrefixExpression)expression).getExpression() instanceof JSLiteralExpression;
    }

    @NotNull
    public SearchScope getUseScope() {
        PsiElement declarationScope;
        if (this.hasBlockScope() && this.useLocalSearchScope(declarationScope = this.getDeclarationScope())) {
            LocalSearchScope localSearchScope = new LocalSearchScope(declarationScope);
            if (localSearchScope == null) {
                JSVariableBaseImpl.$$$reportNull$$$0(0);
            }
            return localSearchScope;
        }
        SearchScope searchScope = JSUseScopeProvider.findUseScope(this);
        if (searchScope == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(1);
        }
        return searchScope;
    }

    protected boolean useLocalSearchScope(@Nullable PsiElement declarationScope) {
        return !(declarationScope instanceof PsiFile);
    }

    public String getName() {
        if (this.myName == null) {
            this.myName = this.doGetName();
        }
        return this.myName;
    }

    @Nullable
    protected String doGetName() {
        String result2;
        String nameFromComputed;
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getName();
        }
        if (this instanceof JSComputedPropertyNameOwner && (nameFromComputed = JSPsiImplUtils.getValidNameFromComputedName(((JSComputedPropertyNameOwner)this).getComputedPropertyName())) != null) {
            return nameFromComputed;
        }
        ASTNode name = this.findNameIdentifier();
        boolean computed = false;
        if (name == null) {
            name = JSPsiImplUtils.getComputedNameOfVariable(this.getNode(), false);
            boolean bl = computed = name != null;
        }
        if (name == null) {
            name = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode());
        }
        if (name == null) {
            name = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode().getFirstChildNode());
        }
        if ((result2 = JSVariableBaseImpl.getResultNameFromNameNode(name, computed)) == null && !computed) {
            result2 = name != null ? JSPsiImplUtils.getNameFromIdentifier(name) : "";
        }
        return result2;
    }

    @Nullable
    protected static String getResultNameFromNameNode(ASTNode nameNode, boolean computed) {
        if (nameNode != null) {
            String referencedName;
            if (nameNode.getElementType() == JSTokenTypes.STRING_LITERAL) {
                return JSStringUtil.unquoteAndUnescapeStringLiteralValue(nameNode.getText());
            }
            PsiElement element = nameNode.getPsi();
            if (computed && element instanceof ES6ComputedName) {
                return ((ES6ComputedName)element).getExpressionAsPropertyName();
            }
            if (element instanceof JSReferenceExpression && (referencedName = ((JSReferenceExpression)element).getReferencedName()) != null) {
                return referencedName;
            }
        }
        return null;
    }

    public ASTNode findNameIdentifier() {
        return JSVariableBaseImpl.findVariableNameIdentifier(this.getNode());
    }

    @Nullable
    public static ASTNode findVariableNameIdentifier(@NotNull ASTNode node) {
        if (node == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(2);
        }
        return node.findChildByType(PROPERTY_NAME_TOKENS_SET);
    }

    public JSAttributeList getAttributeList() {
        PsiElement parent = this.getParent();
        while (parent instanceof JSDestructuringContainer || parent instanceof JSDestructuringProperty || parent instanceof JSDestructuringElement || parent instanceof JSDestructuringArrayRestElement) {
            parent = parent.getParent();
        }
        if (!(parent instanceof JSVarStatementBase)) {
            Logger.getInstance((String)this.getClass().getName()).error("Containing var statement was not found for variable:" + this.getText() + " in " + this.getContainingFile().getName());
            return null;
        }
        JSVarStatementStub stub = (JSVarStatementStub)((JSVarStatementBase)parent).getGreenStub();
        if (stub == null) {
            IElementType type;
            for (ASTNode element = parent.getNode().getFirstChildNode(); element != null && !JSTokenTypes.VAR_MODIFIERS.contains(type = element.getElementType()); element = element.getTreeNext()) {
                if (!JSStubElementTypes.ATTRIBUTE_LISTS.contains(type)) continue;
                return (JSAttributeList)element.getPsi();
            }
            return null;
        }
        StubElement stubElement = StubTreeUtil.findChildStubByType(stub, JSStubElementTypes.ATTRIBUTE_LISTS);
        return stubElement == null ? null : (JSAttributeList)stubElement.getPsi();
    }

    @Deprecated
    @Nullable
    public String getTypeString() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getTypeString();
        }
        JSType type = this.getJSType();
        return JSTypeUtils.serializeType(type);
    }

    public PsiElement getTypeElement() {
        return JSPsiImplUtils.getTypeElementFromDeclaration(this);
    }

    @Deprecated
    @Nullable
    protected JSType doGetType() {
        return this.calculateType();
    }

    @Override
    @Nullable
    public JSType calculateType() {
        JSType explicitlyDeclaredType = this.doGetExplicitlyDeclaredType();
        if (explicitlyDeclaredType != null) {
            return explicitlyDeclaredType;
        }
        return this.getTypeFromInitializer(this.getInitializer());
    }

    @Nullable
    protected JSType doGetExplicitlyDeclaredType() {
        return JSVariableBaseImpl.doGetExplicitlyDeclaredType(this);
    }

    @Nullable
    public static JSType doGetExplicitlyDeclaredType(@NotNull JSVariable var) {
        JSType typeFromDeclaration;
        if (var == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(3);
        }
        if ((typeFromDeclaration = JSPsiImplUtils.getTypeFromDeclaration((JSElement)var)) != null) {
            return typeFromDeclaration;
        }
        return JSDocumentationUtils.findTypeFromComments((JSNamedElement)var);
    }

    @Nullable
    protected JSType getTypeFromInitializer(@Nullable JSExpression initializer) {
        if (initializer == null) {
            return null;
        }
        JSType type = JSDialectSpecificHandlersFactory.forElement(this).getTypeHelper().getTypeForIndexing(initializer, this);
        if (type == null) {
            return null;
        }
        boolean addTypeFromInitializer = this.isConst() || this.getAttributeList() != null && this.getAttributeList().hasModifier(JSAttributeList.ModifierType.EXPORT) || !JSTreeUtil.hasLocalReassignments((TreeElement)this.getNode(), this.hasBlockScope());
        return addTypeFromInitializer ? type : null;
    }

    public boolean requiresTypeChecking() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.requiresTypeChecking();
        }
        return DialectDetector.hasFeature(this, JSLanguageFeature.TYPES) || this.doGetExplicitlyDeclaredType() != null || this.getInitializer() instanceof JSFunction;
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(4);
        }
        if (JSVariableBaseImpl.setComputedPropertyName(name, this)) {
            return this;
        }
        ASTNode nameNode = this.findNameIdentifier();
        if (nameNode == null) {
            nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode());
            if (nameNode == null) {
                nameNode = JSPsiImplUtils.findFallbackNameIdentifierOfVariable(this.getNode().getFirstChildNode());
            }
            if (nameNode == null) {
                return this;
            }
        }
        ASTNode nameElement = JSChangeUtil.createPropertyNameWithContext(name, nameNode);
        nameNode.getTreeParent().replaceChild(nameNode, nameElement);
        return this;
    }

    public static boolean setComputedPropertyName(@NotNull String name, PsiElement owner) {
        JSExpression computedNameExpression;
        ES6ComputedName computedName;
        if (name == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(5);
        }
        if (owner instanceof JSComputedPropertyNameOwner && (computedName = ((JSComputedPropertyNameOwner)owner).getComputedPropertyName()) != null && (computedNameExpression = computedName.getExpression()) instanceof JSLiteralExpression) {
            char quote = computedNameExpression.getText().charAt(0);
            ASTNode expr = JSChangeUtil.createExpressionFromText(owner.getProject(), name.startsWith("\"") || name.startsWith("'") ? name : quote + name + quote);
            ASTNode node = computedNameExpression.getNode();
            node.getTreeParent().replaceChild(node, expr);
            return true;
        }
        return false;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(6);
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSVariable((JSVariable)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public int getTextOffset() {
        ASTNode name = this.findNameIdentifier();
        return name != null ? name.getStartOffset() : super.getTextOffset();
    }

    public boolean isConst() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isConst();
        }
        ASTNode parent = JSDestructuringUtil.getParentSkippingDestructuring(this.getNode());
        if (parent == null) {
            return false;
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(parent.getElementType())) {
            ASTNode node;
            for (node = parent.getFirstChildNode(); node != null && ArrayUtil.contains((Object)node.getElementType(), (Object[])TYPES_TO_SKIP); node = node.getTreeNext()) {
            }
            if (node != null && node.getElementType() == JSTokenTypes.CONST_KEYWORD) {
                return true;
            }
        }
        return JSDocumentationUtils.calculateConst(this);
    }

    public boolean isLocal() {
        return this.getNamespace() == null && !this.isNamespaceExplicitlyDeclared() && JSDocumentationUtils.isClassOrInterface(this) == JSElementBase.ClassOrInterface.NONE && (PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSFunction.class}) != null || this.hasBlockScope() && PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSBlockStatement.class}) != null);
    }

    public boolean hasBlockScope() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.hasBlockScope();
        }
        return JSVariableBaseImpl.hasBlockScope(this.getNode());
    }

    public static boolean hasBlockScope(@NotNull ASTNode varNode) {
        IElementType varKeyword;
        ASTNode varStatement;
        if (varNode == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(7);
        }
        if ((varStatement = JSDestructuringUtil.getParentSkippingDestructuring(varNode)) == null) {
            return false;
        }
        ASTNode varModifier = varStatement.findChildByType(JSTokenTypes.VAR_MODIFIERS);
        IElementType iElementType = varKeyword = varModifier != null ? varModifier.getElementType() : null;
        if (varStatement.getElementType() != JSStubElementTypes.VAR_STATEMENT) {
            return false;
        }
        if (varKeyword == null || varKeyword == JSTokenTypes.VAR_KEYWORD || varKeyword == JSTokenTypes.CONST_KEYWORD && JSTreeUtil.getLanguage(varNode) == JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return false;
        }
        boolean firstParent = true;
        for (ASTNode parent = varStatement.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            IElementType parentType = parent.getElementType();
            if (parentType instanceof IFileElementType || JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(parentType)) {
                return !firstParent;
            }
            if (JSExtendedLanguagesTokenSetProvider.SCOPE_ELEMENTS.contains(parentType)) {
                return JSElementTypes.FUNCTIONS.contains(parentType);
            }
            firstParent = false;
        }
        return false;
    }

    @Override
    public boolean isDeprecated() {
        if (ActionScriptPsiImplUtil.isDeprecatedFromAttribute((JSAttributeListOwner)this)) {
            return true;
        }
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isDeprecated();
        }
        return JSDocumentationUtils.calculateDeprecated(this);
    }

    public PsiElement getDeclarationScope() {
        if (this.hasBlockScope()) {
            return PsiTreeUtil.getParentOfType((PsiElement)this, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSLoopStatement.class});
        }
        return PsiTreeUtil.getContextOfType((PsiElement)this, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
    }

    public Icon getIcon(int flags) {
        JSExpression initializer;
        Icon baseIcon = JSClassUtils.isClassMember(this) ? PlatformIcons.FIELD_ICON : ((initializer = JSPsiImplUtils.getRightmostInitializer((JSInitializerOwner)this)) instanceof JSFunctionItem ? JSFunctionImpl.getFunctionBaseIcon((JSFunctionItem)initializer) : PlatformIcons.VARIABLE_ICON);
        return JSVariableBaseImpl.getIcon((JSPsiElementBase)this, baseIcon, flags);
    }

    public void delete() throws IncorrectOperationException {
        PsiElement parent = this.getParent();
        if (JSVarStatementBase.handleChildDeletion((JSInitializerOwner)this)) {
            return;
        }
        if (parent instanceof JSDestructuringArrayRestElement && parent.getParent() instanceof JSDestructuringArray) {
            JSVariableBaseImpl.removeDestructuringArrayItem((JSDestructuringArray)parent.getParent(), parent);
            return;
        }
        if (parent instanceof JSDestructuringArray) {
            JSVariableBaseImpl.removeDestructuringArrayItem((JSDestructuringArray)parent, this);
            return;
        }
        ASTNode parentAstNode = this.getNode().getTreeParent();
        if (JSStubElementTypes.DESTRUCTURING_PROPERTIES.contains(parentAstNode.getElementType())) {
            parent.delete();
            return;
        }
        throw new IncorrectOperationException("Cannot delete variable from parent : " + parentAstNode.getElementType());
    }

    static void removeDestructuringArrayItem(@NotNull JSDestructuringArray arrayPattern, @NotNull PsiElement arrayElement) {
        if (arrayPattern == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(8);
        }
        if (arrayElement == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(9);
        }
        if (JSDestructuringUtil.hasSingleElement(arrayPattern)) {
            arrayPattern.getParent().delete();
            return;
        }
        Object[] elements = arrayPattern.getElements();
        int index = ArrayUtil.indexOf((Object[])elements, (Object)arrayElement);
        PsiElement comma = null;
        if ((arrayElement instanceof JSDestructuringArrayRestElement || index == elements.length - 1 && arrayPattern.getRestElement() == null) && PsiUtilCore.getElementType((PsiElement)(comma = PsiTreeUtil.skipWhitespacesBackward((PsiElement)arrayElement))) != JSTokenTypes.COMMA) {
            comma = null;
        }
        arrayElement.replace((PsiElement)JSChangeUtil.createEmptyExpression(arrayElement));
        if (comma != null) {
            comma.delete();
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(10);
        }
        if (state == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(11);
        }
        if (place == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(12);
        }
        if (lastParent != null && lastParent.getParent() == this && JSUseScopeProvider.getLexicalScopeOrFile(place) == JSUseScopeProvider.getLexicalScopeOrFile(this)) {
            boolean skipLocal = true;
            if (ActionScriptResolveUtil.isSpecialCallResolveCaseEcmaScript(place, lastParent)) {
                skipLocal = false;
            }
            processor.handleEvent(PsiScopeProcessor.Event.SET_DECLARATION_HOLDER, (Object)this);
            if (skipLocal) {
                return true;
            }
        }
        return processor.execute((PsiElement)this, state);
    }

    public String getQualifiedName() {
        return JSPsiImplUtils.buildQualifiedNameFromNamespaceAndName(this);
    }

    public PsiElement getNameIdentifier() {
        ASTNode node = this.findNameIdentifier();
        return node != null ? node.getPsi() : null;
    }

    @Nullable
    public JSQualifiedName getNamespace() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.getNamespace();
        }
        return this.getJSNamespace().getQualifiedName();
    }

    public boolean isNamespaceExplicitlyDeclared() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            return stub.isNamespaceExplicitlyDeclared();
        }
        return this.getJSNamespace().isExplicitlyDeclared();
    }

    @Override
    public boolean useTypesFromJSDoc() {
        return true;
    }

    @NotNull
    public JSAttributeList.AccessType getAccessType() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            JSAttributeList.AccessType accessType = stub.getAccessType();
            if (accessType == null) {
                JSVariableBaseImpl.$$$reportNull$$$0(13);
            }
            return accessType;
        }
        JSAttributeList.AccessType accessType = this.calcAccessType();
        if (accessType == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(14);
        }
        return accessType;
    }

    @NotNull
    protected JSAttributeList.AccessType calcAccessType() {
        JSAttributeList.AccessType accessType = JSPsiImplUtils.getAccessType(this);
        if (accessType == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(15);
        }
        return accessType;
    }

    @NotNull
    public JSContext getJSContext() {
        JSVariableStubBase stub = (JSVariableStubBase)this.getGreenStub();
        if (stub != null) {
            JSContext jSContext = stub.getJSContext();
            if (jSContext == null) {
                JSVariableBaseImpl.$$$reportNull$$$0(16);
            }
            return jSContext;
        }
        JSContext jSContext = this.getJSNamespace().getJSContext();
        if (jSContext == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(17);
        }
        return jSContext;
    }

    @Override
    @NotNull
    public JSNamespace getJSNamespace() {
        JSNamespace jSNamespace = (JSNamespace)CachedValuesManager.getManager((Project)this.getProject()).getParameterizedCachedValue((UserDataHolder)this, JSCachingNamespaceOwner.NAMESPACE_PROVIDER_KEY, JSCachingNamespaceOwner.NAMESPACE_PROVIDER, false, (Object)this);
        if (jSNamespace == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(18);
        }
        return jSNamespace;
    }

    @Override
    @Nullable
    public JSType calculateDeclarationTypeStubSafe() {
        JSTypeDeclaration declaration = JSPsiImplUtils.getTypeElementFromDeclaration(this);
        return JSPsiImplUtils.getTypeFromElement((PsiElement)declaration, this);
    }

    @Nullable
    public static PsiElement getDeclarationScope(@NotNull PsiElement var, boolean hasBlockScope) {
        if (var == null) {
            JSVariableBaseImpl.$$$reportNull$$$0(19);
        }
        if (hasBlockScope) {
            return PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{JSBlockStatement.class, JSExecutionScope.class, JSSwitchStatement.class, JSLoopStatement.class});
        }
        return PsiTreeUtil.getContextOfType((PsiElement)var, (Class[])new Class[]{JSExecutionScope.class, JSClass.class});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayPattern";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/impl/JSVariableBaseImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "calcAccessType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSContext";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getJSNamespace";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findVariableNameIdentifier";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doGetExplicitlyDeclaredType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setComputedPropertyName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hasBlockScope";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeDestructuringArrayItem";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 19: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

