/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.types.JSLiteralType;
import com.intellij.lang.javascript.psi.types.JSPrimitiveLiteralType;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import org.jetbrains.annotations.NotNull;

public final class JSBooleanLiteralTypeImpl
extends JSBooleanType
implements JSPrimitiveLiteralType<Boolean> {
    private final boolean myLiteral;
    private final boolean myAllowWidening;

    public JSBooleanLiteralTypeImpl(boolean literal, boolean allowWidening, @NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(0);
        }
        super(true, source, JSTypeContext.INSTANCE);
        this.myLiteral = literal;
        this.myAllowWidening = allowWidening;
    }

    protected JSBooleanLiteralTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator serialized) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(1);
        }
        if (serialized == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(2);
        }
        super(source, serialized);
        this.myLiteral = JSTypeSerializer.readBoolean(serialized);
        this.myAllowWidening = JSTypeSerializer.readBoolean(serialized);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.writeBoolean(this.myLiteral, outputStream);
        JSTypeSerializer.writeBoolean(this.myAllowWidening, outputStream);
    }

    @Override
    @NotNull
    public Boolean getLiteral() {
        Boolean bl = this.myLiteral;
        if (bl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(4);
        }
        return bl;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder) {
        if (format == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(6);
        }
        if (format == JSType.TypeTextFormat.RESOLVED) {
            builder.append("Boolean");
            return;
        }
        builder.append(this.isTypeScript() && (!this.allowWidening() || format != JSType.TypeTextFormat.CODE) ? Boolean.toString(this.myLiteral) : "boolean");
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(7);
        }
        if (processingContext == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(8);
        }
        if (elementType instanceof JSBooleanLiteralTypeImpl && this.isSourceStrict() && elementType.isSourceStrict() && !this.myAllowWidening) {
            return this.myLiteral == ((JSBooleanLiteralTypeImpl)elementType).myLiteral;
        }
        if (!this.myAllowWidening && elementType instanceof JSBooleanType) {
            return this.isJavaScript() || elementType.isJavaScript();
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type, ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(9);
        }
        return this.myLiteral == ((JSBooleanLiteralTypeImpl)type).myLiteral && super.isEquivalentToWithSameClass(type, processingContext, allowResolve);
    }

    @Override
    @NotNull
    protected JSBooleanLiteralTypeImpl copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(10);
        }
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl((boolean)this.getLiteral(), this.myAllowWidening, source);
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(11);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Override
    @NotNull
    public String getPrimitiveTypeText() {
        if ("boolean" == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(12);
        }
        return "boolean";
    }

    public boolean allowWidening() {
        return this.myAllowWidening;
    }

    @Override
    @NotNull
    public JSLiteralType copyWithAllowWidening(boolean allowWidening) {
        if (this.myAllowWidening == allowWidening) {
            JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = this;
            if (jSBooleanLiteralTypeImpl == null) {
                JSBooleanLiteralTypeImpl.$$$reportNull$$$0(13);
            }
            return jSBooleanLiteralTypeImpl;
        }
        JSBooleanLiteralTypeImpl jSBooleanLiteralTypeImpl = new JSBooleanLiteralTypeImpl(this.myLiteral, allowWidening, this.getSource());
        if (jSBooleanLiteralTypeImpl == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(14);
        }
        return jSBooleanLiteralTypeImpl;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        String string = this.myLiteral ? "true" : "false";
        if (string == null) {
            JSBooleanLiteralTypeImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serialized";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSBooleanLiteralTypeImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteral";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewSource";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithAllowWidening";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

