/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeSubstitutionContext;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeImpl;
import com.intellij.lang.javascript.psi.types.JSContextualUnionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSIntersectionType;
import com.intellij.lang.javascript.psi.types.JSRecordMemberSourceFactory;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.guard.TypeScriptTypeRelations;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSIntersectionTypeImpl
extends JSCompositeTypeBaseImpl
implements JSIntersectionType {
    public static final String SEPARATOR = "&";

    @NotNull
    public static JSType getIntersectionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source) {
        if (types2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(0);
        }
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(1);
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types2, source, false);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(2);
        }
        return jSType;
    }

    @NotNull
    public static JSType getIntersectionType(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source, boolean allowResolve) {
        Collection<? extends JSType> resultTypes;
        if (types2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(3);
        }
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(4);
        }
        JSIntersectionTypeImpl jSIntersectionTypeImpl = (resultTypes = JSIntersectionTypeImpl.optimizeIntersectionTypes(types2, source, allowResolve, true)).size() == 1 ? resultTypes.iterator().next() : new JSIntersectionTypeImpl(source, resultTypes);
        if (jSIntersectionTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(5);
        }
        return jSIntersectionTypeImpl;
    }

    @NotNull
    public static Collection<? extends JSType> optimizeIntersectionTypes(@NotNull Collection<? extends JSType> types2, @NotNull JSTypeSource source, boolean allowResolve, boolean asIntersection) {
        Collection<? extends JSType> plainTypes;
        if (types2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(6);
        }
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(7);
        }
        if ((plainTypes = JSCompositeTypeImpl.flattenAndDeduplicate(types2, Collections.emptySet(), allowResolve ? JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_SIMPLE : JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE, !asIntersection)).size() == 0) {
            Collection<? extends JSType> collection = plainTypes;
            if (collection == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(8);
            }
            return collection;
        }
        if (plainTypes.size() == 1) {
            Collection<? extends JSType> collection = plainTypes;
            if (collection == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(9);
            }
            return collection;
        }
        if (asIntersection && JSIntersectionTypeImpl.hasAnyType(plainTypes)) {
            JSType item = (JSType)ContainerUtil.getFirstItem(plainTypes);
            assert (item != null);
            List<JSAnyType> list2 = Collections.singletonList(JSAnyType.get(source));
            if (list2 == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(10);
            }
            return list2;
        }
        JSType simplifiedType = JSIntersectionTypeImpl.normalizeIfPossible(plainTypes, source, allowResolve, asIntersection);
        if (simplifiedType != null) {
            List<JSType> list3 = Collections.singletonList(simplifiedType);
            if (list3 == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(11);
            }
            return list3;
        }
        Collection<? extends JSType> collection = plainTypes;
        if (collection == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @Nullable
    protected static JSType normalizeIfPossible(@NotNull Collection<? extends JSType> plainTypes, JSTypeSource source, boolean allowResolve, boolean intersection) {
        if (plainTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(13);
        }
        ProgressManager.checkCanceled();
        if (!intersection) {
            return null;
        }
        int i = -1;
        for (JSType jSType : plainTypes) {
            ++i;
            if (!(jSType instanceof JSUnionType)) continue;
            List<JSType> parts = ((JSUnionType)jSType).getTypes();
            ArrayList<JSType> newParts = new ArrayList<JSType>(parts.size());
            ArrayList<? extends JSType> typesCopy = new ArrayList<JSType>(plainTypes);
            for (JSType part : parts) {
                ProgressManager.checkCanceled();
                typesCopy.set(i, (JSType)part);
                newParts.add(JSIntersectionTypeImpl.getIntersectionType(typesCopy, source, allowResolve));
            }
            return new JSCompositeTypeImpl(source, newParts);
        }
        return null;
    }

    public static boolean hasAnyType(@NotNull Collection<? extends JSType> types2) {
        if (types2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(14);
        }
        for (JSType jSType : types2) {
            if (!(jSType instanceof JSAnyType)) continue;
            return true;
        }
        return false;
    }

    public JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull Collection<? extends JSType> _types) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(15);
        }
        if (_types == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(16);
        }
        super(source, _types);
    }

    protected JSIntersectionTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(17);
        }
        if (inputStream == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(18);
        }
        super(source, inputStream);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(19);
        }
        if (processingContext == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(20);
        }
        boolean allAssignable = true;
        boolean hadAssignable = false;
        List<JSType> types2 = this.getTypes();
        HashSet<JSType> nonAssignable = new HashSet<JSType>();
        for (JSType type : types2) {
            if (!type.isDirectlyAssignableType(elementType, processingContext)) {
                allAssignable = false;
                nonAssignable.add(type);
                continue;
            }
            if (this instanceof JSContextualUnionTypeImpl) {
                return true;
            }
            hadAssignable = true;
        }
        if (allAssignable) {
            return true;
        }
        if (nonAssignable.stream().allMatch(JSIntersectionTypeImpl::isWeakOrWithoutProperties)) {
            if (hadAssignable) {
                return true;
            }
            return this.asRecordType().isDirectlyAssignableType(elementType, processingContext);
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private static boolean isWeakOrWithoutProperties(@Nullable JSType t) {
        JSType jSType = t = t == null ? null : t.substitute();
        if (t instanceof JSPrimitiveType) {
            t = null;
        }
        if (t != null) {
            t = t.asRecordType();
        }
        return t != null && (((JSRecordType)t).isWeak() || !((JSRecordType)t).hasProperties());
    }

    @Override
    @NotNull
    protected String getTypeSeparator() {
        if (SEPARATOR == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(21);
        }
        return SEPARATOR;
    }

    @Override
    @NotNull
    protected JSType createType(@NotNull List<JSType> transformedTypes, @NotNull JSTypeSource newSource, boolean sourceOnly) {
        if (transformedTypes == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(22);
        }
        if (newSource == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(23);
        }
        if (sourceOnly) {
            JSIntersectionTypeImpl jSIntersectionTypeImpl = new JSIntersectionTypeImpl(newSource, transformedTypes);
            if (jSIntersectionTypeImpl == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(24);
            }
            return jSIntersectionTypeImpl;
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(transformedTypes, newSource);
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(25);
        }
        return jSType;
    }

    @Override
    @Nullable
    public JSType substituteImpl(@NotNull JSTypeSubstitutionContext context) {
        JSType result2;
        if (context == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(26);
        }
        if ((result2 = this.getSimpleCompositeTypeResult()) != null) {
            return result2;
        }
        return TypeScriptTypeRelations.expandUnionOrIntersectionType(this, context);
    }

    @Override
    @NotNull
    public JSRecordType asRecordTypeNoCache() {
        Collection<JSRecordType> resolvedTypes = this.getNestedTypesAsRecordType();
        if (resolvedTypes.isEmpty()) {
            JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), ContainerUtil.emptyList());
            if (jSRecordTypeImpl == null) {
                JSIntersectionTypeImpl.$$$reportNull$$$0(27);
            }
            return jSRecordTypeImpl;
        }
        ArrayList<Object> resultMembers = new ArrayList<Object>();
        LinkedMultiMap map = new LinkedMultiMap();
        for (JSRecordType resolvedType : resolvedTypes) {
            for (JSRecordType.TypeMember member : resolvedType.getTypeMembers()) {
                ProgressManager.checkCanceled();
                if (member instanceof JSRecordType.PropertySignature) {
                    JSRecordType.PropertySignature propertySignature = (JSRecordType.PropertySignature)member;
                    String name = propertySignature.getMemberName();
                    map.putValue((Object)name, (Object)propertySignature);
                    continue;
                }
                resultMembers.add(member);
            }
        }
        if (map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                boolean startOptional;
                ProgressManager.checkCanceled();
                Collection value = (Collection)entry.getValue();
                boolean isOptional = startOptional = !(this instanceof JSContextualUnionTypeImpl);
                boolean isReadonly = true;
                ArrayList<JSType> types2 = new ArrayList<JSType>();
                ArrayList<PsiElement> propertySources = new ArrayList<PsiElement>(value.size());
                ArrayList<JSRecordType.PropertySignature> processedSignatures = new ArrayList<JSRecordType.PropertySignature>();
                for (JSRecordType.PropertySignature signature : value) {
                    if (processedSignatures.stream().anyMatch(s -> JSIntersectionTypeImpl.signaturesAreSkippablyEquivalent(signature, s))) continue;
                    processedSignatures.add(signature);
                    if (startOptional != signature.isOptional()) {
                        isOptional = signature.isOptional();
                    }
                    if (!signature.isConst()) {
                        isReadonly = false;
                    }
                    if (signature.getJSType() != null) {
                        types2.add(signature.getJSType());
                    }
                    JSRecordType.MemberSource source = signature.getMemberSource();
                    propertySources.addAll(source.getAllSourceElements());
                }
                JSType resultType = this.getSubIntersectionType(types2);
                boolean finalOptional = isOptional || this instanceof JSContextualUnionTypeImpl && value.size() != resolvedTypes.size();
                resultMembers.add(new JSRecordTypeImpl.PropertySignatureImpl((String)entry.getKey(), resultType, finalOptional, isReadonly, JSRecordMemberSourceFactory.createSource(propertySources, JSRecordType.MemberSourceKind.Intersection)));
            }
        }
        JSRecordTypeImpl jSRecordTypeImpl = new JSRecordTypeImpl(this.getSource(), resultMembers);
        if (jSRecordTypeImpl == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(28);
        }
        return jSRecordTypeImpl;
    }

    @NotNull
    protected JSType getSubIntersectionType(@NotNull Collection<JSType> types2) {
        if (types2 == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(29);
        }
        JSType jSType = JSIntersectionTypeImpl.getIntersectionType(types2, this.getSource());
        if (jSType == null) {
            JSIntersectionTypeImpl.$$$reportNull$$$0(30);
        }
        return jSType;
    }

    private static boolean signaturesAreSkippablyEquivalent(JSRecordType.PropertySignature propertySignature, JSRecordType.PropertySignature s) {
        if (!s.isEquivalentTo((JSRecordType.TypeMember)propertySignature, true)) {
            return false;
        }
        JSRecordType.MemberSource memberSource = s.getMemberSource();
        JSRecordType.MemberSource otherSource = propertySignature.getMemberSource();
        if (!memberSource.isIdentity() || !otherSource.isIdentity()) {
            return false;
        }
        return memberSource.getSingleElement() == otherSource.getSingleElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plainTypes";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_types";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transformedTypes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/JSIntersectionTypeImpl";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIntersectionType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "optimizeIntersectionTypes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSeparator";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "asRecordTypeNoCache";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubIntersectionType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIntersectionType";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "optimizeIntersectionTypes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "normalizeIfPossible";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "hasAnyType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "substituteImpl";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSubIntersectionType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

